// Q's C++ Library
// Copyright (c) 1998-2000 Hisashi HORIKAWA. All rights reserved.

#ifndef QSLIB_XIM__
#define QSLIB_XIM__

#include <vector>
#include <X11/Xlib.h>

using namespace std;

////////////////////////////////////////////////////////////////////////
// InputMethodListener

class InputMethodListener
{
public:
    virtual void inputMethodInstantiated() = 0;
    virtual void inputMethodDestroyed() = 0;
    virtual ~InputMethodListener() { }
};

////////////////////////////////////////////////////////////////////////
// InputMethod

class InputMethod
{
    Display* disp;
    XIM im;
    typedef vector<InputMethodListener*> Listeners;
    Listeners listeners;
    bool to_register;
    
public:
    InputMethod();
    virtual ~InputMethod();

    bool open(Display* disp);
    void close();
    XIMStyle selectInputStyle(const XIMStyle* styles) const;
    XIM getXIM() const;
    void attachInputMethodListener(InputMethodListener* l);
    void detachInputMethodListener(InputMethodListener* l);
    bool is_open() const;

private:
    static void onImInstantiate(Display* disp, XPointer client_data, XPointer call_data);
    static void onImServerDestroy(XIM im_, InputMethod* this_, XPointer /*call_data*/);
};

////////////////////////////////////////////////////////////////////////
// XIM VJE-Deltaĥ

enum IMExtCmd {
    IMEXT_NIHONGO = 1,    // ??

    IMEXT_ON = 2,         // ܸ⡼ɤˤ롣桼ˤ⡼ѹ϶ػߤʤ
    IMEXT_OFF = 3,        // Ⱦѱѿ⡼ɡIMС̤ꤹ⡼ɡˤˤ롣
                        //      桼ˤ⡼ѹ϶ػߤʤ

    IMEXT_DISABLE = 4,    // IMСŪ̵¾Υ⡼ɤؤܤϤǤʤ
    IMEXT_ENABLE = 5,     // IMEXT_DISABLEξ֤᤹
                    // nicolatterǤϡIMEXT_DISABLEʳȯԤ줿ϼưŪenableˤ롣

    IMEXT_ROMA = 6,       // ޻Ϥѹ  nicolatterϼʤ
    IMEXT_KANA = 7,       // Ϥѹ      nicolatterϼʤ

    IMEXT_HIRAGANA = 8,       // Ҥ餬ʸꡣ桼ˤ⡼ѹػߤ롣
    IMEXT_KATAKANA = 9,       // ʸ
    IMEXT_FULLWIDTH_ALNUM = 10    // ѱѿ
                        // ȾѱѿIMEXT_DISABLEȤ
};

extern void setIMExtValue(Display* disp, Window focus_window, IMExtCmd cmdid);

#endif
