#!/usr/bin/awk -f
BEGIN {
  print "/* Automatically generated from chars.dat. Do not edit. */"
  print "#ifndef CHARS_H"
  print "#define CHARS_H"
  FS=""
}
{
  sub(/#.*/, "")
  sub(/[ 	]*$/, "")
  if ($0 == "") next
  name = $0
  sub(/[ 	].*$/, "", name)
  body = $0
  sub(/^[^ 	]*[ 	]*/, "", body)
  if (name == "" || body == "") {
    printf "chars.awk: syntax error in chars.dat line %s\n",NR > "/dev/stderr"
    exit 1
  }
  printf "\n#ifdef C%s\n", name
  printf "# define MYC%s C%s\n", name, name
  printf "#else\n"
  printf "# define MYC%s %s\n", name, body
  printf "#endif\n"
}
END {
  print "#endif /* CHARS_H */"
}
