/*
 *  Emi Clock $B!=(B $B%5%&%s%I=hM}(B
 */

/*
 *  Copyright (c) 1994, 1995, 1997, 1999 Masayuki Koba
 *
 *  $BK\%=%U%H%&%'%"$N%=!<%9$d%P%$%J%j$r:FG[I[$9$k>l9g$O!"<!$N>r7o$r=e<i$7$F(B
 *  $B2<$5$$!#(B
 *
 *  1. $BK\%=%U%H%&%'%"$rF~<j$7$?J}$K$O!"(BX11$BHG(B Emi Clock $B$N;HMQ8"$H!"Bh;0<T(B
 *     $B$X$N:FG[I[8"$,G'$a$i$l$^$9!#$?$@$7!":FG[I[$K4X$7$F$O!"F~<j;~$N%*%j(B
 *     $B%8%J%k$N$^$^2~JQ$;$:$K9T$&$3$H$,>r7o$G$9!#(B
 *  2. $BK\%=%U%H%&%'%"$N0lIt$^$?$OA4It$rCx:n8"<T$KL5CG$G2~JQ$7$FG[I[$9$k$3(B
 *     $B$H$O$G$-$^$;$s!#(B
 *  3. $BK\%=%U%H%&%'%"$N0lIt$^$?$OA4It$rCx:n8"<T$KL5CG$GFs<!MxMQ$9$k$3$H$O(B
 *     $B$G$-$^$;$s!#(B
 *  4. $BK\%=%U%H%&%'%"$r%7%9%F%`$K%P%s%I%k$7$?$j!"%7%9%F%`$NDI2C%Q%C%1!<%8(B
 *     $B$H$7$FBh;0<T$K:FG[I[$7$?$j$9$k>l9g$O!";vA0$KCx:n8"<T$K5v2D$,I,MW$G(B
 *     $B$9!#(B
 *  5. $BK\%=%U%H%&%'%"$r>&MQ$K;HMQ$9$k>l9g(B($B6bA,E*Mx1W$rF@$k>l9g(B)$B$O!";vA0$K(B
 *     $BCx:n8"<T$K5v2D$,I,MW$G$9!#$3$N>l9g!"4pK\E*$KM-=~$H$J$j$^$9!#(B
 *  6. $BK\%=%U%H%&%'%"$rMxMQ$9$k$3$H$K$h$C$FH/@8$7$?$$$+$J$kB;32$b!"Cx:n8"(B
 *     $B<T$OIi$o$J$$$b$N$H$7$^$9!#$3$l$K9g0U$G$-$J$$>l9g$O!";HMQ8"$,$J$$$b(B
 *     $B$N$H$7$^$9!#(B
 *  7. $B!H(BEmi Clock$B!I$N>&I8$*$h$SK\%=%U%H%&%'%"$N2hA|$d%G%6%$%s$K4X$9$kCx:n(B
 *     $B8"$O!"(BMotosoft $B$3$H!HK\(B $B=SLi!I;a$,M-$7$^$9!#(B
 *  8. $B!H(BEmi Clock$B!I$N>&I8$*$h$S2hA|$d%G%6%$%s$O!"(BX11$BHG(B Emi Clock $B3+H/$N$?(B
 *     $B$a!"(BMotosoft $B$h$j!H8E>l(B $B@59T!I$X8D?ME*$K%i%$%;%s%96!M?$5$l$F$^$9!#(B
 *     $BBh;0<T$XFs<!%i%$%;%s%96!M?$9$k$3$H$OG'$a$i$l$F$*$j$^$;$s!#(B
 *  9. Motosoft $B$H8E>l$KL5CG$G!"K\%=%U%H%&%'%"$N2hA|%G!<%?$rFs<!MxMQ$9$k$3(B
 *     $B$H$r6X;_$7$^$9!#(B
 * 10. $B$3$3$K5-=R$7$?0J30$N8"Mx$K$D$$$F$O!"F|K\9q$NCx:n8"K!$K$h$k$b$N$H$7(B
 *     $B$^$9!#(B
 */


/* $B#X%D!<%k%-%C%H%W%m%0%i%_%s%0$KI,MW$J%X%C%@!<(B */
#include <X11/Intrinsic.h>		/* $B%$%s%H%j%s%7%C%/$NDj5A(B */

/* kernel $B4X78$N%X%C%@!<(B */
#include <sys/param.h>			/* $B%7%9%F%`%Q%i%a!<%?(B */

/* $B#C8@8l%i%$%V%i%j(B */
#include <stdio.h>			/* $BI8=`F~=PNO%i%$%V%i%j(B */

/* Emi Clock $BFH<+$N%X%C%@!<(B */
#include "config.h"			/* $B%3%s%Q%$%k4D6-$NDj5A(B */
#include "include/system.h"		/* $B%7%9%F%`4D6-$N:9J,5[<}(B */
#include "include/const.h"		/* $BDj?tDj5A(B */
#include "include/types.h"		/* $BFC<l$J7?$NDj5A(B */
#include "include/public.h"		/* $BHFMQ4X?t!?30ItDj5A%G!<%?$N@k8@(B */
#include "include/util.h"		/* $B%^%/%mDj5A(B */
#include "include/sound.h"		/* $B%5%&%s%I4D6-$N@_Dj(B */

/* RCS ID */
rcsId(soundId, "$Id: sound.c,v 1.2 1999/09/02 14:33:49 koba Exp $")

/* $B%0%m!<%P%k(B */
static char		*hourlyChimeFileName = NULL;
static char		*halfHourChimeFileName = NULL;
static char		*alarmFileName = NULL;
static SoundCacheBuffer	hourlyChimeCache;
static SoundCacheBuffer	halfHourChimeCache;
static Boolean		isHourlyChimeCached = False;
static Boolean		isHalfHourChimeCached = False;


/*
 *  $B#O#S@lMQ%5%&%s%I=hM}$r=q$$$?%U%!%$%k$NFI$_9~$_(B
 */
#ifdef	USE_SOUND

#ifndef	USE_NETAUDIO

/* NEWS-OS */
#ifdef	__sony_news
#include "sys/NEWS-OS/audio.c"
#endif	/* __sony_news */

/* IRIX */
#ifdef	sgi
#include "sys/IRIX/audio.c"
#endif	/* sgi */

/* HP-UX */
#ifdef	__hpux
#include "sys/HP-UX/audio.c"
#endif	/* __hpux */

/* SunOS */
#ifdef	sun
#include "sys/SunOS/audio.c"
#endif	/* sun */

/* BSDI BSD/OS */
#ifdef	__bsdi__
#include "sys/BSD-OS/audio.c"
#endif	/* __bsdi__ */

/* Linux */
#ifdef	linux
#include "sys/Linux/audio.c"
#endif	/* linux */

/* FreeBSD */
#ifdef	__FreeBSD__
#include "sys/FreeBSD/audio.c"
#endif	/* FreeBSD */

#else	/* USE_NETAUDIO */

/* netaudio (NCDaudio) */
#include "sys/netaudio/audio.c"

#endif	/* !USE_NETAUDIO */

#endif	/* USE_SOUND */


/* $B%m!<%+%k4X?t$N%W%m%H%?%$%W@k8@(B */
#if defined(USE_SOUND) && defined(HAS_SOUND_CODE)
static int PlaySound __P((char *));
static Boolean IsSoundCacheAvailable __P((void));
static int CacheSound __P((char *, SoundCacheBuffer *));
static int PlayCacheSound __P((SoundCacheBuffer *));
static char *FullPathSoundFileName __P((char *));
#endif
static void FreeCacheSound __P((SoundCacheBuffer *));


/*
 *  $B%5%&%s%I4D6-$N=i4|2=(B
 */
void
SoundEnvInit()
{
#if defined(USE_SOUND) && defined(HAS_SOUND_CODE)
    S_SoundEnvInit();
#endif
}


/*
 *  $B%5%&%s%I%G%P%$%9$NB8:_H=Dj(B
 */
Boolean
IsSoundAvailable()
{
#if defined(USE_SOUND) && defined(HAS_SOUND_CODE)
    return(S_IsSoundAvailable());
#else
    return(False);
#endif
}


/*
 *  $B5/F02;!V$_$e$C!*!W$N:F@8(B
 */
void
PlayStartupSound()
{
#if defined(USE_SOUND) && defined(HAS_SOUND_CODE)
    char	*fullPathFileName;

    fullPathFileName = FullPathSoundFileName(GetStartupSoundFileName());
    PlaySound(fullPathFileName);
    XtFree(fullPathFileName);
#endif
}


/*
 *  $B!H5/F02;!V$_$e$C!*!W!I$N%5%&%s%I%U%!%$%kL><hF@(B
 */
char *
GetStartupSoundFileName()
{
#if defined(USE_SOUND) && defined(HAS_SOUND_CODE)
    return(STARTUP_SOUND);
#else
    return("");
#endif
}


/*
 *  0$BJ,%A%c%$%`%5%&%s%I$N5-21(B
 */
void
StoreHourlyChimeFileName(filename)
    char	*filename;
{
    if (hourlyChimeFileName != NULL) {
	XtFree(hourlyChimeFileName);
    }
    hourlyChimeFileName = (char *)XtMalloc(strlen(filename) + 1);
    strcpy(hourlyChimeFileName, filename);

#if defined(USE_SOUND) && defined(HAS_SOUND_CODE)
    if (IsSoundCacheAvailable()) {
	char	*fullPathFileName;

	if (isHourlyChimeCached) {
	    FreeCacheSound(&hourlyChimeCache);
	}

	fullPathFileName = FullPathSoundFileName(hourlyChimeFileName);

	if (CacheSound(fullPathFileName, &hourlyChimeCache)
							== SOUND_NO_ERROR) {
	    isHourlyChimeCached = True;
	} else {
	    isHourlyChimeCached = False;
	}

	XtFree(fullPathFileName);
    }
#endif
}


/*
 *  0$BJ,%A%c%$%`%5%&%s%I$N%U%!%$%kL><hF@(B
 */
char *
GetHourlyChimeFileName()
{
    return(hourlyChimeFileName);
}


/*
 *  0$BJ,%A%c%$%`%5%&%s%I$N:F@8(B
 */
void
PlayHourlyChime()
{
#if defined(USE_SOUND) && defined(HAS_SOUND_CODE)
    char	*fullPathFileName;

    fullPathFileName = FullPathSoundFileName(hourlyChimeFileName);

    if (hourlyChimeFileName != NULL) {
	if (!isHourlyChimeCached) {
	    PlaySound(fullPathFileName);
	} else {
	    if (PlayCacheSound(&hourlyChimeCache) != SOUND_NO_ERROR) {
		/* $B%-%c%C%7%e2=$5$l$?%5%&%s%I$r@8@.$G$-$J$+$C$?(B */
		PlaySound(fullPathFileName);
	    }
	}
    }

    XtFree(fullPathFileName);
#endif
}


/*
 *  30$BJ,%A%c%$%`%5%&%s%I$N5-21(B
 */
void
StoreHalfHourChimeFileName(filename)
    char	*filename;
{
    if (halfHourChimeFileName != NULL) {
	XtFree(halfHourChimeFileName);
    }
    halfHourChimeFileName = (char *)XtMalloc(strlen(filename) + 1);
    strcpy(halfHourChimeFileName, filename);

#if defined(USE_SOUND) && defined(HAS_SOUND_CODE)
    if (IsSoundCacheAvailable()) {
	char	*fullPathFileName;

	if (isHalfHourChimeCached) {
	    FreeCacheSound(&halfHourChimeCache);
	}

	fullPathFileName = FullPathSoundFileName(halfHourChimeFileName);

	if (CacheSound(fullPathFileName, &halfHourChimeCache)
							== SOUND_NO_ERROR) {
	    isHalfHourChimeCached = True;
	} else {
	    isHalfHourChimeCached = False;
	}

	XtFree(fullPathFileName);
    }
#endif
}


/*
 *  30$BJ,%A%c%$%`%5%&%s%I$N%U%!%$%kL><hF@(B
 */
char *
GetHalfHourChimeFileName()
{
    return(halfHourChimeFileName);
}


/*
 *  30$BJ,%A%c%$%`%5%&%s%I$N:F@8(B
 */
void
PlayHalfHourChime()
{
#if defined(USE_SOUND) && defined(HAS_SOUND_CODE)
    char	*fullPathFileName;

    fullPathFileName = FullPathSoundFileName(halfHourChimeFileName);

    if (halfHourChimeFileName != NULL) {
	if (!isHalfHourChimeCached) {
	    PlaySound(fullPathFileName);
	} else {
	    if (PlayCacheSound(&halfHourChimeCache) != SOUND_NO_ERROR) {
		/* $B%-%c%C%7%e2=$5$l$?%5%&%s%I$r@8@.$G$-$J$+$C$?(B */
		PlaySound(fullPathFileName);
	    }
	}
    }

    XtFree(fullPathFileName);
#endif
}


/*
 *  $B%"%i!<%`%5%&%s%I$N5-21(B
 */
void
StoreAlarmFileName(filename)
    char	*filename;
{
    if (alarmFileName != NULL) {
	XtFree(alarmFileName);
    }
    alarmFileName = (char *)XtMalloc(strlen(filename) + 1);
    strcpy(alarmFileName, filename);
}


/*
 *  $B%"%i!<%`%5%&%s%I$N%U%!%$%kL><hF@(B
 */
char *
GetAlarmFileName()
{
    return(alarmFileName);
}


/*
 *  $B%"%i!<%`%5%&%s%I$N:F@8(B
 */
void
PlayAlarm()
{
#if defined(USE_SOUND) && defined(HAS_SOUND_CODE)
    char	*fullPathFileName;

    fullPathFileName = FullPathSoundFileName(alarmFileName);
    PlaySound(fullPathFileName);
    XtFree(fullPathFileName);
#endif
}


/*
 *  $B%-%c%C%7%e2=$5$l$?%A%c%$%`$N3+J|(B
 */
void
ClearChimeCache()
{
    if (isHourlyChimeCached) {
    	FreeCacheSound(&hourlyChimeCache);
    }

    if (isHalfHourChimeCached) {
	FreeCacheSound(&halfHourChimeCache);
    }
}


/*
 *  $B%5%&%s%I:F@8(B
 */
#if defined(USE_SOUND) && defined(HAS_SOUND_CODE)
static int
PlaySound(filename)
    char	*filename;
{
    return(S_PlaySound(filename));
}
#endif


/*
 *  $B%5%&%s%I$N%-%c%C%7%e2=2DG=!?IT2DG=H=Dj(B
 */
#if defined(USE_SOUND) && defined(HAS_SOUND_CODE)
static Boolean
IsSoundCacheAvailable()
{
    if (!app_data.isNoSoundCache) {
	return(S_IsSoundCacheAvailable());
    }

    return(False);
}
#endif


/*
 *  $B%5%&%s%I$N%-%c%C%7%e2=(B
 */
#if defined(USE_SOUND) && defined(HAS_SOUND_CODE)
static int
CacheSound(filename, cacheBufferPtr)
    char		*filename;
    SoundCacheBuffer	*cacheBufferPtr;
{
    return(S_CacheSound(filename, cacheBufferPtr));
}
#endif


/*
 *  $B%-%c%C%7%e2=$5$l$?%5%&%s%I$N:F@8(B
 */
#if defined(USE_SOUND) && defined(HAS_SOUND_CODE)
static int
PlayCacheSound(cacheBufferPtr)
    SoundCacheBuffer	*cacheBufferPtr;
{
    return(S_PlayCacheSound(cacheBufferPtr));
}
#endif


/*
 *  $B%-%c%C%7%e2=$5$l$?%5%&%s%I$N3+J|(B
 */
static void
FreeCacheSound(cacheBufferPtr)
    SoundCacheBuffer	*cacheBufferPtr;
{
#if defined(USE_SOUND) && defined(HAS_SOUND_CODE)
    S_FreeCacheSound(cacheBufferPtr);
#endif
}


/*
 *  $B%5%&%s%I4D6-$N8e;OKv(B
 */
void
SoundEnvDispose()
{
    if (hourlyChimeFileName != NULL) {
	XtFree(hourlyChimeFileName);
    }

    if (halfHourChimeFileName != NULL) {
	XtFree(halfHourChimeFileName);
    }

    if (alarmFileName != NULL) {
	XtFree(alarmFileName);
    }

#if defined(USE_SOUND) && defined(HAS_SOUND_CODE)
    S_SoundEnvDispose();
#endif
}


/*
 *  $B%5%&%s%I%U%!%$%kL>$N%U%k%Q%9<hF@(B
 */
#if defined(USE_SOUND) && defined(HAS_SOUND_CODE)
static char *
FullPathSoundFileName(filename)
    char	*filename;
{
    char	*fullPathFileName;

    fullPathFileName = (char *)XtMalloc(sizeof(char) * 
			(strlen(SOUND_DIRECTORY) + strlen(filename) + 2));
    sprintf(fullPathFileName, "%s/%s", SOUND_DIRECTORY, filename);
    return(fullPathFileName);
}
#endif


/*
 *  $B%5%&%s%I%U%!%$%k$NB8:_H=Dj(B
 */
Boolean
IsSoundFileExist(filename)
    char	*filename;
{
#if defined(USE_SOUND) && defined(HAS_SOUND_CODE)
    char	*fullPathFileName;
    Boolean	result;

    fullPathFileName = FullPathSoundFileName(filename);
    result = IsFileExist(fullPathFileName);
    XtFree(fullPathFileName);

    return(result);
#else
    return(False);
#endif
}


/*
 *  $B%5%&%s%I%U%!%$%k$N%F%9%H:F@8(B
 */
int
SoundTest(filename)
    char	*filename;
{
#if defined(USE_SOUND) && defined(HAS_SOUND_CODE)
    char	*fullPathFileName;
    int		status;

    fullPathFileName = FullPathSoundFileName(filename);
    status = PlaySound(fullPathFileName);
    XtFree(fullPathFileName);

    return(status);
#else
    return(SOUND_NOT_AVAILABLE);
#endif
}
