#include "common.h"
#ifndef OPENSSL_NO_DH
#define DN_new DH_new
#ifndef HEADER_DH_H
# include <openssl/dh.h>
#endif

DH *get_dh2048()
{
    static unsigned char dhp_2048[] = {
	0xB6, 0x88, 0xBA, 0xF0, 0x7E, 0xD3, 0x83, 0xBD, 0xCC, 0x18, 
	0x1B, 0xEF, 0xE0, 0x3B, 0xD5, 0x89, 0x50, 0x53, 0xF7, 0x56, 
	0x3C, 0xCD, 0xF0, 0x26, 0x1B, 0xA4, 0xFF, 0x01, 0x72, 0x7D, 
	0x13, 0x23, 0xEB, 0xF2, 0x72, 0x7E, 0xE4, 0x37, 0x04, 0xA0, 
	0x0A, 0x16, 0x5F, 0x85, 0xF7, 0x34, 0x7E, 0x27, 0xDE, 0x4E, 
	0xEF, 0x1F, 0x96, 0x9D, 0x4E, 0x83, 0xE2, 0x22, 0x25, 0x50, 
	0xF3, 0x0D, 0xFB, 0xC6, 0x98, 0x4B, 0x83, 0x36, 0x6F, 0x39, 
	0x0B, 0x3E, 0x05, 0xE1, 0x45, 0x30, 0xD8, 0x00, 0xAF, 0xC1, 
	0x11, 0x7F, 0xFA, 0xA0, 0x5B, 0x5B, 0x53, 0x04, 0x0B, 0xE5, 
	0x3F, 0x01, 0xDC, 0x76, 0x88, 0xB1, 0xDC, 0x5D, 0x05, 0x99, 
	0x50, 0xB6, 0xDA, 0xFD, 0x5F, 0xF8, 0xAF, 0x22, 0x12, 0x49, 
	0x87, 0xBD, 0x01, 0x20, 0x1D, 0x15, 0xAB, 0xA0, 0x61, 0x85, 
	0xCB, 0x0E, 0x92, 0x38, 0x87, 0x0E, 0xBA, 0xE3, 0xE6, 0x74, 
	0x17, 0x32, 0xBC, 0x16, 0xA2, 0x6B, 0x62, 0x13, 0x81, 0x84, 
	0x6E, 0xBD, 0x9A, 0x4F, 0x75, 0x88, 0x44, 0x08, 0xAA, 0x85, 
	0x34, 0x6B, 0x3C, 0xDC, 0x10, 0xB1, 0x82, 0xF6, 0x96, 0x58, 
	0x0F, 0xBC, 0x6E, 0x7A, 0x69, 0xFC, 0x52, 0xD5, 0xF3, 0x6A, 
	0xCF, 0x72, 0xEE, 0x52, 0x88, 0xBB, 0x17, 0x2C, 0x37, 0xD2, 
	0x3C, 0x82, 0xFB, 0x8B, 0xD6, 0x35, 0x6C, 0xFF, 0x4B, 0xE3, 
	0x05, 0x07, 0x24, 0x73, 0xB5, 0xF2, 0x57, 0x22, 0xF9, 0x71, 
	0xEC, 0xA4, 0x2F, 0xB4, 0xC7, 0xF4, 0x17, 0x73, 0xE4, 0xE9, 
	0x21, 0xA4, 0x6C, 0x21, 0x4B, 0xC2, 0xAA, 0x99, 0xF0, 0xCE, 
	0x62, 0x66, 0x98, 0xAC, 0x43, 0x21, 0x21, 0x3F, 0xAF, 0xC0, 
	0x1D, 0xB0, 0x89, 0x6D, 0xCC, 0xAD, 0xAA, 0xA6, 0x2D, 0x25, 
	0x6A, 0x27, 0x83, 0x59, 0x7B, 0x6A, 0x40, 0x70, 0x37, 0x95, 
	0x5B, 0xDF, 0x7A, 0xA9, 0x50, 0x0B
    };
    static unsigned char dhg_2048[] = {
	0x02
    };
    DH *dh = DN_new();

    if (dh == NULL)
        return NULL;
    dh->p = BN_bin2bn(dhp_2048, sizeof (dhp_2048), NULL);
    dh->g = BN_bin2bn(dhg_2048, sizeof (dhg_2048), NULL);
    if (!dh->p || !dh->g) {
        DH_free(dh);
        return NULL;
    }
    return dh;
}
#endif /* OPENSSL_NO_DH */
