#!/bin/sh
# Verify the operations done by shred

# Copyright (C) 2009-2014 Free Software Foundation, Inc.

# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.

# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

. "${srcdir=.}/tests/init.sh"; path_prepend_ ./src
print_ver_ shred


# shred a single letter, which should result in
# 3 random passes and a single rename.
printf 1 > f || framework_failure_
echo "\
shred: f: pass 1/3 (random)...
shred: f: pass 2/3 (random)...
shred: f: pass 3/3 (random)...
shred: f: removing
shred: f: renamed to 0
shred: f: removed" > exp || framework_failure_

shred -v -u f 2>out || fail=1

compare exp out || fail=1

# Likewise but for a zero length file
# to bypass the data passes
touch f || framework_failure_
echo "\
shred: f: removing
shred: f: renamed to 0
shred: f: removed" > exp || framework_failure_

shred -v -u f 2>out || fail=1

compare exp out || fail=1


Exit $fail
