/*
 * Decompiled with CFR 0.152.
 */
package virtuoso.jdbc4;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.BatchUpdateException;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.LinkedList;
import openlink.util.Vector;
import virtuoso.jdbc4.VirtuosoBlob;
import virtuoso.jdbc4.VirtuosoCallableStatement;
import virtuoso.jdbc4.VirtuosoConnection;
import virtuoso.jdbc4.VirtuosoException;
import virtuoso.jdbc4.VirtuosoExplicitString;
import virtuoso.jdbc4.VirtuosoFNSException;
import virtuoso.jdbc4.VirtuosoNullParameter;
import virtuoso.jdbc4.VirtuosoParameterMetaData;
import virtuoso.jdbc4.VirtuosoResultSet;
import virtuoso.jdbc4.VirtuosoStatement;

public class VirtuosoPreparedStatement
extends VirtuosoStatement
implements PreparedStatement {
    protected String sql;
    private static final int _EXECUTE_FAILED = -3;

    VirtuosoPreparedStatement(VirtuosoConnection virtuosoConnection, String string) throws VirtuosoException {
        this(virtuosoConnection, string, 1003, 1007);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    VirtuosoPreparedStatement(VirtuosoConnection virtuosoConnection, String string, int n, int n2) throws VirtuosoException {
        super(virtuosoConnection, n, n2);
        VirtuosoConnection virtuosoConnection2 = virtuosoConnection;
        synchronized (virtuosoConnection2) {
            try {
                this.sql = string;
                this.parse_sql();
                Object[] objectArray = new Object[]{this.statid == null ? (this.statid = new String("s" + virtuosoConnection.hashCode() + req_no++)) : this.statid, virtuosoConnection.escapeSQL(string), new Long(0L), this.getStmtOpts()};
                this.future = virtuosoConnection.getFuture("PREP", objectArray, this.rpc_timeout);
                this.vresultSet = new VirtuosoResultSet(this, this.metaData);
                this.clearParameters();
            }
            catch (IOException iOException) {
                throw new VirtuosoException("Problem during serialization : " + iOException.getMessage(), -3);
            }
        }
    }

    private void parse_sql() {
        String string = this.sql;
        int n = 0;
        do {
            int n2;
            if ((n2 = string.indexOf("?")) >= 0) {
                ++n;
                if ((string = string.substring(n2 + 1, string.length())) != null) continue;
                string = "";
                continue;
            }
            string = "";
        } while (string.length() != 0);
        this.parameters = new Vector(n);
        this.objparams = new Vector(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendQuery() throws VirtuosoException {
        VirtuosoConnection virtuosoConnection = this.connection;
        synchronized (virtuosoConnection) {
            Object[] objectArray = new Object[6];
            Vector vector = new Vector(1);
            objectArray[0] = this.statid;
            objectArray[2] = this.cursorName == null ? objectArray[0] : this.cursorName;
            objectArray[1] = null;
            objectArray[3] = vector;
            objectArray[4] = null;
            try {
                vector.addElement(this.objparams);
                objectArray[5] = this.getStmtOpts();
                this.future = this.connection.getFuture("EXEC", objectArray, this.rpc_timeout);
                this.vresultSet.getMoreResults();
            }
            catch (IOException iOException) {
                throw new VirtuosoException("Problem during serialization : " + iOException.getMessage(), -3);
            }
        }
    }

    protected void setVector(int n, Vector vector) throws VirtuosoException {
        if (n < 1 || n > this.parameters.capacity()) {
            throw new VirtuosoException("Index " + n + " is not 1<n<" + this.parameters.capacity(), -4);
        }
        if (vector == null) {
            this.setNull(n, 2003);
        } else {
            this.objparams.setElementAt(vector, n - 1);
        }
    }

    @Override
    public void clearParameters() throws VirtuosoException {
        this.objparams.removeAllElements();
    }

    @Override
    public boolean execute() throws VirtuosoException {
        this.exec_type = -1;
        this.sendQuery();
        return this.vresultSet.kindop() != 0;
    }

    @Override
    public int executeUpdate() throws VirtuosoException {
        this.exec_type = 0;
        this.sendQuery();
        return this.vresultSet.getUpdateCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] executeBatchUpdate() throws BatchUpdateException {
        int n = this.batch.size();
        int[] nArray = new int[n];
        int n2 = 0;
        VirtuosoConnection virtuosoConnection = this.connection;
        synchronized (virtuosoConnection) {
            Object[] objectArray = new Object[6];
            objectArray[0] = this.statid;
            objectArray[2] = this.cursorName == null ? objectArray[0] : this.cursorName;
            objectArray[1] = null;
            objectArray[3] = this.batch;
            objectArray[4] = null;
            try {
                objectArray[5] = this.getStmtOpts();
                this.future = this.connection.getFuture("EXEC", objectArray, this.rpc_timeout);
                for (n2 = 0; n2 < n; ++n2) {
                    this.vresultSet.setUpdateCount(0);
                    this.vresultSet.getMoreResults();
                    nArray[n2] = this.vresultSet.getUpdateCount();
                }
            }
            catch (IOException iOException) {
                this.throwBatchUpdateException(nArray, "Problem during serialization : " + iOException.getMessage(), n2);
            }
            catch (VirtuosoException virtuosoException) {
                this.throwBatchUpdateException(nArray, virtuosoException, n2);
            }
        }
        return nArray;
    }

    @Override
    public ResultSet executeQuery() throws VirtuosoException {
        this.exec_type = 1;
        this.sendQuery();
        return this.vresultSet;
    }

    @Override
    public ResultSetMetaData getMetaData() throws VirtuosoException {
        if (this.vresultSet != null) {
            return this.vresultSet.getMetaData();
        }
        throw new VirtuosoException("Prepared statement closed", -13);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws VirtuosoException {
        if (this.isCached) {
            this.close_flag = true;
            try {
                this.connection.recacheStmt(this);
            }
            catch (SQLException sQLException) {
                throw new VirtuosoException(sQLException.getMessage(), sQLException.getSQLState(), sQLException.getErrorCode());
            }
            return;
        }
        VirtuosoConnection virtuosoConnection = this.connection;
        synchronized (virtuosoConnection) {
            try {
                if (this.statid == null) {
                    return;
                }
                this.cancel();
                Object[] objectArray = new Object[]{this.statid, new Long(0L)};
                this.future = this.connection.getFuture("FRST", objectArray, this.rpc_timeout);
                this.future.nextResult();
                this.connection.removeFuture(this.future);
                this.future = null;
            }
            catch (IOException iOException) {
                throw new VirtuosoException("Problem during closing : " + iOException.getMessage(), -3);
            }
        }
    }

    @Override
    public void setAsciiStream(int n, InputStream inputStream, int n2) throws VirtuosoException {
        Object object;
        if (n < 1 || n > this.parameters.capacity()) {
            throw new VirtuosoException("Index " + n + " is not 1<n<" + this.parameters.capacity(), -4);
        }
        Object object2 = this.objparams.elementAt(n - 1);
        if (this.parameters != null && this.parameters.elementAt(n - 1) instanceof Vector) {
            object = (Vector)this.parameters.elementAt(n - 1);
            int n3 = ((Number)((Vector)object).elementAt(0)).intValue();
            if (n3 != 125 && n3 != 131 && n3 != 132) {
                throw new VirtuosoException("Passing streams to non-blob columns not supported", "IM001", -7);
            }
            if (n3 == 131) {
                throw new VirtuosoException("Passing ASCII stream to LONG VARBINARY columns not supported", "IM001", -7);
            }
        }
        if (object2 instanceof VirtuosoBlob) {
            ((VirtuosoBlob)object2).setInputStream(inputStream, n2);
            try {
                ((VirtuosoBlob)object2).setReader(new InputStreamReader(inputStream, "ASCII"), n2);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                ((VirtuosoBlob)object2).setReader(new InputStreamReader(inputStream), n2);
            }
        } else if (inputStream == null) {
            this.setNull(n, 2005);
        } else {
            try {
                object = new InputStreamReader(inputStream, "ASCII");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                object = new InputStreamReader(inputStream);
            }
            VirtuosoBlob virtuosoBlob = new VirtuosoBlob((Reader)object, (long)n2, (long)(n - 1));
            virtuosoBlob.setInputStream(inputStream, n2);
            this.objparams.setElementAt(virtuosoBlob, n - 1);
        }
    }

    @Override
    public void setBigDecimal(int n, BigDecimal bigDecimal) throws VirtuosoException {
        if (n < 1 || n > this.parameters.capacity()) {
            throw new VirtuosoException("Index " + n + " is not 1<n<" + this.parameters.capacity(), -4);
        }
        if (bigDecimal == null) {
            this.setNull(n, 2);
        } else {
            this.objparams.setElementAt(bigDecimal, n - 1);
        }
    }

    @Override
    public void setBinaryStream(int n, InputStream inputStream, int n2) throws VirtuosoException {
        Object object;
        if (n < 1 || n > this.parameters.capacity()) {
            throw new VirtuosoException("Index " + n + " is not 1<n<" + this.parameters.capacity(), -4);
        }
        Object object2 = this.objparams.elementAt(n - 1);
        if (this.parameters != null && this.parameters.elementAt(n - 1) instanceof Vector) {
            object = (Vector)this.parameters.elementAt(n - 1);
            int n3 = ((Number)((Vector)object).elementAt(0)).intValue();
            if (n3 != 125 && n3 != 131 && n3 != 132) {
                throw new VirtuosoException("Passing streams to non-blob columns not supported", "IM001", -7);
            }
            if (n3 == 132) {
                throw new VirtuosoException("Passing binary stream to LONG NVARCHAR columns not supported", "IM001", -7);
            }
        }
        if (object2 instanceof VirtuosoBlob) {
            ((VirtuosoBlob)object2).setInputStream(inputStream, n2);
            try {
                ((VirtuosoBlob)object2).setReader(new InputStreamReader(inputStream, "8859_1"), n2);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                ((VirtuosoBlob)object2).setReader(new InputStreamReader(inputStream), n2);
            }
        } else if (inputStream == null) {
            this.setNull(n, 2004);
        } else {
            try {
                object = new InputStreamReader(inputStream, "8859_1");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                object = new InputStreamReader(inputStream);
            }
            VirtuosoBlob virtuosoBlob = new VirtuosoBlob((Reader)object, (long)n2, (long)(n - 1));
            virtuosoBlob.setInputStream(inputStream, n2);
            this.objparams.setElementAt(virtuosoBlob, n - 1);
        }
    }

    @Override
    public void setUnicodeStream(int n, InputStream inputStream, int n2) throws VirtuosoException {
        Object object;
        if (n < 1 || n > this.parameters.capacity()) {
            throw new VirtuosoException("Index " + n + " is not 1<n<" + this.parameters.capacity(), -4);
        }
        Object object2 = this.objparams.elementAt(n - 1);
        if (this.parameters != null && this.parameters.elementAt(n - 1) instanceof Vector) {
            object = (Vector)this.parameters.elementAt(n - 1);
            int n3 = ((Number)((Vector)object).elementAt(0)).intValue();
            if (n3 != 125 && n3 != 131 && n3 != 132) {
                throw new VirtuosoException("Passing streams to non-blob columns not supported", "IM001", -7);
            }
            if (n3 == 131) {
                throw new VirtuosoException("Passing unicode stream to LONG VARBINARY columns not supported", "IM001", -7);
            }
        }
        if (object2 instanceof VirtuosoBlob) {
            ((VirtuosoBlob)object2).setInputStream(inputStream, n2);
            try {
                ((VirtuosoBlob)object2).setReader(new InputStreamReader(inputStream, "UTF8"), n2);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                ((VirtuosoBlob)object2).setReader(new InputStreamReader(inputStream), n2);
            }
        } else if (inputStream == null) {
            this.setNull(n, 2005);
        } else {
            try {
                object = new InputStreamReader(inputStream, "UTF8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                object = new InputStreamReader(inputStream);
            }
            VirtuosoBlob virtuosoBlob = new VirtuosoBlob((Reader)object, (long)n2, (long)(n - 1));
            virtuosoBlob.setInputStream(inputStream, n2);
            this.objparams.setElementAt(virtuosoBlob, n - 1);
        }
    }

    @Override
    public void setBoolean(int n, boolean bl) throws VirtuosoException {
        if (n < 1 || n > this.parameters.capacity()) {
            throw new VirtuosoException("Index " + n + " is not 1<n<" + this.parameters.capacity(), -4);
        }
        this.objparams.setElementAt(new Boolean(bl), n - 1);
    }

    @Override
    public void setByte(int n, byte by) throws VirtuosoException {
        if (n < 1 || n > this.parameters.capacity()) {
            throw new VirtuosoException("Index " + n + " is not 1<n<" + this.parameters.capacity(), -4);
        }
        this.objparams.setElementAt(new Byte(by), n - 1);
    }

    @Override
    public void setBytes(int n, byte[] byArray) throws VirtuosoException {
        if (n < 1 || n > this.parameters.capacity()) {
            throw new VirtuosoException("Index " + n + " is not 1<n<" + this.parameters.capacity(), -4);
        }
        if (byArray == null) {
            this.setNull(n, -3);
        } else {
            this.objparams.setElementAt(byArray, n - 1);
        }
    }

    @Override
    public void setDate(int n, Date date) throws VirtuosoException {
        this.setDate(n, date, null);
    }

    @Override
    public void setDouble(int n, double d) throws VirtuosoException {
        if (n < 1 || n > this.parameters.capacity()) {
            throw new VirtuosoException("Index " + n + " is not 1<n<" + this.parameters.capacity(), -4);
        }
        this.objparams.setElementAt(new Double(d), n - 1);
    }

    @Override
    public void setFloat(int n, float f) throws VirtuosoException {
        if (n < 1 || n > this.parameters.capacity()) {
            throw new VirtuosoException("Index " + n + " is not 1<n<" + this.parameters.capacity(), -4);
        }
        this.objparams.setElementAt(new Float(f), n - 1);
    }

    @Override
    public void setInt(int n, int n2) throws VirtuosoException {
        if (n < 1 || n > this.parameters.capacity()) {
            throw new VirtuosoException("Index " + n + " is not 1<n<" + this.parameters.capacity(), -4);
        }
        this.objparams.setElementAt(new Integer(n2), n - 1);
    }

    @Override
    public void setLong(int n, long l) throws VirtuosoException {
        if (n < 1 || n > this.parameters.capacity()) {
            throw new VirtuosoException("Index " + n + " is not 1<n<" + this.parameters.capacity(), -4);
        }
        this.objparams.setElementAt(new Long(l), n - 1);
    }

    @Override
    public void setNull(int n, int n2) throws VirtuosoException {
        if (n < 1 || n > this.parameters.capacity()) {
            throw new VirtuosoException("Index " + n + " is not 1<n<" + this.parameters.capacity(), -4);
        }
        this.objparams.setElementAt(new VirtuosoNullParameter(n2, true), n - 1);
    }

    @Override
    public void setObject(int n, Object object) throws VirtuosoException {
        this.setObject(n, object, 1111);
    }

    @Override
    public void setObject(int n, Object object, int n2) throws VirtuosoException {
        this.setObject(n, object, n2, 0);
    }

    protected Object mapJavaTypeToSqlType(Object object, int n, int n2) throws VirtuosoException {
        if (object == null) {
            return object;
        }
        if (object instanceof Boolean) {
            object = new Integer((Boolean)object != false ? 1 : 0);
        }
        switch (n) {
            case 1: 
            case 12: {
                if (object instanceof java.util.Date || object instanceof String) {
                    return object;
                }
                return object.toString();
            }
            case -1: {
                if (object instanceof Clob || object instanceof Blob || object instanceof String) {
                    return object;
                }
                return object.toString();
            }
            case 91: 
            case 92: 
            case 93: {
                if (!(object instanceof java.util.Date) && !(object instanceof String)) break;
                return object;
            }
            case 2: 
            case 3: {
                BigDecimal bigDecimal = null;
                if (object instanceof BigDecimal) {
                    bigDecimal = (BigDecimal)object;
                } else if (object instanceof String) {
                    bigDecimal = new BigDecimal((String)object);
                } else if (object instanceof Number) {
                    bigDecimal = new BigDecimal(object.toString());
                }
                if (bigDecimal == null) break;
                return bigDecimal.setScale(n2);
            }
            case -5: {
                if (object instanceof BigDecimal || object instanceof String) {
                    return new Long(object.toString());
                }
                if (!(object instanceof Number)) break;
                return new Long(((Number)object).longValue());
            }
            case 6: 
            case 8: {
                if (object instanceof Double) {
                    return object;
                }
                if (object instanceof Number) {
                    return new Double(((Number)object).doubleValue());
                }
                if (!(object instanceof String)) break;
                return new Double((String)object);
            }
            case 4: {
                if (object instanceof Integer) {
                    return object;
                }
                if (object instanceof Number) {
                    return new Integer(((Number)object).intValue());
                }
                if (!(object instanceof String)) break;
                return new Integer((String)object);
            }
            case 7: {
                if (object instanceof Float) {
                    return object;
                }
                if (object instanceof Number) {
                    return new Float(((Number)object).floatValue());
                }
                if (!(object instanceof String)) break;
                return new Float((String)object);
            }
            case -7: 
            case -6: 
            case 5: 
            case 16: {
                if (object instanceof Short) {
                    return object;
                }
                if (object instanceof String) {
                    return new Short((String)object);
                }
                if (!(object instanceof Number)) break;
                return new Short(((Number)object).shortValue());
            }
            case -8: 
            case 70: 
            case 2001: 
            case 2003: 
            case 2006: {
                throw new VirtuosoException("Type not supported", -7);
            }
            case -3: {
                if (!(object instanceof byte[])) break;
                return object;
            }
            case -4: {
                if (!(object instanceof Blob) && !(object instanceof byte[])) break;
                return object;
            }
            default: {
                return object;
            }
        }
        throw new VirtuosoException("Invalid value specified", -4);
    }

    @Override
    public void setObject(int n, Object object, int n2, int n3) throws VirtuosoException {
        if (n < 1 || n > this.parameters.capacity()) {
            throw new VirtuosoException("Index " + n + " is not 1<n<" + this.parameters.capacity(), -4);
        }
        if (object instanceof VirtuosoExplicitString) {
            this.objparams.setElementAt(object, n - 1);
            return;
        }
        Object object2 = this.objparams.elementAt(n - 1);
        if (object2 instanceof VirtuosoBlob) {
            ((VirtuosoBlob)object2).setObject(object);
            return;
        }
        if (object == null) {
            this.setNull(n, 1111);
        }
        if (!((object = this.mapJavaTypeToSqlType(object, n2, n3)) instanceof Serializable)) {
            throw new VirtuosoException("Object " + object.getClass().getName() + " not serializable", "22023", -11);
        }
        this.objparams.setElementAt(object, n - 1);
    }

    @Override
    public void setShort(int n, short s) throws VirtuosoException {
        if (n < 1 || n > this.parameters.capacity()) {
            throw new VirtuosoException("Index " + n + " is not 1<n<" + this.parameters.capacity(), -4);
        }
        this.objparams.setElementAt(new Short(s), n - 1);
    }

    @Override
    public void setString(int n, String string) throws VirtuosoException {
        if (n < 1 || n > this.parameters.capacity()) {
            throw new VirtuosoException("Index " + n + " is not 1<n<" + this.parameters.capacity(), -4);
        }
        if (string == null) {
            this.setNull(n, 12);
        } else {
            String string2 = string;
            if (this.parameters != null && this.parameters.elementAt(n - 1) instanceof Vector) {
                Vector vector = (Vector)this.parameters.elementAt(n - 1);
                int n2 = ((Number)vector.elementAt(0)).intValue();
                VirtuosoExplicitString virtuosoExplicitString = new VirtuosoExplicitString(string2, n2, this.connection);
                this.objparams.setElementAt(virtuosoExplicitString, n - 1);
            } else {
                this.objparams.setElementAt(string2, n - 1);
            }
        }
    }

    protected void setString(int n, VirtuosoExplicitString virtuosoExplicitString) throws VirtuosoException {
        if (n < 1 || n > this.parameters.capacity()) {
            throw new VirtuosoException("Index " + n + " is not 1<n<" + this.parameters.capacity(), -4);
        }
        if (virtuosoExplicitString == null) {
            this.setNull(n, 12);
        } else {
            this.objparams.setElementAt(virtuosoExplicitString, n - 1);
        }
    }

    @Override
    public void setTime(int n, Time time) throws VirtuosoException {
        this.setTime(n, time, null);
    }

    @Override
    public void setTimestamp(int n, Timestamp timestamp) throws VirtuosoException {
        this.setTimestamp(n, timestamp, null);
    }

    @Override
    public void addBatch() throws VirtuosoException {
        if (this.parameters == null) {
            return;
        }
        if (this.batch == null) {
            this.batch = new LinkedList();
        }
        this.batch.add(this.objparams.clone());
    }

    private void throwBatchUpdateException(int[] nArray, SQLException sQLException, int n) throws BatchUpdateException {
        int[] nArray2 = new int[n + 1];
        System.arraycopy(nArray, 0, nArray2, 0, n);
        nArray2[n] = -3;
        throw new BatchUpdateException(sQLException.getMessage(), sQLException.getSQLState(), sQLException.getErrorCode(), nArray2);
    }

    private void throwBatchUpdateException(int[] nArray, String string, int n) throws BatchUpdateException {
        int[] nArray2 = new int[n + 1];
        System.arraycopy(nArray, 0, nArray2, 0, n);
        nArray2[n] = -3;
        throw new BatchUpdateException(string, "HY000", 0, nArray2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int[] executeBatch() throws BatchUpdateException {
        if (this.batch == null) {
            return new int[0];
        }
        int[] nArray = new int[this.batch.size()];
        boolean bl = false;
        if (this instanceof VirtuosoCallableStatement && ((VirtuosoCallableStatement)this).hasOut()) {
            this.throwBatchUpdateException(nArray, "Batch can't execute calls with out params", 0);
        }
        try {
            if (this.vresultSet.kindop() == 1) {
                this.throwBatchUpdateException(nArray, "Batch executes only update statements", 0);
            }
            nArray = this.executeBatchUpdate();
        }
        catch (VirtuosoException virtuosoException) {
            this.throwBatchUpdateException(nArray, virtuosoException, 0);
        }
        finally {
            this.batch.clear();
        }
        return nArray;
    }

    @Override
    public void setArray(int n, Array array) throws VirtuosoException {
        if (n < 1 || n > this.parameters.capacity()) {
            throw new VirtuosoException("Index " + n + " is not 1<n<" + this.parameters.capacity(), -4);
        }
        if (array == null) {
            this.setNull(n, 2003);
        } else {
            this.objparams.setElementAt(array, n - 1);
        }
    }

    @Override
    public void setBlob(int n, Blob blob) throws VirtuosoException {
        if (n < 1 || n > this.parameters.capacity()) {
            throw new VirtuosoException("Index " + n + " is not 1<n<" + this.parameters.capacity(), -4);
        }
        if (blob == null) {
            this.setNull(n, 2004);
        } else {
            this.objparams.setElementAt(blob, n - 1);
        }
    }

    @Override
    public void setCharacterStream(int n, Reader reader, int n2) throws VirtuosoException {
        Object object;
        if (n < 1 || n > this.parameters.capacity()) {
            throw new VirtuosoException("Index " + n + " is not 1<n<" + this.parameters.capacity(), -4);
        }
        if (this.parameters != null && this.parameters.elementAt(n - 1) instanceof Vector) {
            object = (Vector)this.parameters.elementAt(n - 1);
            int n3 = ((Number)((Vector)object).elementAt(0)).intValue();
            if (n3 != 125 && n3 != 131 && n3 != 132) {
                try {
                    int n4;
                    StringBuffer stringBuffer = new StringBuffer();
                    char[] cArray = new char[4096];
                    int n5 = 0;
                    do {
                        int n6;
                        if ((n4 = reader.read(cArray, 0, n6 = n2 - n5 > cArray.length ? cArray.length : n2 - n5)) <= 0) continue;
                        stringBuffer.append(cArray, 0, n4);
                        n5 += n4;
                    } while (n4 > 0 && n5 < n2);
                    String string = stringBuffer.toString();
                    if (this.connection.charset != null) {
                        this.objparams.setElementAt(new VirtuosoExplicitString(this.connection.charsetBytes(string), 182), n - 1);
                    } else {
                        this.objparams.setElementAt(string, n - 1);
                    }
                    return;
                }
                catch (IOException iOException) {
                    throw new VirtuosoException("Error reading from a character stream " + iOException.getMessage(), -3);
                }
            }
            if (n3 == 131) {
                throw new VirtuosoException("Passing character stream to LONG VARBINARY columns not supported", "IM001", -7);
            }
        }
        if ((object = this.objparams.elementAt(n - 1)) instanceof VirtuosoBlob) {
            ((VirtuosoBlob)object).setReader(reader, n2);
            return;
        }
        if (reader == null) {
            this.setNull(n, 2004);
        } else {
            this.objparams.setElementAt(new VirtuosoBlob(reader, (long)n2, (long)(n - 1)), n - 1);
        }
    }

    @Override
    public void setClob(int n, Clob clob) throws VirtuosoException {
        if (n < 1 || n > this.parameters.capacity()) {
            throw new VirtuosoException("Index " + n + " is not 1<n<" + this.parameters.capacity(), -4);
        }
        if (clob == null) {
            this.setNull(n, 2005);
        } else {
            this.objparams.setElementAt(clob, n - 1);
        }
    }

    @Override
    public void setNull(int n, int n2, String string) throws VirtuosoException {
        this.setNull(n, n2);
    }

    @Override
    public void setRef(int n, Ref ref) throws VirtuosoException {
        if (n < 1 || n > this.parameters.capacity()) {
            throw new VirtuosoException("Index " + n + " is not 1<n<" + this.parameters.capacity(), -4);
        }
        if (ref == null) {
            this.setNull(n, 2006);
        } else {
            this.objparams.setElementAt(ref, n - 1);
        }
    }

    @Override
    public void setDate(int n, Date date, Calendar calendar) throws VirtuosoException {
        if (n < 1 || n > this.parameters.capacity()) {
            throw new VirtuosoException("Index " + n + " is not 1<n<" + this.parameters.capacity(), -4);
        }
        if (date == null) {
            this.setNull(n, 91);
        } else {
            if (calendar != null) {
                calendar.setTime(date);
                date = new Date(calendar.getTime().getTime());
            }
            this.objparams.setElementAt(date, n - 1);
        }
    }

    @Override
    public void setTime(int n, Time time, Calendar calendar) throws VirtuosoException {
        if (n < 1 || n > this.parameters.capacity()) {
            throw new VirtuosoException("Index " + n + " is not 1<n<" + this.parameters.capacity(), -4);
        }
        if (time == null) {
            this.setNull(n, 92);
        } else {
            if (calendar != null) {
                calendar.setTime(time);
                time = new Time(calendar.getTime().getTime());
            }
            this.objparams.setElementAt(time, n - 1);
        }
    }

    @Override
    public void setTimestamp(int n, Timestamp timestamp, Calendar calendar) throws VirtuosoException {
        if (n < 1 || n > this.parameters.capacity()) {
            throw new VirtuosoException("Index " + n + " is not 1<n<" + this.parameters.capacity(), -4);
        }
        if (timestamp == null) {
            this.setNull(n, 93);
        } else {
            if (calendar != null) {
                int n2 = timestamp.getNanos();
                calendar.setTime(timestamp);
                timestamp = new Timestamp(calendar.getTime().getTime());
                timestamp.setNanos(n2);
            }
            this.objparams.setElementAt(timestamp, n - 1);
        }
    }

    @Override
    public void setURL(int n, URL uRL) throws SQLException {
        throw new VirtuosoException("DATALINK not supported", -7);
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        return this.paramsMetaData == null ? new VirtuosoParameterMetaData(null, this.connection) : this.paramsMetaData;
    }

    @Override
    public void setRowId(int n, RowId rowId) throws SQLException {
        throw new VirtuosoFNSException("Method  setRowId(parameterIndex, x)  isn't supported", -7);
    }

    @Override
    public synchronized void setNString(int n, String string) throws SQLException {
        this.setString(n, string);
    }

    @Override
    public synchronized void setNCharacterStream(int n, Reader reader, long l) throws SQLException {
        this.setCharacterStream(n, reader, l);
    }

    @Override
    public synchronized void setNClob(int n, NClob nClob) throws SQLException {
        if (nClob == null) {
            this.setNull(n, 2011);
        } else {
            this.setNCharacterStream(n, nClob.getCharacterStream(), nClob.length());
        }
    }

    @Override
    public void setClob(int n, Reader reader, long l) throws SQLException {
        this.setCharacterStream(n, reader, l);
    }

    @Override
    public void setBlob(int n, InputStream inputStream, long l) throws SQLException {
        this.setBinaryStream(n, inputStream, (int)l);
    }

    @Override
    public synchronized void setNClob(int n, Reader reader, long l) throws SQLException {
        if (reader == null) {
            this.setNull(n, -1);
        } else {
            this.setNCharacterStream(n, reader, l);
        }
    }

    @Override
    public synchronized void setSQLXML(int n, SQLXML sQLXML) throws SQLException {
        throw new VirtuosoFNSException("Method  setSQLXML(parameterIndex, xmlObject)  isn't supported", -7);
    }

    @Override
    public void setAsciiStream(int n, InputStream inputStream, long l) throws SQLException {
        this.setAsciiStream(n, inputStream, (int)l);
    }

    @Override
    public void setBinaryStream(int n, InputStream inputStream, long l) throws SQLException {
        this.setBinaryStream(n, inputStream, (int)l);
    }

    @Override
    public void setCharacterStream(int n, Reader reader, long l) throws SQLException {
        this.setCharacterStream(n, reader, (int)l);
    }

    @Override
    public void setAsciiStream(int n, InputStream inputStream) throws SQLException {
        throw new VirtuosoFNSException("Method  setAsciiStream(parameterIndex, x)  isn't supported", -7);
    }

    @Override
    public void setBinaryStream(int n, InputStream inputStream) throws SQLException {
        throw new VirtuosoFNSException("Method  setAsciiStream(parameterIndex, x)  isn't supported", -7);
    }

    @Override
    public void setCharacterStream(int n, Reader reader) throws SQLException {
        throw new VirtuosoFNSException("Method  setCharacterStream(parameterIndex, reader)  isn't supported", -7);
    }

    @Override
    public void setNCharacterStream(int n, Reader reader) throws SQLException {
        throw new VirtuosoFNSException("Method  setNCharacterStream(parameterIndex, value)  isn't supported", -7);
    }

    @Override
    public void setClob(int n, Reader reader) throws SQLException {
        throw new VirtuosoFNSException("Method  setClob(parameterIndex, reader)  isn't supported", -7);
    }

    @Override
    public void setBlob(int n, InputStream inputStream) throws SQLException {
        throw new VirtuosoFNSException("Method  setBlob(parameterIndex, inputStream)  isn't supported", -7);
    }

    @Override
    public void setNClob(int n, Reader reader) throws SQLException {
        throw new VirtuosoFNSException("Method  setNClob(parameterIndex, reader)  isn't supported", -7);
    }

    protected synchronized void setClosed(boolean bl) {
        this.close_flag = bl;
    }
}

