/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sail.nativerdf;

import info.aduna.concurrent.locks.ExclusiveLockManager;
import info.aduna.concurrent.locks.Lock;
import info.aduna.concurrent.locks.ReadWriteLockManager;
import info.aduna.concurrent.locks.WritePrefReadWriteLockManager;
import info.aduna.iteration.CloseableIteration;
import info.aduna.iteration.CloseableIterationBase;
import info.aduna.iteration.ConvertingIteration;
import info.aduna.iteration.DistinctIteration;
import info.aduna.iteration.EmptyIteration;
import info.aduna.iteration.FilterIteration;
import info.aduna.iteration.Iteration;
import info.aduna.iteration.UnionIteration;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.sail.NotifyingSailConnection;
import org.openrdf.sail.SailException;
import org.openrdf.sail.helpers.DirectoryLockManager;
import org.openrdf.sail.helpers.NotifyingSailBase;
import org.openrdf.sail.nativerdf.NamespaceStore;
import org.openrdf.sail.nativerdf.NativeStatementIterator;
import org.openrdf.sail.nativerdf.NativeStoreConnection;
import org.openrdf.sail.nativerdf.TripleStore;
import org.openrdf.sail.nativerdf.ValueStore;
import org.openrdf.sail.nativerdf.btree.RecordIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NativeStore
extends NotifyingSailBase {
    private String tripleIndexes;
    private boolean forceSync = false;
    private TripleStore tripleStore;
    private ValueStore valueStore;
    private NamespaceStore namespaceStore;
    private ReadWriteLockManager storeLockManager;
    private ExclusiveLockManager txnLockManager;
    private boolean initialized = false;
    private Lock dirLock;

    public NativeStore() {
    }

    public NativeStore(File dataDir) {
        this();
        this.setDataDir(dataDir);
    }

    public NativeStore(File dataDir, String tripleIndexes) {
        this(dataDir);
        this.setTripleIndexes(tripleIndexes);
    }

    public void setTripleIndexes(String tripleIndexes) {
        if (this.isInitialized()) {
            throw new IllegalStateException("sail has already been intialized");
        }
        this.tripleIndexes = tripleIndexes;
    }

    public String getTripleIndexes() {
        return this.tripleIndexes;
    }

    public void setForceSync(boolean forceSync) {
        this.forceSync = forceSync;
    }

    public boolean getForceSync() {
        return this.forceSync;
    }

    @Override
    public void initialize() throws SailException {
        if (this.isInitialized()) {
            throw new IllegalStateException("sail has already been intialized");
        }
        this.logger.debug("Initializing NativeStore...");
        this.storeLockManager = new WritePrefReadWriteLockManager(NativeStore.debugEnabled());
        this.txnLockManager = new ExclusiveLockManager(NativeStore.debugEnabled());
        File dataDir = this.getDataDir();
        if (dataDir == null) {
            throw new SailException("Data dir has not been set");
        }
        if (!dataDir.exists()) {
            boolean success = dataDir.mkdirs();
            if (!success) {
                throw new SailException("Unable to create data directory: " + dataDir);
            }
        } else {
            if (!dataDir.isDirectory()) {
                throw new SailException("The specified path does not denote a directory: " + dataDir);
            }
            if (!dataDir.canRead()) {
                throw new SailException("Not allowed to read from the specified directory: " + dataDir);
            }
        }
        this.dirLock = new DirectoryLockManager(dataDir).lockOrFail();
        this.logger.debug("Data dir is " + dataDir);
        try {
            this.namespaceStore = new NamespaceStore(dataDir);
            this.valueStore = new ValueStore(dataDir, this.forceSync);
            this.tripleStore = new TripleStore(dataDir, this.tripleIndexes, this.forceSync);
        }
        catch (IOException e) {
            throw new SailException(e);
        }
        this.initialized = true;
        this.logger.debug("NativeStore initialized");
    }

    protected final boolean isInitialized() {
        return this.initialized;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void shutDownInternal() throws SailException {
        if (this.isInitialized()) {
            this.logger.debug("Shutting down NativeStore...");
            Lock txnLock = this.getTransactionLock();
            try {
                Lock writeLock = this.getWriteLock();
                try {
                    this.tripleStore.close();
                    this.valueStore.close();
                    this.namespaceStore.close();
                    this.initialized = false;
                    this.logger.debug("NativeStore shut down");
                }
                catch (IOException e) {
                    throw new SailException(e);
                }
                finally {
                    writeLock.release();
                }
            }
            finally {
                txnLock.release();
                this.dirLock.release();
            }
        }
    }

    @Override
    public boolean isWritable() {
        return this.getDataDir().canWrite();
    }

    @Override
    protected NotifyingSailConnection getConnectionInternal() throws SailException {
        if (!this.isInitialized()) {
            throw new IllegalStateException("sail not initialized.");
        }
        try {
            return new NativeStoreConnection(this);
        }
        catch (IOException e) {
            throw new SailException(e);
        }
    }

    @Override
    public ValueFactory getValueFactory() {
        return this.valueStore;
    }

    protected TripleStore getTripleStore() {
        return this.tripleStore;
    }

    protected ValueStore getValueStore() {
        return this.valueStore;
    }

    protected NamespaceStore getNamespaceStore() {
        return this.namespaceStore;
    }

    protected Lock getReadLock() throws SailException {
        try {
            return this.storeLockManager.getReadLock();
        }
        catch (InterruptedException e) {
            throw new SailException(e);
        }
    }

    protected Lock getWriteLock() throws SailException {
        try {
            return this.storeLockManager.getWriteLock();
        }
        catch (InterruptedException e) {
            throw new SailException(e);
        }
    }

    protected Lock getTransactionLock() throws SailException {
        try {
            return this.txnLockManager.getExclusiveLock();
        }
        catch (InterruptedException e) {
            throw new SailException(e);
        }
    }

    protected List<Integer> getContextIDs(Resource ... contexts) throws IOException {
        assert (contexts.length > 0) : "contexts must not be empty";
        LinkedHashSet contextSet = new LinkedHashSet();
        Collections.addAll(contextSet, contexts);
        ArrayList<Integer> contextIDs = new ArrayList<Integer>(contextSet.size());
        for (Resource context : contextSet) {
            if (context == null) {
                contextIDs.add(0);
                continue;
            }
            int contextID = this.valueStore.getID(context);
            if (contextID == -1) continue;
            contextIDs.add(contextID);
        }
        return contextIDs;
    }

    protected CloseableIteration<Resource, IOException> getContextIDs(boolean readTransaction) throws IOException {
        RecordIterator btreeIter = this.tripleStore.getAllTriplesSortedByContext(readTransaction);
        CloseableIteration<Statement, IOException> stIter = btreeIter == null ? this.createStatementIterator(null, null, null, true, readTransaction, new Resource[0]) : new NativeStatementIterator(btreeIter, this.valueStore);
        stIter = new FilterIteration<Statement, IOException>((Iteration)stIter){

            @Override
            protected boolean accept(Statement st) {
                return st.getContext() != null;
            }
        };
        CloseableIterationBase ctxIter = new ConvertingIteration<Statement, Resource, IOException>((Iteration)stIter){

            @Override
            protected Resource convert(Statement st) {
                return st.getContext();
            }
        };
        ctxIter = btreeIter == null ? new DistinctIteration<Resource, IOException>(ctxIter) : new FilterIteration<Resource, IOException>((Iteration)ctxIter){
            private Resource last;
            {
                this.last = null;
            }

            @Override
            protected boolean accept(Resource ctx) throws IOException {
                boolean equal = ctx.equals(this.last);
                this.last = ctx;
                return !equal;
            }
        };
        return ctxIter;
    }

    protected CloseableIteration<? extends Statement, IOException> createStatementIterator(Resource subj, URI pred, Value obj, boolean includeInferred, boolean readTransaction, Resource ... contexts) throws IOException {
        int subjID = -1;
        if (subj != null && (subjID = this.valueStore.getID(subj)) == -1) {
            return new EmptyIteration();
        }
        int predID = -1;
        if (pred != null && (predID = this.valueStore.getID(pred)) == -1) {
            return new EmptyIteration();
        }
        int objID = -1;
        if (obj != null && (objID = this.valueStore.getID(obj)) == -1) {
            return new EmptyIteration();
        }
        ArrayList<Integer> contextIDList = new ArrayList<Integer>(contexts.length);
        if (contexts.length == 0) {
            contextIDList.add(-1);
        } else {
            for (Resource context : contexts) {
                if (context == null) {
                    contextIDList.add(0);
                    continue;
                }
                int contextID = this.valueStore.getID(context);
                if (contextID == -1) continue;
                contextIDList.add(contextID);
            }
        }
        ArrayList<NativeStatementIterator> perContextIterList = new ArrayList<NativeStatementIterator>(contextIDList.size());
        Iterator i$ = contextIDList.iterator();
        while (i$.hasNext()) {
            int contextID = (Integer)i$.next();
            RecordIterator btreeIter = includeInferred ? this.tripleStore.getTriples(subjID, predID, objID, contextID, readTransaction) : this.tripleStore.getTriples(subjID, predID, objID, contextID, true, readTransaction);
            perContextIterList.add(new NativeStatementIterator(btreeIter, this.valueStore));
        }
        if (perContextIterList.size() == 1) {
            return (CloseableIteration)perContextIterList.get(0);
        }
        return new UnionIteration(perContextIterList);
    }

    protected double cardinality(Resource subj, URI pred, Value obj, Resource context) throws IOException {
        int subjID = -1;
        if (subj != null && (subjID = this.valueStore.getID(subj)) == -1) {
            return 0.0;
        }
        int predID = -1;
        if (pred != null && (predID = this.valueStore.getID(pred)) == -1) {
            return 0.0;
        }
        int objID = -1;
        if (obj != null && (objID = this.valueStore.getID(obj)) == -1) {
            return 0.0;
        }
        int contextID = -1;
        if (context != null && (contextID = this.valueStore.getID(context)) == -1) {
            return 0.0;
        }
        return this.tripleStore.cardinality(subjID, predID, objID, contextID);
    }
}

