/*
 * the Decibel Realtime Communication Framework
 * Copyright (C) 2006 by basyskom GmbH
 *  @author Tobias Hunger <info@basyskom.de>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef _DECIBEL_ERRORS_H_
#define _DECIBEL_ERRORS_H_

#include <Decibel/DBusNames>

namespace Decibel
{

const QString ErrorBase(daemon_service + ".Error.");

const QString ErrorDataIncomplete(ErrorBase + "data_incomplete");
const QString ErrorInvalidValue(ErrorBase + "invalid_value");
const QString ErrorNoSuchAccount(ErrorBase + "no_such_account");
const QString ErrorNotSupported(ErrorBase + "not_supported");
const QString ErrorCMFailed(ErrorBase + "CM_failed");
const QString ErrorConnectionError(ErrorBase + "connection_error");
const QString ErrorNoSuchConnection(ErrorBase + "no_such_connection");
const QString ErrorInternalError(ErrorBase + "internal_error");

} // namespace

#endif
