/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import java.io.FileDescriptor;
import java.io.IOException;
import java.nio.ByteBuffer;
import sun.nio.ch.DirectBuffer;
import sun.nio.ch.IOVecWrapper;
import sun.nio.ch.NativeDispatcher;
import sun.nio.ch.Util;

class IOUtil {
    private IOUtil() {
    }

    private static int remaining(ByteBuffer[] byteBufferArray) {
        int n = byteBufferArray.length;
        for (int i = 0; i < n; ++i) {
            if (!byteBufferArray[i].hasRemaining()) continue;
            return i;
        }
        return -1;
    }

    private static ByteBuffer[] skipBufs(ByteBuffer[] byteBufferArray, int n) {
        int n2 = byteBufferArray.length - n;
        ByteBuffer[] byteBufferArray2 = new ByteBuffer[n2];
        for (int i = 0; i < n2; ++i) {
            byteBufferArray2[i] = byteBufferArray[i + n];
        }
        return byteBufferArray2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static int write(FileDescriptor fileDescriptor, ByteBuffer byteBuffer, long l, NativeDispatcher nativeDispatcher, Object object) throws IOException {
        int n;
        if (byteBuffer instanceof DirectBuffer) {
            return IOUtil.writeFromNativeBuffer(fileDescriptor, byteBuffer, l, nativeDispatcher, object);
        }
        int n2 = byteBuffer.position();
        int n3 = byteBuffer.limit();
        assert (n2 <= n3);
        int n4 = n2 <= n3 ? n3 - n2 : 0;
        ByteBuffer byteBuffer2 = null;
        try {
            byteBuffer2 = Util.getTemporaryDirectBuffer(n4);
            byteBuffer2.put(byteBuffer);
            byteBuffer2.flip();
            byteBuffer.position(n2);
            int n5 = IOUtil.writeFromNativeBuffer(fileDescriptor, byteBuffer2, l, nativeDispatcher, object);
            if (n5 > 0) {
                byteBuffer.position(n2 + n5);
            }
            n = n5;
            Object var13_11 = null;
        }
        catch (Throwable throwable) {
            Object var13_12 = null;
            Util.releaseTemporaryDirectBuffer(byteBuffer2);
            throw throwable;
        }
        Util.releaseTemporaryDirectBuffer(byteBuffer2);
        return n;
    }

    private static int writeFromNativeBuffer(FileDescriptor fileDescriptor, ByteBuffer byteBuffer, long l, NativeDispatcher nativeDispatcher, Object object) throws IOException {
        int n = byteBuffer.position();
        int n2 = byteBuffer.limit();
        assert (n <= n2);
        int n3 = n <= n2 ? n2 - n : 0;
        int n4 = 0;
        if (n3 == 0) {
            return 0;
        }
        n4 = l != -1L ? nativeDispatcher.pwrite(fileDescriptor, ((DirectBuffer)((Object)byteBuffer)).address() + (long)n, n3, l, object) : nativeDispatcher.write(fileDescriptor, ((DirectBuffer)((Object)byteBuffer)).address() + (long)n, n3);
        if (n4 > 0) {
            byteBuffer.position(n + n4);
        }
        return n4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static long write(FileDescriptor fileDescriptor, ByteBuffer[] byteBufferArray, NativeDispatcher nativeDispatcher) throws IOException {
        long l;
        int n = IOUtil.remaining(byteBufferArray);
        if (n < 0) {
            return 0L;
        }
        if (n > 0) {
            byteBufferArray = IOUtil.skipBufs(byteBufferArray, n);
        }
        int n2 = byteBufferArray.length;
        ByteBuffer[] byteBufferArray2 = new ByteBuffer[n2];
        try {
            ByteBuffer byteBuffer;
            int n3;
            for (int i = 0; i < n2; ++i) {
                if (!(byteBufferArray[i] instanceof DirectBuffer)) {
                    int n4 = byteBufferArray[i].position();
                    int n5 = byteBufferArray[i].limit();
                    assert (n4 <= n5);
                    n3 = n4 <= n5 ? n5 - n4 : 0;
                    byteBufferArray2[i] = byteBuffer = Util.getTemporaryDirectBuffer(n3);
                    byteBuffer.put(byteBufferArray[i]);
                    byteBufferArray[i].position(n4);
                    byteBuffer.flip();
                    continue;
                }
                byteBufferArray2[i] = byteBufferArray[i];
            }
            IOVecWrapper iOVecWrapper = null;
            long l2 = 0L;
            try {
                iOVecWrapper = new IOVecWrapper(n2);
                for (n3 = 0; n3 < n2; ++n3) {
                    byteBuffer = byteBufferArray2[n3];
                    long l3 = byteBuffer.position();
                    long l4 = (long)byteBuffer.limit() - l3;
                    iOVecWrapper.putBase(n3, ((DirectBuffer)((Object)byteBuffer)).address() + l3);
                    iOVecWrapper.putLen(n3, l4);
                }
                l2 = nativeDispatcher.writev(fileDescriptor, iOVecWrapper.address, n2);
                Object var16_19 = null;
                iOVecWrapper.free();
            }
            catch (Throwable throwable) {
                Object var16_20 = null;
                iOVecWrapper.free();
                throw throwable;
            }
            long l5 = l2;
            for (int i = 0; i < n2; ++i) {
                int n6;
                ByteBuffer byteBuffer2 = byteBufferArray[i];
                int n7 = byteBuffer2.position();
                int n8 = byteBuffer2.limit();
                assert (n7 <= n8);
                int n9 = n6 = n7 <= n8 ? n8 - n7 : n8;
                if (l2 >= (long)n6) {
                    l2 -= (long)n6;
                } else {
                    if (l2 <= 0L) break;
                    assert ((long)n7 + l2 < Integer.MAX_VALUE);
                    int n10 = (int)((long)n7 + l2);
                    byteBuffer2.position(n10);
                    break;
                }
                int n11 = n7 + n6;
                byteBuffer2.position(n11);
            }
            l = l5;
            Object var18_27 = null;
        }
        catch (Throwable throwable) {
            Object var18_28 = null;
            for (int i = 0; i < n2; ++i) {
                ByteBuffer byteBuffer = byteBufferArray2[i];
                if (byteBuffer == null || byteBuffer == byteBufferArray[i]) continue;
                Util.releaseTemporaryDirectBuffer(byteBuffer);
            }
            throw throwable;
        }
        for (int i = 0; i < n2; ++i) {
            ByteBuffer byteBuffer = byteBufferArray2[i];
            if (byteBuffer == null || byteBuffer == byteBufferArray[i]) continue;
            Util.releaseTemporaryDirectBuffer(byteBuffer);
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static int read(FileDescriptor fileDescriptor, ByteBuffer byteBuffer, long l, NativeDispatcher nativeDispatcher, Object object) throws IOException {
        int n;
        if (byteBuffer.isReadOnly()) {
            throw new IllegalArgumentException("Read-only buffer");
        }
        if (byteBuffer instanceof DirectBuffer) {
            return IOUtil.readIntoNativeBuffer(fileDescriptor, byteBuffer, l, nativeDispatcher, object);
        }
        ByteBuffer byteBuffer2 = null;
        try {
            byteBuffer2 = Util.getTemporaryDirectBuffer(byteBuffer.remaining());
            int n2 = IOUtil.readIntoNativeBuffer(fileDescriptor, byteBuffer2, l, nativeDispatcher, object);
            byteBuffer2.flip();
            if (n2 > 0) {
                byteBuffer.put(byteBuffer2);
            }
            n = n2;
            Object var10_8 = null;
        }
        catch (Throwable throwable) {
            Object var10_9 = null;
            Util.releaseTemporaryDirectBuffer(byteBuffer2);
            throw throwable;
        }
        Util.releaseTemporaryDirectBuffer(byteBuffer2);
        return n;
    }

    private static int readIntoNativeBuffer(FileDescriptor fileDescriptor, ByteBuffer byteBuffer, long l, NativeDispatcher nativeDispatcher, Object object) throws IOException {
        int n;
        int n2 = byteBuffer.position();
        int n3 = byteBuffer.limit();
        assert (n2 <= n3);
        int n4 = n = n2 <= n3 ? n3 - n2 : 0;
        if (n == 0) {
            return 0;
        }
        int n5 = 0;
        n5 = l != -1L ? nativeDispatcher.pread(fileDescriptor, ((DirectBuffer)((Object)byteBuffer)).address() + (long)n2, n, l, object) : nativeDispatcher.read(fileDescriptor, ((DirectBuffer)((Object)byteBuffer)).address() + (long)n2, n);
        if (n5 > 0) {
            byteBuffer.position(n2 + n5);
        }
        return n5;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static long read(FileDescriptor fileDescriptor, ByteBuffer[] byteBufferArray, NativeDispatcher nativeDispatcher) throws IOException {
        long l;
        block19: {
            int n = IOUtil.remaining(byteBufferArray);
            if (n < 0) {
                return 0L;
            }
            if (n > 0) {
                byteBufferArray = IOUtil.skipBufs(byteBufferArray, n);
            }
            int n2 = byteBufferArray.length;
            ByteBuffer[] byteBufferArray2 = new ByteBuffer[n2];
            boolean bl = false;
            try {
                int n3;
                for (int i = 0; i < n2; ++i) {
                    if (byteBufferArray[i].isReadOnly()) {
                        throw new IllegalArgumentException("Read-only buffer");
                    }
                    if (!(byteBufferArray[i] instanceof DirectBuffer)) {
                        byteBufferArray2[i] = Util.getTemporaryDirectBuffer(byteBufferArray[i].remaining());
                        bl = true;
                        continue;
                    }
                    byteBufferArray2[i] = byteBufferArray[i];
                }
                IOVecWrapper iOVecWrapper = null;
                long l2 = 0L;
                try {
                    iOVecWrapper = new IOVecWrapper(n2);
                    for (int i = 0; i < n2; ++i) {
                        ByteBuffer byteBuffer = byteBufferArray2[i];
                        long l3 = byteBuffer.position();
                        long l4 = byteBuffer.remaining();
                        iOVecWrapper.putBase(i, ((DirectBuffer)((Object)byteBuffer)).address() + l3);
                        iOVecWrapper.putLen(i, l4);
                    }
                    l2 = nativeDispatcher.readv(fileDescriptor, iOVecWrapper.address, n2);
                    Object var17_18 = null;
                    iOVecWrapper.free();
                }
                catch (Throwable throwable) {
                    Object var17_19 = null;
                    iOVecWrapper.free();
                    throw throwable;
                }
                long l5 = l2;
                for (n3 = 0; n3 < n2; ++n3) {
                    int n4;
                    ByteBuffer byteBuffer = byteBufferArray2[n3];
                    int n5 = byteBuffer.position();
                    int n6 = byteBuffer.remaining();
                    if (l2 >= (long)n6) {
                        l2 -= (long)n6;
                    } else {
                        if (l2 <= 0L) break;
                        assert ((long)n5 + l2 < Integer.MAX_VALUE);
                        n4 = (int)((long)n5 + l2);
                        byteBuffer.position(n4);
                        break;
                    }
                    n4 = n5 + n6;
                    byteBuffer.position(n4);
                }
                if (bl) {
                    for (n3 = 0; n3 < n2; ++n3) {
                        if (byteBufferArray[n3] instanceof DirectBuffer) continue;
                        byteBufferArray2[n3].flip();
                        byteBufferArray[n3].put(byteBufferArray2[n3]);
                    }
                }
                l = l5;
                Object var19_24 = null;
                if (!bl) break block19;
            }
            catch (Throwable throwable) {
                Object var19_25 = null;
                if (bl) {
                    for (int i = 0; i < n2; ++i) {
                        ByteBuffer byteBuffer = byteBufferArray2[i];
                        if (byteBuffer == null || byteBuffer == byteBufferArray[i]) continue;
                        Util.releaseTemporaryDirectBuffer(byteBuffer);
                    }
                }
                throw throwable;
            }
            for (int i = 0; i < n2; ++i) {
                ByteBuffer byteBuffer = byteBufferArray2[i];
                if (byteBuffer == null || byteBuffer == byteBufferArray[i]) continue;
                Util.releaseTemporaryDirectBuffer(byteBuffer);
            }
        }
        return l;
    }

    static FileDescriptor newFD(int n) {
        FileDescriptor fileDescriptor = new FileDescriptor();
        IOUtil.setfdVal(fileDescriptor, n);
        return fileDescriptor;
    }

    static native boolean randomBytes(byte[] var0);

    static native void initPipe(int[] var0, boolean var1);

    static native boolean drain(int var0) throws IOException;

    static native void configureBlocking(FileDescriptor var0, boolean var1) throws IOException;

    static native int fdVal(FileDescriptor var0);

    static native void setfdVal(FileDescriptor var0, int var1);

    static native void initIDs();

    static {
        Util.load();
    }
}

