#!/usr/bin/perl
#
# Auther:	Jun Kuwamura(juk@rccm.co.jp)
# Creation Date:	02/02/1998
#
# Description:
#  Slackware  pkgtool ˤ륤󥹥ȡˤ /var/adm/packages/ ǥ
# ȥ˺褦ʥѥåƥꥹȤ PostgreSQL ǡ١
# Ͽޤ pkglis(ѥå˴ޤޤեΥꥹ)  pkgtab 
# (ʳξ)Ȥơ֥ꡢpkglis Υ˺դޤ
#
#  Ȥϡ
#	pkg2db.pl [-i] <filename>...
#
#	-i:		ꤹȥơ֥ľޤ
#	<filename>...:	ѥåե̾(ʣǽǤ)
#
#  ʤpackage Ȥ̾Υǡ١򤢤餫뤫뤤ϡ
# ץȤ $DBNAME ͤ¸Υǡ١̾ˤɬפޤ
# package ǡ١ϥޥɥ饤ˤơ
#
#	% createdb package
#
# 뤤ϡSQL Ȥϡ  
#
#	% psql
#	postgres=> create database package;
#	postgres=> \q
#
# ¹Ԥޤ
#
#  󥹥ȡ뤵줿 Plagiaware ΥѥåꥹȤ򤹤٤Ͽˤϡ
#
#	% pkg2db.pl -i /var/adm/packages/*
#
# ¹ԤȤǤޤPentium100 Υޥ2֤餤ޤΤ
# ղ
#
# History:
#  1998-02-19(Thu) JuK Add comment
#  1998-02-20(Fri) JuK Add -i option
#  1998-02-28(Sat) JuK Mod ܸθФб
#

use Pg;
$DBNAME = 'package';
#$DBNAME = 'postgres';
$SIG{PIPE} = sub { print "broken pipe\n" };
$DEBUG  = 0;			# set this to 1 for traces

if ($#ARGV < 0) {
	print "Usage:\n";
	print "\tpkg2db.pl [-i] <filename> [<filename1> ...]\n";
	print "\t\t-i:\tinitialize tables\n";
	print "\t\t<filename>:\tpackage contents list file name\n";
	exit;
}

&_db_conn;

if ($ARGV[0] eq "-i") {
	&_db_init_pkg unless ($DEBUG);
	shift(@ARGV);
}

if ($#ARGV > -1) {		# if input files are specified on command line
  FILE: while ($filename = shift(@ARGV)) {
      if ( ! -r  $filename ) {
	  print "Error! file: $filename is not exist!\n";
	  next FILE;
      }
      &_mklist($filename);
  }
}


sub _mklist
{
   $filepath = shift;		#   local($filepath) = @_;

   @filepath = split('/', $filepath);
   $filename = $filepath[$#filepath];

   $mode_lis = 0;
   $mode_dsc = 0;

   $pkg_name = "";
   $tar_size = 0;
   $tgz_size = 0;
   $pkg_loca = "";
   $pkg_desc = "";

   open ( INP, "< $filepath" );
   while (<INP>) {
      chop;
      if ($mode_lis) {				# FILE LIST
         if ( !/\/$/ ) {
            print "$filename\t$_\n" if (!/\/$/);

	    &_db_insert_lis unless ($DEBUG);

	 }
      } elsif ($mode_dsc) {		# ѥå
         if ( /^եꥹ:/ || /^FILE LIST:/ ) {  # (ƵҤμ FILE LIST)
	    $mode_lis = 1;
	    $mode_dsc = 0;
	    print "$pkg_name, $tar_size, $tgz_size, $pkg_loca\n";
	    print "$pkg_desc\n";
	 } else {			# (ƵҤϿ񼰤ˤ)
            $desc = $_;
	    $desc =~ s/^\S+:\s*//;	# 
	    $desc =~ s/\'/\\\'/g;	# 󥰥륯Ȥ򥨥
	    $desc =~ s/\"/\\\"/g;	# ֥륯Ȥ򥨥
	    $pkg_desc .= "$desc\n";
	 }
      } else {
         $fld = $_;
         $fld =~ s/^\D+:\s*//;		# ե̾ȶڤ
         if ( /^ѥå̾:/ || /^PACKAGE NAME:/ ) {$pkg_name = $fld;}
         if ( /^̻ΥѥåΥ:/ || /^COMPRESSED PACKAGE SIZE:/ ) {
	    $fld =~ s/\D//g;		# Ф
	    $tgz_size = $fld;
	 }
         if ( /^󰵽̻ΥѥåΥ:/ || /^UNCOMPRESSED PACKAGE SIZE:/ ) {
	    $fld =~ s/\D//g;		# Ф
	    $tar_size = $fld;
	 }
         if ( /^ѥåν:/ || /^PACKAGE LOCATION:/ ) {$pkg_loca = $fld;}
         if ( /^ѥå:/ || /^PACKAGE DESCRIPTION:/ ) {
	    $mode_dsc = 1;
	    $pkg_desc = "";
	 }
         if ( /^եꥹ:/ || /^FILE LIST:/ ) { $mode_lis = 1; }	# (ѥåƤ̵Ȥ)
      }
   }
   close INP;

   &_db_insert_tab unless ($DEBUG);

}

sub _db_conn {
  $conn = Pg::connectdb("dbname=$DBNAME");
  if ($conn->status ne PGRES_CONNECTION_OK) {
     print "_db_conn: ". $conn->errorMessage . " \n";
     &_db_cre_pkg;
     &_db_conn;
     &_db_init_pkg;
  }
}

#
# create database package;
#
sub _db_cre_pkg {
  $conn = Pg::connectdb("dbname=template1");
  if ($conn->status ne PGRES_CONNECTION_OK) {
     print "_db_cre_pkg: ". $conn->errorMessage . " \n";
     exit;
  }
  $result = $conn->exec( "CREATE DATABASE $DBNAME" );
  if ( $result->resultStatus ne PGRES_COMMAND_OK) {
     print "CREATE DATABASE pkgtab:". $conn->errorMessage . "\n";
     print "$cmd\n" if $DEBUG;
     exit
  }

}

#
# -i ץǡʲ SQL ¹Ԥ롣
#
# create table pkgtab (
# 	pkgname	text,
# 	pkgsize	int4,
# 	pressize	int4,
# 	location	text,
# 	description	text
# );
# create table pkglis (
# 	pkgname	text,
# 	fpath	text
# );
# create index pkglis_pkgname_idx on pkglis using btree ( pkgname );
# create index pkglis_fpath_idx on pkglis using btree ( fpath );
#
sub _db_init_pkg {

  $result = $conn->exec( "DROP TABLE pkgtab" );
  $cmd = "CREATE TABLE pkgtab ("
 	."pkgname	text,"
 	."pkgsize	int4,"
 	."pressize	int4,"
 	."location	text,"
 	."description	text)";
  $result = $conn->exec( $cmd );
  if ( $result->resultStatus ne PGRES_COMMAND_OK) {
     print "CREATE TABLE pkgtab:". $conn->errorMessage . "\n";
     print "$cmd\n" if $DEBUG;
     exit
  }


  $result = $conn->exec( "DROP TABLE pkglis" );
  $cmd = "CREATE TABLE pkglis ("
	."pkgname	text,"
	."fpath	text)";
  $result = $conn->exec( $cmd );
  if ( $result->resultStatus ne PGRES_COMMAND_OK) {
     print "CREATE TABLE pkglis:". $conn->errorMessage . "\n";
     print "$cmd\n" if $DEBUG;
     exit
  }


  $cmd = "CREATE INDEX pkglis_pkgname_ind ON pkglis USING btree ( pkgname )";
  $result = $conn->exec( $cmd );
  if ( $result->resultStatus ne PGRES_COMMAND_OK) {
     print "CREATE INDEX pkglis_pkgname_ind:". $conn->errorMessage . "\n";
     print "$cmd\n" if $DEBUG;
     exit
  }

  $cmd = "CREATE INDEX pkglis_fpath_ind ON pkglis USING btree ( fpath )";
  $result = $conn->exec( $cmd );
  if ( $result->resultStatus ne PGRES_COMMAND_OK) {
     print "CREATE INDEX pkglis_fpath_ind:". $conn->errorMessage . "\n";
     print "$cmd\n" if $DEBUG;
     exit
  }
}


sub _db_insert_lis {
	    $cmd = "INSERT INTO pkglis VALUES "
      	         ."('$filename', '$_')";
	    $result = $conn->exec($cmd);
	    if ( $result->resultStatus ne PGRES_COMMAND_OK) {
	       print "INSERT INTO pkglis:".$conn->errorMessage."\n";
	       print "$cmd\n" if $DEBUG;
	       exit;
	    }
}


sub _db_insert_tab {
   $cmd = "INSERT INTO pkgtab VALUES "
        ."('$pkg_name', $tar_size, $tgz_size, '$pkg_loca', '$pkg_desc')";
   $result = $conn->exec($cmd);
   if ( $result->resultStatus ne PGRES_COMMAND_OK) {
      print "INSERT INTO pkgtab:".$conn->errorMessage."\n";
      print "$cmd\n" if $DEBUG;
      exit;
   }
}
