#!/bin/bash
# OpenVPN	(http://openvpn.net/)
#	BuildScript for Plamo Linux 4.7
#			by Jun Kuwamura <juk@linet.gr.jp> on 2010-07-22
# require:
#
REL=P1
VERSION=2.1.1
APP_NAME=openvpn
PAC_NAME=${APP_NAME}-${VERSION}
SRC_FILE=${PAC_NAME}.tar.gz
SRC_URI=http://openvpn.net/release/$SRC_FILE


REL=P1
CPU=i586
SYS_NAME="${CPU}-${REL}"

PLAMO=/expo/Build
SRC_DIR=$PLAMO/Archive/security
PAC_DIR=$PLAMO/Packages/4.7/03_ext
BUILD_DIR=$PLAMO/openvpn
CUSTOM_DIR=$BUILD_DIR/Custom

echo $PAC_DIR
if [ ! -d $PAC_DIR ]; then
  mkdir -p  $PAC_DIR
fi
echo $SRC_DIR/$SRC_FILE
if [ ! -f $SRC_DIR/$SRC_FILE ]; then
  if [ ! -d $SRC_DIR ]; then
    mkdir -p $SRC_DIR
  fi
  ( cd $SRC_DIR; wget $SRC_URI )
fi


umask 022
CWD=`pwd`
WORK=$CWD/work
rm -rf $WORK/*
mkdir -p $WORK
export LANG=C
export LC_ALL=C
export CFLAGS="-O2 -march=$CPU"
export PATH=$PATH:/usr/X11R7/bin


gzip -dc $SRC_DIR/$SRC_FILE  | tar xvf -
cd $PAC_NAME
 ./configure --prefix=/usr
 make
 make install DESTDIR=$WORK

 mkdir -p $WORK/etc/openvpn
 cp -a  sample-* $WORK/etc/openvpn/
 mkdir $WORK/etc/openvpn/easy-rsa
 (cd easy-rsa/; 
  cp -a 1.0 2.0 Windows $WORK/etc/openvpn/easy-rsa/ )

 cp -a $CUSTOM_DIR/sample-multi $WORK/etc/openvpn/

 mkdir -p $WORK/install
 cat $CUSTOM_DIR/doinst.sample > $WORK/install/doinst.sh
 mkdir -p $WORK/etc/rc.d/init.d
 cat $CUSTOM_DIR/openvpn.sh > $WORK/etc/rc.d/init.d/openvpn
 chmod +x $WORK/etc/rc.d/init.d/openvpn

 DOC_DIR=usr/share/doc/$PAC_NAME
 mkdir -p $WORK/$DOC_DIR || exit 1
 cp -p $BUILD_DIR/`basename $0`  \
	$WORK/$DOC_DIR
 cp -p `find . -maxdepth 1 -type f -name  "[A-Z]*" | grep -vi makefile` \
	$WORK/$DOC_DIR
 chown -R root.root $WORK/$DOC_DIR
 chmod -R a+rX $WORK/$DOC_DIR


# make package
cd $WORK
echo "y
1
" | makepkg ${PAC_NAME}.tgz

echo -n "$PAC_DIR/${PAC_NAME}-${SYS_NAME}.tgz"
if `mv -v ${PAC_NAME}.tgz  $PAC_DIR/${PAC_NAME}-${SYS_NAME}.tgz 1>/dev/null 2>&1`; then
  echo " ... done"
else
  echo " ... false"
fi

cd $CWD
