/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceContext;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.event.ActionEvent;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Method;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;

public class TransferHandler
implements Serializable {
    private static final long serialVersionUID = -967749805571669910L;
    private static final String COMMAND_COPY = "copy";
    private static final String COMMAND_CUT = "cut";
    private static final String COMMAND_PASTE = "paste";
    public static final int NONE = 0;
    public static final int COPY = 1;
    public static final int MOVE = 2;
    public static final int COPY_OR_MOVE = 3;
    private static Action copyAction = new TransferAction("copy");
    private static Action cutAction = new TransferAction("cut");
    private static Action pasteAction = new TransferAction("paste");
    private int sourceActions;
    private Icon visualRepresentation;
    private String propertyName;
    private SwingDragGestureRecognizer recognizer;

    public static Action getCopyAction() {
        return copyAction;
    }

    public static Action getCutAction() {
        return cutAction;
    }

    public static Action getPasteAction() {
        return pasteAction;
    }

    protected TransferHandler() {
        this.sourceActions = 0;
    }

    public TransferHandler(String property) {
        this.propertyName = property;
        this.sourceActions = property != null ? 1 : 0;
    }

    public boolean canImport(JComponent c, DataFlavor[] flavors) {
        DataFlavor flavor;
        Class<?>[] params;
        Method writer;
        PropertyDescriptor propDesc = this.getPropertyDescriptor(c);
        boolean canImport = false;
        if (propDesc != null && (writer = propDesc.getWriteMethod()) != null && (params = writer.getParameterTypes()).length == 1 && (flavor = this.getPropertyDataFlavor(params[0], flavors)) != null) {
            canImport = true;
        }
        return canImport;
    }

    protected Transferable createTransferable(JComponent c) {
        PropertyDescriptor prop;
        PropertyTransferable transferable = null;
        if (this.propertyName != null && (prop = this.getPropertyDescriptor(c)) != null) {
            transferable = new PropertyTransferable(c, prop);
        }
        return transferable;
    }

    public void exportAsDrag(JComponent c, InputEvent e, int action) {
        int src = this.getSourceActions(c);
        int drag = src & action;
        if (!(e instanceof MouseEvent)) {
            drag = 0;
        }
        if (drag != 0) {
            if (this.recognizer == null) {
                SwingDragHandler ds = new SwingDragHandler();
                this.recognizer = new SwingDragGestureRecognizer(ds);
            }
            this.recognizer.gesture(c, (MouseEvent)e, src, drag);
        } else {
            this.exportDone(c, null, 0);
        }
    }

    protected void exportDone(JComponent c, Transferable data, int action) {
    }

    public void exportToClipboard(JComponent c, Clipboard clip, int action) throws IllegalStateException {
        Transferable transferable = this.createTransferable(c);
        if (transferable != null && (action &= this.getSourceActions(c)) != 0) {
            try {
                clip.setContents(transferable, null);
                this.exportDone(c, transferable, action);
            }
            catch (IllegalStateException ex) {
                this.exportDone(c, transferable, 0);
                throw ex;
            }
        } else {
            this.exportDone(c, null, 0);
        }
    }

    public int getSourceActions(JComponent c) {
        return this.sourceActions;
    }

    public Icon getVisualRepresentation(Transferable t) {
        return this.visualRepresentation;
    }

    public boolean importData(JComponent c, Transferable t) {
        DataFlavor flavor;
        Class<?>[] params;
        Method writer;
        boolean ok = false;
        PropertyDescriptor prop = this.getPropertyDescriptor(c);
        if (prop != null && (writer = prop.getWriteMethod()) != null && (params = writer.getParameterTypes()).length == 1 && (flavor = this.getPropertyDataFlavor(params[0], t.getTransferDataFlavors())) != null) {
            try {
                Object value = t.getTransferData(flavor);
                writer.invoke(c, value);
                ok = true;
            }
            catch (Exception exception) {}
        }
        return ok;
    }

    private PropertyDescriptor getPropertyDescriptor(JComponent c) {
        PropertyDescriptor prop = null;
        if (this.propertyName != null) {
            BeanInfo beanInfo;
            Class<? extends Object> clazz = c.getClass();
            try {
                beanInfo = Introspector.getBeanInfo(clazz);
            }
            catch (IntrospectionException introspectionException) {
                beanInfo = null;
            }
            if (beanInfo != null) {
                PropertyDescriptor[] props = beanInfo.getPropertyDescriptors();
                int i = 0;
                while (i < props.length && prop == null) {
                    Class<?>[] params;
                    Method reader;
                    PropertyDescriptor desc = props[i];
                    if (desc.getName().equals(this.propertyName) && (reader = desc.getReadMethod()) != null && ((params = reader.getParameterTypes()) == null || params.length == 0)) {
                        prop = desc;
                    }
                    ++i;
                }
            }
        }
        return prop;
    }

    private DataFlavor getPropertyDataFlavor(Class clazz, DataFlavor[] flavors) {
        DataFlavor found = null;
        int i = 0;
        while (i < flavors.length && found == null) {
            DataFlavor flavor = flavors[i];
            if (flavor.getPrimaryType().equals("application") && flavor.getSubType().equals("x-java-jvm-local-objectref") && clazz.isAssignableFrom(flavor.getRepresentationClass())) {
                found = flavor;
            }
            ++i;
        }
        return found;
    }

    private static class PropertyTransferable
    implements Transferable {
        private JComponent component;
        private PropertyDescriptor property;

        PropertyTransferable(JComponent c, PropertyDescriptor prop) {
            this.component = c;
            this.property = prop;
        }

        public DataFlavor[] getTransferDataFlavors() {
            DataFlavor[] flavors;
            Class<?> propClass = this.property.getPropertyType();
            String mime = "application/x-java-jvm-local-objectref; class=" + propClass.getName();
            try {
                DataFlavor flavor = new DataFlavor(mime);
                flavors = new DataFlavor[]{flavor};
            }
            catch (ClassNotFoundException classNotFoundException) {
                flavors = new DataFlavor[]{};
            }
            return flavors;
        }

        public boolean isDataFlavorSupported(DataFlavor flavor) {
            Class<?> propClass = this.property.getPropertyType();
            return flavor.getPrimaryType().equals("application") && flavor.getSubType().equals("x-java-jvm-local-objectref") && propClass.isAssignableFrom(flavor.getRepresentationClass());
        }

        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            if (this.isDataFlavorSupported(flavor)) {
                Method getter = this.property.getReadMethod();
                try {
                    Object o = getter.invoke(this.component, null);
                    return o;
                }
                catch (Exception exception) {
                    throw new IOException("Property read failed: " + this.property.getName());
                }
            }
            throw new UnsupportedFlavorException(flavor);
        }
    }

    private static class SwingDragGestureRecognizer
    extends DragGestureRecognizer {
        protected SwingDragGestureRecognizer(DragGestureListener dgl) {
            super(DragSource.getDefaultDragSource(), null, 0, dgl);
        }

        void gesture(JComponent c, MouseEvent e, int src, int drag) {
            this.setComponent(c);
            this.setSourceActions(src);
            this.appendEvent(e);
            this.fireDragGestureRecognized(drag, e.getPoint());
        }

        protected void registerListeners() {
        }

        protected void unregisterListeners() {
        }
    }

    private static class SwingDragHandler
    implements DragGestureListener,
    DragSourceListener {
        private boolean autoscrolls;

        private SwingDragHandler() {
        }

        public void dragGestureRecognized(DragGestureEvent e) {
            JComponent c = (JComponent)e.getComponent();
            TransferHandler th = c.getTransferHandler();
            Transferable t = th.createTransferable(c);
            if (t != null) {
                this.autoscrolls = c.getAutoscrolls();
                c.setAutoscrolls(false);
                try {
                    e.startDrag(null, t, this);
                    return;
                }
                finally {
                    c.setAutoscrolls(this.autoscrolls);
                }
            }
            th.exportDone(c, t, 0);
        }

        public void dragDropEnd(DragSourceDropEvent e) {
            DragSourceContext ctx = e.getDragSourceContext();
            JComponent c = (JComponent)ctx.getComponent();
            TransferHandler th = c.getTransferHandler();
            if (e.getDropSuccess()) {
                th.exportDone(c, ctx.getTransferable(), e.getDropAction());
            } else {
                th.exportDone(c, ctx.getTransferable(), e.getDropAction());
            }
            c.setAutoscrolls(this.autoscrolls);
        }

        public void dragEnter(DragSourceDragEvent e) {
        }

        public void dragExit(DragSourceEvent e) {
        }

        public void dragOver(DragSourceDragEvent e) {
        }

        public void dropActionChanged(DragSourceDragEvent e) {
        }
    }

    static class TransferAction
    extends AbstractAction {
        private String command;

        public TransferAction(String command) {
            super(command);
            this.command = command;
        }

        public void actionPerformed(ActionEvent event) {
            Transferable transferable;
            JComponent component = (JComponent)event.getSource();
            TransferHandler transferHandler = component.getTransferHandler();
            Clipboard clipboard = TransferAction.getClipboard(component);
            if (clipboard == null) {
                Toolkit.getDefaultToolkit().beep();
                return;
            }
            if (this.command.equals(TransferHandler.COMMAND_COPY)) {
                transferHandler.exportToClipboard(component, clipboard, 1);
            } else if (this.command.equals(TransferHandler.COMMAND_CUT)) {
                transferHandler.exportToClipboard(component, clipboard, 2);
            } else if (this.command.equals(TransferHandler.COMMAND_PASTE) && (transferable = clipboard.getContents(null)) != null) {
                transferHandler.importData(component, transferable);
            }
        }

        private static Clipboard getClipboard(JComponent component) {
            try {
                return component.getToolkit().getSystemClipboard();
            }
            catch (SecurityException securityException) {
                return null;
            }
        }
    }
}

