/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleExtendedComponent;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleText;
import javax.swing.GrayFilter;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.SwingConstants;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.LabelUI;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Position;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.View;

public class JLabel
extends JComponent
implements Accessible,
SwingConstants {
    private static final long serialVersionUID = 5496508283662221534L;
    static final String LABEL_PROPERTY = "labeledBy";
    protected Component labelFor;
    transient String text;
    private transient int horizontalAlignment = 10;
    private transient int horizontalTextPosition = 11;
    private transient int verticalAlignment = 0;
    private transient int verticalTextPosition = 0;
    private transient Icon icon;
    private transient Icon disabledIcon;
    private transient int displayedMnemonic = 0;
    private transient int displayedMnemonicIndex = -1;
    private transient int iconTextGap = 4;

    public JLabel() {
        this("", null, 10);
    }

    public JLabel(Icon image) {
        this(null, image, 0);
    }

    public JLabel(Icon image, int horizontalAlignment) {
        this(null, image, horizontalAlignment);
    }

    public JLabel(String text) {
        this(text, null, 10);
    }

    public JLabel(String text, int horizontalAlignment) {
        this(text, null, horizontalAlignment);
    }

    public JLabel(String text, Icon icon, int horizontalAlignment) {
        if (horizontalAlignment != 2 && horizontalAlignment != 4 && horizontalAlignment != 0 && horizontalAlignment != 10 && horizontalAlignment != 11) {
            throw new IllegalArgumentException();
        }
        this.text = text;
        this.icon = icon;
        this.horizontalAlignment = horizontalAlignment;
        this.setAlignmentX(0.0f);
        this.setInheritsPopupMenu(true);
        this.updateUI();
    }

    public LabelUI getUI() {
        return (LabelUI)this.ui;
    }

    public void setUI(LabelUI ui) {
        super.setUI(ui);
    }

    public void updateUI() {
        this.setUI((LabelUI)UIManager.getUI(this));
    }

    public String getUIClassID() {
        return "LabelUI";
    }

    protected String paramString() {
        StringBuffer sb = new StringBuffer(super.paramString());
        sb.append(",defaultIcon=");
        if (this.icon != null) {
            sb.append(this.icon);
        }
        sb.append(",disabledIcon=");
        if (this.disabledIcon != null) {
            sb.append(this.disabledIcon);
        }
        sb.append(",horizontalAlignment=");
        sb.append(SwingUtilities.convertHorizontalAlignmentCodeToString(this.horizontalAlignment));
        sb.append(",horizontalTextPosition=");
        sb.append(SwingUtilities.convertHorizontalAlignmentCodeToString(this.horizontalTextPosition));
        sb.append(",iconTextGap=").append(this.iconTextGap);
        sb.append(",labelFor=");
        if (this.labelFor != null) {
            sb.append(this.labelFor);
        }
        sb.append(",text=");
        if (this.text != null) {
            sb.append(this.text);
        }
        sb.append(",verticalAlignment=");
        sb.append(SwingUtilities.convertVerticalAlignmentCodeToString(this.verticalAlignment));
        sb.append(",verticalTextPosition=");
        sb.append(SwingUtilities.convertVerticalAlignmentCodeToString(this.verticalTextPosition));
        return sb.toString();
    }

    public String getText() {
        return this.text;
    }

    public void setText(String newText) {
        if (this.text == null && newText == null) {
            return;
        }
        if (this.text != null && this.text.equals(newText)) {
            return;
        }
        String oldText = this.text;
        this.text = newText;
        this.firePropertyChange("text", oldText, newText);
        if (this.text != null) {
            this.setDisplayedMnemonicIndex(this.text.toUpperCase().indexOf(this.displayedMnemonic));
        } else {
            this.setDisplayedMnemonicIndex(-1);
        }
        this.revalidate();
        this.repaint();
    }

    public Icon getIcon() {
        return this.icon;
    }

    public void setIcon(Icon newIcon) {
        if (this.icon != newIcon) {
            Icon oldIcon = this.icon;
            this.icon = newIcon;
            this.firePropertyChange("icon", oldIcon, newIcon);
            this.repaint();
        }
    }

    public Icon getDisabledIcon() {
        if (this.disabledIcon == null && this.icon instanceof ImageIcon) {
            this.disabledIcon = new ImageIcon(GrayFilter.createDisabledImage(((ImageIcon)this.icon).getImage()));
        }
        return this.disabledIcon;
    }

    public void setDisabledIcon(Icon newIcon) {
        if (this.disabledIcon != newIcon) {
            Icon oldIcon = this.disabledIcon;
            this.disabledIcon = newIcon;
            this.firePropertyChange("disabledIcon", oldIcon, newIcon);
        }
    }

    public void setDisplayedMnemonic(int mnemonic) {
        if (this.displayedMnemonic != mnemonic) {
            int old = this.displayedMnemonic;
            this.displayedMnemonic = mnemonic;
            this.firePropertyChange("displayedMnemonic", old, this.displayedMnemonic);
            if (this.text != null) {
                this.setDisplayedMnemonicIndex(this.text.toUpperCase().indexOf(mnemonic));
            }
        }
    }

    public void setDisplayedMnemonic(char mnemonic) {
        this.setDisplayedMnemonic((int)Character.toUpperCase(mnemonic));
    }

    public int getDisplayedMnemonic() {
        return this.displayedMnemonic;
    }

    public void setDisplayedMnemonicIndex(int newIndex) throws IllegalArgumentException {
        int maxValid = -1;
        if (this.text != null) {
            maxValid = this.text.length() - 1;
        }
        if (newIndex < -1 || newIndex > maxValid) {
            throw new IllegalArgumentException();
        }
        if (newIndex != this.displayedMnemonicIndex) {
            int oldIndex = this.displayedMnemonicIndex;
            this.displayedMnemonicIndex = newIndex;
            this.firePropertyChange("displayedMnemonicIndex", oldIndex, newIndex);
        }
    }

    public int getDisplayedMnemonicIndex() {
        return this.displayedMnemonicIndex;
    }

    protected int checkHorizontalKey(int key, String message) {
        if (key != 2 && key != 0 && key != 4 && key != 10 && key != 11) {
            throw new IllegalArgumentException(message);
        }
        return key;
    }

    protected int checkVerticalKey(int key, String message) {
        if (key != 1 && key != 3 && key != 0) {
            throw new IllegalArgumentException(message);
        }
        return key;
    }

    public int getIconTextGap() {
        return this.iconTextGap;
    }

    public void setIconTextGap(int newGap) {
        if (this.iconTextGap != newGap) {
            this.firePropertyChange("iconTextGap", this.iconTextGap, newGap);
            this.iconTextGap = newGap;
        }
    }

    public int getVerticalAlignment() {
        return this.verticalAlignment;
    }

    public void setVerticalAlignment(int alignment) {
        if (alignment == this.verticalAlignment) {
            return;
        }
        int oldAlignment = this.verticalAlignment;
        this.verticalAlignment = this.checkVerticalKey(alignment, "verticalAlignment");
        this.firePropertyChange("verticalAlignment", oldAlignment, this.verticalAlignment);
    }

    public int getHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    public void setHorizontalAlignment(int alignment) {
        if (this.horizontalAlignment == alignment) {
            return;
        }
        int oldAlignment = this.horizontalAlignment;
        this.horizontalAlignment = this.checkHorizontalKey(alignment, "horizontalAlignment");
        this.firePropertyChange("horizontalAlignment", oldAlignment, this.horizontalAlignment);
    }

    public int getVerticalTextPosition() {
        return this.verticalTextPosition;
    }

    public void setVerticalTextPosition(int textPosition) {
        if (textPosition != this.verticalTextPosition) {
            int oldPos = this.verticalTextPosition;
            this.verticalTextPosition = this.checkVerticalKey(textPosition, "verticalTextPosition");
            this.firePropertyChange("verticalTextPosition", oldPos, this.verticalTextPosition);
        }
    }

    public int getHorizontalTextPosition() {
        return this.horizontalTextPosition;
    }

    public void setHorizontalTextPosition(int textPosition) {
        if (textPosition != this.horizontalTextPosition) {
            int oldPos = this.horizontalTextPosition;
            this.horizontalTextPosition = this.checkHorizontalKey(textPosition, "horizontalTextPosition");
            this.firePropertyChange("horizontalTextPosition", oldPos, this.horizontalTextPosition);
        }
    }

    public boolean imageUpdate(Image img, int infoflags, int x, int y, int w, int h) {
        Icon currIcon;
        Icon icon = currIcon = this.isEnabled() ? this.icon : this.disabledIcon;
        if (currIcon != null && currIcon instanceof ImageIcon) {
            return ((ImageIcon)currIcon).getImage() == img;
        }
        return false;
    }

    public Component getLabelFor() {
        return this.labelFor;
    }

    public void setLabelFor(Component c) {
        if (c != this.labelFor) {
            Component oldLabelFor = this.labelFor;
            this.labelFor = c;
            this.firePropertyChange("labelFor", oldLabelFor, this.labelFor);
            if (oldLabelFor instanceof JComponent) {
                ((JComponent)oldLabelFor).putClientProperty(LABEL_PROPERTY, null);
            }
            if (this.labelFor instanceof JComponent) {
                ((JComponent)this.labelFor).putClientProperty(LABEL_PROPERTY, this);
            }
        }
    }

    public void setFont(Font f) {
        super.setFont(f);
        this.repaint();
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJLabel();
        }
        return this.accessibleContext;
    }

    protected class AccessibleJLabel
    extends JComponent.AccessibleJComponent
    implements AccessibleText,
    AccessibleExtendedComponent {
        protected AccessibleJLabel() {
            super(JLabel.this);
        }

        public String getAccessibleName() {
            if (this.accessibleName != null) {
                return this.accessibleName;
            }
            if (JLabel.this.text != null) {
                return JLabel.this.text;
            }
            return super.getAccessibleName();
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.LABEL;
        }

        public String getSelectedText() {
            return null;
        }

        public int getSelectionStart() {
            return -1;
        }

        public int getSelectionEnd() {
            return -1;
        }

        public AttributeSet getCharacterAttribute(int index) {
            return new SimpleAttributeSet();
        }

        public String getAtIndex(int part, int index) {
            String result = "";
            int startIndex = -1;
            int endIndex = -1;
            switch (part) {
                case 1: {
                    result = String.valueOf(JLabel.this.text.charAt(index));
                    break;
                }
                case 2: {
                    startIndex = JLabel.this.text.lastIndexOf(32, index);
                    endIndex = JLabel.this.text.indexOf(32, startIndex + 1);
                    if (endIndex == -1) {
                        endIndex = startIndex + 1;
                    }
                    result = JLabel.this.text.substring(startIndex + 1, endIndex);
                    break;
                }
                default: {
                    startIndex = JLabel.this.text.lastIndexOf(46, index);
                    endIndex = JLabel.this.text.indexOf(46, startIndex + 1);
                    if (endIndex == -1) {
                        endIndex = startIndex + 1;
                    }
                    result = JLabel.this.text.substring(startIndex + 1, endIndex);
                }
            }
            return result;
        }

        public String getAfterIndex(int part, int index) {
            String result = "";
            int startIndex = -1;
            int endIndex = -1;
            switch (part) {
                case 1: {
                    result = String.valueOf(JLabel.this.text.charAt(index + 1));
                    break;
                }
                case 2: {
                    startIndex = JLabel.this.text.indexOf(32, index);
                    endIndex = JLabel.this.text.indexOf(32, startIndex + 1);
                    if (endIndex == -1) {
                        endIndex = startIndex + 1;
                    }
                    result = JLabel.this.text.substring(startIndex + 1, endIndex);
                    break;
                }
                default: {
                    startIndex = JLabel.this.text.indexOf(46, index);
                    endIndex = JLabel.this.text.indexOf(46, startIndex + 1);
                    if (endIndex == -1) {
                        endIndex = startIndex + 1;
                    }
                    result = JLabel.this.text.substring(startIndex + 1, endIndex);
                }
            }
            return result;
        }

        public String getBeforeIndex(int part, int index) {
            String result = "";
            int startIndex = -1;
            int endIndex = -1;
            switch (part) {
                case 1: {
                    result = String.valueOf(JLabel.this.text.charAt(index - 1));
                    break;
                }
                case 2: {
                    endIndex = JLabel.this.text.lastIndexOf(32, index);
                    if (endIndex == -1) {
                        endIndex = 0;
                    }
                    startIndex = JLabel.this.text.lastIndexOf(32, endIndex - 1);
                    result = JLabel.this.text.substring(startIndex + 1, endIndex);
                    break;
                }
                default: {
                    endIndex = JLabel.this.text.lastIndexOf(46, index);
                    if (endIndex == -1) {
                        endIndex = 0;
                    }
                    startIndex = JLabel.this.text.lastIndexOf(46, endIndex - 1);
                    result = JLabel.this.text.substring(startIndex + 1, endIndex);
                }
            }
            return result;
        }

        public int getCaretPosition() {
            return -1;
        }

        public int getCharCount() {
            return JLabel.this.text.length();
        }

        public Rectangle getCharacterBounds(int index) {
            Rectangle bounds = null;
            View view = (View)JLabel.this.getClientProperty("html");
            if (view != null) {
                Rectangle textR = this.getTextRectangle();
                try {
                    Shape s = view.modelToView(index, textR, Position.Bias.Forward);
                    bounds = s.getBounds();
                }
                catch (BadLocationException badLocationException) {}
            }
            return bounds;
        }

        private Rectangle getTextRectangle() {
            JLabel l = JLabel.this;
            Rectangle textR = new Rectangle();
            Rectangle iconR = new Rectangle();
            Insets i = l.getInsets();
            int w = l.getWidth();
            int h = l.getHeight();
            Rectangle viewR = new Rectangle(i.left, i.top, w - i.left - i.right, h - i.top - i.bottom);
            FontMetrics fm = l.getFontMetrics(l.getFont());
            SwingUtilities.layoutCompoundLabel(l, fm, l.getText(), l.getIcon(), l.getVerticalAlignment(), l.getHorizontalAlignment(), l.getVerticalTextPosition(), l.getHorizontalTextPosition(), viewR, iconR, textR, l.getIconTextGap());
            return textR;
        }

        public int getIndexAtPoint(Point point) {
            int index = -1;
            View view = (View)JLabel.this.getClientProperty("html");
            if (view != null) {
                Rectangle r = this.getTextRectangle();
                index = view.viewToModel(point.x, point.y, r, new Position.Bias[0]);
            }
            return index;
        }
    }
}

