/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.util.EmptyStackException;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Stack<T>
extends Vector<T> {
    private static final long serialVersionUID = 1224463164541339165L;

    public T push(T item) {
        this.addElement(item);
        return item;
    }

    public synchronized T pop() {
        if (this.elementCount == 0) {
            throw new EmptyStackException();
        }
        ++this.modCount;
        Object obj = this.elementData[--this.elementCount];
        this.elementData[this.elementCount] = null;
        return (T)obj;
    }

    public synchronized T peek() {
        if (this.elementCount == 0) {
            throw new EmptyStackException();
        }
        return (T)this.elementData[this.elementCount - 1];
    }

    public synchronized boolean empty() {
        return this.elementCount == 0;
    }

    public synchronized int search(Object o) {
        int i = this.elementCount;
        while (--i >= 0) {
            if (!Stack.equals(o, this.elementData[i])) continue;
            return this.elementCount - i;
        }
        return -1;
    }
}

