/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.Serializable;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class EnumSet<T extends Enum<T>>
extends AbstractSet<T>
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 4782406773684236311L;
    BitSet store;
    int cardinality;
    Class<T> enumClass;

    EnumSet() {
    }

    public EnumSet<T> clone() {
        EnumSet r;
        try {
            r = (EnumSet)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
        r.store = (BitSet)this.store.clone();
        return r;
    }

    public static <T extends Enum<T>> EnumSet<T> allOf(Class<T> eltType) {
        return EnumSet.copyOf((Collection)Arrays.asList((Enum[])eltType.getEnumConstants()));
    }

    public static <T extends Enum<T>> EnumSet<T> noneOf(Class<T> eltType) {
        return EnumSet.complementOf(EnumSet.allOf(eltType));
    }

    public static <T extends Enum<T>> EnumSet<T> copyOf(EnumSet<T> other) {
        return other.clone();
    }

    public static <T extends Enum<T>> EnumSet<T> copyOf(Collection<T> other) {
        if (other instanceof EnumSet) {
            return EnumSet.copyOf((EnumSet)other);
        }
        if (other.isEmpty()) {
            throw new IllegalArgumentException("Collection is empty");
        }
        EnumSet<Enum> r = null;
        for (Enum val : other) {
            if (r == null) {
                r = EnumSet.of(val);
                continue;
            }
            r.add(val);
        }
        return r;
    }

    public static <T extends Enum<T>> EnumSet<T> complementOf(EnumSet<T> other) {
        Object r = other.clone();
        int numConstants = ((Enum[])((EnumSet)r).enumClass.getEnumConstants()).length;
        ((EnumSet)r).store.flip(0, numConstants);
        ((EnumSet)r).cardinality = numConstants - other.cardinality;
        return r;
    }

    public static <T extends Enum<T>> EnumSet<T> of(T first) {
        EnumSet r = new EnumSet<T>(){

            @Override
            public boolean add(T val) {
                if (this.store.get(((Enum)val).ordinal())) {
                    return false;
                }
                this.store.set(((Enum)val).ordinal());
                ++this.cardinality;
                return true;
            }

            @Override
            public boolean addAll(Collection<? extends T> c) {
                boolean result = false;
                if (c instanceof EnumSet) {
                    EnumSet other = (EnumSet)c;
                    if (this.enumClass == other.enumClass) {
                        this.store.or(other.store);
                        int save = this.cardinality;
                        this.cardinality = this.store.cardinality();
                        result = save != this.cardinality;
                    }
                } else {
                    for (Enum val : c) {
                        if (!this.add((T)val)) continue;
                        result = true;
                    }
                }
                return result;
            }

            @Override
            public void clear() {
                this.store.clear();
                this.cardinality = 0;
            }

            @Override
            public boolean contains(Object o) {
                if (!(o instanceof Enum)) {
                    return false;
                }
                Enum e = (Enum)o;
                if (e.getDeclaringClass() != this.enumClass) {
                    return false;
                }
                return this.store.get(e.ordinal());
            }

            @Override
            public boolean containsAll(Collection<?> c) {
                if (c instanceof EnumSet) {
                    EnumSet other = (EnumSet)c;
                    if (this.enumClass == other.enumClass) {
                        return this.store.containsAll(other.store);
                    }
                    return false;
                }
                return super.containsAll(c);
            }

            @Override
            public Iterator<T> iterator() {
                return new Iterator<T>(this){
                    int next;
                    int count;
                    final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = var1_1;
                        this.next = -1;
                        this.count = 0;
                    }

                    public boolean hasNext() {
                        return this.count < this.this$1.cardinality;
                    }

                    public T next() {
                        this.next = this.this$1.store.nextSetBit(this.next + 1);
                        ++this.count;
                        return (T)((Enum[])this.this$1.enumClass.getEnumConstants())[this.next];
                    }

                    public void remove() {
                        if (!this.this$1.store.get(this.next)) {
                            this.this$1.store.clear(this.next);
                            --this.this$1.cardinality;
                        }
                    }
                };
            }

            @Override
            public boolean remove(Object o) {
                if (!(o instanceof Enum)) {
                    return false;
                }
                Enum e = (Enum)o;
                if (e.getDeclaringClass() != this.enumClass) {
                    return false;
                }
                this.store.clear(e.ordinal());
                --this.cardinality;
                return true;
            }

            @Override
            public boolean removeAll(Collection<?> c) {
                if (c instanceof EnumSet) {
                    EnumSet other = (EnumSet)c;
                    if (this.enumClass != other.enumClass) {
                        return false;
                    }
                    this.store.andNot(other.store);
                    int save = this.cardinality;
                    this.cardinality = this.store.cardinality();
                    return save != this.cardinality;
                }
                return super.removeAll(c);
            }

            @Override
            public boolean retainAll(Collection<?> c) {
                if (c instanceof EnumSet) {
                    EnumSet other = (EnumSet)c;
                    if (this.enumClass != other.enumClass) {
                        return false;
                    }
                    this.store.and(other.store);
                    int save = this.cardinality;
                    this.cardinality = this.store.cardinality();
                    return save != this.cardinality;
                }
                return super.retainAll(c);
            }

            @Override
            public int size() {
                return this.cardinality;
            }
        };
        r.enumClass = first.getDeclaringClass();
        r.store = new BitSet(((Enum[])r.enumClass.getEnumConstants()).length);
        r.add(first);
        return r;
    }

    public static <T extends Enum<T>> EnumSet<T> of(T first, T second) {
        EnumSet<T> r = EnumSet.of(first);
        r.add(second);
        return r;
    }

    public static <T extends Enum<T>> EnumSet<T> of(T first, T second, T third) {
        EnumSet<T> r = EnumSet.of(first, second);
        r.add(third);
        return r;
    }

    public static <T extends Enum<T>> EnumSet<T> of(T first, T second, T third, T fourth) {
        EnumSet<T> r = EnumSet.of(first, second, third);
        r.add(fourth);
        return r;
    }

    public static <T extends Enum<T>> EnumSet<T> of(T first, T second, T third, T fourth, T fifth) {
        EnumSet<T> r = EnumSet.of(first, second, third, fourth);
        r.add(fifth);
        return r;
    }

    public static <T extends Enum<T>> EnumSet<T> of(T first, T ... rest) {
        EnumSet<T> r = EnumSet.noneOf(first.getDeclaringClass());
        r.add(first);
        T[] TArray = rest;
        int n = rest.length;
        int n2 = 0;
        while (n2 < n) {
            T val = TArray[n2];
            r.add(val);
            ++n2;
        }
        return r;
    }

    public static <T extends Enum<T>> EnumSet<T> range(T from, T to) {
        if (from.compareTo(to) > 0) {
            throw new IllegalArgumentException();
        }
        Class<T> type = from.getDeclaringClass();
        EnumSet<T> r = EnumSet.noneOf(type);
        Enum[] values = (Enum[])type.getEnumConstants();
        int i = 0;
        while (from != values[i]) {
            ++i;
        }
        while (to != values[i]) {
            r.add(values[i]);
            ++i;
        }
        r.add(to);
        return r;
    }
}

