/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import gnu.java.lang.reflect.ClassSignatureParser;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.annotation.Inherited;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Class<T>
implements Type,
AnnotatedElement,
GenericDeclaration,
Serializable {
    private Class() {
    }

    private native void initializeClass();

    protected native void finalize() throws Throwable;

    public static native Class<?> forName(String var0) throws ClassNotFoundException;

    private static Class forName(String className, Class caller) throws ClassNotFoundException {
        return Class.forName(className, true, caller.getClassLoaderInternal());
    }

    public static native Class<?> forName(String var0, boolean var1, ClassLoader var2) throws ClassNotFoundException;

    public Class<?>[] getClasses() {
        this.memberAccessCheck(0);
        return this.internalGetClasses();
    }

    private Class<?>[] internalGetClasses() {
        ArrayList list2 = new ArrayList();
        list2.addAll(Arrays.asList(this.getDeclaredClasses(true)));
        Class<T> superClass = this.getSuperclass();
        if (superClass != null) {
            list2.addAll(Arrays.asList(super.internalGetClasses()));
        }
        return list2.toArray(new Class[list2.size()]);
    }

    public native ClassLoader getClassLoader();

    private final native ClassLoader getClassLoader(Class var1);

    private native ClassLoader getClassLoaderInternal();

    public native Class<?> getComponentType();

    public native Constructor<T> getConstructor(Class<?> ... var1) throws NoSuchMethodException;

    public Constructor<?>[] getConstructors() {
        this.memberAccessCheck(0);
        return this.getDeclaredConstructors(true);
    }

    public native Constructor<T> getDeclaredConstructor(Class<?> ... var1) throws NoSuchMethodException;

    public Class<?>[] getDeclaredClasses() {
        this.memberAccessCheck(1);
        return this.getDeclaredClasses(false);
    }

    native Class<?>[] getDeclaredClasses(boolean var1);

    public Constructor<?>[] getDeclaredConstructors() {
        this.memberAccessCheck(1);
        return this.getDeclaredConstructors(false);
    }

    native Constructor<?>[] getDeclaredConstructors(boolean var1);

    public native Field getDeclaredField(String var1) throws NoSuchFieldException;

    public Field[] getDeclaredFields() {
        this.memberAccessCheck(1);
        return this.getDeclaredFields(false);
    }

    native Field[] getDeclaredFields(boolean var1);

    private native Method _getDeclaredMethod(String var1, Class[] var2);

    public Method getDeclaredMethod(String methodName, Class<?> ... args) throws NoSuchMethodException {
        this.memberAccessCheck(1);
        if ("<init>".equals(methodName) || "<clinit>".equals(methodName)) {
            throw new NoSuchMethodException(methodName);
        }
        Method match = this._getDeclaredMethod(methodName, args);
        if (match == null) {
            throw new NoSuchMethodException(methodName);
        }
        return match;
    }

    public native Method[] getDeclaredMethods();

    public native Class<?> getDeclaringClass();

    private native Field getField(String var1, int var2) throws NoSuchFieldException;

    public Field getField(String fieldName) throws NoSuchFieldException {
        this.memberAccessCheck(0);
        Field field = this.getField(fieldName, fieldName.hashCode());
        if (field == null) {
            throw new NoSuchFieldException(fieldName);
        }
        return field;
    }

    public Field[] getFields() {
        this.memberAccessCheck(0);
        return this.internalGetFields();
    }

    private Field[] internalGetFields() {
        LinkedHashSet<Field> set = new LinkedHashSet<Field>();
        set.addAll(Arrays.asList(this.getDeclaredFields(true)));
        Class<?>[] interfaces = this.getInterfaces();
        int i = 0;
        while (i < interfaces.length) {
            set.addAll(Arrays.asList(super.internalGetFields()));
            ++i;
        }
        Class<T> superClass = this.getSuperclass();
        if (superClass != null) {
            set.addAll(Arrays.asList(super.internalGetFields()));
        }
        return set.toArray(new Field[set.size()]);
    }

    public Package getPackage() {
        ClassLoader cl = this.getClassLoaderInternal();
        if (cl != null) {
            return cl.getPackage(Class.getPackagePortion(this.getName()));
        }
        return VMClassLoader.getPackage(Class.getPackagePortion(this.getName()));
    }

    public native Class<?>[] getInterfaces();

    private final native void getSignature(StringBuffer var1);

    private static final native String getSignature(Class[] var0, boolean var1);

    public native Method _getMethod(String var1, Class[] var2);

    public Method getMethod(String methodName, Class<?> ... args) throws NoSuchMethodException {
        this.memberAccessCheck(0);
        if ("<init>".equals(methodName) || "<clinit>".equals(methodName)) {
            throw new NoSuchMethodException(methodName);
        }
        Method method = this._getMethod(methodName, args);
        if (method == null) {
            throw new NoSuchMethodException(methodName);
        }
        return method;
    }

    private native int _getMethods(Method[] var1, int var2);

    public native Method[] getMethods();

    public native int getModifiers();

    public native String getName();

    public URL getResource(String resourceName) {
        String name = this.resourcePath(resourceName);
        ClassLoader loader = this.getClassLoaderInternal();
        if (loader == null) {
            return ClassLoader.getSystemResource(name);
        }
        return loader.getResource(name);
    }

    public InputStream getResourceAsStream(String resourceName) {
        String name = this.resourcePath(resourceName);
        ClassLoader loader = this.getClassLoaderInternal();
        if (loader == null) {
            return ClassLoader.getSystemResourceAsStream(name);
        }
        return loader.getResourceAsStream(name);
    }

    private String resourcePath(String resourceName) {
        if (resourceName.length() > 0) {
            if (resourceName.charAt(0) != '/') {
                String pkg = Class.getPackagePortion(this.getName());
                if (pkg.length() > 0) {
                    resourceName = String.valueOf(pkg.replace('.', '/')) + '/' + resourceName;
                }
            } else {
                resourceName = resourceName.substring(1);
            }
        }
        return resourceName;
    }

    public native Object[] getSigners();

    native void setSigners(Object[] var1);

    public native Class<? super T> getSuperclass();

    public native boolean isArray();

    public native boolean isAssignableFrom(Class<?> var1);

    public native boolean isInstance(Object var1);

    public native boolean isInterface();

    public native boolean isPrimitive();

    public native T newInstance() throws InstantiationException, IllegalAccessException;

    private native ProtectionDomain getProtectionDomain0();

    public ProtectionDomain getProtectionDomain() {
        ProtectionDomain protectionDomain;
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(VMClassLoader.protectionDomainPermission);
        }
        if ((protectionDomain = this.getProtectionDomain0()) == null) {
            return VMClassLoader.unknownProtectionDomain;
        }
        return protectionDomain;
    }

    public String toString() {
        if (this.isPrimitive()) {
            return this.getName();
        }
        return String.valueOf(this.isInterface() ? "interface " : "class ") + this.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean desiredAssertionStatus() {
        Object status;
        ClassLoader classLoader;
        ClassLoader c = this.getClassLoaderInternal();
        if (c == null) {
            return VMClassLoader.defaultAssertionStatus();
        }
        if (c.classAssertionStatus != null) {
            classLoader = c;
            synchronized (classLoader) {
                status = c.classAssertionStatus.get(this.getName());
                if (status != null) {
                    return status.equals(Boolean.TRUE);
                }
            }
        } else {
            status = ClassLoader.systemClassAssertionStatus.get(this.getName());
            if (status != null) {
                return status.equals(Boolean.TRUE);
            }
        }
        if (c.packageAssertionStatus != null) {
            classLoader = c;
            synchronized (classLoader) {
                String name = Class.getPackagePortion(this.getName());
                if ("".equals(name)) {
                    status = c.packageAssertionStatus.get(null);
                } else {
                    do {
                        status = c.packageAssertionStatus.get(name);
                    } while (!"".equals(name = Class.getPackagePortion(name)) && status == null);
                }
                if (status != null) {
                    return status.equals(Boolean.TRUE);
                }
            }
        } else {
            String name = Class.getPackagePortion(this.getName());
            if ("".equals(name)) {
                status = ClassLoader.systemPackageAssertionStatus.get(null);
            } else {
                do {
                    status = ClassLoader.systemPackageAssertionStatus.get(name);
                } while (!"".equals(name = Class.getPackagePortion(name)) && status == null);
            }
            if (status != null) {
                return status.equals(Boolean.TRUE);
            }
        }
        return c.defaultAssertionStatus;
    }

    private static String getPackagePortion(String name) {
        int lastInd = name.lastIndexOf(46);
        if (lastInd == -1) {
            return "";
        }
        return name.substring(0, lastInd);
    }

    private void memberAccessCheck(int which) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkMemberAccess(this, which);
            Package pkg = this.getPackage();
            if (pkg != null) {
                sm.checkPackageAccess(pkg.getName());
            }
        }
    }

    public <U> Class<? extends U> asSubclass(Class<U> klass) {
        if (!klass.isAssignableFrom(this)) {
            throw new ClassCastException();
        }
        return this;
    }

    public T cast(Object obj) {
        if (obj != null && !this.isInstance(obj)) {
            throw new ClassCastException();
        }
        return (T)obj;
    }

    public T[] getEnumConstants() {
        if (this.isEnum()) {
            try {
                Method m = this.getMethod("values", new Class[0]);
                Class.setAccessible(m);
                return (Object[])m.invoke(null, new Object[0]);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new Error("Enum lacks values() method");
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new Error("Unable to access Enum class");
            }
            catch (InvocationTargetException exception) {
                throw new RuntimeException("The values method threw an exception", exception);
            }
        }
        return null;
    }

    public native boolean isEnum();

    public native boolean isSynthetic();

    public native boolean isAnnotation();

    public String getSimpleName() {
        StringBuffer sb = new StringBuffer();
        Class<?> klass = this;
        int arrayCount = 0;
        while (klass.isArray()) {
            klass = klass.getComponentType();
            ++arrayCount;
        }
        if (!klass.isAnonymousClass()) {
            String fullName = klass.getName();
            sb.append(fullName, fullName.lastIndexOf(".") + 1, fullName.length());
        }
        while (arrayCount-- > 0) {
            sb.append("[]");
        }
        return sb.toString();
    }

    public native Class<?> getEnclosingClass();

    public native Constructor<T> getEnclosingConstructor();

    public native Method getEnclosingMethod();

    private native String getClassSignature();

    public Type[] getGenericInterfaces() {
        if (this.isPrimitive()) {
            return new Type[0];
        }
        String sig = this.getClassSignature();
        if (sig == null) {
            return this.getInterfaces();
        }
        ClassSignatureParser p = new ClassSignatureParser(this, sig);
        return p.getInterfaceTypes();
    }

    public Type getGenericSuperclass() {
        if (this.isArray()) {
            return Object.class;
        }
        if (this.isPrimitive() || this.isInterface() || this == Object.class) {
            return null;
        }
        String sig = this.getClassSignature();
        if (sig == null) {
            return this.getSuperclass();
        }
        ClassSignatureParser p = new ClassSignatureParser(this, sig);
        return p.getSuperclassType();
    }

    public TypeVariable<Class<T>>[] getTypeParameters() {
        String sig = this.getClassSignature();
        if (sig == null) {
            return new TypeVariable[0];
        }
        ClassSignatureParser p = new ClassSignatureParser(this, sig);
        return p.getTypeParameters();
    }

    public <A extends Annotation> A getAnnotation(Class<A> annotationClass) {
        Annotation[] annotations;
        Annotation foundAnnotation = null;
        Annotation[] annotationArray = annotations = this.getAnnotations();
        int n = annotations.length;
        int n2 = 0;
        while (n2 < n) {
            Annotation annotation = annotationArray[n2];
            if (annotation.annotationType() == annotationClass) {
                foundAnnotation = annotation;
            }
            ++n2;
        }
        return (A)foundAnnotation;
    }

    @Override
    public Annotation[] getAnnotations() {
        HashMap<Class<? extends Annotation>, Annotation> map = new HashMap<Class<? extends Annotation>, Annotation>();
        Annotation[] annotationArray = this.getDeclaredAnnotations();
        int n = annotationArray.length;
        int n2 = 0;
        while (n2 < n) {
            Annotation a = annotationArray[n2];
            map.put(a.annotationType(), a);
            ++n2;
        }
        Class<T> s = this.getSuperclass();
        while (s != null) {
            Annotation[] annotationArray2 = s.getDeclaredAnnotations();
            int n3 = annotationArray2.length;
            n = 0;
            while (n < n3) {
                Annotation a = annotationArray2[n];
                Class<? extends Annotation> k = a.annotationType();
                if (!map.containsKey(k) && k.isAnnotationPresent(Inherited.class)) {
                    map.put(k, a);
                }
                ++n;
            }
            s = s.getSuperclass();
        }
        Collection v = map.values();
        return v.toArray(new Annotation[v.size()]);
    }

    public String getCanonicalName() {
        String memberName;
        String componentName;
        if (this.isArray() && (componentName = this.getComponentType().getCanonicalName()) != null) {
            return String.valueOf(componentName) + "[]";
        }
        if (this.isMemberClass() && (memberName = this.getDeclaringClass().getCanonicalName()) != null) {
            return String.valueOf(memberName) + "." + this.getSimpleName();
        }
        if (this.isLocalClass() || this.isAnonymousClass()) {
            return null;
        }
        return this.getName();
    }

    @Override
    public Annotation[] getDeclaredAnnotations() {
        Annotation[] result = this.getDeclaredAnnotationsInternal();
        if (result == null) {
            result = new Annotation[]{};
        }
        return result;
    }

    private native Annotation[] getDeclaredAnnotationsInternal();

    @Override
    public boolean isAnnotationPresent(Class<? extends Annotation> annotationClass) {
        return this.getAnnotation((Class)annotationClass) != null;
    }

    public native boolean isAnonymousClass();

    public native boolean isLocalClass();

    public native boolean isMemberClass();

    static void setAccessible(final AccessibleObject obj) {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                obj.setAccessible(true);
                return null;
            }
        });
    }
}

