<?php
 /*
 
 PukiWiki コンタクトフォームプラグイン ver. 2009-04-17
 	  					 by J.Kuwamura

  2009-04-17 Mod fix for mysql
  2009-04-16 Mod fix for sqlite2
  2009-04-15 Mod ported to php4
  2009-04-12 Mod change some variable names
  2009-03-29 New contactform4 delived from registerform4


 PukiWiki 登録フォームプラグイン(確認メール付き)
 by J.Kuwamura (ver. 2009-02-02)

 PukiWiki メールフォームプラグイン ver. 2008-11-11
 Ajax版 by masaki.fujimoto
 (version 1.4 of prototype.js is required)


 <<This originaly was a mailform plugin.>>
 PukiWiki メールフォームプラグイン ver. 2002-06-18
 CopyRight 2002 OKAWARA,Satoshi All rights reserved.
 http://www.dml.co.jp/~kawara/pukiwiki/pukiwiki.php
 kawara@dml.co.jp
 
 LANGUAGEファイルに下記の値を追加してからご使用ください
	$_btn_registersend	= '上記の内容で送信';
	$_btn_registerfinish	= '完了';
 */
			      
///////////////////////////////////////////////////////////////////
// 以下のBENKYOKAI的設定項目を目的にあわせて変更してください。
///////////////////////////////////////////////////////////////////
// BENKYOKAI的設定項目: 勉強会タイトル
$GLOBALS['title']="OSS研究所";

// BENKYOKAI的設定項目: 勉強会開催連番デフォルト
// (ここは触らずにプラグインの引数で指定できます)
$GLOBALS['serial'] = 0;

// BENKYOKAI的設定項目: 電話連絡希望
$GLOBALS['callable'] = true;
$GLOBALS['callinfo'] = '';
$GLOBALS['callwarn'] = "<font color='red'>電話連絡を希望されない方はチェックを外してください。</font>";

// BENKYOKAI的設定項目: お知らせ配信案内
$GLOBALS['news'] = true;
$GLOBALS['optinquery'] = "今後、当事務局からのお知らせを受け取りたい場合はチェックをしてください。";

// BENKYOKAI的設定項目: 勉強会事務局
$GLOBALS['jimukyoku'] = "OSS研究所自動受付";
$GLOBALS['shitsumon'] = "お問い合わせなどございましたら、以下にご連絡ください。";

// BENKYOKAI的設定項目: 主催者連絡先
// (必ず届くメールアドレスを指定してください。)
$GLOBALS['mailfrom'] = 'kuwamura+contactform@example.com';
$GLOBALS['url'] = get_script_uri();
$GLOBALS['list'] = '';

// BENKYOKAI的設定項目: データベースとテーブル名
// (PDOのDSNにて指定してください。)
$GLOBALS['dsn'] = "sqlite:/opt/htdocs/pukiwiki-1.4.7utf8/counter/contactform4.sq2";
//$GLOBALS['dsn'] = "mysql://user:pass@localhost/contactform4";
$GLOBALS['tbase'] = "cf4";
$GLOBALS['table'] = $GLOBALS['tbase'].sprintf("%04d", $GLOBALS['serial']);

// BENKYOKAI的設定項目: 管理モード
// (管理者用のページを指定することができます。)
$GLOBALS['admin'] = (basename($_SERVER["PHP_SELF"])=="admin.php")?1:0;
///////////////////////////////////////////////////////////////////


///////////////////////////////////////////////////////////////////
// コンタクトフォームには不要なパラメータです
///////////////////////////////////////////////////////////////////
// 登録確認のアクティベートフラグ
// (いたずら対策です)
$GLOBALS['active'] = false;
// 登録メンバー公開
// （trueにするとプライバシ情報の漏洩になる可能性があります)
$GLOBALS['sns'] = false;
// 文字列時刻フォーマット
$GLOBALS['regtform'] = '%Y-%m-%d %H:%M';

// 出力／データベースのエンコーディング
// (利用環境にあわせてください。)
define('OUTPUT_ENCODING', 'UTF-8');
define('DB_ENCODING', 'EUC_JP');
///////////////////////////////////////////////////////////////////

// 投稿内容のメール送信時の題名
if ($GLOBALS['serial']) {
  define("MAIL_SUBJECT_PREFIX", " {$GLOBALS['title']}({$GLOBALS['serial']})");
} else {
  define("MAIL_SUBJECT_PREFIX", "{$GLOBALS['title']}");
}

$dbms = substr($GLOBALS['dsn'], 0, strpos($GLOBALS['dsn'], ':'));
if ( $dbms == "sqlite" ) {
    include_once 'mysqlite.inc.php';
 } else {
    if (!extension_loaded('mysql') && extension_loaded('pgsql')) {
	include_once 'mypgsql.inc.php';
    }
 }

function _plugin_contactform4_strptime($strtime)
{
    /*
  $tma = strptime($strtime, $GLOBALS['regtform']);
  //tm_sec  	分未満の秒数 (0-61)
  //tm_min 	時間未満の分数 (0-59)
  //tm_hour 	0 時以降の時間数 (0-23)
  //tm_mday 	月内の日数 (1-31)
  //tm_mon 	1 月から数えた月数 (0-11)
  //tm_year 	1900 年以降の年
  //tm_wday 	日曜日からの日数 (0-6)
  //tm_yday 	1 月 1 日からの日数 (0-365)
  return (mktime($tma['tm_hour'], $tma['tm_min'], $tma['tm_sec'],
		 $tma['tm_mon']+1, $tma['tm_mday'], $tma['tm_year']+1900));
    */

  $ts = explode(' ', $strtime);
  $ts_day = explode('-', $ts[0]);
  $ts_hms = explode(':', $ts[1]);
  return (mktime((int)$ts_hms[0], (int)$ts_hms[1], 0,
		 (int)$ts_day[1], $ts_day[2], $ts_day[0]));

}

function _plugin_contactform4_checkskew($ts, $skew=300)
{
    $dt = time() - (int)_plugin_contactform4_strptime($ts);
    return ($skew>abs($dt))?1:0;
}


/////
/////
///// mailto_*
//
// 事務局へのメール
//
function plugin_contactform4_mailto_secretariat($row='')
{
  global $post;

  $entryurl = "http://{$_SERVER["HTTP_HOST"]}{$_SERVER['PHP_SELF']}?{$post['page']}";
  if (empty($row)) {
      $accesskey = urlencode(md5($post['fromaddress'].$post['fromname'].$post['now']));
    $row = plugin_contactform4_search($post['fromaddress'], $accesskey);
  } else {
      $accesskey = $post['ackey'];
  }
  $confirmurl = $entryurl."&plugin={$post['plugin']}&serial={$post['serial']}&fromaddress={$post['fromaddress']}&fromkey={$accesskey}";

  // 事務局へ
  // メール通知
  $mailsubject = "［".MAIL_SUBJECT_PREFIX."］ <{$post['fromaddress']}>";
  //$mailsubject = mb_convert_encoding( $mailsubject, "ISO-2022-JP" );
  //$mailsubject = mb_encode_mimeheader($mailsubject, "ISO-2022-JP" );

  $mailbody = '';
  foreach ($row as $k => $v) {
      $mailbody .= "{$k}: {$v}\n";
  }
  $mailbody .= "\n受付時刻：" . strftime("%Y/%m/%d %H:%M:%S") . "\n";
  $mailbody .= "AGENT：" . getenv('HTTP_USER_AGENT') . "\n";
  $mailbody .= "REMOTE：" . $_SERVER['REMOTE_ADDR'] . "\n";
  $mailbody .= "\n確認URL：\n" . $confirmurl . "\n";

  //$mailbody = mb_convert_encoding( $mailbody, "ISO-2022-JP" );
  $mailaddheader = "From: ".$post['fromaddress'];

  /* sendmail by system call
  $mailfrom = $post['fromaddress'];
  $rcptto = $GLOBALS['mailfrom'];
  $subject = mb_encode_mimeheader(mb_convert_encoding($mailsubject, "ISO-2022-JP" ), "ISO-2022-JP" );
  $cmd = "/usr/sbin/sendmail -t -i $rcptto";
  if ( ($fh = popen($cmd, 'w')) === false ) {
      echo "Open failed: {$php_errormsg}<br>\n";
      echo "    command: {$cmd}<br>\n";
  } else {
      fwrite($fh, "From: ".$mailfrom."\n");
      fwrite($fh, "To: ".$rcptto."\n");
      fwrite($fh, "Subject: ".$subject."\n");
      fwrite($fh, "\n");
      fwrite($fh, mb_convert_encoding($mailbody, "ISO-2022-JP"));
      pclose($fh); 
  }
  */

  // 事務局へ送信。
  mb_language("ja");
  if (! mb_send_mail($GLOBALS['mailfrom'], $mailsubject, $mailbody, $mailaddheader) ) {
      echo "Error! mb_send_mail({$GLOBALS['mailfrom']}, $mailsubject, $mailbody, $mailaddheader)<br>\n";
  }
}

//
// 質問者へのメール
// 以下の内容で受付いたしましたのでお知らせいたします。
function plugin_contactform4_mailto_participant($confirm=0, $row='')
{
  global $post;

  $entryurl = "http://{$_SERVER["HTTP_HOST"]}{$_SERVER['PHP_SELF']}?{$post['page']}";
  if (empty($row)) {
      $accesskey = urlencode(md5($post['fromaddress'].$post['fromname'].$post['now']));
    $row = plugin_contactform4_search($post['fromaddress'], $accesskey);
  } else {
      $accesskey = $post['ackey'];
  }
  $confirmurl = $entryurl."&plugin={$post['plugin']}&serial={$post['serial']}&fromaddress={$post['fromaddress']}&fromkey={$accesskey}";

  if ($confirm) {
    if (empty($row)) {
      $row = plugin_contactform4_search($address, $key);
    }
    foreach ($row as $k => $v) {
      $post["from$k"] = $row[$k];
    }
  }

  $mailaddheader = "From: " . $GLOBALS['mailfrom'];

  if ($GLOBALS['active']) {
    $subject = "【".MAIL_SUBJECT_PREFIX."】 ご質問登録のお知らせ";
  } else {
    $subject = "【".MAIL_SUBJECT_PREFIX."】 ご質問受付のお知らせ";
    if ($post['fromnews'] == 1) {
      $newsannounce = "上記アドレス宛てに次回のご案内を送付させていただきます。";
    } else {
      $newsannounce = '';
    }

  }

  if ($GLOBALS['callable']) {
    if ($post['fromcallable'] == 1) {
      $callable = "電話連絡：希望する";
    } else {
      $callable = "電話連絡：希望しない";
    }
  } else {
    $callable = "";
  }
  if ($post['fromnews'] == 1) {
    $news = "希望する";
  } else {
    $news = "希望しない";
  }

  $now = strftime("%Y/%m/%d %H:%M:%S");
  $agent = getenv('HTTP_USER_AGENT');

  if ($GLOBALS['active']) {
    ;
  } else {
  //($GLOBALS['active']==false)//
    $mailbody = <<<__EOD__
{$post['fromname']} <{$post['fromaddress']}> 様

お世話になっております。{$GLOBALS['jimukyoku']} です。

このたびは、{$GLOBALS['title']}にお問い合わせいただきまして
まことにありがとうございました。

以下の内容でご質問を受付ましたのでお知らせいたします。

■ご登録内容

メールアドレス： {$post['fromaddress']}
お名前： {$post['fromname']}
ご所属： {$post['frombelong']}
お電話番号： {$post['fromphone']}
 {$callable}
ご質問内容：
 {$post['frommsg']}


__EOD__;

    if ($GLOBALS['news']) {
      $mailbody .= <<<__EOD__
お知らせ配信： {$news}
__EOD__;
    }

    $mailbody .= <<<__EOD__


■ご登録時の情報
TIME：  {$now}
AGENT： {$agent}
REMOTE：{$_SERVER['REMOTE_ADDR']}

{$newsannounce}
なお、{$GLOBALS['shitsumon']}

------------------
{$GLOBALS['jimukyoku']}
{$GLOBALS['url']}
{$GLOBALS['mailfrom']}
__EOD__;
  }			//($GLOBALS['active'])//

  // 質問者へ送信！
  mb_language("ja");
  if (! mb_send_mail($post['fromaddress'], $subject, $mailbody, $mailaddheader) ) {
      echo "Error! mb_send_mail({$post['fromaddress']}, $subject, $mailbody, $mailaddheader)<br>\n";
  }

}
///// mailto_*
/////
/////


//
// プラグイン登録アクション
//
function plugin_contactform4_action()
{
  global $post,$vars,$digest;

  if (isset($post['serial'])) {
    $num = intval($post['serial']);
    $GLOBALS['serial'] = $num;
    $GLOBALS['table'] = $GLOBALS['tbase'].sprintf("%04d", $GLOBALS['serial']);
  }

  if ( $post['pcmd'] == "confirm" ) {
    // 登録確認の更新処理
    $html = <<<_EOD_
 <link rel="stylesheet" type="text/css" media="screen" href="skin/pukiwiki.css.php?charset=Shift_JIS" charset="Shift_JIS" />

<h2>《登録完了》{$GLOBALS['title']}</h2>
<blockquote>
  <div id='confirmation'>
_EOD_;

    // for posted checkbox values not checked
    if (! isset($post['callable']) ) {
      $post['callable'] = 0;
    }
    if (! isset($post['news']) ) {
      $post['news'] = 0;
    }

    $tbl = plugin_contactform4_fixentry();

    if ( $tbl ) {
      $html .= "問い合わせを確定しました。<br />";
      $html .= "<p>\n$tbl\n</p>";

      // 登録メール送信
      $address = str_replace(" ", "+", trim($post['fromaddress']));
      $key = $post['fromkey'];
      $row = plugin_contactform4_search($address, $key);
      //plugin_contactform4_mailto_participant(1,$row);
      plugin_contactform4_mailto_secretariat($row);

    } else {
      $html .= "問い合わせの確定に失敗いたしました。<br />";
      $html .= "下記へご連絡ください。<br />";
    }

    $html .= <<<_EOD_
  </div>
</blockquote>
<pre>
{$GLOBALS['jimukyoku']}
{$GLOBALS['url']}
{$GLOBALS['mailfrom']}
</pre>
<br />
<a href="http://{$_SERVER["HTTP_HOST"]}{$_SERVER['PHP_SELF']}?{$post['page']}">
登録ページにもどる</a>
_EOD_;

    print mb_convert_encoding($html, 'UTF-8');
    exit;

  } //($post['pcmd']=="confirm")//

  if ($GLOBALS['callable']) {
    $items = array(
		 'fromname' => "お名前",
		 'frombelong' => "ご所属",
		 'fromurl' => "URL(blog等)",
		 'fromaddress' => "メールアドレス",
		 'fromphone' => "お電話番号",
		 'fromcallable' => "お電話連絡",
		 'frommsg' => "ご質問",
		 'fromnews' => "お知らせ配信",

		 );
  } else {
    $items = array(
		 'fromname' => "お名前",
		 'frombelong' => "ご所属",
		 'fromurl' => "URL(blog等)",
		 'fromaddress' => "メールアドレス",
		 'fromphone' => "お電話番号",
		 'frommsg' => "ご質問",
		 'fromnews' => "お知らせ配信",
		 );
  }

  $error = array();
  foreach ($items as $k => $v) {
    $post[$k] = uniDecode($post[$k], OUTPUT_ENCODING);
    if ($post[$k] == "" && $k != "frommsg" && $k != "fromurl" && $k != "fromcallable"  && $k != "fromnews") {
      $error[] = "{$v}を入力してください";
    }
  }

//// Message replacement
//  $post['frommsg'] = urlencode($post['frommsg']);
  // Mail Address replacement
  $pattern = '/(.*)<(.*)>(.*)/i';
  $replacement = '${2}';
  $post['fromaddress'] = preg_replace($pattern, $replacement, $post['fromaddress']);
  // メ・アドに含まれる' 'は、誤変換された'+'として元に戻す
  $post['fromaddress'] = str_replace(" ", "+", trim($post['fromaddress']));

  if ($error) {
    $s = _plugin_contactform4_form($post, $error);
    print mb_convert_encoding($s, 'UTF-8');
    exit;
  }

  // 事務局へメール
  //foreach ($items as $k => $v) {
  //  $row[$v] = $post[$k];
  //}


  if ( $post['pcmd'] != "confirm" ) {
   $btn = "<form action=\"".$_SERVER['PHP_SELF']."\" method=\"post\">\n"
       ."<input type=\"hidden\" name=\"refer\" value=\"{$post['page']}\">\n"
       ."<input type=\"hidden\" name=\"page\" value=\"{$post['page']}\">\n"
       ."<input type=\"hidden\" name=\"digest\" value=\"{$post['digest']}\">\n"
       ."<input type=\"hidden\" name=\"now\" value=\"{$post['now']}\">\n"
       ."<input type=\"hidden\" name=\"plugin\" value=\"contactform4\">\n"
       ."<input type=\"hidden\" name=\"pcmd\" value=\"send\">\n"
       ."<input type=\"button\" name=\"contactform4\" value=\"戻る\" onclick=\"location.reload()\">\n"
       ."</form>\n";

   // skew check to eliminate SPAM
   if ( _plugin_contactform4_checkskew($post['now']) ) {

    // DB登録
    if ( plugin_contactform4_preentry($post) ) {

      // 事務局へメール
      plugin_contactform4_mailto_secretariat();

      // 質問者へメール
      plugin_contactform4_mailto_participant();

      // 成功時の画面表示
      $s = <<<__EOD__
<div style="width:100%; text-align: left"><p style="line-height: 120%">
お問い合わせありがとうございました。<br /><br />
</p>
</div>
__EOD__;

    } else {
      $s = <<<__EOD__
<div style="width:100%; text-align: left"><p style="line-height: 120%">
まことに申し訳けありません。なんらかの原因で登録に失敗したようです。<br />
{$GLOBALS['shitsumon']}
</p></div>
------------------<br />
{$GLOBALS['jimukyoku']}<br />
{$GLOBALS['url']}<br />
{$GLOBALS['mailfrom']}<br /><br />
__EOD__;

    }

    $s .= $btn;

    // 登録者サマリー表
    $s .= plugin_contactform4_summary();

   } // skew check
   else {
       $s = <<<__EOD__
<div style="width:100%; text-align: left"><p style="line-height: 120%">
申し訳ありませんが、タイムアウトしてしまったようです。<br />
お手数ですが、もう一度やりなおしてください。<br />
</p>
</div>
__EOD__;

       $s .= $btn;
   }

   print mb_convert_encoding($s, "UTF-8");

  }	//($post['pcmd']!="confirm")//

  exit;
}

//
// プラグイン
//
function plugin_contactform4_convert()
{
  global $vars, $post, $get;

//echo basename($_SERVER["PHP_SELF"]);

  $args = func_get_args();
  if (isset($args[0])) {
    $num = intval($args[0]);
    $GLOBALS['serial'] = $num;
    $GLOBALS['table'] = $GLOBALS['tbase'].sprintf("%04d", $GLOBALS['serial']);
  }

  if (! isset($vars['fromkey']) ) {
    //return _plugin_contactform4_form(array('fromcallable' => 1));
    $fromvarskey = array('fromaddress', 'fromphone', 'fromname', 'frombelong', 'fromurl', 'frommsg');
    foreach ($fromvarskey as $key) {
      if (! isset($vars[$key]) ) {
	$vars[$key] = '';
      }
    }
    if (! isset($vars['fromcallable']) ) {
      $vars['fromcallable'] = 1;
    }
    if (! isset($vars['fromnews']) ) {
      $vars['fromnews'] = 0;
    }
    return _plugin_contactform4_form($vars);
  } else {
    return _plugin_contactform4_confirm($vars);
  }
}


//
// プラグイン・確認フォーム
//
function _plugin_contactform4_confirm($value)
{
  global $vars,$post,$script,$_btn_registerfinish;
  global $dbms;

  if (isset($value['serial'])) {
    $num = intval($value['serial']);
    $GLOBALS['serial'] = $num;
    $GLOBALS['table'] = $GLOBALS['tbase'].sprintf("%04d", $GLOBALS['serial']);
  }

  $address = str_replace(" ", "+", trim($value['fromaddress']));
  $key = $value['fromkey'];
  $row = plugin_contactform4_search($address, $key);

  foreach ($row as $k => $v) {
    if ( strtoupper(mb_detect_encoding($v)) != OUTPUT_ENCODING ) {
      $row[$k] =  mb_convert_encoding($v, OUTPUT_ENCODING, 'auto');
    }
    // タグが混じってしまった場合の対策
    $row[$k] = str_replace(array("<",">"), "", strip_tags($row[$k]));
    //$post["from$k"] = $row[$k];
  }

  if ($dbms == "sqlite") {
      $t_val = "true";
  } else {
      $t_val = 1;
  }

  if ($row['callable'] == $t_val) {
      $value['callable_check'] = "希望する";
  }
  if ($row['news'] == $t_val) {
      $value['news_check'] = "希望する";
  }

  // checked for confirm
  $confirm_check = array('', '');
  if ( $row['confirm'] == $t_val ) {
      $confirm_check[1] = "checked";
  } else {
      $confirm_check[0] = "checked";
  }
  

  // サブミットボタン
  $button = "<input type=\"submit\" name=\"contactform4\" value=\"$_btn_registerfinish\">\n";

  $vakey = array_keys($value);
  $page  = empty($value['page'])?$vakey[0]:$vars['page'];
  // 登録の確定用ページ
  $string = <<<_EOD_
 <link rel="stylesheet" type="text/css" media="screen" href="skin/pukiwiki.css.php?charset=Shift_JIS" charset="Shift_JIS" />

<h2>《登録の確認》{$GLOBALS['title']}</h2>

<div id='confirmation'>
	<form action="{$_SERVER['PHP_SELF']}" method="post">
	<input type="hidden" name="digest" value="{$digest}">
	<input type="hidden" name="plugin" value="contactform4">
	<input type="hidden" name="pcmd" value="confirm">

	<input type="hidden" name="page" value="$page">
	<input type="hidden" name="serial" value="{$value['serial']}">
	<input type="hidden" name="fromaddress" value="{$address}">
	<input type="hidden" name="fromphone" value="{$phone}">
	<input type="hidden" name="fromkey" value="{$key}">

	<input type="hidden" name="fromname" value="{$row['name']}">
	<input type="hidden" name="frombelong" value="{$row['belong']}">
	<input type="hidden" name="fromcallable" value="{$row['callable']}">
	<input type="hidden" name="frommsg" value="{$row['msg']}">
	<input type="hidden" name="fromnews" value="{$row['news']}">
_EOD_;

  if ($GLOBALS['callable']) {
    $callable_html = <<<__EOD__
		<tr><th class="style_th">電話連絡希望</th>
			<td class="style_td2">{$value['callable_check']}
			<input type="hidden" name="callable" value="{$row['callable']}" id="callable">
			</td>
		</tr>
__EOD__;
  } else {
    $callable_html = "<input type=\"hidden\" name=\"callable\" value=\"0\">\n";
  }

  if ($GLOBALS['news']) {
    $callable_html .= <<<__EOD__
		<tr>
		  <th class="style_th">お知らせの配信</th>
		  <td class="style_td2">{$value['news_check']}
		  <input type="hidden" name="news" value="{$row['news']}" id="news">
		  </td>
		</tr>
__EOD__;
  } else {
    $callable_html .= "<input type=\"hidden\" name=\"news\" value=\"0\">\n";
  }



  // post request
  $string .= <<<__EOD__
	<table border="0">
	  <tbody>
		<tr>
		  <th class="style_th">id</th>		<td class="style_td2">{$row['id']}</td>
		  <input type="hidden" name="id" value="{$row['id']}">
		</tr><tr>
		<tr>
		  <th class="style_th">お名前(*)</th>		<td class="style_td2">{$row['name']}</td>
		  <input type="hidden" name="name" value="{$row['name']}">
		</tr><tr>
		  <th class="style_th">会社名/所属(*)</th>	<td class="style_td2">{$row['belong']}</td>
		  <input type="hidden" name="belong" value="{$row['belong']}">
		</tr><tr>
		  <th class="style_th">URL(blog等)</th>		<td class="style_td2">{$row['url']}</td>
		  <input type="hidden" name="url" value="{$row['url']}">
		</tr>
		<tr>
		  <th class="style_th">メールアドレス(*)</th>	<td class="style_td2">{$row['address']}</td>
		  <input type="hidden" name="address" value="{$row['address']}">
		  <input type="hidden" name="ackey" value="{$row['ackey']}">
		</tr>
		<tr>
		  <th class="style_th">お電話番号(*)</th>	<td class="style_td2">{$row['phone']}</td>
		  <input type="hidden" name="phone" value="{$row['phone']}">
		</tr>
		<tr>
		  <th class="style_th">ご質問内容</th>		<td class="style_td2">{$row['msg']}</td>
		  <input type="hidden" name="msg" value="{$row['msg']}">
		%s

		<tr bgcolor="#ff66cc">
		  <th class="style_th">ご確認ください</th>
		    <td class="style_td2">
			<input type="radio" name="confirm" value="1" id="comfirm" {$confirm_check[1]}>
		    登録確定<br />
			<input type="radio" name="confirm" value="0" id="comfirm" {$confirm_check[0]}>
		    登録解除<br />
		    </td></tr>
	  </tbody>
		<tr>
		  <th class="style_th" />
		  <td class="style_td2" style="text-align: center">$button</td>
		</tr>
	</table>
	</form>
<br />
<pre>
{$GLOBALS['shitsumon']}
------------------
{$GLOBALS['jimukyoku']}
{$GLOBALS['url']}
{$GLOBALS['mailfrom']}
</pre>
__EOD__;

  // 登録者サマリー表
  //$string .= plugin_contactform4_summary();

  $string .= "</div>";

  // 電話連絡確認にチェックボックスの挿入
  $string = sprintf($string, $callable_html);

  return $string;
}


//
// プラグイン・登録フォーム
//
function _plugin_contactform4_form($value, $error = array())
{
  global $_btn_registersend,$vars,$digest;
  if (UA_PROFILE == 'keitai') {
    $errmsg = '<p>現在携帯電話端末からのお申し込みは受け付けられません。 PC サイトからのお申し込みをお待ちしております。</p>';
    return $errmsg;
  }

  if ( isset($vars['fromkey']) ) {
    // 確認フォーム
    return _plugin_contactform4_confirm($vars);
  }

  foreach ($value as $k => $v) {
    $value[$k] = htmlspecialchars($v);
  }
  if ($value['fromcallable'] == "1") {
    $value['fromcallable_check'] = "checked";
  }
  if ($value['fromnews'] == "1") {
    $value['fromnews_check'] = "checked";
  }


  $string = "<div id='contactform4'>";

  if ($error) {
    $string .= "<ul class='arrowhead'>";
    foreach ($error as $errmsg) {
      $string .= "<li>$errmsg</li>";
    }
    $string .= "</ul>";
  }

  $button = "<input type=\"button\" name=\"contactform4\" value=\"$_btn_registersend\" onclick=\"contactform4_submit()\">\n";

  $now = date("Y-m-d G:i:s");	//'CURRENT_TIMESTAMP'
  $string .= "<form action=\"$script\" method=\"post\">\n"
		 ."<input type=\"hidden\" name=\"refer\" value=\"{$vars['page']}\">\n"
		 ."<input type=\"hidden\" name=\"page\" value=\"{$vars['page']}\">\n"
		 ."<input type=\"hidden\" name=\"serial\" value=\"{$GLOBALS['serial']}\" id=\"serial\">\n"
		 ."<input type=\"hidden\" name=\"now\" value=\"{$now}\">\n"

		 ."<input type=\"hidden\" name=\"digest\" value=\"$digest\">\n"
		 ."<input type=\"hidden\" name=\"plugin\" value=\"contactform4\">\n"
		 ."<input type=\"hidden\" name=\"pcmd\" value=\"send\">\n";

  if ($GLOBALS['callable']) {
    $callable_js = "query_string += \"&fromcallable=\" + ($('fromcallable').checked ? \"1\" : \"\");\n";

    $callable_html = <<<__EOD__
			<tr>
				<th class="style_th">電話連絡希望</th>
				<td class="style_td2"><input type="checkbox" name="fromcallable" style="" {$value['fromcallable_check']} value="1" id="fromcallable">
{$GLOBALS['callinfo']}{$GLOBALS['callwarn']}</td></tr>
			</tr>
__EOD__;
  } else {	// $GLOBALS['callable']: false
    $callable_js = "query_string += \"&fromcallable=\" + \"0\";";
    $callable_html = 
      "<input type=\"hidden\" name=\"fromcallable\" value=\"0\">\n";
  }

  if ($GLOBALS['news']) {
    $news_js =  <<<__EOD__
		query_string += "&fromnews=" + escape($('fromnews').checked ? "1" : "");
__EOD__;

    $news_html = <<<__EOD__
			<tr>
				<th class="style_th">お知らせの配信</th>
				<td class="style_td2"><input type="checkbox" name="fromnews" style="" {$value['fromnews_check']} value="1" id="fromnews">{$GLOBALS['optinquery']}</td>
			</tr>
__EOD__;
  } else {	// $GLOBALS['news']: false
    $news_js = "query_string += \"&fromnews=\" + \"0\";";
    $news_html = 
      "<input type=\"hidden\" name=\"fromnews\" value=\"0\">\n";
  }


  $indexpage = get_script_uri().'?'.$vars['page'];

  // post request with Ajax.Updater(prototype.js)
  $string .= <<<__EOD__
	<script type="text/javascript">
	<!--
	// <![CDATA[
	function contactform4_submit()
	{
		var query_string = "";

		if(window.location.search){
			var q=window.location.search.substring(1,window.location.search.length);
			var p = q.split('&');
			if (p[0])
				query_string = "page="+p[0];
		}
		if (! query_string)
		  query_string = "page={$vars['page']}";

		query_string += "&plugin=contactform4";
		query_string += "&fromname=" + escape($('fromname').value);
		query_string += "&frombelong=" + escape($('frombelong').value);
		query_string += "&fromurl=" + escape($('fromurl').value);
		query_string += "&fromaddress=" + escape($('fromaddress').value);
		query_string += "&fromphone=" + escape($('fromphone').value);
		%s
		query_string += "&frommsg=" + escape($('frommsg').value);
		%s
		query_string += "&serial=" + escape($('serial').value);
		query_string += "&now={$now}";

		ajax = new Ajax.Updater(
			'contactform4',
			'{$indexpage}',
			{
				'method': 'post',
				'parameters': query_string
	                });
	}
	// ]]>
	-->
	</script>
	    <div class="style_blockquote">
		 <table border="0">
		 	<tbody>
			<tr>
				<th class="style_th">お名前(*)</th>
				<td class="style_td2"><input type="text" name="fromname" style="width: 384px;" value="{$value['fromname']}" id="fromname"></td>
			</tr>
			<tr>
				<th class="style_th">会社名/所属(*)</th>
				<td class="style_td2"><input type="text" name="frombelong" style="width: 384px;" value="{$value['frombelong']}" id="frombelong"></td>
			</tr>
			<tr>
				<th class="style_th">URL(blog等)</th>
				<td class="style_td2"><input type="text" name="fromurl" style="width: 384px;" value="{$value['fromurl']}" id="fromurl"></td>
			</tr>
		 	<tr>
				<th class="style_th">メールアドレス(*)</th>
				<td class="style_td2"><input type="text" name="fromaddress" style="width: 384px;" value="{$value['fromaddress']}" id="fromaddress"></td>
			</tr>
		 	<tr>
				<th class="style_th">お電話番号(*)</th>
				<td class="style_td2"><input type="text" name="fromphone" style="width: 384px;" value="{$value['fromphone']}" id="fromphone"></td>
			</tr>
			%s
			<tr>
				<th class="style_th">ご質問内容<br /></th>
				<td class="style_td2"><textarea style="width: 384px; height: 80px;" name="frommsg" id="frommsg">{$value['frommsg']}</textarea></td>
			</tr>
			%s

			</tbody>
			<tr>
				<th class="style_th" />
				<td class="style_td2" style="text-align: center">$button</td>
			</tr>
		  </table>
	    </div>
	 </form>
<br />
__EOD__;

  if ($GLOBALS['active']) {
    $string .= "※ここで送信ボタンを押すと仮登録され、登録されたアドレス宛にメールが返送されます。お手数ですが、返信メールに書かれているURLにアクセスをし、登録を完了してください。<br />";
  }

  // 登録者サマリー
  $string .= plugin_contactform4_summary();

  $string .= "</div>";

  // 電話連絡確認に関する挿入
  $string = sprintf($string, $callable_js, $news_js, $callable_html, $news_html);

  return $string;
}

//
// URL Encodedから、指定の文字エンコーディングへ変換 
//
function uniDecode($str, $charcode = 'EUC-JP')
{
	$text = preg_replace_callback("/%u[0-9A-Za-z]{4}/", "toUtf8", $str); 
	if ($charcode == 'UTF-8') {
	  return $text;
	} else {
	  return mb_convert_encoding($text, $charcode, 'utf-8');
	}
}

//
// URL Encodedから、utf-8へ変換 
//
function toUtf8($ar)
{
	foreach($ar as $val)
	{
		$val = intval(substr($val,2),16); 
		if ($val < 0x7F) {
			$c .= chr($val); 
		} elseif ($val < 0x800) {
			$c .= chr(0xC0 | ($val / 64)); 
			$c .= chr(0x80 | ($val % 64)); 
		} else {
			$c .= chr(0xE0 | (($val / 64) / 64)); 
			$c .= chr(0x80 | (($val / 64) % 64)); 
			$c .= chr(0x80 | ($val % 64)); 
		}
	} 
	return $c; 
}

//
// DB接続
//
function plugin_contactform4_conn()
{
    global $dbms;

    //$GLOBALS['dsn'] = "mysql://user:passwd@hostname/dbname";
    $dsn = explode('/', $GLOBALS['dsn']);
    $dbms = substr($dsn[0], 0, strpos($dsn[0], ':'));
    $param = explode('@', $dsn[2]);
    $hostname = $param[1];
    $account = explode(':', $param[0]);
    $user = $account[0];
    $passw = $account[1];
    $dbname = $dsn[3];

    //echo "{$dbms}://{$user}:{$passw}@{$hostname}/$dbname";

    // 接続
    if ( $dbms == "sqlite" ) {
	array_shift($dsn);
	$path = "/".implode('/', $dsn);
	$dbh = sqlite_open($path);
	if (!$dbh) {
	    echo "DBError#0 \n";
	    echo 'Could not open sqlite file';
	    return false;
	}
    } else {
	$dbh = mysql_connect($hostname, $user, $passw);
	if (!$dbh) {
	    echo "DBError#0 \n";
	    echo 'Could not connect to mysqlserver';
	    return false;
	}
	if (!mysql_select_db($dbname, $dbh)) {
	    echo "DBError#1 \n";
	    echo 'Could not select database';
	    $dbh = false;
	    return false;
	}
    }
    return $dbh;
}


//
// テーブル作成
//
function plugin_contactform4_create($dbh)
{
  global $dbms;
  // テーブルの定義

  $INCLTYPE = "SERIAL";
  $STMPTYPE = "TIMESTAMP";
  $DFLTTRUE = "DEFAULT true";
  $DFLTFALSE = "DEFAULT false";
  $KEYS = "";
  if ($dbms == "sqlite") {
      $INCLTYPE = "INTEGER PRIMARY KEY";
      $STMPTYPE = "DATETIME";
  } elseif ($dbms == "mysql") {
      if (extension_loaded('mysql')) {
	  $INCLTYPE = "INT(11) NOT NULL AUTO_INCREMENT";
	  $STMPTYPE = "DATETIME";
	  $DFLTTRUE = "DEFAULT 'true'";
	  $DFLTFALSE = "DEFAULT 'false'";
	  $KEYS = ",KEY `id` (`id`)";
      }
  }

  $query = <<<_EOQ_
      CREATE TABLE {$GLOBALS['table']}
	       (
		id {$INCLTYPE},
		address VARCHAR(128)  NOT NULL,
		phone VARCHAR(32) NOT NULL,
		name VARCHAR(64) NOT NULL,
		belong VARCHAR(128),
		url VARCHAR(128),
		callable bool NOT NULL {$DFLTTRUE},
		msg VARCHAR(256),
		news bool NOT NULL {$DFLTFALSE},
		ackey VARCHAR(32) NOT NULL,
		confirm BOOL {$DFLTFALSE},
		browser VARCHAR(256),
		remoteip VARCHAR(16),
		timestamp {$STMPTYPE}
	       {$KEYS}
		);
_EOQ_;

  // テーブルの作成
  $result = mysql_query($query, $dbh);
  if (!$result) {
    echo "DBError#2 (create)\n";
    echo 'SQL Error: ' . mysql_error();
    return false;
  }
  return true;
}

//
// 登録
//
function plugin_contactform4_insert($dbh, $post)
{
  global $dbms;

  if ($dbms == "sqlite") {
      $t_val = "'true'";
      $f_val = "'false'";
  } else {
      $t_val = 1;
      $f_val = 0;
  }

  foreach ($post as $k => $v) {
    if ( strtoupper(mb_detect_encoding($v)) != DB_ENCODING ) {
      $row[$k] = strip_tags(mb_convert_encoding($v, DB_ENCODING, 'auto'));
    } else {
      $row[$k] = strip_tags($v);
    }
  }

  // 値のバインド
  $name =      mysql_escape_string($row['fromname']);
  $belong =    mysql_escape_string($row['frombelong']);
  $url =       mysql_escape_string($row['fromurl']);
  $address =   mysql_escape_string($row['fromaddress']);
  $phone =     mysql_escape_string($row['fromphone']);
  $callable =  ($row['fromcallable'])?"$t_val":"$f_val";
  $msg =       mysql_escape_string($row['frommsg']);
  $news =      ($row['fromnews'])?"$t_val":"$f_val";
  $accesskey = md5($post['fromaddress'].$post['fromname'].$post['now']);
  $ackey =     $accesskey;
  $useragent = strip_tags(substr(getenv('HTTP_USER_AGENT'), 0, 255));
  $confirm   = 'null';
  $browser =   mysql_escape_string($useragent);
  $remoteip =  mysql_escape_string($_SERVER['REMOTE_ADDR']);
  $timestamp = mysql_escape_string($post['now']);

  $query = "INSERT INTO {$GLOBALS['table']} ("
    ." address, phone, name, belong, url, callable, msg, news"
    .", ackey, confirm, browser, remoteip, timestamp"
    ." ) VALUES ("
    ." '$address', '$phone', '$name', '$belong', '$url', $callable, '$msg', $news"
    .", '$ackey', $confirm, '$browser', '$remoteip', '$timestamp'"
    .")";

  // クエリを実行
  $result = mysql_query($query, $dbh);
  if (!$result) {
    echo "DBError#3 (insert)\n";
    echo 'SQL Error: ' . mysql_error();
    return false;
  }
  return true;
}

//
// 更新
//
function plugin_contactform4_update($dbh, $post)
{
  global $dbms;

  if ($dbms == "sqlite") {
      $t_val = "'true'";
      $f_val = "'false'";
  } else {
      $t_val = 1;
      $f_val = 0;
  }

  foreach ($post as $k => $v) {
    if ( strtoupper(mb_detect_encoding($v)) != DB_ENCODING ) {
      $row[$k] = strip_tags(mb_convert_encoding($v, DB_ENCODING, 'auto'));
    } else {
      $row[$k] = strip_tags($v);
    }
  }

  // 値のバインド
  //$name=      mysql_escape_string($post['name']);
  //$belong =   mysql_escape_string($post['belong']);
  //$url =      mysql_escape_string($post['url']);
  //$phone =    mysql_escape_string($post['phone']);
  //$callable = ($post['callable'] == 't')?"$t_val":"$f_val";
  //$msg =      mysql_escape_string($post['msg']);
  //$news =     ($post['news'] == 't')?"$t_val":"$f_val";
  $confirm =  ($post['confirm'])?"$t_val":"$f_val";
  $now = date("Y-m-d G:i:s");	//'CURRENT_TIMESTAMP'
  $timestamp = $now;
  // 条件
  $address =  mysql_escape_string($post['address']);
  $ackey =    mysql_escape_string($post['ackey']);

  // プレースホルダの用意
  $query = "UPDATE {$GLOBALS['table']} SET "
      /*
    ." name = '$name', belong = '$belong', url = '$url', phone = '$phone',"
    ." callable = $callable, msg = '$msg', news = $news, "
       */
    ." confirm = $confirm, timestamp = '$timestamp'"
    ." WHERE address = '$address' AND ackey = '$ackey'";

  // クエリを実行
  $result = mysql_query($query, $dbh);
  if (!$result) {
    echo "DBError#4 (update)\n";
    echo 'SQL Error: ' . mysql_error();
    return false;
  }
  return true;
}

//
// 登録者リスト
//
function plugin_contactform4_list($dbh, $fix = 1, $admin=0, $nlrow=3)
{
  if (!$dbh) {
    return;
  }

  // クエリのステートメントを準備
  $tbl = "<div id=\"list\">\n";
  $query = "SELECT * FROM {$GLOBALS['table']}";

  if ($GLOBALS['active']) {
    if ( $fix == 1 ) {
      $query .= " WHERE confirm = 1";
    }
  }

  // 実行
  $result = mysql_query($query, $dbh);
  if (!$result) {
    $error[]= "DBError#5 (select)\n";
    $error[]= 'SQL Error: ' . mysql_error();
    return;
  }
  if (mysql_num_rows($result) == 0) {
    $error[]= "DBError#5 (select)\n";
    $error[]= "No rows found, nothing to print so am exiting";
    return;
  }

    // リストヘッダ
    if ($nlrow == 1) {
      $tbl .= "  <table border=\"0\">\n    <tbody>\n";
      $tbl .= "    <tr>";
      $tbl .= "<th class=\"style_th\">＃</th>";
      $tbl .= "<th class=\"style_th\">E-メール</th>";
      $tbl .= "<th class=\"style_th\">お名前</th>";
      $tbl .= "<th class=\"style_th\">ご所属</th>";
      $tbl .= "<th class=\"style_th\">URL</th>";
      if ($GLOBALS['callable']) {
	$tbl .= "<th class=\"style_th\">電話連絡</th>";
      }
      $tbl .= "<th class=\"style_th\">その他</th>";
      if ($GLOBALS['news']) {
	$tbl .= "<th class=\"style_th\">配信</th>";
      }
      if ($admin) {
	$tbl .= "<th class=\"style_th\">確認</th>";
      }
      $tbl .= "    </tr>\n";
    } elseif ($nlrow == 3) {

      $la_confirm = ($admin)?"(未)":"";
      $la_callable = ($GLOBALS['callable'])?"電話連絡":"--";
      $la_news = ($GLOBALS['news'])?"配信許諾":"--";

      $tbl .= <<<_EOR_
<style type="text/css">
<!--
#list_master {
	border-top-width: 2px;
	border-right-width: 2px;
	border-left-width: 2px;
	border-top-style: solid;
	border-right-style: solid;
	border-bottom-style: solid;
	border-left-style: solid;
#	border-top-color: #990000;
#	border-right-color: #990000;
#	border-left-color: #990000;
#	border-bottom-color: #990000;
	border-bottom-width: 1px;
#	width: 550px;
}
#list_master td {
	padding: 5px;
	margin: 0px;
	border-bottom-width: 1px;
	border-bottom-style: solid;
#	border-bottom-color: #990000;
	border-right-width: 1px;
	border-right-style: solid;
#	border-right-color: #990000;
}
#list_master .name {
	width: 150px;
}
#list_master .num {
	width: 30px;
	border-bottom-width: 2px;
	border-bottom-style: solid;
	text-align: center;
}
#list_master .comment {
	border-bottom-width: 2px;
	border-bottom-style: solid;
}
#list_master .haishin {
	width: 30px;
	text-align: center;
}
#list_master .konshinkai {
	width: 30px;
	text-align: center;
}
-->
</style>

<table border="0" cellpadding="0" cellspacing="0" id="list_master">
  <tr>
    <td rowspan="3" class="num">No<br />{$la_confirm}</td>
	<td class="name">お名前</td>
	<td class="konshinkai">{$la_callable}</td>
	<td class="email">E-メール</td>
	<td class="haishin">{$la_news}</td>
  </tr>
  <tr>	<td colspan="2" class="position">ご所属</td>
  	<td colspan="2" class="uri">URL</td></tr>
  <tr>
	<td colspan="4" class="comment">お問い合わせ内容</td>
  </tr>
_EOR_;
    } else {
      // default
      $tbl .= "<table border=\"1\" width=\"550px\">\n    <tbody>\n";
      $tbl .= "<tr><td width=\"170px\"><table border=\"0\" cellpadding=\"0\" cellspacing=\"0\">\n";
      $tbl .= "    <tr>";
      $tbl .= "<th align=\"left\">＃</th>";
      $tbl .= "    </tr>\n";
      $tbl .= "    <tr>";
      $tbl .= "<th >お名前</th>";
      $tbl .= "    </tr>\n";
      $tbl .= "    <tr>";
      $tbl .= "<td align=\"right\">".($GLOBALS['callable']?"電話連絡":"")."</td>";
      $tbl .= "    </tr></table>\n";
      $tbl .= "</td><td><table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"380px\">\n";
      $tbl .= "    <tr>";
      $tbl .= "<th align=\"left\">E-メール</th>";
      $tbl .= "<th >ご所属</th>";
      $tbl .= "<th align=\"right\">".($GLOBALS['news']?"配信許諾":"")."</th>";
      if ($admin) {
	$tbl .= "<th >確認</th>";
      }
      $tbl .= "    </tr>\n";
      $tbl .= "    <tr>";
      $tbl .= "<th colspan=\"4\" align=\"left\">あればURL</th>";
      $tbl .= "    </tr>\n";
      $tbl .= "    <tr>";
      $tbl .= "<th colspan=\"4\" align=\"left\">あればコメント</th>";
      $tbl .= "    </tr>\n";
      $tbl .= "</table></td></tr>\n";
    }

    // リスト出力
    $cols = array();
    $nl = 0;
  while ($cols = mysql_fetch_assoc($result)) { 
      foreach ($cols as $k => $v) {
        if ( strtoupper(mb_detect_encoding($v)) != OUTPUT_ENCODING ) {
	  $cols[$k] =  mb_convert_encoding($v, OUTPUT_ENCODING, 'auto');
        }
        // タグが混じってしまった場合の対策
        $cols[$k] = str_replace(array("<",">"), "", strip_tags($cols[$k]));
      }

      $id = "{$cols['id']}";
      $adduser = substr($cols['address'], 0, strpos($cols['address'],'@'));
      if ($admin) {
	//$confirm = ($cols['confirm']?"":"未");
	if ($cols['confirm'] === "1") {
	  $confirm = "";
	} elseif ($cols['confirm'] === "0") {
	  $confirm = "取消";
	} else {
	  $confirm = "未";
	}
	if (!empty($confirm)) {
	  $id = "({$cols['id']})";
	}
      }

      if ($GLOBALS['callable']) {
	$callable = ($cols['callable']?"希望":"×");
      } else {
	$callable = "";
      }

      if ($GLOBALS['news']) {
	$news = ($cols['news']?"配信":"×");
      } else {
	$news = "";
      }

      //"style=\"background-color: ".{($nl%2)?"lightyellow":"seashell"}."\""
      if ($nlrow == 1) {
	$tbl .= "    <tr bgcolor=\"".(($nl % 2)?"#ffffe0":"#fff5ee")."\">";
	$tbl .= "<td class=\"style_td2\">{$id}</td>";
	$tbl .= "<td class=\"style_td2\">{$adduser}</td>";
	$tbl .= "<td class=\"style_td2\">{$cols['name']}</td>";
	$tbl .= "<td class=\"style_td2\">{$cols['belong']}</td>";
	$tbl .= "<td class=\"style_td2\">{$cols['url']}</td>";
	if ($GLOBALS['callable']) {
	  $tbl .= "<td align=\"center\">".($cols['callable']?"希望":"×")."</td>";
	}
	$tbl .= "<td class=\"style_td2\">{$cols['msg']}</td>";
	if ($GLOBALS['callable']) {
	  $tbl .= "<td class=\"style_td2\">".($cols['news']?"配信":"×")."</td>";
	}
	if ($admin) {
	  $tbl .= "<td class=\"style_td2\">{$cols['confirm']}</td>";
	}
	$tbl .= "    </tr>\n";
    } elseif ($nlrow == 3) {
	$tbl .= <<<__EOR__
<tr>
    <td rowspan="3" class="num">{$id}<br />{$confirm}</td>
	<td class="name">{$cols['name']} 様</td>
	<td class="konshinkai">{$callable}</td>
	<td class="email">{$adduser}</td>
	<td class="haishin">{$news}</td>
</tr>
<tr>	<td colspan="2" class="position">{$cols['belong']}</td>
	<td colspan="2" class="uri">{$cols['url']}</tr>
<tr>
	<td colspan="4" class="comment">{$cols['msg']}</td>
</tr>
__EOR__;
      } else {
	// default
	if ($cols['confirm'] != 1) {
	  $bgc = ($nl % 2)?"#777760":"#777566";
	} else {
	  $bgc = ($nl % 2)?"#ffffe0":"#fff0ee";
	}
	$tbl .= "<tr bgcolor=\"{$bgc}\"><td bgcolor=\"{$bgc}\" width=\"170px\"><table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" bgcolor=\"{$bgc}\" width=\"170px\">\n";

	$tbl .= "    <tr bgcolor=\"{$bgc}\">";
	$tbl .= "<td align=\"left\" bgcolor=\"{$bgc}\">{$cols['id']}</td>";
	$tbl .= "    </tr>\n";
	$tbl .= "    <tr>";
	$tbl .= "<td >{$cols['name']} 様</td>";
	$tbl .= "    </tr>\n";
	$tbl .= "    <tr>";
	$tbl .= "<td align=\"right\">".($GLOBALS['callable']?$callable:"")."</td>";
	$tbl .= "    </tr></table>\n";
	$tbl .= "</td><td><table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"380px\">\n";
	$tbl .= "    <tr>";
	$tbl .= "<td align=\"left\">{$adduser}</td>";
	$tbl .= "<td >{$cols['belong']}</td>";
	$tbl .= "<td align=\"right\">".($GLOBALS['news']?$news:"")."</td>";
	if ($admin) {
	  $tbl .= "<td >{$cols['confirm']}</td>";
	}
	$tbl .= "    </tr><tr>\n";
	$tbl .= "<td colspan=\"4\" >{$cols['url']}</td>";
	$tbl .= "    </tr><tr>\n";
	$tbl .= "<td colspan=\"4\" >{$cols['msg']}</td>";
	$tbl .= "    </tr>\n";
	$tbl .= "</table></td></tr>\n";
      }
      $nl++;
  } 

    $tbl .= "    </tbody>  </table>\n";
    $tbl .= "</div>\n";

  // 検索結果を開放
  mysql_free_result($result);

  return $tbl;
}

//
// 登録者数
//
function plugin_contactform4_count($dbh)
{
  $query = "SELECT count(*) FROM {$GLOBALS['table']}";
  if ($GLOBALS['active']) {
    $query .= " WHERE confirm = 1";
  }

  if (! $result = $mysql_query($query, $dbh) ) {
    if (! plugin_contactform4_create($dbh) ) {
      echo "DBError@_count!\n";
      return false;
    }
    if (! $result = $mysql_query($query, $dbh) ) {
      echo "SQLError@_count!\n";
      echo " ($query)\n";
      return false;
    }
  }
  if (mysql_num_rows($result) == 0) {
      return 0;
  }
  $ret = mysql_fetch_row($result);
  return $ret[0];
}

//
// 電話連絡希望者数
//
function plugin_contactform4_countcallable($dbh)
{
  $query = "SELECT count(callable) FROM {$GLOBALS['table']} WHERE callable = 1";
  if ($GLOBALS['active']) {
    $query .= " AND confirm = 1";
  }
  if (! $result = $mysql_query($query, $dbh) ) {
    if (! plugin_contactform4_create($dbh) ) {
      echo "DBError@_countcallable!\n";
      return false;
    }
    if (! $result = $mysql_query($query, $dbh) ) {
      echo "SQLError@_countcallable!\n";
      echo " ($query)\n";
      return false;
    }
  }
  if (! $sth->execute() ) {
    echo "QUELError@_countcallable!\n";
    print_r($sth->errorInfo());
    return false;
  }
  if (mysql_num_rows($result) == 0) {
      return 0;
  }
  $ret = mysql_fetch_row($result);
  return $ret[0];
}

//
// データベースへのエントリ登録
//
function plugin_contactform4_preentry($post)
{
  // DB接続
  if (! $dbh = plugin_contactform4_conn() ) {
    return false;
  }

  //// テーブル作成＝＞自動化（各所でエラー処理として行う）
  //if (! TABLE_CREATED ) {
  //  if (! plugin_contactform4_create($dbh) ) {
  //    return false;
  //  }
  //}
 
  // 登録
  if (! plugin_contactform4_insert($dbh, $post) ) {
    if (! plugin_contactform4_create($dbh) ) {
      return false;
    }
    if (! plugin_contactform4_insert($dbh, $post) ) {
      return false;
    }
  }

  //// リスト
  //$tbl = plugin_contactform4_list($dbh);

  return true;
}

//
// データベースへのエントリ更新
//
function plugin_contactform4_fixentry()
{
  global $post;
	
  // DB接続
  if (! $dbh = plugin_contactform4_conn() ) {
    return false;
  }

  //// テーブル作成＝＞自動化（各所でエラー処理として行う）
  //if (! TABLE_CREATED ) {
  //  if (! plugin_contactform4_create($dbh) ) {
  //    return false;
  //  }
  //}
 
  // 登録
  if (! plugin_contactform4_update($dbh, $post) ) {
    return false;
  }

  // リスト
  if ( $tbl = plugin_contactform4_summary($dbh) ) {
    return $tbl;
  }
}

//
// 質問登録者サマリー
//
function plugin_contactform4_summary($dbh='')
{

  if (empty($dbh)) {
    // 登録者DBアクセス
    if (!  $dbh = plugin_contactform4_conn() ) {
      return "DB接続エラー！";
    }
  }

  // 登録者数集計
  $now = date("Y-m-d G:i");
  $string .= "<br />{$now} 現在";
//  $nentry = plugin_contactform4_count($dbh);
//  $string .= "&nbsp;&nbsp;&nbsp;質問者数: {$nentry}名";
//  if ($GLOBALS['callable']) {
//    $nbanqu = plugin_contactform4_countcallable($dbh);
//    $string .= "&nbsp;&nbsp;&nbsp;電話連絡希望: {$nbanqu}名";
//  }

  if ($GLOBALS['admin']) {
    // 現行リスト
    $string .= plugin_contactform4_list($dbh, 0, 1);
  } else {
    if ($GLOBALS['sns']) {
      if ($GLOBALS['active']) {
	$string .= "<br />ここには、登録が確定されたエントリのみリストされています。" ;
      }
      $string .= plugin_contactform4_list($dbh, 1);
    }
  }

  return $string;
}

//
// 登録者検索
//
function plugin_contactform4_search($addr, $key)
{
  // 登録者DBアクセス
  if (!  $dbh = plugin_contactform4_conn() ) {
    echo "接続エラー@_search！";
    return false;
  }

  $query = "SELECT * FROM {$GLOBALS['table']}"
  	   . " WHERE address = '$addr' AND ackey = '$key'";

  $result = mysql_query($query, $dbh);
  if (!$result) {
    echo "DBError@_search!";
    echo " ($query)\n";
    return false;
  }
  $row = mysql_fetch_assoc($result);

  foreach ($row as $k => $v) {
      //if ( strtoupper(mb_detect_encoding($v)) == DB_ENCODING ) {
      $row[$k] = mb_convert_encoding($v, OUTPUT_ENCODING, DB_ENCODING);
      //}
  }

  return $row;
}

?>
