/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jnlp;

import com.sun.deploy.cache.LocalApplicationProperties;
import com.sun.deploy.config.Config;
import com.sun.deploy.config.JREInfo;
import com.sun.deploy.util.Trace;
import com.sun.deploy.util.TraceLevel;
import com.sun.javaws.Main;
import com.sun.javaws.exceptions.ExitException;
import com.sun.javaws.jnl.LaunchSelection;
import com.sun.javaws.progress.ProgressListener;
import com.sun.javaws.ui.LaunchErrorDialog;
import com.sun.jnlp.JNLPClassLoaderUtil;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Date;
import javax.jnlp.ExtensionInstallerService;

public final class ExtensionInstallerServiceImpl
implements ExtensionInstallerService {
    private LocalApplicationProperties _lap;
    private ProgressListener _progress;
    private String _target;
    private String _installPath;
    private boolean _failedJREInstall = false;
    static ExtensionInstallerServiceImpl _sharedInstance = null;

    private ExtensionInstallerServiceImpl(String string, LocalApplicationProperties localApplicationProperties, ProgressListener progressListener) {
        this._lap = localApplicationProperties;
        this._progress = progressListener;
        this._installPath = string;
    }

    public static synchronized ExtensionInstallerServiceImpl getInstance() {
        return _sharedInstance;
    }

    public static synchronized void initialize(String string, LocalApplicationProperties localApplicationProperties, ProgressListener progressListener) {
        if (_sharedInstance == null) {
            _sharedInstance = new ExtensionInstallerServiceImpl(string, localApplicationProperties, progressListener);
        }
    }

    public String getInstallPath() {
        return this._installPath;
    }

    public String getExtensionVersion() {
        return this._lap.getVersionId();
    }

    public URL getExtensionLocation() {
        return this._lap.getLocation();
    }

    public String getInstalledJRE(URL uRL, String string) {
        JREInfo jREInfo = LaunchSelection.selectJRE(uRL, string);
        return jREInfo != null ? jREInfo.getPath() : null;
    }

    public void setHeading(String string) {
        this._progress.setHeading(string, true);
    }

    public void setStatus(String string) {
        this._progress.setStatus(string);
    }

    public void updateProgress(int n) {
        this._progress.setProgressBarValue(n);
    }

    public void hideProgressBar() {
        this._progress.setProgressBarVisible(false);
    }

    public void hideStatusWindow() {
        this._progress.setVisible(false);
    }

    public void setJREInfo(String string, String string2) {
        int n = JNLPClassLoaderUtil.getInstance().getDefaultSecurityModel();
        if (n != 1 && n != 2) {
            throw new SecurityException("Unsigned extension installer attempting to call setJREInfo.");
        }
        Trace.println((String)("setJREInfo: " + string2), (TraceLevel)TraceLevel.EXTENSIONS);
        if (string2 != null && new File(string2).exists()) {
            JREInfo.removeJREsIn((String)string2);
            JREInfo.addJRE((JREInfo)new JREInfo(string, this.getExtensionVersion(), this.getExtensionLocation().toString(), string2, null, Config.getOSName(), Config.getOSArch(), true, false));
        } else {
            Trace.println((String)"jre install failed: jrePath invalid", (TraceLevel)TraceLevel.EXTENSIONS);
            this._failedJREInstall = true;
        }
    }

    public void setNativeLibraryInfo(String string) {
        Trace.println((String)("setNativeLibInfo: " + string), (TraceLevel)TraceLevel.EXTENSIONS);
        this._lap.setNativeLibDirectory(string);
    }

    public void installFailed() {
        Trace.println((String)"installFailed", (TraceLevel)TraceLevel.EXTENSIONS);
        try {
            Main.systemExit(1);
        }
        catch (ExitException exitException) {
            Trace.println((String)("systemExit: " + exitException), (TraceLevel)TraceLevel.BASIC);
            Trace.ignoredException((Exception)exitException);
        }
    }

    public void installSucceeded(boolean bl) {
        if (this._failedJREInstall) {
            return;
        }
        Trace.println((String)"installSucceded", (TraceLevel)TraceLevel.EXTENSIONS);
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Config.store();
                return null;
            }
        });
        this._lap.setInstallDirectory(this._installPath);
        this._lap.setLastAccessed(new Date());
        if (bl) {
            this._lap.setRebootNeeded(true);
        } else {
            this._lap.setLocallyInstalled(true);
        }
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    ExtensionInstallerServiceImpl.this._lap.store();
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            if (privilegedActionException.getException() instanceof IOException) {
                LaunchErrorDialog.show(this._progress.getOwner(), (IOException)privilegedActionException.getException(), false);
            }
            Trace.ignoredException((Exception)privilegedActionException.getException());
        }
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    Main.systemExit(0);
                }
                catch (ExitException exitException) {
                    Trace.println((String)("systemExit: " + exitException), (TraceLevel)TraceLevel.BASIC);
                    Trace.ignoredException((Exception)exitException);
                }
                return null;
            }
        });
    }
}

