/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.rio.turtle;

import info.aduna.text.ASCIIUtil;
import info.aduna.text.StringUtil;

public class TurtleUtil {
    public static int findURISplitIndex(String uri) {
        int idx;
        int uriLength = uri.length();
        for (idx = uriLength - 1; idx >= 0 && TurtleUtil.isNameChar(uri.charAt(idx)); --idx) {
        }
        ++idx;
        while (idx < uriLength && !TurtleUtil.isNameStartChar(uri.charAt(idx))) {
            ++idx;
        }
        if (idx > 0 && idx < uriLength) {
            return idx;
        }
        return -1;
    }

    public static boolean isWhitespace(int c) {
        return c == 32 || c == 9 || c == 10 || c == 13;
    }

    public static boolean isPrefixStartChar(int c) {
        return ASCIIUtil.isLetter(c) || c >= 192 && c <= 214 || c >= 216 && c <= 246 || c >= 248 && c <= 767 || c >= 880 && c <= 893 || c >= 895 && c <= 8191 || c >= 8204 && c <= 8205 || c >= 8304 && c <= 8591 || c >= 11264 && c <= 12271 || c >= 12289 && c <= 55295 || c >= 63744 && c <= 64975 || c >= 65008 && c <= 65533 || c >= 65536 && c <= 983039;
    }

    public static boolean isNameStartChar(int c) {
        return c == 95 || TurtleUtil.isPrefixStartChar(c);
    }

    public static boolean isNameChar(int c) {
        return TurtleUtil.isNameStartChar(c) || ASCIIUtil.isNumber(c) || c == 45 || c == 183 || c >= 768 && c <= 879 || c >= 8255 && c <= 8256;
    }

    public static boolean isPrefixChar(int c) {
        return TurtleUtil.isNameChar(c);
    }

    public static boolean isLanguageStartChar(int c) {
        return ASCIIUtil.isLetter(c);
    }

    public static boolean isLanguageChar(int c) {
        return ASCIIUtil.isLetter(c) || ASCIIUtil.isNumber(c) || c == 45;
    }

    public static boolean isLegalPrefix(String prefix) {
        if (prefix.length() == 0) {
            return false;
        }
        if (!TurtleUtil.isPrefixStartChar(prefix.charAt(0))) {
            return false;
        }
        for (int i = 1; i < prefix.length(); ++i) {
            if (TurtleUtil.isPrefixChar(prefix.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isLegalName(String name) {
        if (name.length() == 0) {
            return false;
        }
        if (!TurtleUtil.isNameStartChar(name.charAt(0))) {
            return false;
        }
        for (int i = 1; i < name.length(); ++i) {
            if (TurtleUtil.isNameChar(name.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static String encodeString(String s) {
        s = StringUtil.gsub("\\", "\\\\", s);
        s = StringUtil.gsub("\t", "\\t", s);
        s = StringUtil.gsub("\n", "\\n", s);
        s = StringUtil.gsub("\r", "\\r", s);
        s = StringUtil.gsub("\"", "\\\"", s);
        return s;
    }

    public static String encodeLongString(String s) {
        s = StringUtil.gsub("\\", "\\\\", s);
        s = StringUtil.gsub("\"", "\\\"", s);
        return s;
    }

    public static String encodeURIString(String s) {
        s = StringUtil.gsub("\\", "\\\\", s);
        s = StringUtil.gsub(">", "\\>", s);
        return s;
    }

    public static String decodeString(String s) {
        int backSlashIdx = s.indexOf(92);
        if (backSlashIdx == -1) {
            return s;
        }
        int startIdx = 0;
        int sLength = s.length();
        StringBuilder sb = new StringBuilder(sLength);
        while (backSlashIdx != -1) {
            String xx;
            sb.append(s.substring(startIdx, backSlashIdx));
            if (backSlashIdx + 1 >= sLength) {
                throw new IllegalArgumentException("Unescaped backslash in: " + s);
            }
            char c = s.charAt(backSlashIdx + 1);
            if (c == 't') {
                sb.append('\t');
                startIdx = backSlashIdx + 2;
            } else if (c == 'r') {
                sb.append('\r');
                startIdx = backSlashIdx + 2;
            } else if (c == 'n') {
                sb.append('\n');
                startIdx = backSlashIdx + 2;
            } else if (c == '\"') {
                sb.append('\"');
                startIdx = backSlashIdx + 2;
            } else if (c == '>') {
                sb.append('>');
                startIdx = backSlashIdx + 2;
            } else if (c == '\\') {
                sb.append('\\');
                startIdx = backSlashIdx + 2;
            } else if (c == 'u') {
                if (backSlashIdx + 5 >= sLength) {
                    throw new IllegalArgumentException("Incomplete Unicode escape sequence in: " + s);
                }
                xx = s.substring(backSlashIdx + 2, backSlashIdx + 6);
                try {
                    c = (char)Integer.parseInt(xx, 16);
                    sb.append(c);
                    startIdx = backSlashIdx + 6;
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("Illegal Unicode escape sequence '\\u" + xx + "' in: " + s);
                }
            } else if (c == 'U') {
                if (backSlashIdx + 9 >= sLength) {
                    throw new IllegalArgumentException("Incomplete Unicode escape sequence in: " + s);
                }
                xx = s.substring(backSlashIdx + 2, backSlashIdx + 10);
                try {
                    c = (char)Integer.parseInt(xx, 16);
                    sb.append(c);
                    startIdx = backSlashIdx + 10;
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("Illegal Unicode escape sequence '\\U" + xx + "' in: " + s);
                }
            } else {
                throw new IllegalArgumentException("Unescaped backslash in: " + s);
            }
            backSlashIdx = s.indexOf(92, startIdx);
        }
        sb.append(s.substring(startIdx));
        return sb.toString();
    }
}

