#!/bin/bash
# unixODBC (http://www.unixodbc.org/)
#	BuildScript for Plamo Linux 4.7
#			by Jun Kuwamura <juk@linet.gr.jp> on 2009-09-17
# require:
#
SRC_URI="http://www.unixodbc.org/unixODBC-2.2.14.tar.gz"

SRC_FILE=${SRC_URI##*/}
PAC_NAME=${SRC_FILE%%.tar.gz}

REL=P2
CPU=i586
SYS_NAME="${CPU}-${REL}"

PLAMO=/expo/Build
SRC_DIR=$PLAMO/Archive/database
#PAC_DIR=$PLAMO/Packages/4.7/09_webdb/01_PostgreSQL.tgz
PAC_DIR=$PLAMO/Packages/4.7/03_ext
BUILD_DIR=$PLAMO/unixodbc
CUSTOM_DIR=$BUILD_DIR/Custom

echo $PAC_DIR
if [ ! -d $PAC_DIR ]; then
  mkdir -p  $PAC_DIR
fi
echo $SRC_DIR/$SRC_FILE
if [ ! -f $SRC_DIR/$SRC_FILE ]; then
  if [ ! -d $SRC_DIR ]; then
    mkdir -p $SRC_DIR
  fi
  ( cd $SRC_DIR; wget $SRC_URI )
fi


umask 022
CWD=`pwd`
WORK=$CWD/work
rm -rf $WORK/*
mkdir -p $WORK
export LANG=C
export LC_ALL=C
export CFLAGS="-O2 -march=$CPU"
export PATH=$PATH:/usr/X11R7/bin


tar xvfz $SRC_DIR/$SRC_FILE
cd $PAC_NAME
./configure --prefix=/usr --without-x --without-qt
make -i
make -i install DESTDIR=$WORK

cp -p $CUSTOM_DIR/odbc.ini $WORK/usr/etc
cp -p $CUSTOM_DIR/odbcinst.ini $WORK/usr/etc

DOC_DIR=$WORK/usr/share/doc/$PAC_NAME
mkdir -p $DOC_DIR
cp -p [A-Z]*  $DOC_DIR/
cp -a doc  $DOC_DIR/
find $DOC_DIR  -name "Makefile*" -exec rm -f {} \;
cp $BUILD_DIR/`basename $0`  $DOC_DIR/
chown -R root.root $DOC_DIR
chmod -R a+rX $DOC_DIR

cd $WORK
echo "y
" | makepkg ${PAC_NAME}.tgz

echo -n "$PAC_DIR/${PAC_NAME}-${SYS_NAME}.tgz"
if `mv -v ${PAC_NAME}.tgz  $PAC_DIR/${PAC_NAME}-${SYS_NAME}.tgz 1>/dev/null 2>&1`; then
  echo " ... done"
else
  echo " ... false"
fi

cd $CWD
