/*
 * QtTapioca, the Tapioca Qt4 Client Library
 * Copyright (C) 2006 by INdT
 *  @author Abner Jose de Faria Silva <abner.silva@indt.org.br>
 *  @author Andre Moreira Magalhaes <andre.magalhaes@indt.org.br>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301, USA
 */

#ifndef QTTAPIOCA_DBUSPROXYOBJECT_H
#define QTTAPIOCA_DBUSPROXYOBJECT_H

#include <QtCore/QObject>
#include <QtCore/QString>
#include <qglobal.h>

namespace QtTapioca {

class DBusProxyObjectPrivate;

class Q_DECL_EXPORT DBusProxyObject: public QObject {
    Q_OBJECT
    Q_PROPERTY(QString serviceName READ serviceName)
    Q_PROPERTY(QString objectPath READ objectPath)
    Q_DECLARE_PRIVATE(DBusProxyObject)

public:
    ~DBusProxyObject();

    QString serviceName() const;
    QString objectPath() const;

protected:
    DBusProxyObject(const QString &serviceName, const QString &objPath, QObject *parent = 0);

private:
    DBusProxyObjectPrivate *d;
};

} // namespace

#endif

