/*
 * QtTapioca, the Tapioca Qt4 Client Library
 * Copyright (C) 2006 by INdT
 *  @author Abner Jose de Faria Silva <abner.silva@indt.org.br>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301, USA
 */

#ifndef QTTAPIOCA_CONTACTGROUP_H
#define QTTAPIOCA_CONTACTGROUP_H

#include <QtCore/QObject>

#include <qglobal.h>

#include <QtTapioca/Contact>

namespace QtTapioca {

class Channel;
class Conatct;
class Connection;
class ContactGroupPrivate;

class Q_DECL_EXPORT ContactGroup: public QObject {
    Q_OBJECT
    Q_DECLARE_PRIVATE(ContactGroup)
    Q_ENUMS(Flags)

public:

    enum Flags{
        FlagCanAdd = 1,
        FlagCanRemove = 2,
        FlagCanRescind = 4,
        FlagMessageAdd = 8,
        FlagMessageRemove = 16,
        FlagMessageAccept = 32,
        FlagMessageReject = 64,
        FlagMessageRescind = 128,
        FlagChannelSpecific_Handles = 256,
        FlagOnlyOneGroup = 512
    };

    ~ContactGroup();

    void inviteContact(Contact *contact);
    void expelContact(Contact *contact);
    bool canInvite() const;
    bool canExpel() const;
    QList<Contact *> contacts() const;
    QList<Contact *> pendingContacts() const;

    Channel * channel() const;

Q_SIGNALS:
    void contactEntered(QtTapioca::Contact *contact);
    void contactLeft(QtTapioca::Contact *contact);
    void newPendingContact(QtTapioca::Contact *contact);

private Q_SLOTS:
    void onGroupFlagsChanged(uint added, uint removed);
    void onMembersChanged(const QString &message, const QList<uint> &added,
                          const QList<uint> &removed, const QList<uint> &local_pending,
                          const QList<uint> &remote_pending, uint actor, uint reason);

private:
    ContactGroup(Connection *connection, const QString &serviceName, const QString &objPath, Channel *channel);
    QList<Contact *> contactsFromContactList(QList<uint> ids) const;

    ContactGroupPrivate *d;

    friend class Channel;
};

} // namespace

#endif

