/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.org.jvnet.mimepull;

import com.sun.xml.internal.org.jvnet.mimepull.DataHead;
import com.sun.xml.internal.org.jvnet.mimepull.Header;
import com.sun.xml.internal.org.jvnet.mimepull.InternetHeaders;
import com.sun.xml.internal.org.jvnet.mimepull.MIMEMessage;
import java.io.File;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MIMEPart {
    private volatile InternetHeaders headers;
    private volatile String contentId;
    private String contentType;
    volatile boolean parsed;
    final MIMEMessage msg;
    private final DataHead dataHead;

    MIMEPart(MIMEMessage mIMEMessage) {
        this.msg = mIMEMessage;
        this.dataHead = new DataHead(this);
    }

    MIMEPart(MIMEMessage mIMEMessage, String string) {
        this(mIMEMessage);
        this.contentId = string;
    }

    public InputStream read() {
        return this.dataHead.read();
    }

    public void close() {
        this.dataHead.close();
    }

    public InputStream readOnce() {
        return this.dataHead.readOnce();
    }

    public void moveTo(File file) {
        this.dataHead.moveTo(file);
    }

    public String getContentId() {
        if (this.contentId == null) {
            this.getHeaders();
        }
        return this.contentId;
    }

    public String getContentType() {
        if (this.contentType == null) {
            this.getHeaders();
        }
        return this.contentType;
    }

    private void getHeaders() {
        while (this.headers == null) {
            if (this.msg.makeProgress() || this.headers != null) continue;
            throw new IllegalStateException("Internal Error. Didn't get Headers even after complete parsing.");
        }
    }

    public List<String> getHeader(String string) {
        this.getHeaders();
        assert (this.headers != null);
        return this.headers.getHeader(string);
    }

    public List<? extends Header> getAllHeaders() {
        this.getHeaders();
        assert (this.headers != null);
        return this.headers.getAllHeaders();
    }

    void setHeaders(InternetHeaders internetHeaders) {
        this.headers = internetHeaders;
        List<String> list = this.getHeader("Content-Type");
        this.contentType = list == null ? "application/octet-stream" : list.get(0);
    }

    void addBody(ByteBuffer byteBuffer) {
        this.dataHead.addBody(byteBuffer);
    }

    void doneParsing() {
        this.parsed = true;
        this.dataHead.doneParsing();
    }

    void setContentId(String string) {
        this.contentId = string;
    }

    public String toString() {
        return "Part=" + this.contentId;
    }
}

