/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.wizards.ui;

import com.sun.star.awt.AdjustmentEvent;
import com.sun.star.awt.XAdjustmentListener;
import com.sun.star.awt.XScrollBar;
import com.sun.star.beans.PropertyValue;
import com.sun.star.lang.EventObject;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.wizards.common.Desktop;
import com.sun.star.wizards.common.Helper;
import com.sun.star.wizards.ui.PeerConfig;
import com.sun.star.wizards.ui.UnoDialog;
import com.sun.star.wizards.ui.WizardDialog;
import java.util.Vector;

public abstract class ControlScroller {
    protected WizardDialog CurUnoDialog;
    protected XMultiServiceFactory xMSF;
    private Object oImgControl;
    protected int ncurfieldcount;
    protected int nblockincrement;
    private int nlineincrement;
    protected int nscrollvalue = 0;
    protected int ntotfieldcount;
    XScrollBar xScrollBar;
    protected Vector scrollfields;
    protected Integer ICompPosX;
    protected int iCompPosX;
    protected Integer ICompPosY;
    protected int iCompPosY;
    protected Integer ICompWidth;
    protected int iCompWidth;
    protected Integer ICompHeight;
    protected int iCompHeight;
    protected int iStartPosY;
    protected short curtabindex;
    int iStep;
    protected Integer IStep;
    protected int linedistance;
    int iScrollBarWidth = 10;
    int SORELFIRSTPOSY = 3;
    protected int curHelpIndex;
    String sIncSuffix;
    protected Vector ControlGroupVector = new Vector();
    protected PeerConfig oTitlePeerConfig;

    protected ControlScroller(WizardDialog wizardDialog, XMultiServiceFactory xMultiServiceFactory, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        this.xMSF = xMultiServiceFactory;
        this.nblockincrement = n5;
        this.CurUnoDialog = wizardDialog;
        this.iStep = n;
        this.curHelpIndex = n7;
        this.curtabindex = UnoDialog.setInitialTabindex(this.iStep);
        this.linedistance = n6;
        this.IStep = new Integer(this.iStep);
        this.iCompPosX = n2;
        this.iCompPosY = n3;
        this.ICompPosX = new Integer(this.iCompPosX);
        this.ICompPosY = new Integer(this.iCompPosY);
        this.iCompWidth = n4;
        this.ICompWidth = new Integer(this.iCompWidth);
        this.iCompHeight = 2 * this.SORELFIRSTPOSY + this.nblockincrement * this.linedistance;
        this.iStartPosY = this.iCompPosY + this.SORELFIRSTPOSY;
        int n8 = this.iCompHeight - 2;
        this.nlineincrement = 1;
        this.sIncSuffix = Desktop.getIncrementSuffix(this.CurUnoDialog.getDlgNameAccess(), "imgBackground");
        this.oImgControl = this.CurUnoDialog.insertControlModel("com.sun.star.awt.UnoControlImageControlModel", "imgBackground" + this.sIncSuffix, new String[]{"Border", "Height", "PositionX", "PositionY", "Step", "Width"}, new Object[]{new Short("1"), new Integer(this.iCompHeight), this.ICompPosX, new Integer(this.iCompPosY), this.IStep, this.ICompWidth});
        this.oImgControl = this.CurUnoDialog.xDlgContainer.getControl("imgBackground" + this.sIncSuffix);
        this.setComponentMouseTransparent();
        this.xScrollBar = this.CurUnoDialog.insertScrollBar("TitleScrollBar" + this.sIncSuffix, 0, new AdjustmentListenerImpl(), new String[]{"Border", "Enabled", "Height", "HelpURL", "Orientation", "PositionX", "PositionY", "Step", "Width"}, new Object[]{new Short(0), new Boolean(true), new Integer(n8), "HID:" + this.curHelpIndex, new Integer(1), new Integer(this.iCompPosX + this.iCompWidth - this.iScrollBarWidth - 1), new Integer(this.iCompPosY + 1), this.IStep, new Integer(this.iScrollBarWidth)});
        this.scrollfields = new Vector();
        int n9 = this.iStartPosY + this.SORELFIRSTPOSY;
        for (int i = 0; i < this.nblockincrement; ++i) {
            this.insertControlGroup(i, n9);
            n9 += this.linedistance;
        }
    }

    public void setComponentMouseTransparent() {
        this.CurUnoDialog.getPeerConfiguration().setPeerProperties(this.oImgControl, new String[]{"MouseTransparent"}, (Object[])new Boolean[]{Boolean.TRUE});
    }

    protected void setScrollBarOrientationHorizontal() {
        Helper.setUnoPropertyValue(this.xScrollBar, "Orientation", new Integer(0));
    }

    protected void initialize(int n) {
        try {
            this.ntotfieldcount = n;
            this.setCurFieldCount();
            this.nscrollvalue = 0;
            Helper.setUnoPropertyValue(UnoDialog.getModel(this.xScrollBar), new String("ScrollValue"), new Integer(this.nscrollvalue));
            if (this.ntotfieldcount > this.nblockincrement) {
                Helper.setUnoPropertyValues(UnoDialog.getModel(this.xScrollBar), new String[]{"Enabled", "BlockIncrement", "LineIncrement", "ScrollValue", "ScrollValueMax"}, new Object[]{Boolean.TRUE, new Integer(this.nblockincrement), new Integer(this.nlineincrement), new Integer(this.nscrollvalue), new Integer(this.ntotfieldcount - this.nblockincrement)});
            } else {
                Helper.setUnoPropertyValues(UnoDialog.getModel(this.xScrollBar), new String[]{"Enabled", "ScrollValue"}, new Object[]{Boolean.FALSE, new Integer(this.nscrollvalue)});
            }
            this.fillupControls(true);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected void fillupControls(boolean bl) {
        for (int i = 0; i < this.nblockincrement; ++i) {
            if (i < this.ncurfieldcount) {
                this.fillupControls(i);
            }
            if (!bl) continue;
            this.setControlGroupVisible(i, i < this.ncurfieldcount);
        }
        if (bl) {
            this.CurUnoDialog.repaintDialogStep();
        }
    }

    protected void fillupControls(int n) {
        PropertyValue[] propertyValueArray = (PropertyValue[])this.scrollfields.get(n);
        PropertyValue[] propertyValueArray2 = (PropertyValue[])this.scrollfields.get(n + this.nscrollvalue);
        for (int i = 0; i < propertyValueArray.length; ++i) {
            if (!this.CurUnoDialog.getDlgNameAccess().hasByName(propertyValueArray[i].Name)) {
                throw new IllegalArgumentException("No such control !");
            }
            this.setControlData(propertyValueArray[i].Name, propertyValueArray2[i].Value);
        }
    }

    protected void setScrollValue(int n) {
        if (n >= 0) {
            Helper.setUnoPropertyValue(UnoDialog.getModel(this.xScrollBar), new String("ScrollValue"), new Integer(n));
            this.scrollControls();
        }
    }

    protected void setScrollValue(int n, int n2) {
        this.setTotalFieldCount(n2);
        this.setScrollValue(n);
    }

    protected int getTotalFieldCount() {
        return this.ntotfieldcount;
    }

    protected int getCurFieldCount() {
        return this.ncurfieldcount;
    }

    private void setCurFieldCount() {
        this.ncurfieldcount = this.ntotfieldcount > this.nblockincrement ? this.nblockincrement : this.ntotfieldcount;
    }

    protected void setTotalFieldCount(int n) {
        this.ntotfieldcount = n;
        this.setCurFieldCount();
        if (this.ntotfieldcount > this.nblockincrement) {
            Helper.setUnoPropertyValues(UnoDialog.getModel(this.xScrollBar), new String[]{"Enabled", "ScrollValueMax"}, new Object[]{Boolean.TRUE, new Integer(this.ntotfieldcount - this.nblockincrement)});
        } else {
            Helper.setUnoPropertyValue(UnoDialog.getModel(this.xScrollBar), "Enabled", Boolean.FALSE);
        }
    }

    protected void toggleComponent(boolean bl) {
        boolean bl2 = bl && this.ntotfieldcount > this.nblockincrement;
        this.CurUnoDialog.setControlProperty("TitleScrollBar" + this.sIncSuffix, "Enabled", new Boolean(bl2));
    }

    protected void toggleControls(boolean bl) {
        for (int i = 0; i < this.scrollfields.size(); ++i) {
            PropertyValue[] propertyValueArray = (PropertyValue[])this.scrollfields.elementAt(i);
            for (int j = 0; j < propertyValueArray.length; ++j) {
                PropertyValue propertyValue = propertyValueArray[j];
                this.CurUnoDialog.setControlProperty(propertyValue.Name, "Enabled", new Boolean(bl));
            }
        }
    }

    protected int getScrollValue() {
        return this.nscrollvalue;
    }

    protected void setLineIncrementation(int n) {
        this.nlineincrement = n;
        Helper.setUnoPropertyValue(UnoDialog.getModel(this.xScrollBar), new String("LineIncrement"), new Integer(this.nlineincrement));
    }

    protected int getLineIncrementation() {
        return this.nlineincrement;
    }

    protected void setBlockIncrementation(int n) {
        this.nblockincrement = n;
        Helper.setUnoPropertyValues(UnoDialog.getModel(this.xScrollBar), new String[]{"Enabled", "BlockIncrement", "ScrollValueMax"}, new Object[]{new Boolean(this.ntotfieldcount > this.nblockincrement), new Integer(this.nblockincrement), new Integer(this.ntotfieldcount - this.nblockincrement)});
    }

    protected int getBlockIncrementation() {
        return this.nblockincrement;
    }

    private void scrollControls() {
        try {
            this.scrollRowsInfo();
            this.nscrollvalue = (Integer)Helper.getUnoPropertyValue(UnoDialog.getModel(this.xScrollBar), "ScrollValue");
            if (this.nscrollvalue + this.nblockincrement >= this.ntotfieldcount) {
                this.nscrollvalue = this.ntotfieldcount - this.nblockincrement;
            }
            this.fillupControls(false);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected void scrollRowsInfo() {
        int n = this.scrollfields.size() > 0 ? ((PropertyValue[])this.scrollfields.get(0)).length : 0;
        for (int i = 0; i < this.ncurfieldcount; ++i) {
            for (int j = 0; j < n; ++j) {
                this.fieldInfo(i, j);
            }
        }
    }

    protected PropertyValue fieldInfo(int n, int n2) {
        if (n + this.nscrollvalue < this.scrollfields.size()) {
            PropertyValue propertyValue = this.fieldInfo(((PropertyValue[])this.scrollfields.elementAt(n + this.nscrollvalue))[n2], ((PropertyValue[])this.scrollfields.elementAt(n))[n2]);
            return propertyValue;
        }
        return null;
    }

    protected PropertyValue fieldInfo(PropertyValue propertyValue, PropertyValue propertyValue2) {
        propertyValue.Value = this.CurUnoDialog.getDlgNameAccess().hasByName(propertyValue2.Name) ? this.getControlData(propertyValue2.Name) : propertyValue2.Value;
        return propertyValue;
    }

    protected void unregisterControlGroup(int n) {
        this.scrollfields.remove(n);
    }

    protected void registerControlGroup(PropertyValue[] propertyValueArray, int n) {
        if (n == 0) {
            this.scrollfields.removeAllElements();
        }
        if (n >= this.scrollfields.size()) {
            this.scrollfields.addElement(propertyValueArray);
        } else {
            this.scrollfields.setElementAt(propertyValueArray, n);
        }
    }

    protected PropertyValue[] getControlGroupInfo(int n) {
        return (PropertyValue[])this.scrollfields.elementAt(n);
    }

    protected void setControlData(String string, Object object) {
        Object object2 = UnoDialog.getModel(this.CurUnoDialog.xDlgContainer.getControl(string));
        String string2 = UnoDialog.getDisplayProperty(object2);
        if (string2 != "") {
            this.CurUnoDialog.setControlProperty(string, string2, object);
        }
    }

    protected Object getControlData(String string) {
        Object object = UnoDialog.getModel(this.CurUnoDialog.xDlgContainer.getControl(string));
        String string2 = UnoDialog.getDisplayProperty(object);
        if (string2 != "") {
            return this.CurUnoDialog.getControlProperty(string, string2);
        }
        return null;
    }

    protected PropertyValue[][] getScrollFieldValues() {
        this.scrollRowsInfo();
        PropertyValue[][] propertyValueArrayArray = new PropertyValue[this.scrollfields.size()][];
        try {
            for (int i = 0; i < this.scrollfields.size(); ++i) {
                PropertyValue[] propertyValueArray;
                propertyValueArrayArray[i] = propertyValueArray = (PropertyValue[])this.scrollfields.elementAt(i);
            }
            return propertyValueArrayArray;
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
            return null;
        }
    }

    protected abstract void initializeScrollFields();

    protected abstract void insertControlGroup(int var1, int var2);

    protected abstract void setControlGroupVisible(int var1, boolean var2);

    class AdjustmentListenerImpl
    implements XAdjustmentListener {
        AdjustmentListenerImpl() {
        }

        public void disposing(EventObject eventObject) {
        }

        public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
            ControlScroller.this.scrollControls();
        }
    }
}

