/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.servicetag;

import com.sun.star.servicetag.SystemEnvironment;
import java.util.HashSet;

class LinuxSystemEnvironment
extends SystemEnvironment {
    private String dmiInfo = null;
    private String kstatCpuInfo = null;
    private static final int SN = 1;
    private static final int SYS = 2;
    private static final int CPU = 3;
    private static final int MODEL = 4;

    LinuxSystemEnvironment() {
        this.setHostId(this.getLinuxHostId());
        this.setSystemModel(this.getLinuxModel());
        this.setSystemManufacturer(this.getLinuxSystemManufacturer());
        this.setCpuManufacturer(this.getLinuxCpuManufacturer());
        this.setSerialNumber(this.getLinuxSN());
        this.setPhysMem(this.getLinuxPhysMem());
        this.setSockets(this.getLinuxSockets());
        this.setCores(this.getLinuxCores());
        this.setVirtCpus(this.getLinuxVirtCpus());
        this.setCpuName(this.getLinuxCpuName());
        this.setClockRate(this.getLinuxClockRate());
    }

    private String getLinuxHostId() {
        String string = this.getCommandOutput("/usr/bin/hostid");
        if (string.startsWith("0x")) {
            string = string.substring(2);
        }
        return string;
    }

    private String getLinuxCpuManufacturer() {
        String string = this.getLinuxPSNInfo(3);
        if (string.length() > 0) {
            return string;
        }
        String string2 = this.getFileContent("/proc/cpuinfo");
        for (String string3 : string2.split("\n")) {
            String[] stringArray;
            if (!string3.contains("vendor_id") || (stringArray = string3.split(":", 2)).length <= 1) continue;
            return stringArray[1].trim();
        }
        return this.getLinuxDMIInfo("dmi type 4", "manufacturer");
    }

    private String getLinuxModel() {
        String string = this.getLinuxPSNInfo(4);
        if (string.length() > 0) {
            return string + "::" + this.getCommandOutput("/bin/uname", "-v");
        }
        string = this.getLinuxDMIInfo("dmi type 1", "product name");
        if (string.length() > 0) {
            return string + "::" + this.getCommandOutput("/bin/uname", "-v");
        }
        return this.getCommandOutput("/bin/uname", "-i") + "::" + this.getCommandOutput("/bin/uname", "-v");
    }

    private String getLinuxSystemManufacturer() {
        String string = this.getLinuxPSNInfo(2);
        if (string.length() > 0) {
            return string;
        }
        return this.getLinuxDMIInfo("dmi type 1", "manufacturer");
    }

    private String getLinuxSN() {
        String string = this.getLinuxPSNInfo(1);
        if (string.length() > 0) {
            return string;
        }
        return this.getLinuxDMIInfo("dmi type 1", "serial number");
    }

    private String getLinuxPSNInfo(int n) {
        String string = this.getFileContent("/var/run/psn");
        String[] stringArray = string.split("\n");
        if (n <= stringArray.length) {
            return stringArray[n - 1];
        }
        return "";
    }

    private synchronized String getLinuxDMIInfo(String string, String string2) {
        if (this.dmiInfo == null) {
            Thread thread = new Thread(){

                public void run() {
                    LinuxSystemEnvironment.this.dmiInfo = LinuxSystemEnvironment.this.getCommandOutput("/usr/sbin/dmidecode");
                }
            };
            thread.start();
            try {
                thread.join(3000L);
                if (thread.isAlive()) {
                    thread.interrupt();
                    this.dmiInfo = "";
                }
            }
            catch (InterruptedException interruptedException) {
                thread.interrupt();
            }
        }
        if (this.dmiInfo.length() == 0) {
            return "";
        }
        boolean bl = false;
        for (String string3 : this.dmiInfo.split("\n")) {
            String string4 = string3.toLowerCase();
            if (bl) {
                if (!string4.contains(string2)) continue;
                String string5 = string2 + ":";
                int n = string4.indexOf(string5) + string5.length();
                if (string4.contains(string5) && n < string4.length()) {
                    return string4.substring(n).trim();
                }
                String[] stringArray = string4.split(":");
                return stringArray[stringArray.length - 1];
            }
            if (!string4.contains(string)) continue;
            bl = true;
        }
        return "";
    }

    private String getLinuxClockRate() {
        String string = this.getFileContent("/proc/cpuinfo");
        String string2 = "cpu MHz";
        for (String string3 : string.split("\n")) {
            String[] stringArray;
            if (!string3.contains(string2) || (stringArray = string3.split(":", 2)).length <= 1) continue;
            return stringArray[1].trim();
        }
        return "";
    }

    private String getLinuxCpuName() {
        String string = this.getFileContent("/proc/cpuinfo");
        String string2 = "model name";
        for (String string3 : string.split("\n")) {
            String[] stringArray;
            if (!string3.contains(string2) || (stringArray = string3.split(":", 2)).length <= 1) continue;
            return stringArray[1].trim();
        }
        return "";
    }

    private String getLinuxVirtCpus() {
        HashSet<String> hashSet = new HashSet<String>();
        String string = this.getFileContent("/proc/cpuinfo");
        String string2 = "processor";
        for (String string3 : string.split("\n")) {
            String[] stringArray;
            if (!string3.contains(string2) || (stringArray = string3.split(":", 2)).length <= 1) continue;
            hashSet.add(stringArray[1].trim());
        }
        return "" + hashSet.size();
    }

    private String getLinuxCores() {
        HashSet<String> hashSet = new HashSet<String>();
        String string = this.getFileContent("/proc/cpuinfo");
        String string2 = "core id";
        for (String string3 : string.split("\n")) {
            String[] stringArray;
            if (!string3.contains(string2) || (stringArray = string3.split(":", 2)).length <= 1) continue;
            hashSet.add(stringArray[1].trim());
        }
        if (hashSet.size() == 0) {
            return "1";
        }
        return "" + hashSet.size();
    }

    private String getLinuxPhysMem() {
        String string = this.getFileContent("/proc/meminfo");
        for (String string2 : string.split("\n")) {
            String[] stringArray;
            if (!string2.contains("MemTotal") || (stringArray = string2.split(":", 2)).length <= 1) continue;
            String[] stringArray2 = stringArray[1].trim().split(" ");
            if (stringArray2.length >= 1) {
                return stringArray2[0].trim();
            }
            return stringArray[1].trim();
        }
        return "";
    }

    private String getLinuxSockets() {
        HashSet<String> hashSet = new HashSet<String>();
        HashSet<String> hashSet2 = new HashSet<String>();
        String string = this.getFileContent("/proc/cpuinfo");
        String string2 = "physical id";
        String string3 = "processor";
        for (String string4 : string.split("\n")) {
            String[] stringArray;
            if (string4.contains(string2) && (stringArray = string4.split(":", 2)).length > 1) {
                hashSet.add(stringArray[1].trim());
            }
            if (!string4.contains(string3) || (stringArray = string4.split(":", 2)).length <= 1) continue;
            hashSet2.add(stringArray[1].trim());
        }
        if (hashSet.size() != 0) {
            return "" + hashSet.size();
        }
        return "" + hashSet2.size();
    }
}

