#!/bin/bash
# PostGIS	(http://postgis.refractions.net/)
VERSION=1.4.1
VER=${VERSION%%.?}
#	BuildScript for Plamo Linux 4.7
#			by Jun Kuwamura <juk@linet.gr.jp> on 2010-02-14
# require:
PGVERSION=8.4.2
POSTGRESQL=postgresql-$PGVERSION
GEOS=geos-3.1.1
PROJ=proj-4.6.1
#
PAC_NAME=postgis-$VERSION
SRC_FILE=${PAC_NAME}.tar.gz
SRC_URI=http://postgis.refractions.net/download/$SRC_FILE
#       http://postgis.refractions.net/download/postgis-1.4.0.tar.gz


REL=P1
CPU=i586
SYS_NAME="${CPU}-${REL}"

PLAMO=/expo/Build
SRC_DIR=$PLAMO/Archive/dbms/pgsql
PAC_DIR=$PLAMO/Packages/4.7/10_gis/
BUILD_DIR=$PLAMO/postgis
CUSTOM_DIR=$BUILD_DIR/Custom
PAT_FILE=

echo $PAC_DIR
if [ ! -d $PAC_DIR ]; then
  mkdir -p  $PAC_DIR
fi
echo $SRC_DIR/$SRC_FILE
if [ ! -f $SRC_DIR/$SRC_FILE ]; then
  if [ ! -d $SRC_DIR ]; then
    mkdir -p $SRC_DIR
  fi
  ( cd $SRC_DIR; wget $SRC_URI )
fi


umask 022
CWD=`pwd`
WORK=$CWD/work
rm -rf $WORK/*
mkdir -p $WORK
export LANG=C
export LC_ALL=C
export CFLAGS="-O2 -march=$CPU"
export PATH=$PATH:/usr/X11R7/bin


# it must be extracted in postgresql tree under contrib.
rm -f $POSTGRESQL
if [ ! -d ../postgresql/$POSTGRESQL ]; then
  echo "../postgresql/$POSTGRESQL not found.";
  exit;
fi
ln -sf ../postgresql/$POSTGRESQL
cd $POSTGRESQL/contrib/

tar xvfz  $SRC_DIR/$SRC_FILE
cd $PAC_NAME
  PREFIX=/opt/pgsql
  ./configure --prefix=$PREFIX \
      --datadir=$PREFIX/share/contrib \
      --with-pgconfig=$PREFIX/bin/pg_config \
      --with-projdir=/usr \
      --with-geosconfig=/usr/bin/geos-config \
      || exit 1

 #USE_PROJ=1 PROJ_DIR=/usr USE_GEOS=1 GEOS_DIR=/usr  make
 make install DESTDIR=$WORK
 cd topology
 make install DESTDIR=$WORK
 cd ..
 cd doc
 make install DESTDIR=$WORK
 cd ..

 # regression test
 #cd regress/
 #chown -R postgres .
 #su postgres -c make > regress-make.log
 #mv regress-make.log $CUSTOM_DIR
 #cd ..

DOC_DIR=usr/share/doc/$PAC_NAME
mkdir -p $WORK/$DOC_DIR || exit 1
cp -p $BUILD_DIR/`basename $0`  \
      COPYING TODO CREDITS NEWS ChangeLog README.postgis \
	$WORK/$DOC_DIR

cp -p $CUSTOM_DIR/regress-make.log $WORK/$DOC_DIR
mv $WORK/$PREFIX/share/{man,doc} $WORK/$PREFIX
chown -R root.root $WORK/$DOC_DIR
chmod -R a+rX $WORK/$DOC_DIR


# make package
cd $WORK
 mv opt/$POSTGRESQL opt/pgsql

 tar cf - \
    $PREFIX/share/doc/postgis/ \
    $PREFIX/share/man/man1/pgsql2shp.1 \
    $PREFIX/share/man/man1/shp2pgsql.1 \
  | tar xvf -

 mkdir install
 sed -e "s/_VER_/$VER/" \
     -e "s/_PAC_NAME_/$PAC_NAME/" \
     -e "s/_PACKAGENAME_/${PAC_NAME}-${SYS_NAME}/" \
     $CUSTOM_DIR/doinst.sh-1.4 > install/doinst.sh
 cp -p $CUSTOM_DIR/postgis-install.sh $DOC_DIR
 cp -p $CUSTOM_DIR/postgis-upgrade.sh $DOC_DIR
 cp -p $CUSTOM_DIR/postgis-uninstall.sh $DOC_DIR
 chown -R postgres:pgsql opt/pgsql


  tar cvfz ../${PAC_NAME}-${SYS_NAME}.tgz \
    opt/pgsql/{bin,lib}/* opt/pgsql/share/man/*/* opt/pgsql/share/contrib/* usr/share/doc/${PAC_NAME}/ install/doinst.sh
  mv -v ../${PAC_NAME}-${SYS_NAME}.tgz $PAC_DIR/${PAC_NAME}-${SYS_NAME}.tgz
  ls -l $PAC_DIR/${PAC_NAME}-${SYS_NAME}.tgz


#echo "y
#1" | makepkg ${PAC_NAME}.tgz
#mv ${PAC_NAME}.tgz  $PAC_DIR/${PAC_NAME}-${SYS_NAME}.tgz
#echo "$PAC_DIR/${PAC_NAME}-${SYS_NAME}.tgz ... done"
cd $CWD
