# pgAdmin-III	(http://pgadmin.org/)
#	BuildScript for Plamo Linux 4.7
#			by Jun Kuwamura <juk@linet.gr.jp> on 2009-09-12
# require:
#	readline
#
VERSION=1.10.0
SRC_URI=http://ftp2.jp.postgresql.org/pub/postgresql//pgadmin3/release/v$VERSION/src/pgadmin3-$VERSION.tar.gz
AGENT_URI=http://ftp2.jp.postgresql.org/pub/postgresql//pgadmin3/release/pgagent/pgAgent-3.0.1-Source.tar.gz

SRC_FILE=${SRC_URI##*/}
SRC_NAME=${SRC_FILE%%.tar.gz}
PAC_NAME=${SRC_NAME%%-stable}

REL=P1
CPU=i586
SYS_NAME="${CPU}-${REL}"

PLAMO=/expo/Build
SRC_DIR=$PLAMO/Archive/dbms/pgsql
PAC_DIR=$PLAMO/Packages/4.7/09_webdb/01_PostgreSQL.tgz/
BUILD_DIR=$PLAMO/pgadmin3
CUSTOM_DIR=$BUILD_DIR/Custom

#wget -N http://www.pgadmin.org/svnrepo/pgadmin3/i18n/ja_JP/pgadmin3.po

echo $PAC_DIR
if [ ! -d $PAC_DIR ]; then
  mkdir -p  $PAC_DIR
fi
echo $SRC_DIR/$SRC_FILE
if [ ! -f $SRC_DIR/$SRC_FILE ]; then
  if [ ! -d $SRC_DIR ]; then
    mkdir -p $SRC_DIR
  fi
  ( cd $SRC_DIR; wget $SRC_URI )
fi


umask 022
CWD=`pwd`
WORK=$CWD/work
rm -rf $WORK/*
mkdir -p $WORK
export LANG=C
export LC_ALL=C
export CFLAGS="-O2 -march=$CPU"
export PATH=$PATH:/usr/X11R7/bin


tar xvfz $SRC_DIR/$SRC_FILE
cd $PAC_NAME
./configure --enable-unicode --enable-gtk2 --prefix=/usr \
	--with-pgsql=/opt/pgsql  --with-wx=/usr
make
make install DESTDIR=$WORK

DOC_DIR=$WORK/usr/share/doc/${PAC_NAME}/
mkdir -p $DOC_DIR
cp -p $BUILD_DIR/`basename $0`  \
      BUGS CHANGELOG DEVELOPERS INSTALL LICENSE README TODO \
  $DOC_DIR
chown -R root.root $DOC_DIR/
chmod -R a+rX,go-w $DOC_DIR/

mkdir -p  $WORK/opt/kde/share/applnk/Development
cp  pkg/pgadmin3.desktop $WORK/opt/kde/share/applnk/Development
mkdir -p  $WORK/usr/share/pgadmin3
cp  pgadmin/include/images/elephant48.xpm $WORK/usr/share/pgadmin3/pgadmin3.xpm
mkdir -p  $WORK/usr/share/pixmaps
cp  pkg/debian/pgadmin3.xpm $WORK/usr/share/pixmaps/
mkdir -p  $WORK/install/
sed -e "s/VERSION/$VERSION/"  $CUSTOM_DIR/doinst.sh > $WORK/install/doinst.sh

cd $WORK
echo "y
1
" | makepkg ${PAC_NAME}.tgz

echo -n "$PAC_DIR/${PAC_NAME}-${SYS_NAME}.tgz"
if `mv -v ${PAC_NAME}.tgz  $PAC_DIR/${PAC_NAME}-${SYS_NAME}.tgz 1>/dev/null 2>&1`; then
  echo " ... done"
else
  echo " ... false"
fi

cd $CWD
