/*
 * Decompiled with CFR 0.152.
 */
package info.aduna.iteration;

import info.aduna.iteration.FilterIteration;
import info.aduna.iteration.Iteration;
import info.aduna.iteration.Iterations;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntersectIteration<E, X extends Exception>
extends FilterIteration<E, X> {
    private final Iteration<? extends E, ? extends X> arg2;
    private final boolean distinct;
    private boolean initialized;
    private Set<E> includeSet;

    public IntersectIteration(Iteration<? extends E, ? extends X> arg1, Iteration<? extends E, ? extends X> arg2) {
        this(arg1, arg2, false);
    }

    public IntersectIteration(Iteration<? extends E, ? extends X> arg1, Iteration<? extends E, ? extends X> arg2, boolean distinct) {
        super(arg1);
        assert (arg2 != null);
        this.arg2 = arg2;
        this.distinct = distinct;
        this.initialized = false;
    }

    @Override
    protected boolean accept(E object) throws X {
        if (!this.initialized) {
            this.includeSet = Iterations.addAll(this.arg2, new HashSet());
            this.initialized = true;
        }
        if (this.includeSet.contains(object)) {
            if (this.distinct) {
                this.includeSet.remove(object);
            }
            return true;
        }
        return false;
    }

    @Override
    protected void handleClose() throws X {
        super.handleClose();
        Iterations.closeCloseable(this.arg2);
    }
}

