# - Try to find KOffice Libraries
# Once done this will define
#
#  KOFFICELIBS_FOUND - system has KOffice
#  KOFFICELIBS_INCLUDE_DIR - the Koffice include directory
# KOMAIN_LIBRARY
# KOTEXT_LIBRARY
# KOPLUGIN_LIBRARY
# KOODF_LIBRARY
# KOPAGEAPP_LIBRARY
# KOKROSS_LIBRARY
# FLAKE_LIBRARY
# KOWIDGETS_LIBRARY
# PIGMENTCMS_LIBRARY
#  KOFFICELIBS_DEFINITIONS - Compiler switches required for using Koffice
# Redistribution and use is allowed according to the terms of the BSD license.
# For details see the accompanying COPYING-CMAKE-SCRIPTS file.
#

if ( KOFFICELIBS_INCLUDE_DIR AND KOFFICELIBS_LIBRARIES )
   # in cache already
   SET( KOFFICELIBS_FIND_QUIETLY TRUE )
endif ( KOFFICELIBS_INCLUDE_DIR AND KOFFICELIBS_LIBRARIES )

FIND_PATH( KOFFICELIBS_INCLUDE_DIR NAMES KoDocument.h)# HINTS ${CMAKE_INSTALL_PREFIX}/include)

FIND_LIBRARY(KOMAIN_LIBRARY NAMES komain)
FIND_LIBRARY(KOTEXT_LIBRARY NAMES kotext)
FIND_LIBRARY(KOPLUGIN_LIBRARY NAMES koplugin)
FIND_LIBRARY(KOODF_LIBRARY NAMES koodf)
FIND_LIBRARY(KOPAGEAPP_LIBRARY NAMES kopageapp)
FIND_LIBRARY(KOKROSS_LIBRARY NAMES kokross)
FIND_LIBRARY(FLAKE_LIBRARY NAMES flake)
FIND_LIBRARY(PIGMENTCMS_LIBRARY NAMES pigmentcms)
FIND_LIBRARY(KOWIDGETS_LIBRARY NAMES kowidgets)


SET( KOFFICECORE_LIBRARIES
    ${KOODF_LIBRARY}
    ${FLAKE_LIBRARY}
    ${KOTEXT_LIBRARY}
    ${KOPAGEAPP_LIBRARY}
    ${KOPLUGIN_LIBRARY}
    ${KOMAIN_LIBRARY}
)

SET( KOFFICELIBS_LIBRARIES
    ${KOKROSS_LIBRARY}
    ${PIGMENTCMS_LIBRARY}
    ${KOWIDGETS_LIBRARY}
)

include( FindPackageHandleStandardArgs )

FIND_PACKAGE_HANDLE_STANDARD_ARGS( KOfficeLibs DEFAULT_MSG KOFFICELIBS_INCLUDE_DIR KOFFICECORE_LIBRARIES )

# show the KOFFICELIBS_INCLUDE_DIR and KOFFICELIBS_LIBRARIES variables only in the advanced view
MARK_AS_ADVANCED(KOFFICELIBS_INCLUDE_DIR
    KOMAIN_LIBRARY
    KOTEXT_LIBRARY
    KOPLUGIN_LIBRARY
    KOODF_LIBRARY
    KOPAGEAPP_LIBRARY
    KOKROSS_LIBRARY
    FLAKE_LIBRARY
    KOWIDGETS_LIBRARY
    PIGMENTCMS_LIBRARY
    KOFFICELIBS_LIBRARIES )

# define the generic version of the KOffice libraries here
# this makes it easy to advance it when the next KOffice release comes
set(GENERIC_KOFFICE_LIB_VERSION "7.0.0")
set(GENERIC_KOFFICE_LIB_SOVERSION "7")
