/*
 * Decompiled with CFR 0.152.
 */
package sun.security.krb5.internal.ktab;

import java.io.IOException;
import java.io.InputStream;
import sun.security.krb5.PrincipalName;
import sun.security.krb5.Realm;
import sun.security.krb5.RealmException;
import sun.security.krb5.internal.KerberosTime;
import sun.security.krb5.internal.Krb5;
import sun.security.krb5.internal.ktab.KeyTabConstants;
import sun.security.krb5.internal.ktab.KeyTabEntry;
import sun.security.krb5.internal.util.KrbDataInputStream;

public class KeyTabInputStream
extends KrbDataInputStream
implements KeyTabConstants {
    boolean DEBUG = Krb5.DEBUG;
    static int index;

    public KeyTabInputStream(InputStream inputStream) {
        super(inputStream);
    }

    int readEntryLength() throws IOException {
        return this.read(4);
    }

    KeyTabEntry readEntry(int n, int n2) throws IOException, RealmException {
        int n3;
        index = n;
        if (index == 0) {
            return null;
        }
        if (index < 0) {
            this.skip(Math.abs(index));
            return null;
        }
        int n4 = this.read(2);
        index -= 2;
        if (n2 == 1281) {
            --n4;
        }
        Realm realm = new Realm(this.readName());
        String[] stringArray = new String[n4];
        for (n3 = 0; n3 < n4; ++n3) {
            stringArray[n3] = this.readName();
        }
        n3 = this.read(4);
        index -= 4;
        PrincipalName principalName = new PrincipalName(stringArray, n3);
        principalName.setRealm(realm);
        KerberosTime kerberosTime = this.readTimeStamp();
        int n5 = this.read() & 0xFF;
        --index;
        int n6 = this.read(2);
        index -= 2;
        int n7 = this.read(2);
        index -= 2;
        byte[] byArray = this.readKey(n7);
        if ((index -= n7) >= 4) {
            int n8 = this.read(4);
            if (n8 != 0) {
                n5 = n8;
            }
            index -= 4;
        }
        if (index < 0) {
            throw new RealmException("Keytab is corrupted");
        }
        this.skip(index);
        return new KeyTabEntry(principalName, realm, kerberosTime, n5, n6, byArray);
    }

    byte[] readKey(int n) throws IOException {
        byte[] byArray = new byte[n];
        this.read(byArray, 0, n);
        return byArray;
    }

    KerberosTime readTimeStamp() throws IOException {
        index -= 4;
        return new KerberosTime((long)this.read(4) * 1000L);
    }

    String readName() throws IOException {
        int n = this.read(2);
        index -= 2;
        byte[] byArray = new byte[n];
        this.read(byArray, 0, n);
        index -= n;
        String string = new String(byArray);
        if (this.DEBUG) {
            System.out.println(">>> KeyTabInputStream, readName(): " + string);
        }
        return string;
    }
}

