/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ComponentEvent;
import java.awt.event.InvocationEvent;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import sun.awt.X11.ComponentAccessor;
import sun.awt.X11.WindowDimensions;
import sun.awt.X11.XAtom;
import sun.awt.X11.XAtomList;
import sun.awt.X11.XClientMessageEvent;
import sun.awt.X11.XConfigureEvent;
import sun.awt.X11.XContentWindow;
import sun.awt.X11.XCreateWindowParams;
import sun.awt.X11.XEvent;
import sun.awt.X11.XFocusChangeEvent;
import sun.awt.X11.XFocusProxyWindow;
import sun.awt.X11.XIconInfo;
import sun.awt.X11.XIconWindow;
import sun.awt.X11.XKeyboardFocusManagerPeer;
import sun.awt.X11.XQueryTree;
import sun.awt.X11.XReparentEvent;
import sun.awt.X11.XToolkit;
import sun.awt.X11.XTranslateCoordinates;
import sun.awt.X11.XWM;
import sun.awt.X11.XWindowAttributes;
import sun.awt.X11.XWindowAttributesData;
import sun.awt.X11.XWindowPeer;
import sun.awt.X11.XlibWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class XDecoratedPeer
extends XWindowPeer {
    private static final Logger log = Logger.getLogger("sun.awt.X11.XDecoratedPeer");
    private static final Logger insLog = Logger.getLogger("sun.awt.X11.insets.XDecoratedPeer");
    private static final Logger focusLog = Logger.getLogger("sun.awt.X11.focus.XDecoratedPeer");
    private static final Logger iconLog = Logger.getLogger("sun.awt.X11.icon.XDecoratedPeer");
    private static XAtom resize_request = new XAtom("_SUN_AWT_RESIZE_REQUEST", false);
    boolean configure_seen;
    boolean insets_corrected;
    XIconWindow iconWindow;
    WindowDimensions dimensions;
    XContentWindow content;
    Insets currentInsets;
    XFocusProxyWindow focusProxy;
    long reparent_serial = 0L;
    boolean no_reparent_artifacts = false;
    private XWindowPeer actualFocusedWindow = null;

    XDecoratedPeer(Window window) {
        super(window);
    }

    XDecoratedPeer(XCreateWindowParams xCreateWindowParams) {
        super(xCreateWindowParams);
    }

    public long getShell() {
        return this.window;
    }

    @Override
    public long getContentWindow() {
        return this.content == null ? this.window : this.content.getWindow();
    }

    @Override
    void preInit(XCreateWindowParams xCreateWindowParams) {
        super.preInit(xCreateWindowParams);
        if (!resize_request.isInterned()) {
            resize_request.intern(false);
        }
        this.winAttr.initialFocus = true;
        this.currentInsets = new Insets(0, 0, 0, 0);
        this.changeInsets();
        Rectangle rectangle = (Rectangle)xCreateWindowParams.get("bounds");
        this.dimensions = new WindowDimensions(rectangle, this.getRealInsets(), false);
        xCreateWindowParams.put("bounds", this.dimensions.getClientRect());
        insLog.log(Level.FINE, "Initial dimensions {0}", new Object[]{this.dimensions});
        Long l = (Long)xCreateWindowParams.get("event mask");
        xCreateWindowParams.add((Object)"event mask", l & 0xFFFFFFFFFFDFFFFCL);
    }

    @Override
    void postInit(XCreateWindowParams xCreateWindowParams) {
        super.postInit(xCreateWindowParams);
        this.initResizability();
        this.updateSizeHints(this.dimensions);
        this.content = this.createContent(this.dimensions);
        this.content.initialize();
        if (this.warningWindow != null) {
            this.warningWindow.toFront();
        }
        this.focusProxy = this.createFocusProxy();
    }

    @Override
    void setIconHints(List<XIconInfo> list) {
        ArrayList arrayList = new ArrayList();
        if (!XWM.getWM().setNetWMIcon(this, list) && list.size() > 0) {
            if (this.iconWindow == null) {
                this.iconWindow = new XIconWindow(this);
            }
            this.iconWindow.setIconImages(list);
        }
    }

    @Override
    public void updateMinimumSize() {
        super.updateMinimumSize();
        if (this.isResizable()) {
            Dimension dimension = this.getTargetMinimumSize();
            if (dimension != null) {
                Insets insets = this.getRealInsets();
                int n = dimension.width - insets.left - insets.right;
                int n2 = dimension.height - insets.top - insets.bottom;
                if (n < 0) {
                    n = 0;
                }
                if (n2 < 0) {
                    n2 = 0;
                }
                this.setSizeHints(0x10L | (this.isLocationByPlatform() ? 0L : 5L), this.getX(), this.getY(), n, n2);
                if (this.isVisible()) {
                    int n3;
                    Rectangle rectangle = this.getShellBounds();
                    int n4 = rectangle.width < n ? n : rectangle.width;
                    int n5 = n3 = rectangle.height < n2 ? n2 : rectangle.height;
                    if (n4 != rectangle.width || n3 != rectangle.height) {
                        this.setShellSize(new Rectangle(0, 0, n4, n3));
                    }
                }
            } else {
                boolean bl = this.isMinSizeSet();
                XWM.removeSizeHints(this, 16L);
                if (bl && this.isShowing() && XWM.needRemap(this)) {
                    this.xSetVisible(false);
                    XToolkit.XSync();
                    this.xSetVisible(true);
                }
            }
        }
    }

    XContentWindow createContent(WindowDimensions windowDimensions) {
        Rectangle rectangle = windowDimensions.getBounds();
        Insets insets = windowDimensions.getInsets();
        if (insets != null) {
            rectangle.x = -insets.left;
            rectangle.y = -insets.top;
        } else {
            rectangle.x = 0;
            rectangle.y = 0;
        }
        return new XContentWindow(this, rectangle);
    }

    XFocusProxyWindow createFocusProxy() {
        return new XFocusProxyWindow(this);
    }

    @Override
    protected XAtomList getWMProtocols() {
        XAtomList xAtomList = super.getWMProtocols();
        xAtomList.add(wm_delete_window);
        xAtomList.add(wm_take_focus);
        return xAtomList;
    }

    @Override
    public Graphics getGraphics() {
        return this.getGraphics(this.content.surfaceData, this.target.getForeground(), this.target.getBackground(), this.target.getFont());
    }

    public void setTitle(String string) {
        if (log.isLoggable(Level.FINE)) {
            log.fine("Title is " + string);
        }
        this.winAttr.title = string;
        this.updateWMName();
    }

    @Override
    protected String getWMName() {
        if (this.winAttr.title == null || this.winAttr.title.trim().equals("")) {
            return " ";
        }
        return this.winAttr.title;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void updateWMName() {
        super.updateWMName();
        String string = this.getWMName();
        XToolkit.awtLock();
        try {
            if (string == null || string.trim().equals("")) {
                string = "Java";
            }
            XAtom xAtom = XAtom.get(37L);
            xAtom.setProperty(this.getWindow(), string);
            XAtom xAtom2 = XAtom.get("_NET_WM_ICON_NAME");
            xAtom2.setPropertyUTF8(this.getWindow(), string);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            XToolkit.awtUnlock();
            throw throwable;
        }
        XToolkit.awtUnlock();
    }

    @Override
    public void handleIconify() {
        this.postEvent(new WindowEvent((Window)this.target, 203));
    }

    @Override
    public void handleDeiconify() {
        this.postEvent(new WindowEvent((Window)this.target, 204));
    }

    @Override
    public void handleFocusEvent(XEvent xEvent) {
        super.handleFocusEvent(xEvent);
        XFocusChangeEvent xFocusChangeEvent = xEvent.get_xfocus();
        if (xFocusChangeEvent.get_type() == 10 && xFocusChangeEvent.get_mode() == 1) {
            log.finer("Generating MOVED event due to a user grab on toplevel");
            this.postEvent(new ComponentEvent(this.target, 100));
        }
        focusLog.finer("Received focus event on shell: " + xFocusChangeEvent);
    }

    @Override
    protected boolean isInitialReshape() {
        return false;
    }

    Insets difference(Insets insets, Insets insets2) {
        return new Insets(insets.top - insets2.top, insets.left - insets2.left, insets.bottom - insets2.bottom, insets.right - insets2.right);
    }

    void add(Insets insets, Insets insets2) {
        insets.left += insets2.left;
        insets.top += insets2.top;
        insets.right += insets2.right;
        insets.bottom += insets2.bottom;
    }

    boolean isNull(Insets insets) {
        return insets == null || (insets.left | insets.top | insets.right | insets.bottom) == 0;
    }

    Insets copy(Insets insets) {
        return new Insets(insets.top, insets.left, insets.bottom, insets.right);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void handleReparentNotifyEvent(XEvent xEvent) {
        block15: {
            block16: {
                block14: {
                    XReparentEvent xReparentEvent = xEvent.get_xreparent();
                    if (insLog.isLoggable(Level.FINE)) {
                        insLog.fine(xReparentEvent.toString());
                    }
                    this.reparent_serial = xReparentEvent.get_serial();
                    XToolkit.awtLock();
                    try {
                        long l = XlibWrapper.RootWindow(XToolkit.getDisplay(), this.getScreenNumber());
                        if (this.isEmbedded()) {
                            this.setReparented(true);
                            this.insets_corrected = true;
                            Object var9_4 = null;
                            break block14;
                        }
                        Component component = this.target;
                        if (this.getDecorations() == XWindowAttributesData.AWT_DECOR_NONE) {
                            this.setReparented(true);
                            this.insets_corrected = true;
                            this.reshape(this.dimensions, 2, false);
                            break block15;
                        }
                        if (xReparentEvent.get_parent() == l) {
                            this.configure_seen = false;
                            this.insets_corrected = false;
                            if (this.isVisible()) {
                                XWM.getWM().unshadeKludge(this);
                                insLog.fine("- WM exited");
                                break block15;
                            } else {
                                insLog.fine(" - reparent due to hide");
                            }
                            break block15;
                        }
                        this.setReparented(true);
                        this.insets_corrected = false;
                        Insets insets = this.getWMSetInsets(null);
                        if (insets != null) {
                            insLog.log(Level.FINER, "wm-provided insets {0}", new Object[]{insets});
                            Insets insets2 = this.dimensions.getInsets();
                            if (insets.equals(insets2)) {
                                insLog.finer("Insets are the same as estimated - no additional reshapes necessary");
                                this.no_reparent_artifacts = true;
                                this.insets_corrected = true;
                                this.changeInsets();
                                break block16;
                            }
                        } else {
                            insets = XWM.getWM().getInsets(this, xReparentEvent.get_window(), xReparentEvent.get_parent());
                            if (insets != null) {
                                insLog.log(Level.FINER, "correctWM {0}", new Object[]{insets});
                            } else {
                                insLog.log(Level.FINER, "correctWM insets are not available, waiting for configureNotify");
                            }
                        }
                        if (insets != null) {
                            this.handleCorrectInsets(insets);
                        }
                        break block15;
                    }
                    catch (Throwable throwable) {
                        Object var9_7 = null;
                        XToolkit.awtUnlock();
                        throw throwable;
                    }
                }
                XToolkit.awtUnlock();
                return;
            }
            Object var9_5 = null;
            XToolkit.awtUnlock();
            return;
        }
        Object var9_6 = null;
        XToolkit.awtUnlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void handleCorrectInsets(Insets insets) {
        block8: {
            block7: {
                XToolkit.awtLock();
                try {
                    Insets insets2 = this.difference(insets, this.currentInsets);
                    insLog.log(Level.FINEST, "Corrention {0}", new Object[]{insets2});
                    if (!this.isNull(insets2)) {
                        this.add(this.currentInsets, insets2);
                        this.changeInsets();
                        this.updateMinimumSize();
                    }
                    if (insLog.isLoggable(Level.FINER)) {
                        insLog.finer("Dimensions before reparent: " + this.dimensions);
                    }
                    this.dimensions.setInsets(this.getRealInsets());
                    this.insets_corrected = true;
                    if (this.isMaximized()) {
                        Object var4_3 = null;
                        break block7;
                    }
                    if ((this.getHints().get_flags() & 5L) != 0L) {
                        this.reshape(this.dimensions, 3, false);
                        break block8;
                    } else {
                        this.reshape(this.dimensions, 2, false);
                    }
                    break block8;
                }
                catch (Throwable throwable) {
                    Object var4_5 = null;
                    XToolkit.awtUnlock();
                    throw throwable;
                }
            }
            XToolkit.awtUnlock();
            return;
        }
        Object var4_4 = null;
        XToolkit.awtUnlock();
    }

    public void handleMoved(WindowDimensions windowDimensions) {
        Point point = windowDimensions.getLocation();
        ComponentAccessor.setX(this.target, point.x);
        ComponentAccessor.setY(this.target, point.y);
        this.postEvent(new ComponentEvent(this.target, 100));
    }

    protected Insets guessInsets() {
        if (this.isEmbedded()) {
            return new Insets(0, 0, 0, 0);
        }
        if (this.currentInsets.top > 0) {
            return this.copy(this.currentInsets);
        }
        Insets insets = this.getWMSetInsets(null);
        if (insets == null) {
            insets = XWM.getWM().guessInsets(this);
        }
        return insets;
    }

    void changeInsets() {
        Insets insets = this.guessInsets();
        this.currentInsets = this.copy(insets);
        this.insets = this.copy(this.currentInsets);
    }

    public void revalidate() {
        XToolkit.executeOnEventHandlerThread(this.target, new Runnable(){

            public void run() {
                XDecoratedPeer.this.target.invalidate();
                XDecoratedPeer.this.target.validate();
            }
        });
    }

    Insets getRealInsets() {
        if (this.isNull(this.insets)) {
            this.changeInsets();
        }
        return this.insets;
    }

    @Override
    public Insets getInsets() {
        Insets insets = this.copy(this.getRealInsets());
        insets.top += this.getMenuBarHeight();
        if (insLog.isLoggable(Level.FINEST)) {
            insLog.log(Level.FINEST, "Get insets returns {0}", new Object[]{insets});
        }
        return insets;
    }

    boolean gravityBug() {
        return XWM.configureGravityBuggy();
    }

    int getInputMethodHeight() {
        return 0;
    }

    void updateSizeHints(WindowDimensions windowDimensions) {
        Rectangle rectangle = windowDimensions.getClientRect();
        this.checkShellRect(rectangle);
        this.updateSizeHints(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    @Override
    void updateSizeHints() {
        this.updateSizeHints(this.dimensions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void reshape(WindowDimensions windowDimensions, int n, boolean bl) {
        block22: {
            block20: {
                Cloneable cloneable;
                Cloneable cloneable2;
                Cloneable cloneable3;
                if (insLog.isLoggable(Level.FINE)) {
                    insLog.fine("Reshaping " + this + " to " + windowDimensions + " op " + n + " user reshape " + bl);
                }
                if (bl) {
                    cloneable3 = windowDimensions.getBounds();
                    cloneable2 = this.constrainBounds(cloneable3.x, cloneable3.y, cloneable3.width, cloneable3.height);
                    if (!((Rectangle)cloneable2).equals(cloneable3)) {
                        if (windowDimensions.isClientSizeSet()) {
                            cloneable = windowDimensions.getInsets();
                            windowDimensions = new WindowDimensions(new Rectangle(((Rectangle)cloneable2).x + cloneable.left, ((Rectangle)cloneable2).y + cloneable.top, ((Rectangle)cloneable2).width - (cloneable.left + cloneable.right), ((Rectangle)cloneable2).height - (cloneable.top + cloneable.bottom)), windowDimensions.getInsets(), true);
                        } else {
                            windowDimensions = new WindowDimensions((Rectangle)cloneable2, windowDimensions.getInsets(), false);
                        }
                    }
                }
                XToolkit.awtLock();
                try {
                    if (!this.isReparented() || !this.isVisible()) {
                        insLog.log(Level.FINE, "- not reparented({0}) or not visible({1}), default reshape", new Object[]{this.isReparented(), this.visible});
                        cloneable3 = this.getLocation();
                        cloneable2 = new Point(ComponentAccessor.getX(this.target), ComponentAccessor.getY(this.target));
                        if (!((Point)cloneable2).equals(cloneable3)) {
                            this.handleMoved(windowDimensions);
                        }
                        this.dimensions = new WindowDimensions(windowDimensions);
                        this.updateSizeHints(this.dimensions);
                        cloneable = this.dimensions.getClientRect();
                        this.checkShellRect((Rectangle)cloneable);
                        this.setShellBounds((Rectangle)cloneable);
                        if (this.content != null && !this.content.getSize().equals(windowDimensions.getSize())) {
                            this.reconfigureContentWindow(windowDimensions);
                        }
                        Object var8_8 = null;
                        break block20;
                    }
                    int n2 = XWM.getWMID();
                    this.updateChildrenSizes();
                    this.changeInsets();
                    cloneable2 = windowDimensions.getClientRect();
                    if (this.gravityBug()) {
                        cloneable = windowDimensions.getInsets();
                        ((Rectangle)cloneable2).translate(cloneable.left, cloneable.top);
                    }
                    if ((n & 0x4000) == 0 && this.isEmbedded()) {
                        ((Rectangle)cloneable2).setLocation(0, 0);
                    }
                    this.checkShellRectSize((Rectangle)cloneable2);
                    if (!this.isEmbedded()) {
                        this.checkShellRectPos((Rectangle)cloneable2);
                    }
                    if ((n &= 0xFFFFBFFF) == 1) {
                        this.setShellPosition((Rectangle)cloneable2);
                    } else if (this.isResizable()) {
                        if (n == 3) {
                            this.setShellBounds((Rectangle)cloneable2);
                        } else {
                            this.setShellSize((Rectangle)cloneable2);
                        }
                    } else {
                        XWM.setShellNotResizable(this, windowDimensions, (Rectangle)cloneable2, true);
                        if (n == 3) {
                            this.setShellPosition((Rectangle)cloneable2);
                        }
                    }
                    this.reconfigureContentWindow(windowDimensions);
                    break block22;
                }
                catch (Throwable throwable) {
                    Object var8_10 = null;
                    XToolkit.awtUnlock();
                    throw throwable;
                }
            }
            XToolkit.awtUnlock();
            return;
        }
        Object var8_9 = null;
        XToolkit.awtUnlock();
    }

    private void reshape(int n, int n2, int n3, int n4, int n5, boolean bl) {
        boolean bl2 = false;
        WindowDimensions windowDimensions = new WindowDimensions(this.dimensions);
        switch (n5 & 0xFFFFBFFF) {
            case 1: {
                windowDimensions.setLocation(n, n2);
                break;
            }
            case 2: {
                windowDimensions.setSize(n3, n4);
                break;
            }
            case 4: {
                Insets insets = this.currentInsets;
                windowDimensions.setClientSize(n3 -= insets.left + insets.right, n4 -= insets.top + insets.bottom);
                break;
            }
            default: {
                windowDimensions.setLocation(n, n2);
                windowDimensions.setSize(n3, n4);
            }
        }
        if (insLog.isLoggable(Level.FINE)) {
            insLog.log(Level.FINE, "For the operation {0} new dimensions are {1}", new Object[]{XDecoratedPeer.operationToString(n5), windowDimensions});
        }
        this.reshape(windowDimensions, n5, bl);
    }

    abstract boolean isTargetUndecorated();

    @Override
    Rectangle constrainBounds(int n, int n2, int n3, int n4) {
        if (!this.hasWarningWindow()) {
            return new Rectangle(n, n2, n3, n4);
        }
        if (!this.isVisible() || this.isTargetUndecorated()) {
            return super.constrainBounds(n, n2, n3, n4);
        }
        int n5 = n;
        int n6 = n2;
        int n7 = n3;
        int n8 = n4;
        GraphicsConfiguration graphicsConfiguration = ((Window)this.target).getGraphicsConfiguration();
        Rectangle rectangle = graphicsConfiguration.getBounds();
        Insets insets = ((Window)this.target).getToolkit().getScreenInsets(graphicsConfiguration);
        Rectangle rectangle2 = this.getBounds();
        int n9 = Math.max(rectangle.width - insets.left - insets.right, rectangle2.width);
        int n10 = Math.max(rectangle.height - insets.top - insets.bottom, rectangle2.height);
        if (n7 > n9) {
            n7 = n9;
        }
        if (n8 > n10) {
            n8 = n10;
        }
        return new Rectangle(n5, n6, n7, n8);
    }

    @Override
    public void setBounds(int n, int n2, int n3, int n4, int n5) {
        this.reshape(n, n2, n3, n4, n5, true);
        this.validateSurface();
    }

    void reconfigureContentWindow(WindowDimensions windowDimensions) {
        if (this.content == null) {
            insLog.fine("WARNING: Content window is null");
            return;
        }
        this.content.setContentBounds(windowDimensions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void handleConfigureNotifyEvent(XEvent xEvent) {
        block24: {
            block23: {
                XConfigureEvent xConfigureEvent = xEvent.get_xconfigure();
                insLog.log(Level.FINE, "Configure notify {0}", new Object[]{xConfigureEvent});
                if (this.isReparented()) {
                    this.configure_seen = true;
                }
                if (!(this.isMaximized() || xConfigureEvent.get_serial() != this.reparent_serial && xConfigureEvent.get_window() == this.getShell() || this.no_reparent_artifacts)) {
                    insLog.fine("- reparent artifact, skipping");
                    return;
                }
                this.no_reparent_artifacts = false;
                if (!this.isVisible() && XWM.getWMID() != 2) {
                    insLog.fine(" - not visible, skipping");
                    return;
                }
                XToolkit.awtLock();
                try {
                    Rectangle rectangle;
                    Object object;
                    int n = XWM.getWMID();
                    insLog.log(Level.FINE, "reparented={0}, visible={1}, WM={2}, decorations={3}", new Object[]{this.isReparented(), this.isVisible(), n, this.getDecorations()});
                    if (!this.isReparented() && this.isVisible() && n != 2 && !XWM.isNonReparentingWM()) {
                        if (this.getDecorations() != XWindowAttributesData.AWT_DECOR_NONE) {
                            insLog.fine("- visible but not reparented, skipping");
                            Object var11_4 = null;
                            break block23;
                        }
                    }
                    if (!this.insets_corrected) {
                        if (this.getDecorations() != XWindowAttributesData.AWT_DECOR_NONE) {
                            long l = -1L;
                            object = new XQueryTree(this.window);
                            try {
                                ((XQueryTree)object).execute();
                                l = ((XQueryTree)object).get_parent();
                                Object var9_10 = null;
                                ((XQueryTree)object).dispose();
                            }
                            catch (Throwable throwable) {
                                Object var9_11 = null;
                                ((XQueryTree)object).dispose();
                                throw throwable;
                            }
                            Cloneable cloneable = rectangle = l != -1L ? XWM.getWM().getInsets(this, this.window, l) : null;
                            if (insLog.isLoggable(Level.FINER)) {
                                if (rectangle != null) {
                                    insLog.finer("Configure notify - insets : " + rectangle);
                                } else {
                                    insLog.finer("Configure notify - insets are still not available");
                                }
                            }
                            if (rectangle != null) {
                                this.handleCorrectInsets((Insets)((Object)rectangle));
                            } else {
                                this.insets_corrected = true;
                            }
                        }
                    }
                    this.updateChildrenSizes();
                    rectangle = new Rectangle(ComponentAccessor.getX(this.target), ComponentAccessor.getY(this.target), ComponentAccessor.getWidth(this.target), ComponentAccessor.getHeight(this.target));
                    WindowDimensions windowDimensions = new WindowDimensions(rectangle, this.copy(this.currentInsets), false);
                    Object object2 = rectangle.getLocation();
                    if (xConfigureEvent.get_send_event()) {
                        object2 = new Point(xConfigureEvent.get_x() - this.currentInsets.left, xConfigureEvent.get_y() - this.currentInsets.top);
                    } else {
                        switch (XWM.getWMID()) {
                            case 5: 
                            case 6: 
                            case 9: 
                            case 11: 
                            case 12: 
                            case 13: {
                                object = this.queryXLocation();
                                if (log.isLoggable(Level.FINE)) {
                                    log.log(Level.FINE, "New X location: {0}", new Object[]{object});
                                }
                                if (object == null) break;
                                object2 = object;
                                break;
                            }
                        }
                    }
                    object = new WindowDimensions((Point)object2, new Dimension(xConfigureEvent.get_width(), xConfigureEvent.get_height()), this.copy(this.currentInsets), true);
                    insLog.log(Level.FINER, "Insets are {0}, new dimensions {1}", new Object[]{this.currentInsets, object});
                    this.checkIfOnNewScreen(((WindowDimensions)object).getBounds());
                    Point point = this.getLocation();
                    this.dimensions = object;
                    if (!((Point)object2).equals(point)) {
                        this.handleMoved((WindowDimensions)object);
                    }
                    this.reconfigureContentWindow((WindowDimensions)object);
                    this.updateChildrenSizes();
                    break block24;
                }
                catch (Throwable throwable) {
                    Object var11_6 = null;
                    XToolkit.awtUnlock();
                    throw throwable;
                }
            }
            XToolkit.awtUnlock();
            return;
        }
        Object var11_5 = null;
        XToolkit.awtUnlock();
        this.repositionSecurityWarning();
    }

    private void checkShellRectSize(Rectangle rectangle) {
        if (rectangle.width < 0) {
            rectangle.width = 1;
        }
        if (rectangle.height < 0) {
            rectangle.height = 1;
        }
    }

    private void checkShellRectPos(Rectangle rectangle) {
        int n = XWM.getWMID();
        if ((n == 5 || n == 6) && rectangle.x == 0 && rectangle.y == 0) {
            rectangle.y = 1;
            rectangle.x = 1;
        }
    }

    private void checkShellRect(Rectangle rectangle) {
        this.checkShellRectSize(rectangle);
        this.checkShellRectPos(rectangle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setShellBounds(Rectangle rectangle) {
        if (insLog.isLoggable(Level.FINE)) {
            insLog.fine("Setting shell bounds on " + this + " to " + rectangle);
        }
        XToolkit.awtLock();
        try {
            this.updateSizeHints(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            XlibWrapper.XResizeWindow(XToolkit.getDisplay(), this.getShell(), rectangle.width, rectangle.height);
            XlibWrapper.XMoveWindow(XToolkit.getDisplay(), this.getShell(), rectangle.x, rectangle.y);
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            XToolkit.awtUnlock();
            throw throwable;
        }
        XToolkit.awtUnlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setShellSize(Rectangle rectangle) {
        if (insLog.isLoggable(Level.FINE)) {
            insLog.fine("Setting shell size on " + this + " to " + rectangle);
        }
        XToolkit.awtLock();
        try {
            this.updateSizeHints(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            XlibWrapper.XResizeWindow(XToolkit.getDisplay(), this.getShell(), rectangle.width, rectangle.height);
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            XToolkit.awtUnlock();
            throw throwable;
        }
        XToolkit.awtUnlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setShellPosition(Rectangle rectangle) {
        if (insLog.isLoggable(Level.FINE)) {
            insLog.fine("Setting shell position on " + this + " to " + rectangle);
        }
        XToolkit.awtLock();
        try {
            this.updateSizeHints(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            XlibWrapper.XMoveWindow(XToolkit.getDisplay(), this.getShell(), rectangle.x, rectangle.y);
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            XToolkit.awtUnlock();
            throw throwable;
        }
        XToolkit.awtUnlock();
    }

    void initResizability() {
        this.setResizable(this.winAttr.initialResizability);
    }

    public void setResizable(boolean bl) {
        int n = this.winAttr.functions;
        if (!this.isResizable() && bl) {
            this.insets = this.currentInsets = new Insets(0, 0, 0, 0);
            this.resetWMSetInsets();
            if (!this.isEmbedded()) {
                this.setReparented(false);
            }
            this.winAttr.isResizable = bl;
            n = (n & 1) != 0 ? (n &= 0xFFFFFFED) : (n |= 0x12);
            this.winAttr.functions = n;
            XWM.setShellResizable(this);
        } else if (this.isResizable() && !bl) {
            this.insets = this.currentInsets = new Insets(0, 0, 0, 0);
            this.resetWMSetInsets();
            if (!this.isEmbedded()) {
                this.setReparented(false);
            }
            this.winAttr.isResizable = bl;
            n = (n & 1) != 0 ? (n |= 0x12) : (n &= 0xFFFFFFED);
            this.winAttr.functions = n;
            XWM.setShellNotResizable(this, this.dimensions, this.dimensions.getScreenBounds(), false);
        }
    }

    Rectangle getShellBounds() {
        return this.dimensions.getClientRect();
    }

    @Override
    public Rectangle getBounds() {
        return this.dimensions.getBounds();
    }

    @Override
    public Dimension getSize() {
        return this.dimensions.getSize();
    }

    @Override
    public int getX() {
        return this.dimensions.getLocation().x;
    }

    @Override
    public int getY() {
        return this.dimensions.getLocation().y;
    }

    public Point getLocation() {
        return this.dimensions.getLocation();
    }

    @Override
    public int getAbsoluteX() {
        return this.dimensions.getScreenBounds().x;
    }

    @Override
    public int getAbsoluteY() {
        return this.dimensions.getScreenBounds().y;
    }

    @Override
    public int getWidth() {
        return this.getSize().width;
    }

    @Override
    public int getHeight() {
        return this.getSize().height;
    }

    public WindowDimensions getDimensions() {
        return this.dimensions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Point getLocationOnScreen() {
        block4: {
            Point point;
            XToolkit.awtLock();
            try {
                if (!this.configure_seen) break block4;
                point = this.toGlobal(0, 0);
                Object var4_3 = null;
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                XToolkit.awtUnlock();
                throw throwable;
            }
            XToolkit.awtUnlock();
            return point;
        }
        Point point = this.target.getLocation();
        if (insLog.isLoggable(Level.FINE)) {
            insLog.log(Level.FINE, "getLocationOnScreen {0} not reparented: {1} ", new Object[]{this, point});
        }
        Point point2 = point;
        Object var4_4 = null;
        XToolkit.awtUnlock();
        return point2;
    }

    @Override
    protected boolean isEventDisabled(XEvent xEvent) {
        switch (xEvent.get_type()) {
            case 22: {
                return true;
            }
            case 7: 
            case 8: {
                return true;
            }
        }
        return super.isEventDisabled(xEvent);
    }

    int getDecorations() {
        return this.winAttr.decorations;
    }

    int getFunctions() {
        return this.winAttr.functions;
    }

    @Override
    public void setVisible(boolean bl) {
        log.log(Level.FINER, "Setting {0} to visible {1}", new Object[]{this, bl});
        if (bl && !this.isVisible()) {
            XWM.setShellDecor(this);
            super.setVisible(bl);
            if (this.winAttr.isResizable) {
                XWM.removeSizeHints(this, 32L);
                this.updateMinimumSize();
            }
        } else {
            super.setVisible(bl);
        }
    }

    @Override
    public void dispose() {
        if (this.content != null) {
            this.content.destroy();
        }
        this.focusProxy.destroy();
        if (this.iconWindow != null) {
            this.iconWindow.destroy();
        }
        super.dispose();
    }

    @Override
    public void handleClientMessage(XEvent xEvent) {
        super.handleClientMessage(xEvent);
        XClientMessageEvent xClientMessageEvent = xEvent.get_xclient();
        if (wm_protocols != null && xClientMessageEvent.get_message_type() == wm_protocols.getAtom()) {
            if (xClientMessageEvent.get_data(0) == wm_delete_window.getAtom()) {
                this.handleQuit();
            } else if (xClientMessageEvent.get_data(0) == wm_take_focus.getAtom()) {
                this.handleWmTakeFocus(xClientMessageEvent);
            }
        } else if (xClientMessageEvent.get_message_type() == resize_request.getAtom()) {
            this.reshape((int)xClientMessageEvent.get_data(0), (int)xClientMessageEvent.get_data(1), (int)xClientMessageEvent.get_data(2), (int)xClientMessageEvent.get_data(3), (int)xClientMessageEvent.get_data(4), true);
        }
    }

    private void handleWmTakeFocus(XClientMessageEvent xClientMessageEvent) {
        focusLog.log(Level.FINE, "WM_TAKE_FOCUS on {0}", new Object[]{this});
        XWindowPeer xWindowPeer = this.requestXFocusGently(xClientMessageEvent.get_data(1));
        if (xWindowPeer != null) {
            focusLog.log(Level.FINE, "WM_TAKE_FOCUS accepted focus on {0}", new Object[]{xWindowPeer});
        }
    }

    @Override
    protected void requestXFocus(long l, boolean bl) {
        if (this.focusProxy == null) {
            if (focusLog.isLoggable(Level.FINE)) {
                focusLog.warning("Focus proxy is null for " + this);
            }
        } else {
            if (focusLog.isLoggable(Level.FINE)) {
                focusLog.fine("Requesting focus to proxy: " + this.focusProxy);
            }
            if (bl) {
                this.focusProxy.xRequestFocus(l);
            } else {
                this.focusProxy.xRequestFocus();
            }
        }
    }

    XFocusProxyWindow getFocusProxy() {
        return this.focusProxy;
    }

    public void handleQuit() {
        this.postEvent(new WindowEvent((Window)this.target, 201));
    }

    final void dumpMe() {
        System.err.println(">>> Peer: " + this.x + ", " + this.y + ", " + this.width + ", " + this.height);
    }

    final void dumpTarget() {
        int n = ComponentAccessor.getWidth(this.target);
        int n2 = ComponentAccessor.getHeight(this.target);
        int n3 = ComponentAccessor.getX(this.target);
        int n4 = ComponentAccessor.getY(this.target);
        System.err.println(">>> Target: " + n3 + ", " + n4 + ", " + n + ", " + n2);
    }

    final void dumpShell() {
        this.dumpWindow("Shell", this.getShell());
    }

    final void dumpContent() {
        this.dumpWindow("Content", this.getContentWindow());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void dumpParent() {
        XQueryTree xQueryTree = new XQueryTree(this.getShell());
        try {
            xQueryTree.execute();
            if (xQueryTree.get_parent() != 0L) {
                this.dumpWindow("Parent", xQueryTree.get_parent());
            } else {
                System.err.println(">>> NO PARENT");
            }
            Object var3_2 = null;
            xQueryTree.dispose();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            xQueryTree.dispose();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void dumpWindow(String string, long l) {
        XWindowAttributes xWindowAttributes = new XWindowAttributes();
        try {
            XToolkit.awtLock();
            try {
                int n = XlibWrapper.XGetWindowAttributes(XToolkit.getDisplay(), l, xWindowAttributes.pData);
                Object var7_5 = null;
            }
            catch (Throwable throwable) {
                Object var7_6 = null;
                XToolkit.awtUnlock();
                throw throwable;
            }
            XToolkit.awtUnlock();
            System.err.println(">>>> " + string + ": " + xWindowAttributes.get_x() + ", " + xWindowAttributes.get_y() + ", " + xWindowAttributes.get_width() + ", " + xWindowAttributes.get_height());
            Object var9_8 = null;
            xWindowAttributes.dispose();
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            xWindowAttributes.dispose();
            throw throwable;
        }
    }

    final void dumpAll() {
        this.dumpTarget();
        this.dumpMe();
        this.dumpParent();
        this.dumpShell();
        this.dumpContent();
    }

    boolean isMaximized() {
        return false;
    }

    @Override
    boolean isOverrideRedirect() {
        return false;
    }

    @Override
    public boolean requestWindowFocus() {
        focusLog.fine("Request for decorated window focus");
        Window window = (Window)this.target;
        focusLog.log(Level.FINER, "Current window is: active={0}, focused={1}", new Object[]{window.isActive(), window.isFocused()});
        if (this.focusAllowedFor()) {
            if (window.isActive() && !window.isFocused()) {
                focusLog.fine("Focus is on child window - transfering it back");
                this.handleWindowFocusInSync(-1L);
            } else {
                focusLog.fine("Requesting focus to this top-level");
                ((XWindowPeer)this.target.getPeer()).requestXFocus();
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void setActualFocusedWindow(XWindowPeer xWindowPeer) {
        Object object = this.getStateLock();
        synchronized (object) {
            this.actualFocusedWindow = xWindowPeer;
        }
    }

    boolean requestWindowFocus(XWindowPeer xWindowPeer) {
        this.setActualFocusedWindow(xWindowPeer);
        return this.requestWindowFocus();
    }

    @Override
    public void handleWindowFocusIn(long l) {
        super.handleWindowFocusIn(l);
        if (this.actualFocusedWindow != null) {
            this.postEvent(new InvocationEvent((Object)this.target, new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    XWindowPeer xWindowPeer = null;
                    Object object = XDecoratedPeer.this.getStateLock();
                    synchronized (object) {
                        xWindowPeer = XDecoratedPeer.this.actualFocusedWindow;
                        XDecoratedPeer.this.actualFocusedWindow = null;
                    }
                    if (xWindowPeer != null && xWindowPeer.isVisible()) {
                        xWindowPeer.handleWindowFocusIn_Dispatch();
                    }
                }
            }));
        }
    }

    @Override
    public void handleWindowFocusOut(Window window, long l) {
        Window window2 = XKeyboardFocusManagerPeer.getCurrentNativeFocusedWindow();
        if (window2 != null && window2 != this.target) {
            Window window3;
            for (window3 = window2.getOwner(); window3 != null && !(window3 instanceof Frame) && !(window3 instanceof Dialog); window3 = window3.getOwner()) {
            }
            if (window3 != null && window3 == this.target) {
                this.setActualFocusedWindow((XWindowPeer)window2.getPeer());
            }
        }
        super.handleWindowFocusOut(window, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Point queryXLocation() {
        XToolkit.awtLock();
        try {
            XTranslateCoordinates xTranslateCoordinates;
            block5: {
                Point point;
                xTranslateCoordinates = new XTranslateCoordinates(this.getContentWindow(), XlibWrapper.RootWindow(XToolkit.getDisplay(), this.getScreenNumber()), 0, 0);
                try {
                    if (xTranslateCoordinates.execute() == 0) break block5;
                    point = new Point(xTranslateCoordinates.get_dest_x(), xTranslateCoordinates.get_dest_y());
                    Object var4_4 = null;
                    xTranslateCoordinates.dispose();
                }
                catch (Throwable throwable) {
                    Object var4_6 = null;
                    xTranslateCoordinates.dispose();
                    throw throwable;
                }
                Object var6_7 = null;
                XToolkit.awtUnlock();
                return point;
            }
            Point point = null;
            Object var4_5 = null;
            xTranslateCoordinates.dispose();
            Object var6_8 = null;
            XToolkit.awtUnlock();
            return point;
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            XToolkit.awtUnlock();
            throw throwable;
        }
    }
}

