/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.config;

import com.sun.deploy.config.Config;
import com.sun.deploy.net.proxy.NSPreferences;
import com.sun.deploy.panel.PlatformSpecificUtils;
import com.sun.deploy.util.SearchPath;
import com.sun.deploy.util.Trace;
import com.sun.deploy.util.TraceLevel;
import java.io.File;
import java.io.IOException;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Vector;
import sun.security.action.GetPropertyAction;

public class UnixConfig
extends Config {
    private String _userHome;
    private String _systemHome;
    private String _osHome;
    private static final int ARGS_LIST_CAPACITY = 32;
    private static final int ARG_CAPACITY = 64;
    private static final char BACKSLASH = '\\';
    private static final char SINGLE_QUOTE = '\'';
    private static final char DOUBLE_QUOTE = '\"';
    private static final char TAB = '\t';
    private static final char LINEFEED = '\n';
    private static final char RETURN = '\r';
    private static final char SPACE = ' ';

    public void loadDeployNativeLib() {
        try {
            String string = System.getProperty("os.arch");
            if (string.equals("x86")) {
                string = "i386";
            }
            System.load(Config.getJavaHome() + File.separator + "lib" + File.separator + string + File.separator + "libdeploy.so");
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            // empty catch block
        }
    }

    public String escapeBackslashAndQuoteString(String string) {
        return string;
    }

    public String getPlatformUserHome() {
        if (this._userHome == null) {
            String string = AccessController.doPrivileged(new GetPropertyAction("javaplugin.user.profile"));
            if (string == null || string.trim().equals("")) {
                string = AccessController.doPrivileged(new GetPropertyAction("user.home"));
            }
            this._userHome = string + (string.endsWith(File.separator) ? "" : File.separator) + ".java" + File.separator + "deployment";
        }
        return this._userHome;
    }

    public String getPlatformSystemHome() {
        if (this._systemHome == null) {
            this._systemHome = File.separator + "etc" + File.separator + ".java" + File.separator + "deployment";
        }
        return this._systemHome;
    }

    public String getPlatformOSHome() {
        if (this._osHome == null) {
            this._osHome = File.separator + "etc";
        }
        return this._osHome;
    }

    public String getPlatformExtension() {
        return "";
    }

    public String getLibraryPrefix() {
        return "lib";
    }

    public String getLibrarySufix() {
        return ".so";
    }

    public boolean useAltFileSystemView() {
        return false;
    }

    public boolean isLocalInstallSupported() {
        return UnixConfig.getEnv("GNOME_DESKTOP_SESSION_ID") != null;
    }

    public boolean systemLookAndFeelDefault() {
        return UnixConfig.getEnv("GNOME_DESKTOP_SESSION_ID") != null && UnixConfig.isJavaVersionAtLeast15();
    }

    public String getSessionSpecificString() {
        String string = UnixConfig.getEnv("DISPLAY");
        if (string != null) {
            return string;
        }
        return "";
    }

    public String getPlatformSpecificJavaName() {
        return "java";
    }

    public static native String getEnv(String var0);

    public String getBrowserPath() {
        File file;
        String string = UnixConfig.getProperty("deployment.browser.path");
        if (string != null && string.length() > 0 && !(file = new File(string)).exists()) {
            string = null;
        }
        if ((string == null || string.length() == 0) && (file = SearchPath.findOne(UnixConfig.getEnv("PATH"))) != null) {
            string = file.getAbsolutePath();
        }
        return string;
    }

    public String getFireFoxUserProfileDirectory() {
        return this.getMozillaUserProfileDirectory();
    }

    public String getMozillaUserProfileDirectory() {
        String string = null;
        try {
            String string2 = System.getProperty("user.home");
            File file = new File(string2 + "/.mozilla/appreg");
            if (file.exists()) {
                string = NSPreferences.getNS6UserProfileDirectory(file);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return string;
    }

    public boolean showDocument(String string) {
        File file;
        String string2 = this.getBrowserPath();
        boolean bl = false;
        if (string2 != null && !string2.equals("") && (file = new File(string2)).exists()) {
            String[] stringArray = null;
            Process process = null;
            stringArray = UnixConfig.getExtendedBrowserArgs(file, string);
            if (stringArray != null) {
                try {
                    Trace.println("Invoking browser with: \n     " + UnixConfig.argsFromArray(stringArray), TraceLevel.BASIC);
                    process = Runtime.getRuntime().exec(stringArray);
                    int n = process.waitFor();
                    if (n == 0) {
                        bl = true;
                    }
                }
                catch (IOException iOException) {
                    Trace.ignoredException(iOException);
                }
                catch (InterruptedException interruptedException) {
                    Trace.ignoredException(interruptedException);
                }
            }
            if (!bl) {
                try {
                    stringArray = UnixConfig.getBasicBrowserArgs(file, string);
                    Trace.println("Invoking browser with: \n     " + UnixConfig.argsFromArray(stringArray), TraceLevel.BASIC);
                    process = Runtime.getRuntime().exec(stringArray);
                    bl = process != null;
                }
                catch (IOException iOException) {
                    Trace.ignoredException(iOException);
                }
            }
        }
        return bl;
    }

    public static String argsFromArray(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer(2048);
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuffer.append(stringArray[i]).append(' ');
        }
        return stringBuffer.toString().trim();
    }

    public static String[] argsFromString(String string) {
        ArrayList<String> arrayList = new ArrayList<String>(32);
        StringBuffer stringBuffer = new StringBuffer(64);
        boolean bl = false;
        boolean bl2 = false;
        int n = 0;
        String[] stringArray = new String[]{};
        if (string != null) {
            n = string.length();
        }
        block6: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\\': {
                    if (++i >= n) continue block6;
                    stringBuffer.append(string.charAt(i));
                    continue block6;
                }
                case '\'': {
                    if (bl) {
                        stringBuffer.append(c);
                    }
                    bl2 = !bl2;
                    continue block6;
                }
                case '\"': {
                    if (bl2) {
                        stringBuffer.append(c);
                    }
                    bl = !bl;
                    continue block6;
                }
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    if (bl2 || bl) {
                        stringBuffer.append(c);
                        continue block6;
                    }
                    if (stringBuffer.length() <= 0) continue block6;
                    arrayList.add(stringBuffer.toString());
                    stringBuffer.delete(0, stringBuffer.length());
                    continue block6;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
        }
        if (stringBuffer.length() > 0) {
            arrayList.add(stringBuffer.toString());
        }
        return arrayList.toArray(stringArray);
    }

    private static String[] getBasicBrowserArgs(File file, String string) {
        String[] stringArray = new String[]{file.getAbsolutePath(), string};
        return stringArray;
    }

    private static String[] getExtendedBrowserArgs(File file, String string) {
        boolean bl = false;
        String[] stringArray = UnixConfig.argsFromString(UnixConfig.getProperty("deployment.browser.args"));
        String[] stringArray2 = null;
        for (int i = 0; i < stringArray.length; ++i) {
            int n = 0;
            int n2 = -1;
            n2 = stringArray[i].indexOf("%u", n);
            while (n2 >= 0) {
                stringArray[i] = stringArray[i].substring(n, n2) + string + stringArray[i].substring(n2 + 2);
                n = n2 + 2;
                n2 = stringArray[i].indexOf("%u", n);
                bl = true;
            }
        }
        if (bl) {
            stringArray2 = new String[stringArray.length + 1];
            System.arraycopy(stringArray, 0, stringArray2, 1, stringArray.length);
            stringArray2[0] = file.getAbsolutePath();
        }
        return stringArray2;
    }

    public String getDebugJavaPath(String string) {
        return string;
    }

    public boolean isPlatformIconType(String string) {
        return this.isLocalInstallSupported() && (string.toLowerCase().endsWith(".png") || string.toLowerCase().endsWith(".ico"));
    }

    public Vector getInstalledJREList() {
        return PlatformSpecificUtils.getPublicJres();
    }

    public String getBrowserHomePath() {
        return System.getenv("MOZILLA_HOME");
    }

    protected native int getPlatformMaxCommandLineLength();

    protected native long getPlatformPID();

    static {
        Config.getInstance().loadDeployNativeLib();
    }
}

