/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin.util;

import com.sun.deploy.cache.MemoryCache;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.security.TrustDecider;
import com.sun.deploy.ui.AppInfo;
import com.sun.deploy.ui.UIFactory;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.Rectangle2D;
import java.util.HashSet;
import java.util.Iterator;
import javax.swing.JPanel;
import sun.plugin.JavaRunTime;
import sun.plugin.util.ErrorDelegate;

public class ErrorPanel
extends JPanel
implements MouseListener,
ActionListener {
    private Image errorImage = null;
    private static final String ERROR_IMAGE_FILE = "sun/plugin/util/graybox_error.png";
    private static final Color ERROR_BORDER = new Color(204, 204, 204);
    private Color bg_color;
    private Color fg_color;
    private PopupMenu popup;
    private MenuItem open_console;
    private MenuItem about_java;
    private MenuItem reload;
    private Container parent = null;
    private ErrorDelegate errorDelegate;
    private boolean deniedCertificateFailure = false;

    public ErrorPanel(Color color, Color color2, Container container, ErrorDelegate errorDelegate) {
        this.parent = container;
        this.errorDelegate = errorDelegate;
        this.bg_color = color;
        this.fg_color = color2;
        this.setToolTipText(ResourceManager.getMessage((String)"applet.error.message"));
        this.addMouseListener(this);
        this.deniedCertificateFailure = this.deniedCertificateFailure();
        if (this.deniedCertificateFailure) {
            MemoryCache.clearLoadedResources();
            TrustDecider.resetDenyStore();
        }
    }

    private synchronized Image getErrorImage() {
        if (this.errorImage == null) {
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            this.errorImage = toolkit.createImage(ClassLoader.getSystemResource(ERROR_IMAGE_FILE));
            MediaTracker mediaTracker = new MediaTracker(this);
            mediaTracker.addImage(this.errorImage, 0);
            try {
                mediaTracker.waitForID(0);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return this.errorImage;
    }

    protected void paintComponent(Graphics graphics) {
        graphics.setColor(this.bg_color);
        graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        this.drawBorder(graphics2D, this.getSize());
        if (this.getWidth() > 24 && this.getHeight() > 24) {
            int n = 4;
            int n2 = 5;
            graphics2D.drawImage(this.getErrorImage(), n, n2, this.bg_color, null);
            this.drawMessage(graphics2D, ResourceManager.getMessage((String)"applet.error.message"), this.getErrorImage().getWidth(null) + n + 7, this.getErrorImage().getHeight(null) + n2 - 4);
        }
        graphics2D.dispose();
    }

    private void drawBorder(Graphics graphics, Dimension dimension) {
        Color color = ERROR_BORDER;
        Color color2 = graphics.getColor();
        graphics.setColor(color);
        graphics.drawRect(0, 0, dimension.width - 1, dimension.height - 1);
        graphics.setColor(color2);
    }

    private void drawMessage(Graphics2D graphics2D, String string, int n, int n2) {
        Dimension dimension = this.getSize();
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        Rectangle2D rectangle2D = fontMetrics.getStringBounds(string, graphics2D);
        boolean bl = true;
        if (rectangle2D.getWidth() + (double)n > dimension.getWidth()) {
            int n3;
            bl = false;
            while (!bl && (n3 = string.lastIndexOf(" ")) != -1) {
                string = string.substring(0, n3);
                rectangle2D = fontMetrics.getStringBounds(string = string + "...", graphics2D);
                if (!(rectangle2D.getWidth() + (double)n < dimension.getWidth())) continue;
                bl = true;
            }
            if (!bl && (rectangle2D = fontMetrics.getStringBounds(string = "...", graphics2D)).getWidth() + (double)n < dimension.getWidth()) {
                bl = true;
            }
        }
        if (bl) {
            Color color = graphics2D.getColor();
            graphics2D.setColor(this.fg_color);
            graphics2D.drawString(string, n, n2);
            graphics2D.setColor(color);
        }
    }

    private PopupMenu getPopupMenu() {
        if (this.popup == null) {
            this.popup = new PopupMenu();
            this.open_console = new MenuItem(ResourceManager.getMessage((String)"dialogfactory.menu.open_console"));
            this.popup.add(this.open_console);
            this.popup.add("-");
            this.about_java = new MenuItem(ResourceManager.getMessage((String)"dialogfactory.menu.about_java"));
            this.popup.add(this.about_java);
            if (this.deniedCertificateFailure) {
                this.reload = new MenuItem("Reload applet");
                this.popup.add("-");
                this.popup.add(this.reload);
                this.reload.addActionListener(this);
            }
            this.open_console.addActionListener(this);
            this.about_java.addActionListener(this);
            this.add(this.popup);
        }
        return this.popup;
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            this.getPopupMenu().show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
        } else if (mouseEvent.getButton() == 1) {
            this.onLeftMouseClick();
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            this.getPopupMenu().show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
        } else if (mouseEvent.getButton() == 1) {
            this.onLeftMouseClick();
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    private void onLeftMouseClick() {
        int n = -1;
        n = this.deniedCertificateFailure ? UIFactory.showErrorDialog(null, (AppInfo)new AppInfo(), (String)ResourceManager.getMessage((String)"applet.error.generic.masthead"), (String)ResourceManager.getMessage((String)"applet.error.generic.body"), (String)"applet.error.details.btn", (String)"applet.error.ignore.btn", (String)"applet.error.reload.btn") : UIFactory.showErrorDialog(null, (AppInfo)new AppInfo(), (String)ResourceManager.getMessage((String)"applet.error.generic.masthead"), (String)ResourceManager.getMessage((String)"applet.error.generic.body"), (String)"applet.error.details.btn", (String)"applet.error.ignore.btn", null);
        if (n == 0) {
            JavaRunTime.showJavaConsoleLater(true);
            JavaRunTime.installConsoleTraceListener();
        } else if (n != 1 && n == 3) {
            this.reloadApplet();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.open_console) {
            JavaRunTime.showJavaConsoleLater(true);
            JavaRunTime.installConsoleTraceListener();
        } else if (actionEvent.getSource() == this.about_java) {
            UIFactory.showAboutJavaDialog();
        } else if (actionEvent.getSource() == this.reload) {
            this.reloadApplet();
        }
    }

    private void reloadApplet() {
        if (this.errorDelegate != null) {
            this.errorDelegate.handleReloadApplet();
        }
    }

    private boolean deniedCertificateFailure() {
        boolean bl = false;
        String string = null;
        HashSet hashSet = new HashSet();
        HashSet hashSet2 = TrustDecider.getDeniedURL();
        if (this.errorDelegate != null) {
            string = this.errorDelegate.getCodeBase();
            this.errorDelegate.addJarFilesToSet(hashSet);
        }
        Iterator iterator = hashSet2.iterator();
        block0: while (iterator.hasNext()) {
            String string2 = iterator.next().toString();
            if (string == null || !string2.startsWith(string)) continue;
            Iterator iterator2 = hashSet.iterator();
            while (iterator2.hasNext()) {
                String string3 = iterator2.next().toString();
                if (!string2.endsWith(string3)) continue;
                bl = true;
                continue block0;
            }
        }
        return bl;
    }
}

