#!/bin/bash
# mecab	(http://mecab.sourceforge.net/)
#	BuildScript for Plamo Linux 4.5
#			by Jun Kuwamura <juk@linet.gr.jp> on 2008-07-16
# require:
#
SRC_URI=http://downloads.sourceforge.net/mecab/mecab-0.97.tar.gz
SRC_FILE=${SRC_URI##*/}
PAC_NAME=${SRC_FILE%%.tar.gz}
VERSION=${PAC_NAME##*-}

REL=P1
CPU=i586
SYS_NAME="${CPU}-${REL}"

PLAMO=/expo/Build
SRC_DIR=$PLAMO/Archive/text
PAC_DIR=$PLAMO/Packages/4.5/Text
BUILD_DIR=$PLAMO/mecab
CUSTOM_DIR=$BUILD_DIR/Custom
PAT_FILE=


echo $PAC_DIR
if [ ! -d $PAC_DIR ]; then
  mkdir -p  $PAC_DIR
fi
echo $SRC_DIR/$SRC_FILE
if [ ! -f $SRC_DIR/$SRC_FILE ]; then
  if [ ! -d $SRC_DIR ]; then
    mkdir -p $SRC_DIR
  fi
  ( cd $SRC_DIR; wget $SRC_URI )
fi


umask 022
CWD=`pwd`
WORK=$CWD/work
rm -rf $WORK/*
mkdir -p $WORK
export LANG=C
export LC_ALL=C
export CFLAGS="-O2 -march=$CPU"
export PATH=$PATH:/usr/X11R7/bin


tar xvfz $SRC_DIR/$SRC_FILE
cd $PAC_NAME
if [ -f "$PAT_FILE" ]; then
  patch < $PAT_FILE
fi
./configure --prefix=/usr --enable-utf8-only
make
make install DESTDIR=$WORK


DOC_DIR=usr/share/doc/$PAC_NAME
mkdir -p $WORK/$DOC_DIR || exit 1
cp -p $BUILD_DIR/`basename $0`  \
      AUTHORS BSD GPL LGPL NEWS README INSTALL COPYING ChangeLog \
  $WORK/$DOC_DIR/
cp -a doc/ example/ \
  $WORK/$DOC_DIR/
rm -f $WORK/$DOC_DIR/doc/Makefile*
chown -R root.root $WORK/$DOC_DIR/
chmod -R a+rX,go-w $WORK/$DOC_DIR/


mkdir -p $WORK/opt/htdocs/AppList || exit 1
TYP=1 #(0:httpd, 1:libraries, 2:application)
cat >> $WORK/opt/htdocs/AppList/$TYP.${PAC_NAME}.list <<__EOCL__
TYP	$TYP
NAM	${PAC_NAME}
URL	http://mecab.sourceforge.net/
DOC	/$DOC_DIR/doc/
REM	MeCab ǲϥ󥸥
__EOCL__


cd $WORK
echo "y
1
" | makepkg ${PAC_NAME}.tgz

echo -n "$PAC_DIR/${PAC_NAME}-${SYS_NAME}.tgz"
if `mv -v ${PAC_NAME}.tgz  $PAC_DIR/${PAC_NAME}-${SYS_NAME}.tgz 1>/dev/null 2>&1`; then
  echo " ... done"
else
  echo " ... false"
fi

cd $CWD
