//@line 36 "/mnt/Srcs/Thunderbird/build/mail/base/content/aboutDialog.js"

function onLoad() {
  document.getElementById("userAgent").value = navigator.userAgent;

  document.documentElement.getButton("extra2").setAttribute("hidden", true);

  document.documentElement.getButton("accept").focus();
//@line 50 "/mnt/Srcs/Thunderbird/build/mail/base/content/aboutDialog.js"
}

function onUnload(aEvent) {
  if (aEvent.target != document)
    return;
  document.getElementById("creditsIframe").setAttribute("src", "");
}

function switchPage(aEvent) {
  let iframe = document.getElementById("creditsIframe");
  let item = aEvent.target;

  // If the user clicked a menuitem, that's the credits option from the menu
  // so switch to the credits page.
  if (item.localName == "menuitem") {
    iframe.setAttribute("src", "chrome://messenger/content/credits.xhtml");

    document.getElementById("aboutMenu").setAttribute("hidden", true);
    document.documentElement.getButton("extra2").removeAttribute("hidden");

    document.getElementById("modes").setAttribute("selectedIndex", 1);
  }
  // If its a button, it is the back button, so switch back to the main page.
  else if (item.localName == "button") {
    iframe.setAttribute("src", "");

    document.getElementById("aboutMenu").removeAttribute("hidden");
    document.documentElement.getButton("extra2").setAttribute("hidden", true);

    document.getElementById("modes").setAttribute("selectedIndex", 0);
  }
}

function loadAbout(type)
{
  let tabmail = document.getElementById("tabmail");
  if (!tabmail) {
    // Try opening new tabs in an existing 3pane window
    let mail3PaneWindow = Components.classes["@mozilla.org/appshell/window-mediator;1"]
                                    .getService(Components.interfaces.nsIWindowMediator)
                                    .getMostRecentWindow("mail:3pane");
    if (mail3PaneWindow) {
      tabmail = mail3PaneWindow.document.getElementById("tabmail");
      mail3PaneWindow.focus();
    }
  }

  const tabParams = {
    contentPage: "about:" + type,
    clickHandler: "specialTabs.aboutClickHandler(event);"
  };

  if (tabmail)
    tabmail.openTab("contentTab", tabParams);
  else
    window.openDialog("chrome://messenger/content/", "_blank",
                      "chrome,dialog=no,all", null,
                      { tabType: "contentTab",
                        tabParams: tabParams });
}
