'\"
'\" $Id: TixIntro.n,v 1.6 2001/02/27 06:43:24 ioilam Exp $
'\"
'\"
'\" Copyright (c) 1993-1999 Ioi Kim Lam.
'\" Copyright (c) 2000-2001 Tix Project Group.
'\"
'\" See the file "license.terms" for information on usage and redistribution
'\" of this file, and for a DISCLAIMER OF ALL WARRANTIES.
'\" 
'\" The definitions below are for supplemental macros used in Tcl/Tk
'\" manual entries.
'\"
'\" .AP type name in/out ?indent?
'\"	Start paragraph describing an argument to a library procedure.
'\"	type is type of argument (int, etc.), in/out is either "in", "out",
'\"	or "in/out" to describe whether procedure reads or modifies arg,
'\"	and indent is equivalent to second arg of .IP (shouldn't ever be
'\"	needed;  use .AS below instead)
'\"
'\" .AS ?type? ?name?
'\"	Give maximum sizes of arguments for setting tab stops.  Type and
'\"	name are examples of largest possible arguments that will be passed
'\"	to .AP later.  If args are omitted, default tab stops are used.
'\"
'\" .BS
'\"	Start box enclosure.  From here until next .BE, everything will be
'\"	enclosed in one large box.
'\"
'\" .BE
'\"	End of box enclosure.
'\"
'\" .CS
'\"	Begin code excerpt.
'\"
'\" .CE
'\"	End code excerpt.
'\"
'\" .VS ?version? ?br?
'\"	Begin vertical sidebar, for use in marking newly-changed parts
'\"	of man pages.  The first argument is ignored and used for recording
'\"	the version when the .VS was added, so that the sidebars can be
'\"	found and removed when they reach a certain age.  If another argument
'\"	is present, then a line break is forced before starting the sidebar.
'\"
'\" .VE
'\"	End of vertical sidebar.
'\"
'\" .DS
'\"	Begin an indented unfilled display.
'\"
'\" .DE
'\"	End of indented unfilled display.
'\"
'\" .SO
'\"	Start of list of standard options for a Tk widget.  The
'\"	options follow on successive lines, in four columns separated
'\"	by tabs.
'\"
'\" .SE
'\"	End of list of standard options for a Tk widget.
'\"
'\" .OP cmdName dbName dbClass
'\"	Start of description of a specific option.  cmdName gives the
'\"	option's name as specified in the class command, dbName gives
'\"	the option's name in the option database, and dbClass gives
'\"	the option's class in the option database.
'\"
'\" .UL arg1 arg2
'\"	Print arg1 underlined, then print arg2 normally.
'\"
'\" RCS: @(#) $Id: man.macros,v 1.2 2001/01/22 00:32:09 ioilam Exp $
'\"
'\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
'\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ta \\n()Au \\n()Bu
.ie !"\\$3"" \{\
\&\\$1	\\fI\\$2\\fP	(\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
'\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
'\"	# BS - start boxed text
'\"	# ^y = starting y location
'\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
'\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
'\"	# VS - start vertical sidebar
'\"	# ^Y = starting y location
'\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$2"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
'\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
'\"	# Special macro to handle page bottom:  finish off current
'\"	# box/sidebar if in box/sidebar mode, then invoked standard
'\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
'\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
'\"	# DE - end display
.de DE
.fi
.RE
.sp
..
'\"	# SO - start of list of standard options
.de SO
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 4c 8c 12c
.ft B
..
'\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\fBoptions\\fR manual entry for details on the standard options.
..
'\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
'\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
'\"	# CE - end code excerpt
.de CE
.fi
.RE
..
.de UL
\\$1\l'|0\(ul'\\$2
..
'\" copyrighted: (c) 1990 The Regents of the University of California.
'\"              (c) 1994-1995 Sun Microsystems, Inc.
'\" The license terms of the Tcl/Tk distrobution are in the file
'\" license.tcl.
'\" The definitions below are for supplemental macros used in Tcl/Tk
'\" manual entries.
'\"
'\" .AP type name in/out ?indent?
'\"	Start paragraph describing an argument to a library procedure.
'\"	type is type of argument (int, etc.), in/out is either "in", "out",
'\"	or "in/out" to describe whether procedure reads or modifies arg,
'\"	and indent is equivalent to second arg of .IP (shouldn't ever be
'\"	needed;  use .AS below instead)
'\"
'\" .AS ?type? ?name?
'\"	Give maximum sizes of arguments for setting tab stops.  Type and
'\"	name are examples of largest possible arguments that will be passed
'\"	to .AP later.  If args are omitted, default tab stops are used.
'\"
'\" .BS
'\"	Start box enclosure.  From here until next .BE, everything will be
'\"	enclosed in one large box.
'\"
'\" .BE
'\"	End of box enclosure.
'\"
'\" .CS
'\"	Begin code excerpt.
'\"
'\" .CE
'\"	End code excerpt.
'\"
'\" .VS ?version? ?br?
'\"	Begin vertical sidebar, for use in marking newly-changed parts
'\"	of man pages.  The first argument is ignored and used for recording
'\"	the version when the .VS was added, so that the sidebars can be
'\"	found and removed when they reach a certain age.  If another argument
'\"	is present, then a line break is forced before starting the sidebar.
'\"
'\" .VE
'\"	End of vertical sidebar.
'\"
'\" .DS
'\"	Begin an indented unfilled display.
'\"
'\" .DE
'\"	End of indented unfilled display.
'\"
'\" .SO
'\"	Start of list of standard options for a Tk widget.  The
'\"	options follow on successive lines, in four columns separated
'\"	by tabs.
'\"
'\" .SE
'\"	End of list of standard options for a Tk widget.
'\"
'\" .OP cmdName dbName dbClass
'\"	Start of description of a specific option.  cmdName gives the
'\"	option's name as specified in the class command, dbName gives
'\"	the option's name in the option database, and dbClass gives
'\"	the option's class in the option database.
'\"
'\" .UL arg1 arg2
'\"	Print arg1 underlined, then print arg2 normally.
'\"
'\" RCS: @(#) $Id: man.macros,v 1.2 2001/01/22 00:32:09 ioilam Exp $
'\"
'\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
'\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ta \\n()Au \\n()Bu
.ie !"\\$3"" \{\
\&\\$1	\\fI\\$2\\fP	(\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
'\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
'\"	# BS - start boxed text
'\"	# ^y = starting y location
'\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
'\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
'\"	# VS - start vertical sidebar
'\"	# ^Y = starting y location
'\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$2"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
'\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
'\"	# Special macro to handle page bottom:  finish off current
'\"	# box/sidebar if in box/sidebar mode, then invoked standard
'\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
'\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
'\"	# DE - end display
.de DE
.fi
.RE
.sp
..
'\"	# SO - start of list of standard options
.de SO
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 4c 8c 12c
.ft B
..
'\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\fBoptions\\fR manual entry for details on the standard options.
..
'\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
'\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
'\"	# CE - end code excerpt
.de CE
.fi
.RE
..
.de UL
\\$1\l'|0\(ul'\\$2
..
.TH TixIntro n 8.0 Tix "Tix Built-In Commands"
.BS
'\"
'\"
.SH NAME
TixIntro \- Introduction to the Tix library
.BE
'\"
'\"
.SH DESCRIPTION
'\"
Tix, which stands for Tk Interface Extension, is an extension library
for Tcl/Tk. Tix adds many new widgets, image types and other commands that
allows you to create compelling Tcl/Tk-based GUI applications.
.PP
One advantage of Tix over other Tk widget libraries is many of the Tix
standard widgets are implemented in native code. This enhances
performance and provides native look-and-feel for your applications.
.PP
This version of Tix works with Tcl/Tk version 8.0 or above.
If Tix has been installed properly on your system, you can load the
package into any Tk script by invoking the command
.CS
package require Tix
.CE
After this command has successfully returned, you can start using the
functionalities of the Tix library. See the \fBEXAMPLES\fR section
below for example scripts that use Tix.
.PP
If the "package require Tix" command fails, you
probably need to install a new copy of Tix on your system. You can
download the latest version of Tix from the web site
\fBhttp://tixlibrary.sourceforge.net/\fR.
.PP
'\"
.SH STANDARD WIDGETS
Tix includes the following standard widgets which, like their counterparts in
Tk, are implemented in native code to achieve high performance and
native look-and-feel.
.TP
\fBtixGrid\fR
The \fBtixGrid\fR widget displays items in a spread-sheet format.
.TP
\fBtixHList\fR
Hierarchical listbox widget. This widget display entries in a
tree-like format.
.TP
\fBtixInputOnly\fR
A transparent window that can be used to cover another widget so as to
disable mouse input.
.TP
\fBtixNBFrame\fR
The \fBtixNBFrame\fR widget is used internally by the
\fBtixNoteBook\fR widget to display choices among a set of overlapping
pages.
.TP
\fBtixTList\fR
Tabular listbox widget. This widget is similar to the built-in Tk
\fBlistbox\fR widget but provides more flexibility in displaying the
list entries. 
.SH MEGA WIDGETS
Tix provides many new types of \fImega widgets\fR: these are widgets
that are composed of built-in Tk widgets and the Tix standard widgets
mentioned above.
.TP
\fBtixBalloon\fR
The \fBtixBalloon\fR widget provides context-sensitive on-screen
help.
.TP
\fBtixButtonBox\fR
A convenience class for creating a box of \fBbutton\fR widgets.
.TP
\fBtixCheckList\fR
A subclass of \fBtixTree\fR that presents single- or multiple
choices to the user in a tree-like format.
.TP
\fBtixComboBox\fR
A combination of the \fBlistbox\fR and \fBentry\fR widgets that allows
the user to input an item by typing or by selecting from a list of
items.
.TP
\fBtixControl\fR
The \fBtixControl\fR widget allows the user to adjust a value using
arrow buttons.
.TP
\fBtixDirList\fR
A directory selection widget that displays the file system as a
cascading list.
.TP
\fBtixDirSelectDialog\fR
A dialog for selecting a directory. \fIThis widget is
deprecated.\fR Use \fBtk_chooseDirectory\fR instead.
.TP
\fBtixDirTree\fR
A directory selection widget that displays the file system in a tree
format.
.TP
\fBtixExFileSelectBox\fR
A widget for selecting a file. \fIThis widget is
deprecated.\fR Use \fBtk_getOpenFile\fR instead.
.TP
\fBtixExFileSelectDialog\fR
A dialog for selecting a file. \fIThis widget is
deprecated.\fR Use \fBtk_getOpenFile\fR instead.
.TP
\fBtixFileEntry\fR
A special entry widget that allows the user to choose a file by typing
in its name or by selecting from a file dialog.
.TP
\fBtixFileSelectBox\fR
A widget for selecting a file. \fIThis widget is
deprecated.\fR Use \fBtk_getOpenFile\fR instead.
.TP
\fBtixFileSelectDialog\fR
A dialog for selecting a file. \fIThis widget is
deprecated.\fR Use \fBtk_getOpenFile\fR instead.
.TP
\fBtixLabelEntry\fR
A convenience class for creating an \fBentry\fR with an associated
\fBlabel\fR widget.
.TP
\fBtixLabelFrame\fR
A labeled \fBframe\fR widget for grouping together a set of related
widgets.
.TP
\fBtixListNoteBook\fR
The \fBtixListNoteBook\fR widget allows the user to choose from a
set of over-lapping pages by selecting from a list box.
.TP
\fBtixMeter\fR
The \fBtixMeter\fR widget displays a bar graph to indicate progress.
.TP
\fBtixNoteBook\fR
The \fBtixNoteBook\fR widget allows the user to choose from a
set of over-lapping pages with a tabbed notebook metaphor.
.TP
\fBtixOptionMenu\fR
The \fBtixOptionMenu\fR widget allows the user to choose a value from
a pop-up menu.
.TP
\fBtixPanedWindow\fR
The \fBtixPanedWindow\fR widgets allows the user to adjust the
visible size of several \fBframe\fR widgets with handle bars.
.TP
\fBtixPopupMenu\fR
The \fBtixPopupMenu\fR widget can be used to implement
context-sensitive pop-up menu.
.TP
\fBtixScrolledHList\fR
A \fBtixHList\fR widget with smart scrollbars. Like other Tix scrolled
widgets, the scroll bars can be displayed on an as-needed basis.
.TP
\fBtixScrolledListBox\fR
A Tk \fBlistbox\fR widget with smart scrollbars.
.TP
\fBtixScrolledText\fR
A Tk \fBtext\fR widget with smart scrollbars.
.TP
\fBtixScrolledWindow\fR
A Tk \fBframe\fR widget with smart scrollbars.
.TP
\fBtixSelect\fR
The \fBtixSelect\fR widget uses a set of buttons to present
single- or multiple selection options to the user.
.TP
\fBtixStdButtonBox\fR
A subclass of \fBtixButtonBox\fR that provides four standard
buttons (OK, Apply, Cancel Help) for Motif(TM)-like dialog boxes.
.TP
\fBtixTree\fR
A subclass of \fBtixScrolledHList\fR that supports expanding and collapsing
of entries in a hierarchical list.
.SH DISPLAY ITEMS
Three Tix standard widgets \fBtixGrid\fR, \fBtixHList\fR and
\fBtixTList\fR support the \fIDisplay Items\fR mechanism. Display
items are created by the widget command of these standard widgets. You can
customize the items using \fIstyles\fR objects.
.TP
\fBtixDisplayStyle\fR
Create style objects to customize display items.
.SH IMAGE TYPES
Tix provides two additional image types to the Tk \fBimage\fR
framework.
.TP
\fBcompound\fR
The \fBcompound\fR image type allows you to combine images, widgets,
and text strings into a single Tk \fBimage\fR object.
.TP
\fBpixmap\fR
The \fBpixmap\fR image type supports the XPM format.
.SH OTHER COMMANDS
The following Tcl command are also included in the Tix library to
perform various functions.
.TP
\fBtixDestroy\fR
Destroy Tix objects instances of classes defined by \fBtixClass\fR construct.
.TP
\fBtixForm\fR
A geometry manager based on attachment rules. \fIThis geometry manager
is deprecated\fR. Use the Tk \fBgrid\fR geometry manager instead.
.TP
\fBtixMwm\fR
A command to communicate with the Mwm, the Motif(TM) Window
Manager. Works on Unix only.
.TP
\fBtix\fR
The \fBtix\fR command controls the Tix application context.
.TP
\fBtixGetBoolean\fR
The \fBtixGetBoolean\fR command converts a string to a boolean value.
.TP
\fBtixGetInt\fR
The \fBtixGetInt\fR command converts a string to a integer value.
.TP
\fBtixUtils\fR
The \fBtixUtils\fR manual page describes some utility Tix commands.
.SH EXECUTABLE PROGRAM
.TP
\fBtixwish\fR
The \fBtixwish\fR program can be used to execute Tix-based
applications. \fBtixwish\fR \fIis deprecated\fR. You should use the
standard \fBwish\fR program from Tk and access Tix via the "package require
Tix" command.
.SH EXAMPLES
The following is an example script that uses a \fBtixTree\fR widget.
.PP
.CS
set tree [tixTree .t]
pack $tree -expand yes -fill both
for {set i 0} {$i < 2} {incr i} {
    $tree subwidget hlist add $i -itemtype imagetext \\
        -text "Folder $i" -image [tix getimage folder]
    for {set j 0} {$j < 5} {incr j} {
        $tree subwidget hlist add $i.$j -itemtype imagetext \\
            -text "File $i.$j" -image [tix getimage textfile]
    }
}
$tree autosetmode
.CE
.SH KEYWORDS
'\"
Tix, mega widgets



