#!/bin/bash
# libmemcache
#	BuildScript for Plamo Linux 4.5
#			by Jun Kuwamura <juk@linet.gr.jp> on 2008-07-20
# require:
#	libevent-1.4
#	memcached-1.2
#
SRC_URI=http://people.freebsd.org/~seanc/libmemcache/libmemcache-1.4.0.rc2.tar.bz2
PAC_NAME="libmemcache-1.4.0.rc2"
SRC_FILE="${PAC_NAME}.tar.bz2"
#SRC_FILE=${SRC_URI##*/}
#PAC_NAME=${SRC_FILE%%.tar.gz}


REL=P1
CPU=i586
SYS_NAME="${CPU}-${REL}"

PLAMO=/expo/Build
SRC_DIR=$PLAMO/Archive/network
PAC_DIR=$PLAMO/Packages/4.5/Network
BUILD_DIR=$PLAMO/memcached
CUSTOM_DIR=$BUILD_DIR/Custom
PAT_FILE=libmemcache-1.4.0.rc2.patch

echo $PAC_DIR
if [ ! -d $PAC_DIR ]; then
  mkdir -p  $PAC_DIR
fi
echo $SRC_DIR/$SRC_FILE
if [ ! -f $SRC_DIR/$SRC_FILE ]; then
  if [ ! -d $SRC_DIR ]; then
    mkdir -p $SRC_DIR
  fi
  ( cd $SRC_DIR; wget $SRC_URI )
fi


umask 022
CWD=`pwd`
WORK=$CWD/work
rm -rf $WORK/*
mkdir -p $WORK
export LANG=C
export LC_ALL=C
export CFLAGS="-O2 -march=$CPU"
export PATH=$PATH:/usr/X11R7/bin


tar xvfj $SRC_DIR/$SRC_FILE
cd $PAC_NAME
  if [ "$PAT_FILE" != "" ]; then
    patch -p1 < $CUSTOM_DIR/$PAT_FILE
  fi
./configure --prefix=/usr
make
make install DESTDIR=$WORK

  wget -N http://people.freebsd.org/~seanc/libmemcache/README
  mv README README.html
  w3m -dump -T text/html README.html  > README


DOC_DIR=usr/share/doc/$PAC_NAME
mkdir -p $WORK/$DOC_DIR || exit 1
cp -p $BUILD_DIR/`basename $0`  \
	COPYING  ChangeLog README INSTALL \
  $WORK/$DOC_DIR/

cd $WORK
echo "y
1
" | makepkg ${PAC_NAME}.tgz

echo -n "$PAC_DIR/${PAC_NAME}-${SYS_NAME}.tgz"
if `mv -v ${PAC_NAME}.tgz  $PAC_DIR/${PAC_NAME}-${SYS_NAME}.tgz 1>/dev/null 2>&1`; then
  echo " ... done"
else
  echo " ... false"
fi

cd $CWD
