/*
 * Decompiled with CFR 0.152.
 */
package org.ietf.jgss;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.StringTokenizer;
import org.ietf.jgss.GSSException;

public class Oid {
    private static final int OBJECT_IDENTIFIER = 6;
    private static final int RELATIVE_OID = 13;
    private final int[] components;
    private byte[] derOid;
    private String strOid;
    private boolean relative;

    public Oid(String strOid) throws GSSException {
        if (strOid == null) {
            throw new NullPointerException();
        }
        this.strOid = strOid;
        try {
            StringTokenizer tok = new StringTokenizer(strOid, ".");
            this.components = new int[tok.countTokens()];
            int i = 0;
            while (tok.hasMoreTokens() && i < this.components.length) {
                this.components[i++] = Integer.parseInt(tok.nextToken());
            }
        }
        catch (Exception exception) {
            throw new GSSException(11);
        }
        this.relative = false;
    }

    public Oid(InputStream derOid) throws GSSException {
        DataInputStream in = new DataInputStream(derOid);
        try {
            int j;
            int tag = in.read() & 0x1F;
            if (tag != 6 && tag != 13) {
                throw new IOException();
            }
            int len = in.read();
            if ((len & 0xFFFFFF80) != 0) {
                byte[] buf = new byte[len & 0x7F];
                in.readFully(buf);
                len = new BigInteger(1, buf).intValue();
            }
            if (len < 0) {
                throw new IOException();
            }
            byte[] enc = new byte[len];
            in.readFully(enc);
            int[] comp = new int[len + 1];
            int count = 0;
            int i = 0;
            boolean bl = this.relative = tag == 13;
            if (!this.relative && i < len) {
                j = enc[i] & 0xFF;
                comp[count++] = j / 40;
                comp[count++] = j % 40;
                ++i;
            }
            while (i < len) {
                j = 0;
                do {
                    j = enc[i++] & 0xFF;
                    int n = count;
                    comp[n] = comp[n] << 7;
                    int n2 = count;
                    comp[n2] = comp[n2] | j & 0x7F;
                    if (i < len || (j & 0x80) == 0) continue;
                    throw new IOException();
                } while ((j & 0x80) != 0);
                ++count;
            }
            if (count == len) {
                this.components = comp;
            } else {
                this.components = new int[count];
                System.arraycopy(comp, 0, this.components, 0, count);
            }
        }
        catch (IOException iOException) {
            throw new GSSException(11);
        }
    }

    public Oid(byte[] derOid) throws GSSException {
        this(new ByteArrayInputStream(derOid));
        this.derOid = (byte[])derOid.clone();
    }

    Oid(int[] components) {
        this.components = components;
        this.relative = false;
    }

    public String toString() {
        if (this.strOid == null) {
            StringBuffer buf = new StringBuffer();
            int i = 0;
            while (i < this.components.length) {
                buf.append(this.components[i]);
                if (i < this.components.length - 1) {
                    buf.append('.');
                }
                ++i;
            }
            this.strOid = buf.toString();
        }
        return this.strOid;
    }

    public byte[] getDER() throws GSSException {
        if (this.derOid == null) {
            ByteArrayOutputStream out = new ByteArrayOutputStream(256);
            try {
                int i = 0;
                if (!this.relative) {
                    int b = this.components[i++] * 40 + (this.components.length > 1 ? this.components[i++] : 0);
                    Oid.encodeSubId(out, b);
                }
                while (i < this.components.length) {
                    Oid.encodeSubId(out, this.components[i]);
                    ++i;
                }
                byte[] oid = out.toByteArray();
                out.reset();
                if (this.relative) {
                    out.write(13);
                } else {
                    out.write(6);
                }
                if (oid.length < 128) {
                    out.write(oid.length);
                } else if (oid.length < 256) {
                    out.write(129);
                    out.write(oid.length);
                } else if (oid.length < 65536) {
                    out.write(130);
                    out.write(oid.length >>> 8 & 0xFF);
                    out.write(oid.length & 0xFF);
                } else if (oid.length < 0x1000000) {
                    out.write(131);
                    out.write(oid.length >>> 16 & 0xFF);
                    out.write(oid.length >>> 8 & 0xFF);
                    out.write(oid.length & 0xFF);
                } else {
                    out.write(132);
                    out.write(oid.length >>> 24 & 0xFF);
                    out.write(oid.length >>> 16 & 0xFF);
                    out.write(oid.length >>> 8 & 0xFF);
                    out.write(oid.length & 0xFF);
                }
                out.write(oid);
            }
            catch (IOException iOException) {
                throw new GSSException(11);
            }
            this.derOid = out.toByteArray();
        }
        return (byte[])this.derOid.clone();
    }

    public boolean containedIn(Oid[] oids) {
        int i = 0;
        while (i < oids.length) {
            if (this.equals(oids[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean equals(Object o) {
        if (!(o instanceof Oid)) {
            return false;
        }
        Oid that = (Oid)o;
        return Arrays.equals(this.components, that.components);
    }

    public int hashCode() {
        int code = 0;
        int i = 0;
        while (i < this.components.length) {
            code += this.components[i];
            ++i;
        }
        return code;
    }

    private static void encodeSubId(OutputStream out, int id) throws IOException {
        if (id < 128) {
            out.write(id);
        } else if (id < 16384) {
            out.write(id >>> 7 | 0x80);
            out.write(id & 0x7F);
        } else if (id < 0x200000) {
            out.write(id >>> 14 | 0x80);
            out.write((id >>> 7 | 0x80) & 0xFF);
            out.write(id & 0x7F);
        } else if (id < 0x10000000) {
            out.write(id >>> 21 | 0x80);
            out.write((id >>> 14 | 0x80) & 0xFF);
            out.write((id >>> 7 | 0x80) & 0xFF);
            out.write(id & 0x7F);
        }
    }
}

