/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.stream;

import gnu.xml.stream.XMLEventFactoryImpl;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Iterator;
import java.util.Properties;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.Location;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.Comment;
import javax.xml.stream.events.DTD;
import javax.xml.stream.events.EndDocument;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.EntityDeclaration;
import javax.xml.stream.events.EntityReference;
import javax.xml.stream.events.Namespace;
import javax.xml.stream.events.ProcessingInstruction;
import javax.xml.stream.events.StartDocument;
import javax.xml.stream.events.StartElement;

public abstract class XMLEventFactory {
    protected XMLEventFactory() {
    }

    public static XMLEventFactory newInstance() throws FactoryConfigurationError {
        return XMLEventFactory.newInstance(null, null);
    }

    static XMLEventFactory newInstance(String factoryId, ClassLoader classLoader) throws FactoryConfigurationError {
        ClassLoader loader = classLoader;
        if (loader == null) {
            loader = Thread.currentThread().getContextClassLoader();
        }
        if (loader == null) {
            loader = XMLEventFactory.class.getClassLoader();
        }
        String className = null;
        int count = 0;
        do {
            if ((className = XMLEventFactory.getFactoryClassName(loader, count++)) == null) continue;
            try {
                Class<?> t = loader != null ? loader.loadClass(className) : Class.forName(className);
                return (XMLEventFactory)t.newInstance();
            }
            catch (ClassNotFoundException classNotFoundException) {
                className = null;
            }
            catch (Exception e) {
                throw new FactoryConfigurationError(e, "error instantiating class " + className);
            }
        } while (className == null && count < 3);
        return new XMLEventFactoryImpl();
    }

    private static String getFactoryClassName(ClassLoader loader, int attempt) {
        switch (attempt) {
            case 0: {
                return System.getProperty("javax.xml.stream.XMLEventFactory");
            }
            case 1: {
                try {
                    File file = new File(System.getProperty("java.home"));
                    file = new File(file, "lib");
                    file = new File(file, "stax.properties");
                    FileInputStream in = new FileInputStream(file);
                    Properties props = new Properties();
                    props.load(in);
                    ((InputStream)in).close();
                    return props.getProperty("javax.xml.stream.XMLEventFactory");
                }
                catch (IOException iOException) {
                    return null;
                }
            }
            case 2: {
                try {
                    InputStream in;
                    String serviceKey = "/META-INF/services/javax.xml.stream.XMLEventFactory";
                    InputStream inputStream = in = loader != null ? loader.getResourceAsStream(serviceKey) : XMLEventFactory.class.getResourceAsStream(serviceKey);
                    if (in != null) {
                        BufferedReader r = new BufferedReader(new InputStreamReader(in));
                        String ret = r.readLine();
                        r.close();
                        return ret;
                    }
                }
                catch (IOException iOException) {}
                return null;
            }
        }
        return null;
    }

    public abstract void setLocation(Location var1);

    public abstract Attribute createAttribute(String var1, String var2, String var3, String var4);

    public abstract Attribute createAttribute(String var1, String var2);

    public abstract Attribute createAttribute(QName var1, String var2);

    public abstract Namespace createNamespace(String var1);

    public abstract Namespace createNamespace(String var1, String var2);

    public abstract StartElement createStartElement(QName var1, Iterator var2, Iterator var3);

    public abstract StartElement createStartElement(String var1, String var2, String var3);

    public abstract StartElement createStartElement(String var1, String var2, String var3, Iterator var4, Iterator var5);

    public abstract StartElement createStartElement(String var1, String var2, String var3, Iterator var4, Iterator var5, NamespaceContext var6);

    public abstract EndElement createEndElement(QName var1, Iterator var2);

    public abstract EndElement createEndElement(String var1, String var2, String var3);

    public abstract EndElement createEndElement(String var1, String var2, String var3, Iterator var4);

    public abstract Characters createCharacters(String var1);

    public abstract Characters createCData(String var1);

    public abstract Characters createSpace(String var1);

    public abstract Characters createIgnorableSpace(String var1);

    public abstract StartDocument createStartDocument();

    public abstract StartDocument createStartDocument(String var1, String var2, boolean var3);

    public abstract StartDocument createStartDocument(String var1, String var2);

    public abstract StartDocument createStartDocument(String var1);

    public abstract EndDocument createEndDocument();

    public abstract EntityReference createEntityReference(String var1, EntityDeclaration var2);

    public abstract Comment createComment(String var1);

    public abstract ProcessingInstruction createProcessingInstruction(String var1, String var2);

    public abstract DTD createDTD(String var1);
}

