/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text.html;

import gnu.javax.swing.text.html.parser.GnuParserDelegator;
import gnu.javax.swing.text.html.parser.HTML_401F;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.swing.Action;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.Element;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import javax.swing.text.StyledEditorKit;
import javax.swing.text.TextAction;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import javax.swing.text.html.BRView;
import javax.swing.text.html.BlockView;
import javax.swing.text.html.FormView;
import javax.swing.text.html.FrameSetView;
import javax.swing.text.html.FrameView;
import javax.swing.text.html.HRuleView;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLFrameHyperlinkEvent;
import javax.swing.text.html.HTMLWriter;
import javax.swing.text.html.ImageView;
import javax.swing.text.html.InlineView;
import javax.swing.text.html.ListView;
import javax.swing.text.html.MinimalHTMLWriter;
import javax.swing.text.html.NullView;
import javax.swing.text.html.ObjectView;
import javax.swing.text.html.ParagraphView;
import javax.swing.text.html.StyleSheet;
import javax.swing.text.html.TableView;

public class HTMLEditorKit
extends StyledEditorKit
implements Serializable,
Cloneable,
Accessible {
    private static final long serialVersionUID = 8751997116710384592L;
    public static final String DEFAULT_CSS = "default.css";
    public static final String BOLD_ACTION = "html-bold-action";
    public static final String ITALIC_ACTION = "html-italic-action";
    public static final String COLOR_ACTION = "html-color-action";
    public static final String FONT_CHANGE_BIGGER = "html-font-bigger";
    public static final String FONT_CHANGE_SMALLER = "html-font-smaller";
    public static final String IMG_ALIGN_BOTTOM = "html-image-align-bottom";
    public static final String IMG_ALIGN_MIDDLE = "html-image-align-middle";
    public static final String IMG_ALIGN_TOP = "html-image-align-top";
    public static final String IMG_BORDER = "html-image-border";
    public static final String LOGICAL_STYLE_ACTION = "html-logical-style-action";
    public static final String PARA_INDENT_LEFT = "html-para-indent-left";
    public static final String PARA_INDENT_RIGHT = "html-para-indent-right";
    private static final Action[] defaultActions = new Action[]{new InsertHTMLTextAction("InsertTable", "<table border=1><tr><td></td></tr></table>", HTML.Tag.BODY, HTML.Tag.TABLE), new InsertHTMLTextAction("InsertTableRow", "<table border=1><tr><td></td></tr></table>", HTML.Tag.TABLE, HTML.Tag.TR, HTML.Tag.BODY, HTML.Tag.TABLE), new InsertHTMLTextAction("InsertTableCell", "<table border=1><tr><td></td></tr></table>", HTML.Tag.TR, HTML.Tag.TD, HTML.Tag.BODY, HTML.Tag.TABLE), new InsertHTMLTextAction("InsertUnorderedList", "<ul><li></li></ul>", HTML.Tag.BODY, HTML.Tag.UL), new InsertHTMLTextAction("InsertUnorderedListItem", "<ul><li></li></ul>", HTML.Tag.UL, HTML.Tag.LI, HTML.Tag.BODY, HTML.Tag.UL), new InsertHTMLTextAction("InsertOrderedList", "<ol><li></li></ol>", HTML.Tag.BODY, HTML.Tag.OL), new InsertHTMLTextAction("InsertOrderedListItem", "<ol><li></li></ol>", HTML.Tag.OL, HTML.Tag.LI, HTML.Tag.BODY, HTML.Tag.OL), new InsertHTMLTextAction("InsertPre", "<pre></pre>", HTML.Tag.BODY, HTML.Tag.PRE)};
    private StyleSheet styleSheet;
    HTMLFactory viewFactory;
    Cursor linkCursor;
    Cursor defaultCursor;
    Parser parser;
    private LinkController linkController = new LinkController();
    String contentType = "text/html";
    MutableAttributeSet inputAttributes;
    JEditorPane editorPane;
    private boolean autoFormSubmission = true;

    public ViewFactory getViewFactory() {
        if (this.viewFactory == null) {
            this.viewFactory = new HTMLFactory();
        }
        return this.viewFactory;
    }

    public Document createDefaultDocument() {
        StyleSheet styleSheet = this.getStyleSheet();
        StyleSheet ss = new StyleSheet();
        ss.addStyleSheet(styleSheet);
        HTMLDocument document = new HTMLDocument(ss);
        document.setParser(this.getParser());
        document.setAsynchronousLoadPriority(4);
        document.setTokenThreshold(100);
        return document;
    }

    protected Parser getParser() {
        if (this.parser == null) {
            this.parser = new GnuParserDelegator(HTML_401F.getInstance());
        }
        return this.parser;
    }

    public void insertHTML(HTMLDocument doc, int offset, String html, int popDepth, int pushDepth, HTML.Tag insertTag) throws BadLocationException, IOException {
        Parser parser = this.getParser();
        if (offset < 0 || offset > doc.getLength()) {
            throw new BadLocationException("Bad location", offset);
        }
        if (parser == null) {
            throw new IOException("Parser is null.");
        }
        ParserCallback pc = doc.getReader(offset, popDepth, pushDepth, insertTag);
        parser.parse(new StringReader(html), pc, false);
        pc.flush();
    }

    public void read(Reader in, Document doc, int pos) throws IOException, BadLocationException {
        if (doc instanceof HTMLDocument) {
            Parser parser = this.getParser();
            if (pos < 0 || pos > doc.getLength()) {
                throw new BadLocationException("Bad location", pos);
            }
            if (parser == null) {
                throw new IOException("Parser is null.");
            }
            HTMLDocument hd = (HTMLDocument)doc;
            if (this.editorPane != null) {
                hd.setBase(this.editorPane.getPage());
            }
            ParserCallback pc = hd.getReader(pos);
            parser.parse(in, pc, false);
            pc.flush();
        } else {
            super.read(in, doc, pos);
        }
    }

    public void write(Writer out, Document doc, int pos, int len) throws IOException, BadLocationException {
        if (doc instanceof HTMLDocument) {
            HTMLWriter writer = new HTMLWriter(out, (HTMLDocument)doc, pos, len);
            writer.write();
        } else if (doc instanceof StyledDocument) {
            MinimalHTMLWriter writer = new MinimalHTMLWriter(out, (StyledDocument)doc, pos, len);
            writer.write();
        } else {
            super.write(out, doc, pos, len);
        }
    }

    public String getContentType() {
        return this.contentType;
    }

    public Object clone() {
        HTMLEditorKit copy = (HTMLEditorKit)super.clone();
        copy.linkController = new LinkController();
        return copy;
    }

    protected void createInputAttributes(Element element, MutableAttributeSet set) {
        set.removeAttributes(set);
        set.addAttributes(element.getAttributes());
    }

    public void install(JEditorPane c) {
        super.install(c);
        c.addMouseListener(this.linkController);
        c.addMouseMotionListener(this.linkController);
        this.editorPane = c;
    }

    public void deinstall(JEditorPane c) {
        super.deinstall(c);
        c.removeMouseListener(this.linkController);
        c.removeMouseMotionListener(this.linkController);
        this.editorPane = null;
    }

    public AccessibleContext getAccessibleContext() {
        return null;
    }

    public Action[] getActions() {
        return TextAction.augmentList(super.getActions(), defaultActions);
    }

    public Cursor getDefaultCursor() {
        if (this.defaultCursor == null) {
            this.defaultCursor = Cursor.getDefaultCursor();
        }
        return this.defaultCursor;
    }

    public Cursor getLinkCursor() {
        if (this.linkCursor == null) {
            this.linkCursor = Cursor.getPredefinedCursor(12);
        }
        return this.linkCursor;
    }

    public void setLinkCursor(Cursor cursor) {
        this.linkCursor = cursor;
    }

    public void setDefaultCursor(Cursor cursor) {
        this.defaultCursor = cursor;
    }

    public MutableAttributeSet getInputAttributes() {
        return this.inputAttributes;
    }

    public StyleSheet getStyleSheet() {
        if (this.styleSheet == null) {
            try {
                this.styleSheet = new StyleSheet();
                Class<HTMLEditorKit> c = HTMLEditorKit.class;
                InputStream in = c.getResourceAsStream(DEFAULT_CSS);
                InputStreamReader r = new InputStreamReader(in);
                this.styleSheet.loadRules(r, null);
                r.close();
            }
            catch (IOException ex) {
                throw new RuntimeException("No style available.", ex);
            }
        }
        return this.styleSheet;
    }

    public void setStyleSheet(StyleSheet s) {
        this.styleSheet = s;
    }

    public boolean isAutoFormSubmission() {
        return this.autoFormSubmission;
    }

    public void setAutoFormSubmission(boolean auto) {
        this.autoFormSubmission = auto;
    }

    public static class HTMLFactory
    implements ViewFactory {
        public View create(Element element) {
            View view = null;
            Object attr = element.getAttributes().getAttribute(StyleConstants.NameAttribute);
            if (attr instanceof HTML.Tag) {
                HTML.Tag tag = (HTML.Tag)attr;
                if (tag == HTML.Tag.IMPLIED || tag == HTML.Tag.P || tag == HTML.Tag.H1 || tag == HTML.Tag.H2 || tag == HTML.Tag.H3 || tag == HTML.Tag.H4 || tag == HTML.Tag.H5 || tag == HTML.Tag.H6 || tag == HTML.Tag.DT) {
                    view = new ParagraphView(element);
                } else if (tag == HTML.Tag.LI || tag == HTML.Tag.DL || tag == HTML.Tag.DD || tag == HTML.Tag.BODY || tag == HTML.Tag.HTML || tag == HTML.Tag.CENTER || tag == HTML.Tag.DIV || tag == HTML.Tag.BLOCKQUOTE || tag == HTML.Tag.PRE || tag == HTML.Tag.FORM || tag == HTML.Tag.TD || tag == HTML.Tag.TH) {
                    view = new BlockView(element, 1);
                } else if (tag == HTML.Tag.TR) {
                    view = new BlockView(element, 0);
                } else if (tag == HTML.Tag.IMG) {
                    view = new ImageView(element);
                } else if (tag == HTML.Tag.CONTENT) {
                    view = new InlineView(element);
                } else if (tag == HTML.Tag.HEAD) {
                    view = new NullView(element);
                } else if (tag == HTML.Tag.TABLE) {
                    view = new TableView(element);
                } else if (tag == HTML.Tag.HR) {
                    view = new HRuleView(element);
                } else if (tag == HTML.Tag.BR) {
                    view = new BRView(element);
                } else if (tag == HTML.Tag.INPUT || tag == HTML.Tag.SELECT || tag == HTML.Tag.TEXTAREA) {
                    view = new FormView(element);
                } else if (tag == HTML.Tag.MENU || tag == HTML.Tag.DIR || tag == HTML.Tag.UL || tag == HTML.Tag.OL) {
                    view = new ListView(element);
                } else if (tag == HTML.Tag.FRAMESET) {
                    view = new FrameSetView(element);
                } else if (tag == HTML.Tag.FRAME) {
                    view = new FrameView(element);
                } else if (tag == HTML.Tag.OBJECT) {
                    view = new ObjectView(element);
                }
            }
            if (view == null) {
                view = new NullView(element);
            }
            return view;
        }
    }

    public static abstract class HTMLTextAction
    extends StyledEditorKit.StyledTextAction {
        public HTMLTextAction(String name) {
            super(name);
        }

        protected HTMLDocument getHTMLDocument(JEditorPane e) {
            Document d = e.getDocument();
            if (d instanceof HTMLDocument) {
                return (HTMLDocument)d;
            }
            throw new IllegalArgumentException("Document is not a HTMLDocument.");
        }

        protected HTMLEditorKit getHTMLEditorKit(JEditorPane e) {
            EditorKit d = e.getEditorKit();
            if (d instanceof HTMLEditorKit) {
                return (HTMLEditorKit)d;
            }
            throw new IllegalArgumentException("EditorKit is not a HTMLEditorKit.");
        }

        protected Element[] getElementsAt(HTMLDocument doc, int offset) {
            return this.getElementsAt(doc.getDefaultRootElement(), offset, 0);
        }

        private Element[] getElementsAt(Element root, int offset, int depth) {
            Element[] elements = null;
            if (root != null) {
                if (root.isLeaf()) {
                    elements = new Element[depth + 1];
                    elements[depth] = root;
                    return elements;
                }
                elements = this.getElementsAt(root.getElement(root.getElementIndex(offset)), offset, depth + 1);
                elements[depth] = root;
            }
            return elements;
        }

        protected int elementCountToTag(HTMLDocument doc, int offset, HTML.Tag tag) {
            Element root = doc.getDefaultRootElement();
            int num = -1;
            Element next = root.getElement(root.getElementIndex(offset));
            while (!next.isLeaf()) {
                ++num;
                if (next.getAttributes().getAttribute(StyleConstants.NameAttribute).equals(tag)) {
                    return num;
                }
                next = next.getElement(next.getElementIndex(offset));
            }
            return num;
        }

        protected Element findElementMatchingTag(HTMLDocument doc, int offset, HTML.Tag tag) {
            Element element = doc.getDefaultRootElement();
            Element tagElement = null;
            while (element != null) {
                Object otag = element.getAttributes().getAttribute(StyleConstants.NameAttribute);
                if (otag instanceof HTML.Tag && otag.equals(tag)) {
                    tagElement = element;
                }
                element = element.getElement(element.getElementIndex(offset));
            }
            return tagElement;
        }
    }

    public static class InsertHTMLTextAction
    extends HTMLTextAction {
        protected HTML.Tag addTag;
        protected HTML.Tag alternateAddTag;
        protected HTML.Tag alternateParentTag;
        protected String html;
        protected HTML.Tag parentTag;

        public InsertHTMLTextAction(String name, String html, HTML.Tag parentTag, HTML.Tag addTag) {
            this(name, html, parentTag, addTag, null, null);
        }

        public InsertHTMLTextAction(String name, String html, HTML.Tag parentTag, HTML.Tag addTag, HTML.Tag alternateParentTag, HTML.Tag alternateAddTag) {
            super(name);
            this.html = html;
            this.parentTag = parentTag;
            this.addTag = addTag;
            this.alternateParentTag = alternateParentTag;
            this.alternateAddTag = alternateAddTag;
        }

        protected void insertHTML(JEditorPane editor, HTMLDocument doc, int offset, String html, int popDepth, int pushDepth, HTML.Tag addTag) {
            try {
                super.getHTMLEditorKit(editor).insertHTML(doc, offset, html, popDepth, pushDepth, addTag);
            }
            catch (IOException e) {
                throw (RuntimeException)new RuntimeException("Parser is null.").initCause(e);
            }
            catch (BadLocationException ex) {
                throw (RuntimeException)new RuntimeException("BadLocationException: " + offset).initCause(ex);
            }
        }

        protected void insertAtBoundary(JEditorPane editor, HTMLDocument doc, int offset, Element insertElement, String html, HTML.Tag parentTag, HTML.Tag addTag) {
            this.insertAtBoundry(editor, doc, offset, insertElement, html, parentTag, addTag);
        }

        protected void insertAtBoundry(JEditorPane editor, HTMLDocument doc, int offset, Element insertElement, String html, HTML.Tag parentTag, HTML.Tag addTag) {
            Element el;
            Element parent = insertElement;
            if (offset > 0 || insertElement == null) {
                el = doc.getDefaultRootElement();
                while (el != null && el.getStartOffset() != offset && !el.isLeaf()) {
                    el = el.getElement(el.getElementIndex(offset));
                }
                Element element = parent = el != null ? el.getParentElement() : null;
            }
            if (parent != null) {
                int pops = 0;
                int pushes = 0;
                if (offset == 0 && insertElement != null) {
                    el = parent;
                    while (el != null && !el.isLeaf()) {
                        el = el.getElement(el.getElementIndex(offset));
                        ++pops;
                    }
                } else {
                    el = parent;
                    --offset;
                    while (el != null && !el.isLeaf()) {
                        el = el.getElement(el.getElementIndex(offset));
                        ++pops;
                    }
                    el = parent;
                    ++offset;
                    while (el != null && el != insertElement) {
                        el = el.getElement(el.getElementIndex(offset));
                        ++pushes;
                    }
                }
                pops = Math.max(0, pops - 1);
                this.insertHTML(editor, doc, offset, html, pops, pushes, addTag);
            }
        }

        public void actionPerformed(ActionEvent ae) {
            JEditorPane source = this.getEditor(ae);
            if (source != null) {
                HTMLDocument d = this.getHTMLDocument(source);
                int offset = source.getSelectionStart();
                int length = d.getLength();
                boolean inserted = true;
                if (!this.tryInsert(source, d, offset, this.parentTag, this.addTag)) {
                    inserted = this.tryInsert(source, d, offset, this.alternateParentTag, this.alternateAddTag);
                }
                if (inserted) {
                    this.adjustSelection(source, d, offset, length);
                }
            }
        }

        private boolean tryInsert(JEditorPane pane, HTMLDocument doc, int offset, HTML.Tag tag, HTML.Tag addTag) {
            int depth;
            boolean inserted = false;
            Element el = this.findElementMatchingTag(doc, offset, tag);
            if (el != null && el.getStartOffset() == offset) {
                this.insertAtBoundary(pane, doc, offset, el, this.html, tag, addTag);
                inserted = true;
            } else if (offset > 0 && (depth = this.elementCountToTag(doc, offset - 1, tag)) != -1) {
                this.insertHTML(pane, doc, offset, this.html, depth, 0, addTag);
                inserted = true;
            }
            return inserted;
        }

        private void adjustSelection(JEditorPane pane, HTMLDocument doc, int offset, int oldLen) {
            int newLen = doc.getLength();
            if (newLen != oldLen && offset < newLen) {
                if (offset > 0) {
                    String text;
                    try {
                        text = doc.getText(offset - 1, 1);
                    }
                    catch (BadLocationException badLocationException) {
                        text = null;
                    }
                    if (text != null && text.length() > 0 && text.charAt(0) == '\n') {
                        pane.select(offset, offset);
                    } else {
                        pane.select(offset + 1, offset + 1);
                    }
                } else {
                    pane.select(1, 1);
                }
            }
        }
    }

    public static class LinkController
    extends MouseAdapter
    implements MouseMotionListener,
    Serializable {
        private Element lastAnchorElement;

        public void mouseClicked(MouseEvent e) {
            Point loc;
            int pos;
            JEditorPane editor = (JEditorPane)e.getSource();
            if (!editor.isEditable() && SwingUtilities.isLeftMouseButton(e) && (pos = editor.viewToModel(loc = e.getPoint())) >= 0) {
                this.activateLink(pos, editor, e.getX(), e.getY());
            }
        }

        public void mouseDragged(MouseEvent e) {
        }

        public void mouseMoved(MouseEvent e) {
            Document doc;
            JEditorPane editor = (JEditorPane)e.getSource();
            HTMLEditorKit kit = (HTMLEditorKit)editor.getEditorKit();
            if (!editor.isEditable() && (doc = editor.getDocument()) instanceof HTMLDocument) {
                Element el;
                Cursor newCursor = kit.getDefaultCursor();
                HTMLDocument htmlDoc = (HTMLDocument)doc;
                Point loc = e.getPoint();
                int pos = editor.viewToModel(loc);
                if (pos < (el = htmlDoc.getCharacterElement(pos)).getStartOffset() || pos >= el.getEndOffset()) {
                    el = null;
                }
                if (el != null) {
                    AttributeSet aAtts = (AttributeSet)el.getAttributes().getAttribute(HTML.Tag.A);
                    if (aAtts != null) {
                        if (el != this.lastAnchorElement) {
                            if (this.lastAnchorElement != null) {
                                htmlDoc.updateSpecialClass(this.lastAnchorElement, HTML.Attribute.DYNAMIC_CLASS, null);
                            }
                            this.lastAnchorElement = el;
                            htmlDoc.updateSpecialClass(el, HTML.Attribute.DYNAMIC_CLASS, "hover");
                        }
                        newCursor = kit.getLinkCursor();
                    } else {
                        if (this.lastAnchorElement != null) {
                            htmlDoc.updateSpecialClass(this.lastAnchorElement, HTML.Attribute.DYNAMIC_CLASS, null);
                        }
                        this.lastAnchorElement = null;
                    }
                } else {
                    if (this.lastAnchorElement != null) {
                        htmlDoc.updateSpecialClass(this.lastAnchorElement, HTML.Attribute.DYNAMIC_CLASS, null);
                    }
                    this.lastAnchorElement = null;
                }
                if (editor.getCursor() != newCursor) {
                    editor.setCursor(newCursor);
                }
            }
        }

        protected void activateLink(int pos, JEditorPane editor) {
            this.activateLink(pos, editor);
        }

        private void activateLink(int pos, JEditorPane editor, int x, int y) {
            Document doc = editor.getDocument();
            if (doc instanceof HTMLDocument) {
                HTMLDocument htmlDoc = (HTMLDocument)doc;
                Element el = htmlDoc.getCharacterElement(pos);
                AttributeSet atts = el.getAttributes();
                AttributeSet anchorAtts = (AttributeSet)atts.getAttribute(HTML.Tag.A);
                String href = null;
                if (anchorAtts != null) {
                    href = (String)anchorAtts.getAttribute(HTML.Attribute.HREF);
                    htmlDoc.updateSpecialClass(el, HTML.Attribute.PSEUDO_CLASS, "visited");
                }
                HyperlinkEvent event = null;
                if (href != null) {
                    event = this.createHyperlinkEvent(editor, htmlDoc, href, anchorAtts, el);
                }
                if (event != null) {
                    editor.fireHyperlinkUpdate(event);
                }
            }
        }

        private HyperlinkEvent createHyperlinkEvent(JEditorPane editor, HTMLDocument doc, String href, AttributeSet anchor, Element el) {
            HyperlinkEvent ev;
            URL url;
            try {
                URL base = doc.getBase();
                url = new URL(base, href);
            }
            catch (MalformedURLException malformedURLException) {
                url = null;
            }
            if (doc.isFrameDocument()) {
                String target = null;
                if (anchor != null) {
                    target = (String)anchor.getAttribute(HTML.Attribute.TARGET);
                }
                if (target == null || target.equals("")) {
                    target = doc.getBaseTarget();
                }
                if (target == null || target.equals("")) {
                    target = "_self";
                }
                ev = new HTMLFrameHyperlinkEvent(editor, HyperlinkEvent.EventType.ACTIVATED, url, href, el, target);
            } else {
                ev = new HyperlinkEvent(editor, HyperlinkEvent.EventType.ACTIVATED, url, href, el);
            }
            return ev;
        }
    }

    public static abstract class Parser {
        public abstract void parse(Reader var1, ParserCallback var2, boolean var3) throws IOException;
    }

    public static class ParserCallback {
        public static final Object IMPLIED = "_implied_";

        public void flush() throws BadLocationException {
        }

        public void handleComment(char[] comment, int position) {
        }

        public void handleEndOfLineString(String end_of_line) {
        }

        public void handleEndTag(HTML.Tag tag, int position) {
        }

        public void handleError(String message, int position) {
        }

        public void handleSimpleTag(HTML.Tag tag, MutableAttributeSet attributes, int position) {
        }

        public void handleStartTag(HTML.Tag tag, MutableAttributeSet attributes, int position) {
        }

        public void handleText(char[] text, int position) {
        }
    }
}

