/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.io.Serializable;

public class TabStop
implements Serializable {
    private static final long serialVersionUID = -5381995917363605058L;
    public static final int ALIGN_LEFT = 0;
    public static final int ALIGN_RIGHT = 1;
    public static final int ALIGN_CENTER = 2;
    public static final int ALIGN_DECIMAL = 4;
    public static final int ALIGN_BAR = 5;
    public static final int LEAD_NONE = 0;
    public static final int LEAD_DOTS = 1;
    public static final int LEAD_HYPHENS = 2;
    public static final int LEAD_UNDERLINE = 3;
    public static final int LEAD_THICKLINE = 4;
    public static final int LEAD_EQUALS = 5;
    float pos;
    int align;
    int leader;

    public TabStop(float pos) {
        this(pos, 0, 0);
    }

    public TabStop(float pos, int align, int leader) {
        this.pos = pos;
        this.align = align;
        this.leader = leader;
    }

    public boolean equals(Object other) {
        return other != null && other instanceof TabStop && ((TabStop)other).getPosition() == this.getPosition() && ((TabStop)other).getLeader() == this.getLeader() && ((TabStop)other).getAlignment() == this.getAlignment();
    }

    public int getAlignment() {
        return this.align;
    }

    public int getLeader() {
        return this.leader;
    }

    public float getPosition() {
        return this.pos;
    }

    public int hashCode() {
        return (int)this.pos + this.leader + this.align;
    }

    public String toString() {
        String prefix = "";
        switch (this.align) {
            case 1: {
                prefix = "right ";
                break;
            }
            case 2: {
                prefix = "center ";
                break;
            }
            case 4: {
                prefix = "decimal ";
                break;
            }
            case 5: {
                prefix = "bar ";
                break;
            }
        }
        return String.valueOf(prefix) + "tab @" + this.pos + (this.leader == 0 ? "" : " (w/leaders)");
    }
}

