/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.table;

import java.io.Serializable;
import java.util.Vector;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;

public class DefaultTableModel
extends AbstractTableModel
implements Serializable {
    static final long serialVersionUID = 6680042567037222321L;
    protected Vector dataVector;
    protected Vector columnIdentifiers;

    public DefaultTableModel() {
        this(0, 0);
    }

    public DefaultTableModel(int numRows, int numColumns) {
        Vector<String> defaultNames = new Vector<String>(numColumns);
        Vector data = new Vector(numRows);
        int i = 0;
        while (i < numColumns) {
            defaultNames.add(super.getColumnName(i));
            ++i;
        }
        int r = 0;
        while (r < numRows) {
            Vector tmp = new Vector(numColumns);
            tmp.setSize(numColumns);
            data.add(tmp);
            ++r;
        }
        this.setDataVector(data, defaultNames);
    }

    public DefaultTableModel(Vector columnNames, int numRows) {
        if (numRows < 0) {
            throw new IllegalArgumentException("numRows < 0");
        }
        Vector data = new Vector();
        int numColumns = 0;
        if (columnNames != null) {
            numColumns = columnNames.size();
        }
        while (numRows-- > 0) {
            Vector rowData = new Vector();
            rowData.setSize(numColumns);
            data.add(rowData);
        }
        this.setDataVector(data, columnNames);
    }

    public DefaultTableModel(Object[] columnNames, int numRows) {
        this(DefaultTableModel.convertToVector(columnNames), numRows);
    }

    public DefaultTableModel(Vector data, Vector columnNames) {
        this.setDataVector(data, columnNames);
    }

    public DefaultTableModel(Object[][] data, Object[] columnNames) {
        this(DefaultTableModel.convertToVector(data), DefaultTableModel.convertToVector(columnNames));
    }

    public Vector getDataVector() {
        return this.dataVector;
    }

    public void setDataVector(Vector data, Vector columnNames) {
        this.dataVector = data == null ? new Vector() : data;
        this.setColumnIdentifiers(columnNames);
    }

    public void setDataVector(Object[][] data, Object[] columnNames) {
        this.setDataVector(DefaultTableModel.convertToVector(data), DefaultTableModel.convertToVector(columnNames));
    }

    public void newDataAvailable(TableModelEvent event) {
        this.fireTableChanged(event);
    }

    public void newRowsAdded(TableModelEvent event) {
        this.fireTableChanged(event);
    }

    public void rowsRemoved(TableModelEvent event) {
        this.fireTableChanged(event);
    }

    public void setColumnIdentifiers(Vector columnIdentifiers) {
        this.columnIdentifiers = columnIdentifiers;
        this.setColumnCount(columnIdentifiers == null ? 0 : columnIdentifiers.size());
    }

    public void setColumnIdentifiers(Object[] columnIdentifiers) {
        this.setColumnIdentifiers(DefaultTableModel.convertToVector(columnIdentifiers));
    }

    public void setNumRows(int numRows) {
        this.setRowCount(numRows);
    }

    public void setRowCount(int rowCount) {
        int existingRowCount = this.dataVector.size();
        if (rowCount < existingRowCount) {
            this.dataVector.setSize(rowCount);
            this.fireTableRowsDeleted(rowCount, existingRowCount - 1);
        } else {
            int rowsToAdd = rowCount - existingRowCount;
            this.addExtraRows(rowsToAdd, this.columnIdentifiers.size());
            this.fireTableRowsInserted(existingRowCount, rowCount - 1);
        }
    }

    public void setColumnCount(int columnCount) {
        int i = 0;
        while (i < this.dataVector.size()) {
            ((Vector)this.dataVector.get(i)).setSize(columnCount);
            ++i;
        }
        if (this.columnIdentifiers != null) {
            this.columnIdentifiers.setSize(columnCount);
        }
        this.fireTableStructureChanged();
    }

    public void addColumn(Object columnName) {
        this.addColumn(columnName, (Object[])null);
    }

    public void addColumn(Object columnName, Vector columnData) {
        Object[] dataArray = null;
        if (columnData != null) {
            int rowCount = this.dataVector.size();
            if (columnData.size() < rowCount) {
                columnData.setSize(rowCount);
            }
            dataArray = columnData.toArray();
        }
        this.addColumn(columnName, dataArray);
    }

    public void addColumn(Object columnName, Object[] columnData) {
        if (columnData != null) {
            if (columnData.length > this.dataVector.size()) {
                int rowsToAdd = columnData.length - this.dataVector.size();
                this.addExtraRows(rowsToAdd, this.columnIdentifiers.size());
            } else if (columnData.length < this.dataVector.size()) {
                Object[] tmp = new Object[this.dataVector.size()];
                System.arraycopy(columnData, 0, tmp, 0, columnData.length);
                columnData = tmp;
            }
        }
        int i = 0;
        while (i < this.dataVector.size()) {
            ((Vector)this.dataVector.get(i)).add(columnData == null ? null : columnData[i]);
            ++i;
        }
        this.columnIdentifiers.add(columnName);
        this.fireTableStructureChanged();
    }

    public void addRow(Vector rowData) {
        int rowIndex = this.dataVector.size();
        this.dataVector.add(rowData);
        this.newRowsAdded(new TableModelEvent(this, rowIndex, rowIndex, -1, 1));
    }

    public void addRow(Object[] rowData) {
        this.addRow(DefaultTableModel.convertToVector(rowData));
    }

    public void insertRow(int row, Vector rowData) {
        this.dataVector.add(row, rowData);
        this.fireTableRowsInserted(row, row);
    }

    public void insertRow(int row, Object[] rowData) {
        this.insertRow(row, DefaultTableModel.convertToVector(rowData));
    }

    public void moveRow(int startIndex, int endIndex, int toIndex) {
        Vector removed = new Vector();
        int i = endIndex;
        while (i >= startIndex) {
            removed.add(this.dataVector.remove(i));
            --i;
        }
        i = 0;
        while (i <= endIndex - startIndex) {
            this.dataVector.insertElementAt(removed.get(i), toIndex);
            ++i;
        }
        int firstRow = Math.min(startIndex, toIndex);
        int lastRow = Math.max(endIndex, toIndex + (endIndex - startIndex));
        this.fireTableRowsUpdated(firstRow, lastRow);
    }

    public void removeRow(int row) {
        this.dataVector.remove(row);
        this.fireTableRowsDeleted(row, row);
    }

    public int getRowCount() {
        return this.dataVector.size();
    }

    public int getColumnCount() {
        return this.columnIdentifiers == null ? 0 : this.columnIdentifiers.size();
    }

    public String getColumnName(int column) {
        String result = "";
        if (this.columnIdentifiers == null) {
            result = super.getColumnName(column);
        } else if (column < this.getColumnCount()) {
            this.checkSize();
            Object id = this.columnIdentifiers.get(column);
            result = id != null ? id.toString() : super.getColumnName(column);
        } else {
            result = super.getColumnName(column);
        }
        return result;
    }

    public boolean isCellEditable(int row, int column) {
        return true;
    }

    public Object getValueAt(int row, int column) {
        return ((Vector)this.dataVector.get(row)).get(column);
    }

    public void setValueAt(Object value, int row, int column) {
        ((Vector)this.dataVector.get(row)).set(column, value);
        this.fireTableCellUpdated(row, column);
    }

    protected static Vector convertToVector(Object[] data) {
        if (data == null) {
            return null;
        }
        Vector<Object> vector = new Vector<Object>(data.length);
        int i = 0;
        while (i < data.length) {
            vector.add(data[i]);
            ++i;
        }
        return vector;
    }

    protected static Vector convertToVector(Object[][] data) {
        if (data == null) {
            return null;
        }
        Vector<Vector> vector = new Vector<Vector>(data.length);
        int i = 0;
        while (i < data.length) {
            vector.add(DefaultTableModel.convertToVector(data[i]));
            ++i;
        }
        return vector;
    }

    private void addExtraRows(int rowsToAdd, int nbColumns) {
        int i = 0;
        while (i < rowsToAdd) {
            Vector tmp = new Vector();
            tmp.setSize(this.columnIdentifiers.size());
            this.dataVector.add(tmp);
            ++i;
        }
    }

    private void checkSize() {
        int columnCount = this.getColumnCount();
        int rowCount = this.getRowCount();
        if (columnCount > this.columnIdentifiers.size()) {
            this.columnIdentifiers.setSize(columnCount);
        }
        if (this.dataVector != null && rowCount > this.dataVector.size()) {
            int rowsToAdd = rowCount - this.dataVector.size();
            this.addExtraRows(rowsToAdd, columnCount);
        }
    }
}

