/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import gnu.classpath.SystemProperties;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.ActionMap;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.MenuDragMouseEvent;
import javax.swing.event.MenuDragMouseListener;
import javax.swing.event.MenuKeyEvent;
import javax.swing.event.MenuKeyListener;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ActionMapUIResource;
import javax.swing.plaf.ComponentInputMapUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.MenuItemUI;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.text.View;

public class BasicMenuItemUI
extends MenuItemUI {
    protected Font acceleratorFont;
    protected Color acceleratorForeground;
    protected Color acceleratorSelectionForeground;
    protected Icon arrowIcon;
    protected Icon checkIcon;
    protected int defaultTextIconGap = 4;
    protected Color disabledForeground;
    protected MenuDragMouseListener menuDragMouseListener;
    protected JMenuItem menuItem;
    protected MenuKeyListener menuKeyListener;
    protected MouseInputListener mouseInputListener = this.createMouseInputListener(this.menuItem);
    protected boolean oldBorderPainted;
    protected Color selectionBackground;
    protected Color selectionForeground;
    private String acceleratorDelimiter;
    private ItemListener itemListener;
    private PropertyChangeHandler propertyChangeListener;
    private Rectangle viewRect;
    private Rectangle textRect;
    private Rectangle accelRect;
    private Rectangle iconRect;
    private Rectangle arrowIconRect;
    private Rectangle checkIconRect;
    private Rectangle cachedRect;

    public BasicMenuItemUI() {
        this.menuDragMouseListener = this.createMenuDragMouseListener(this.menuItem);
        this.menuKeyListener = this.createMenuKeyListener(this.menuItem);
        this.itemListener = new ItemHandler();
        this.propertyChangeListener = new PropertyChangeHandler();
        this.viewRect = new Rectangle();
        this.textRect = new Rectangle();
        this.iconRect = new Rectangle();
        this.arrowIconRect = new Rectangle();
        this.checkIconRect = new Rectangle();
        this.accelRect = new Rectangle();
        this.cachedRect = new Rectangle();
    }

    protected MenuDragMouseListener createMenuDragMouseListener(JComponent c) {
        return new MenuDragMouseHandler();
    }

    protected MenuKeyListener createMenuKeyListener(JComponent c) {
        return new MenuKeyHandler();
    }

    protected MouseInputListener createMouseInputListener(JComponent c) {
        return new MouseInputHandler();
    }

    public static ComponentUI createUI(JComponent c) {
        return new BasicMenuItemUI();
    }

    protected void doClick(MenuSelectionManager msm) {
        this.menuItem.doClick(0);
        msm.clearSelectedPath();
    }

    public Dimension getMaximumSize(JComponent c) {
        return null;
    }

    public Dimension getMinimumSize(JComponent c) {
        return null;
    }

    public MenuElement[] getPath() {
        ArrayList<JMenuItem> path = new ArrayList<JMenuItem>();
        Component c = this.menuItem;
        while (c instanceof MenuElement) {
            path.add(0, (JMenuItem)c);
            c = c instanceof JPopupMenu ? ((JPopupMenu)c).getInvoker() : c.getParent();
        }
        MenuElement[] pathArray = new MenuElement[path.size()];
        path.toArray(pathArray);
        return pathArray;
    }

    protected Dimension getPreferredMenuItemSize(JComponent c, Icon checkIcon, Icon arrowIcon, int defaultTextIconGap) {
        JMenuItem m = (JMenuItem)c;
        String accelText = this.getAcceleratorString(m);
        this.resetRectangles(null);
        this.layoutMenuItem(m, accelText);
        this.cachedRect.setBounds(this.textRect);
        Rectangle pref = SwingUtilities.computeUnion(this.iconRect.x, this.iconRect.y, this.iconRect.width, this.iconRect.height, this.cachedRect);
        Container parent = m.getParent();
        if (!(parent == null || !(parent instanceof JComponent) || m instanceof JMenu && ((JMenu)m).isTopLevelMenu())) {
            int maxAccelValue;
            int maxTextValue;
            JComponent p = (JComponent)parent;
            Integer maxTextWidth = (Integer)p.getClientProperty("maxTextWidth");
            int n = maxTextValue = maxTextWidth == null ? 0 : maxTextWidth;
            if (pref.width < maxTextValue) {
                pref.width = maxTextValue;
            } else {
                p.putClientProperty("maxTextWidth", new Integer(pref.width));
            }
            Integer maxAccelWidth = (Integer)p.getClientProperty("maxAccelWidth");
            int n2 = maxAccelValue = maxAccelWidth == null ? 0 : maxAccelWidth;
            if (this.accelRect.width > maxAccelValue) {
                maxAccelValue = this.accelRect.width;
                p.putClientProperty("maxAccelWidth", new Integer(this.accelRect.width));
            }
            pref.width += maxAccelValue;
            pref.width += defaultTextIconGap;
        }
        if (!(m instanceof JMenu) || !((JMenu)m).isTopLevelMenu()) {
            pref.width += this.checkIconRect.width;
            pref.width += defaultTextIconGap;
            pref.width += this.arrowIconRect.width;
            pref.width += defaultTextIconGap;
        }
        pref.width += 2 * defaultTextIconGap;
        Insets i = m.getInsets();
        pref.width += i.left + i.right;
        pref.height += i.top + i.bottom;
        return pref.getSize();
    }

    public Dimension getPreferredSize(JComponent c) {
        return this.getPreferredMenuItemSize(c, this.checkIcon, this.arrowIcon, this.defaultTextIconGap);
    }

    protected String getPropertyPrefix() {
        return "MenuItem";
    }

    protected void installComponents(JMenuItem menuItem) {
    }

    protected void installDefaults() {
        String prefix = this.getPropertyPrefix();
        LookAndFeel.installBorder(this.menuItem, String.valueOf(prefix) + ".border");
        LookAndFeel.installColorsAndFont(this.menuItem, String.valueOf(prefix) + ".background", String.valueOf(prefix) + ".foreground", String.valueOf(prefix) + ".font");
        this.menuItem.setMargin(UIManager.getInsets(String.valueOf(prefix) + ".margin"));
        this.acceleratorFont = UIManager.getFont(String.valueOf(prefix) + ".acceleratorFont");
        this.acceleratorForeground = UIManager.getColor(String.valueOf(prefix) + ".acceleratorForeground");
        this.acceleratorSelectionForeground = UIManager.getColor(String.valueOf(prefix) + ".acceleratorSelectionForeground");
        this.selectionBackground = UIManager.getColor(String.valueOf(prefix) + ".selectionBackground");
        this.selectionForeground = UIManager.getColor(String.valueOf(prefix) + ".selectionForeground");
        this.acceleratorDelimiter = UIManager.getString(String.valueOf(prefix) + ".acceleratorDelimiter");
        this.checkIcon = UIManager.getIcon(String.valueOf(prefix) + ".checkIcon");
        this.menuItem.setHorizontalTextPosition(11);
        this.menuItem.setHorizontalAlignment(10);
    }

    protected void installKeyboardActions() {
        KeyStroke accelerator;
        InputMap focusedWindowMap = SwingUtilities.getUIInputMap(this.menuItem, 2);
        if (focusedWindowMap == null) {
            focusedWindowMap = new ComponentInputMapUIResource(this.menuItem);
        }
        if ((accelerator = this.menuItem.getAccelerator()) != null) {
            focusedWindowMap.put(accelerator, "doClick");
        }
        SwingUtilities.replaceUIInputMap(this.menuItem, 2, focusedWindowMap);
        ActionMap UIActionMap = SwingUtilities.getUIActionMap(this.menuItem);
        if (UIActionMap == null) {
            UIActionMap = new ActionMapUIResource();
        }
        UIActionMap.put("doClick", new ClickAction());
        SwingUtilities.replaceUIActionMap(this.menuItem, UIActionMap);
    }

    protected void installListeners() {
        this.menuItem.addMouseListener(this.mouseInputListener);
        this.menuItem.addMouseMotionListener(this.mouseInputListener);
        this.menuItem.addMenuDragMouseListener(this.menuDragMouseListener);
        this.menuItem.addMenuKeyListener(this.menuKeyListener);
        this.menuItem.addItemListener(this.itemListener);
        this.menuItem.addPropertyChangeListener(this.propertyChangeListener);
        this.propertyChangeListener.propertyChange(new PropertyChangeEvent(this.menuItem, "font", null, this.menuItem.getFont()));
    }

    public void installUI(JComponent c) {
        super.installUI(c);
        this.menuItem = (JMenuItem)c;
        this.installDefaults();
        this.installComponents(this.menuItem);
        this.installListeners();
        this.installKeyboardActions();
    }

    public void paint(Graphics g, JComponent c) {
        this.paintMenuItem(g, c, this.checkIcon, this.arrowIcon, this.selectionBackground, c.getForeground(), this.defaultTextIconGap);
    }

    protected void paintBackground(Graphics g, JMenuItem menuItem, Color bgColor) {
        ButtonModel mod = menuItem.getModel();
        Color saved = g.getColor();
        if (mod.isArmed() || menuItem instanceof JMenu && mod.isSelected()) {
            g.setColor(bgColor);
            g.fillRect(0, 0, menuItem.getWidth(), menuItem.getHeight());
        } else if (menuItem.isOpaque()) {
            g.setColor(menuItem.getBackground());
            g.fillRect(0, 0, menuItem.getWidth(), menuItem.getHeight());
        }
        g.setColor(saved);
    }

    protected void paintMenuItem(Graphics g, JComponent c, Icon checkIcon, Icon arrowIcon, Color background, Color foreground, int defaultTextIconGap) {
        String text;
        JMenuItem m = (JMenuItem)c;
        Font oldFont = g.getFont();
        Font font = c.getFont();
        g.setFont(font);
        FontMetrics accelFm = m.getFontMetrics(this.acceleratorFont);
        String accelText = this.getAcceleratorString(m);
        this.resetRectangles(m);
        this.layoutMenuItem(m, accelText);
        this.paintBackground(g, m, background);
        Color oldColor = g.getColor();
        if (checkIcon != null) {
            checkIcon.paintIcon(m, g, this.checkIconRect.x, this.checkIconRect.y);
        }
        ButtonModel model = m.getModel();
        if (m.getIcon() != null) {
            Icon icon;
            if (!m.isEnabled()) {
                icon = m.getDisabledIcon();
            } else if (model.isPressed() && model.isArmed()) {
                icon = m.getPressedIcon();
                if (icon == null) {
                    icon = m.getIcon();
                }
            } else {
                icon = m.getIcon();
            }
            if (icon != null) {
                icon.paintIcon(m, g, this.iconRect.x, this.iconRect.y);
            }
        }
        if ((text = m.getText()) != null) {
            View html = (View)m.getClientProperty("html");
            if (html != null) {
                html.paint(g, this.textRect);
            } else {
                this.paintText(g, m, this.textRect, text);
            }
        }
        if (!accelText.equals("")) {
            int accelOffset = 0;
            Container parent = m.getParent();
            if (parent != null && parent instanceof JComponent) {
                JComponent p = (JComponent)parent;
                Integer maxAccelWidth = (Integer)p.getClientProperty("maxAccelWidth");
                int maxAccelValue = maxAccelWidth == null ? 0 : maxAccelWidth;
                accelOffset = maxAccelValue - this.accelRect.width;
            }
            g.setFont(this.acceleratorFont);
            if (!m.isEnabled()) {
                g.setColor(this.disabledForeground);
            } else if (m.isArmed() || m instanceof JMenu && m.isSelected()) {
                g.setColor(this.acceleratorSelectionForeground);
            } else {
                g.setColor(this.acceleratorForeground);
            }
            g.drawString(accelText, this.accelRect.x - accelOffset, this.accelRect.y + accelFm.getAscent());
        }
        if (!(arrowIcon == null || m instanceof JMenu && ((JMenu)m).isTopLevelMenu())) {
            arrowIcon.paintIcon(m, g, this.arrowIconRect.x, this.arrowIconRect.y);
        }
        g.setFont(oldFont);
        g.setColor(oldColor);
    }

    protected void paintText(Graphics g, JMenuItem menuItem, Rectangle textRect, String text) {
        Font f = menuItem.getFont();
        g.setFont(f);
        FontMetrics fm = g.getFontMetrics(f);
        if (text != null && !text.equals("")) {
            if (menuItem.isEnabled()) {
                ButtonModel mod = menuItem.getModel();
                if (menuItem.isSelected() && this.checkIcon == null || mod != null && mod.isArmed() && menuItem.getParent() instanceof MenuElement) {
                    g.setColor(this.selectionForeground);
                } else {
                    g.setColor(menuItem.getForeground());
                }
            } else {
                g.setColor(Color.gray);
            }
            int mnemonicIndex = menuItem.getDisplayedMnemonicIndex();
            if (mnemonicIndex != -1) {
                BasicGraphicsUtils.drawStringUnderlineCharAt(menuItem, g, text, mnemonicIndex, textRect.x, textRect.y + fm.getAscent());
            } else {
                BasicGraphicsUtils.drawString(menuItem, g, text, 0, textRect.x, textRect.y + fm.getAscent());
            }
        }
    }

    protected void uninstallComponents(JMenuItem menuItem) {
    }

    protected void uninstallDefaults() {
        this.menuItem.setForeground(null);
        this.menuItem.setBackground(null);
        this.menuItem.setBorder(null);
        this.menuItem.setMargin(null);
        this.menuItem.setBackground(null);
        this.menuItem.setBorder(null);
        this.menuItem.setFont(null);
        this.menuItem.setForeground(null);
        this.menuItem.setMargin(null);
        this.acceleratorFont = null;
        this.acceleratorForeground = null;
        this.acceleratorSelectionForeground = null;
        this.arrowIcon = null;
        this.selectionBackground = null;
        this.selectionForeground = null;
        this.acceleratorDelimiter = null;
    }

    protected void uninstallKeyboardActions() {
        SwingUtilities.replaceUIInputMap(this.menuItem, 2, null);
    }

    protected void uninstallListeners() {
        this.menuItem.removeMouseListener(this.mouseInputListener);
        this.menuItem.removeMenuDragMouseListener(this.menuDragMouseListener);
        this.menuItem.removeMenuKeyListener(this.menuKeyListener);
        this.menuItem.removeItemListener(this.itemListener);
        this.menuItem.removePropertyChangeListener(this.propertyChangeListener);
    }

    public void uninstallUI(JComponent c) {
        this.uninstallListeners();
        this.uninstallDefaults();
        this.uninstallComponents(this.menuItem);
        c.putClientProperty("BasicGraphicsUtils.cachedTextLayout", null);
        this.menuItem = null;
    }

    public void update(Graphics g, JComponent c) {
        this.paint(g, c);
    }

    private String getAcceleratorString(JMenuItem m) {
        KeyStroke accel = m.getAccelerator();
        String accelText = "";
        if (accel != null) {
            int keycode;
            int mods = accel.getModifiers();
            if (mods > 0) {
                accelText = KeyEvent.getKeyModifiersText(mods);
                accelText = String.valueOf(accelText) + this.acceleratorDelimiter;
            }
            accelText = (keycode = accel.getKeyCode()) != 0 ? String.valueOf(accelText) + KeyEvent.getKeyText(keycode) : String.valueOf(accelText) + accel.getKeyChar();
        }
        return accelText;
    }

    private void resetRectangles(JMenuItem i) {
        this.iconRect.setBounds(0, 0, 0, 0);
        this.textRect.setBounds(0, 0, 0, 0);
        this.accelRect.setBounds(0, 0, 0, 0);
        this.checkIconRect.setBounds(0, 0, 0, 0);
        this.arrowIconRect.setBounds(0, 0, 0, 0);
        if (i == null) {
            this.viewRect.setBounds(0, 0, Short.MAX_VALUE, Short.MAX_VALUE);
        } else {
            Insets insets = i.getInsets();
            this.viewRect.setBounds(insets.left, insets.top, i.getWidth() - insets.left - insets.right, i.getHeight() - insets.top - insets.bottom);
        }
    }

    private void layoutMenuItem(JMenuItem m, String accelText) {
        Font font = m.getFont();
        FontMetrics fm = m.getFontMetrics(font);
        FontMetrics accelFm = m.getFontMetrics(this.acceleratorFont);
        String text = m.getText();
        SwingUtilities.layoutCompoundLabel(m, fm, text, m.getIcon(), m.getVerticalAlignment(), m.getHorizontalAlignment(), m.getVerticalTextPosition(), m.getHorizontalTextPosition(), this.viewRect, this.iconRect, this.textRect, this.defaultTextIconGap);
        if (!accelText.equals("")) {
            this.accelRect.width = accelFm.stringWidth(accelText);
            this.accelRect.height = accelFm.getHeight();
        }
        if (!(m instanceof JMenu) || !((JMenu)m).isTopLevelMenu()) {
            if (this.checkIcon != null) {
                this.checkIconRect.width = this.checkIcon.getIconWidth();
                this.checkIconRect.height = this.checkIcon.getIconHeight();
            }
            if (this.arrowIcon != null) {
                this.arrowIconRect.width = this.arrowIcon.getIconWidth();
                this.arrowIconRect.height = this.arrowIcon.getIconHeight();
            }
        }
        this.cachedRect.setBounds(this.textRect);
        Rectangle labelRect = SwingUtilities.computeUnion(this.iconRect.x, this.iconRect.y, this.iconRect.width, this.iconRect.height, this.cachedRect);
        this.textRect.x += this.defaultTextIconGap;
        this.iconRect.x += this.defaultTextIconGap;
        this.accelRect.x = this.viewRect.x + this.viewRect.width - this.arrowIconRect.width - this.defaultTextIconGap - this.accelRect.width;
        if (!(m instanceof JMenu) || !((JMenu)m).isTopLevelMenu()) {
            this.checkIconRect.x = this.viewRect.x + this.defaultTextIconGap;
            this.textRect.x += this.defaultTextIconGap + this.checkIconRect.width;
            this.iconRect.x += this.defaultTextIconGap + this.checkIconRect.width;
            this.arrowIconRect.x = this.viewRect.x + this.viewRect.width - this.defaultTextIconGap - this.arrowIconRect.width;
        }
        this.accelRect.y = labelRect.y + labelRect.height / 2 - this.accelRect.height / 2;
        if (!(m instanceof JMenu) || !((JMenu)m).isTopLevelMenu()) {
            this.arrowIconRect.y = labelRect.y + labelRect.height / 2 - this.arrowIconRect.height / 2;
            this.checkIconRect.y = labelRect.y + labelRect.height / 2 - this.checkIconRect.height / 2;
        }
    }

    class ClickAction
    extends AbstractAction {
        ClickAction() {
        }

        public void actionPerformed(ActionEvent event) {
            BasicMenuItemUI.this.doClick(MenuSelectionManager.defaultManager());
        }
    }

    private class ItemHandler
    implements ItemListener {
        private ItemHandler() {
        }

        public void itemStateChanged(ItemEvent evt) {
            boolean state = false;
            if (BasicMenuItemUI.this.menuItem instanceof JCheckBoxMenuItem) {
                if (evt.getStateChange() == 1) {
                    state = true;
                }
                ((JCheckBoxMenuItem)BasicMenuItemUI.this.menuItem).setState(state);
            }
            BasicMenuItemUI.this.menuItem.revalidate();
            BasicMenuItemUI.this.menuItem.repaint();
        }
    }

    private class MenuDragMouseHandler
    implements MenuDragMouseListener {
        private MenuDragMouseHandler() {
        }

        public void menuDragMouseDragged(MenuDragMouseEvent e) {
            MenuSelectionManager manager = e.getMenuSelectionManager();
            manager.setSelectedPath(e.getPath());
        }

        public void menuDragMouseEntered(MenuDragMouseEvent e) {
            MenuSelectionManager manager = e.getMenuSelectionManager();
            manager.setSelectedPath(e.getPath());
        }

        public void menuDragMouseExited(MenuDragMouseEvent e) {
        }

        public void menuDragMouseReleased(MenuDragMouseEvent e) {
            MenuSelectionManager manager = e.getMenuSelectionManager();
            int x = e.getX();
            int y = e.getY();
            if (x >= 0 && x < BasicMenuItemUI.this.menuItem.getWidth() && y >= 0 && y < BasicMenuItemUI.this.menuItem.getHeight()) {
                BasicMenuItemUI.this.doClick(manager);
            } else {
                manager.clearSelectedPath();
            }
        }
    }

    private class MenuKeyHandler
    implements MenuKeyListener {
        private MenuKeyHandler() {
        }

        public void menuKeyPressed(MenuKeyEvent e) {
        }

        public void menuKeyReleased(MenuKeyEvent e) {
        }

        public void menuKeyTyped(MenuKeyEvent e) {
        }
    }

    protected class MouseInputHandler
    implements MouseInputListener {
        protected MouseInputHandler() {
        }

        public void mouseClicked(MouseEvent e) {
            MenuSelectionManager manager = MenuSelectionManager.defaultManager();
            manager.processMouseEvent(e);
        }

        public void mouseDragged(MouseEvent e) {
            MenuSelectionManager manager = MenuSelectionManager.defaultManager();
            manager.processMouseEvent(e);
        }

        public void mouseEntered(MouseEvent e) {
            Component source = (Component)e.getSource();
            if (source.getParent() instanceof MenuElement) {
                MenuSelectionManager manager = MenuSelectionManager.defaultManager();
                manager.setSelectedPath(BasicMenuItemUI.this.getPath());
                manager.processMouseEvent(e);
            }
        }

        public void mouseExited(MouseEvent e) {
            MenuSelectionManager manager = MenuSelectionManager.defaultManager();
            manager.processMouseEvent(e);
        }

        public void mouseMoved(MouseEvent e) {
            MenuSelectionManager manager = MenuSelectionManager.defaultManager();
            manager.processMouseEvent(e);
        }

        public void mousePressed(MouseEvent e) {
            MenuSelectionManager manager = MenuSelectionManager.defaultManager();
            manager.processMouseEvent(e);
        }

        public void mouseReleased(MouseEvent e) {
            MenuSelectionManager manager = MenuSelectionManager.defaultManager();
            int x = e.getX();
            int y = e.getY();
            if (x > 0 && x < BasicMenuItemUI.this.menuItem.getWidth() && y > 0 && y < BasicMenuItemUI.this.menuItem.getHeight()) {
                BasicMenuItemUI.this.doClick(manager);
            } else {
                manager.processMouseEvent(e);
            }
        }
    }

    class PropertyChangeHandler
    implements PropertyChangeListener {
        PropertyChangeHandler() {
        }

        public void propertyChange(PropertyChangeEvent e) {
            String property = e.getPropertyName();
            if (property.equals("accelerator")) {
                InputMap map = SwingUtilities.getUIInputMap(BasicMenuItemUI.this.menuItem, 2);
                if (map != null) {
                    map.remove((KeyStroke)e.getOldValue());
                } else {
                    map = new ComponentInputMapUIResource(BasicMenuItemUI.this.menuItem);
                }
                KeyStroke accelerator = (KeyStroke)e.getNewValue();
                if (accelerator != null) {
                    map.put(accelerator, "doClick");
                }
            } else if ((property.equals("text") || property.equals("font")) && SystemProperties.getProperty("gnu.javax.swing.noGraphics2D") == null) {
                AbstractButton b = (AbstractButton)e.getSource();
                String text = b.getText();
                if (text == null) {
                    text = "";
                }
                FontRenderContext frc = new FontRenderContext(new AffineTransform(), false, false);
                TextLayout layout = new TextLayout(text, b.getFont(), frc);
                b.putClientProperty("BasicGraphicsUtils.cachedTextLayout", layout);
            }
        }
    }
}

