/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractListModel;
import javax.swing.JFileChooser;
import javax.swing.SwingUtilities;
import javax.swing.event.ListDataEvent;
import javax.swing.filechooser.FileSystemView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicDirectoryModel
extends AbstractListModel
implements PropertyChangeListener {
    private Vector contents;
    private Vector directories;
    private Vector files;
    private int listingMode;
    private JFileChooser filechooser;
    private DirectoryLoadThread loadThread;
    private Comparator comparator = new Comparator(){

        public int compare(Object o1, Object o2) {
            if (BasicDirectoryModel.this.lt((File)o1, (File)o2)) {
                return -1;
            }
            return 1;
        }
    };

    public BasicDirectoryModel(JFileChooser filechooser) {
        this.filechooser = filechooser;
        filechooser.addPropertyChangeListener(this);
        this.listingMode = filechooser.getFileSelectionMode();
        this.contents = new Vector();
        this.validateFileCache();
    }

    public boolean contains(Object o) {
        return this.contents.contains(o);
    }

    public void fireContentsChanged() {
        this.fireContentsChanged(this, 0, this.getSize() - 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector<File> getDirectories() {
        Vector vector = this.contents;
        synchronized (vector) {
            Vector dirs = this.directories;
            if (dirs == null) {
                this.getFiles();
                dirs = this.directories;
            }
            return dirs;
        }
    }

    @Override
    public Object getElementAt(int index) {
        if (index > this.getSize() - 1) {
            return null;
        }
        return this.contents.elementAt(index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector<File> getFiles() {
        Vector vector = this.contents;
        synchronized (vector) {
            Vector<File> f = this.files;
            if (f == null) {
                f = new Vector<File>();
                Vector<File> d = new Vector<File>();
                for (File file : this.contents) {
                    if (this.filechooser.isTraversable(file)) {
                        d.add(file);
                        continue;
                    }
                    f.add(file);
                }
                this.files = f;
                this.directories = d;
            }
            return f;
        }
    }

    @Override
    public int getSize() {
        return this.contents.size();
    }

    public int indexOf(Object o) {
        return this.contents.indexOf(o);
    }

    public void intervalAdded(ListDataEvent e) {
    }

    public void intervalRemoved(ListDataEvent e) {
    }

    public void invalidateFileCache() {
    }

    protected boolean lt(File a, File b) {
        boolean bTrav;
        boolean aTrav = this.filechooser.isTraversable(a);
        if (aTrav == (bTrav = this.filechooser.isTraversable(b))) {
            String bname;
            String aname = a.getName().toLowerCase();
            return aname.compareTo(bname = b.getName().toLowerCase()) < 0;
        }
        return aTrav;
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        String property = e.getPropertyName();
        if (property.equals("directoryChanged") || property.equals("fileFilterChanged") || property.equals("FileHidingChanged") || property.equals("fileSelectionChanged") || property.equals("fileViewChanged")) {
            this.validateFileCache();
        }
    }

    public boolean renameFile(File oldFile, File newFile) {
        return oldFile.renameTo(newFile);
    }

    protected void sort(Vector<? extends File> v) {
        Collections.sort(v, this.comparator);
    }

    public void validateFileCache() {
        File dir = this.filechooser.getCurrentDirectory();
        if (dir != null) {
            if (this.loadThread != null) {
                this.loadThread.interrupt();
                this.loadThread.cancelPending();
            }
            this.loadThread = new DirectoryLoadThread(dir);
            this.loadThread.start();
        }
    }

    private class DirectoryLoadThread
    extends Thread {
        File directory;
        private UpdateSwingRequest pending;

        DirectoryLoadThread(File dir) {
            super("Basic L&F directory loader");
            this.directory = dir;
        }

        public void run() {
            int start;
            FileSystemView fsv = BasicDirectoryModel.this.filechooser.getFileSystemView();
            File[] files = fsv.getFiles(this.directory, BasicDirectoryModel.this.filechooser.isFileHidingEnabled());
            if (this.isInterrupted()) {
                return;
            }
            Vector<File> accepted = new Vector<File>();
            int i = 0;
            while (i < files.length) {
                if (BasicDirectoryModel.this.filechooser.accept(files[i])) {
                    accepted.add(files[i]);
                }
                ++i;
            }
            if (this.isInterrupted()) {
                return;
            }
            BasicDirectoryModel.this.sort(accepted);
            Vector<File> newFiles = new Vector<File>();
            Vector<File> newDirectories = new Vector<File>();
            for (File f : accepted) {
                boolean traversable = BasicDirectoryModel.this.filechooser.isTraversable(f);
                if (traversable) {
                    newDirectories.add(f);
                } else if (!traversable && BasicDirectoryModel.this.filechooser.isFileSelectionEnabled()) {
                    newFiles.add(f);
                }
                if (!this.isInterrupted()) continue;
                return;
            }
            Vector<File> newCache = new Vector<File>(newDirectories);
            newCache.addAll((Collection<File>)newFiles);
            int newSize = newCache.size();
            int oldSize = BasicDirectoryModel.this.contents.size();
            if (newSize < oldSize) {
                start = -1;
                int end = -1;
                boolean found = false;
                int i2 = 0;
                while (i2 < newSize && !found) {
                    if (!newCache.get(i2).equals(BasicDirectoryModel.this.contents.get(i2))) {
                        start = i2;
                        end = i2 + oldSize - newSize;
                        found = true;
                    }
                    ++i2;
                }
                if (start >= 0 && end > start && BasicDirectoryModel.this.contents.subList(end, oldSize).equals(newCache.subList(start, newSize))) {
                    if (this.isInterrupted()) {
                        return;
                    }
                    Vector removed = new Vector(BasicDirectoryModel.this.contents.subList(start, end));
                    UpdateSwingRequest r = new UpdateSwingRequest(null, 0, removed, start);
                    this.invokeLater(r);
                    newCache = null;
                }
            } else if (newSize > oldSize) {
                start = oldSize;
                int end = newSize;
                boolean found = false;
                int i3 = 0;
                while (i3 < oldSize && !found) {
                    if (!newCache.get(i3).equals(BasicDirectoryModel.this.contents.get(i3))) {
                        start = i3;
                        boolean foundEnd = false;
                        int j = i3;
                        while (j < newSize && !foundEnd) {
                            if (newCache.get(j).equals(BasicDirectoryModel.this.contents.get(i3))) {
                                end = j;
                                foundEnd = true;
                            }
                            ++j;
                        }
                        end = i3 + oldSize - newSize;
                    }
                    ++i3;
                }
                if (start >= 0 && end > start && newCache.subList(end, newSize).equals(BasicDirectoryModel.this.contents.subList(start, oldSize))) {
                    if (this.isInterrupted()) {
                        return;
                    }
                    List added = newCache.subList(start, end);
                    UpdateSwingRequest r = new UpdateSwingRequest(added, start, null, 0);
                    this.invokeLater(r);
                    newCache = null;
                }
            }
            if (newCache != null && !BasicDirectoryModel.this.contents.equals(newCache)) {
                if (this.isInterrupted()) {
                    return;
                }
                UpdateSwingRequest r = new UpdateSwingRequest(newCache, 0, BasicDirectoryModel.this.contents, 0);
                this.invokeLater(r);
            }
        }

        private void invokeLater(UpdateSwingRequest update) {
            this.pending = update;
            SwingUtilities.invokeLater(update);
        }

        void cancelPending() {
            if (this.pending != null) {
                this.pending.cancel();
            }
        }

        private class UpdateSwingRequest
        implements Runnable {
            private List added;
            private int addIndex;
            private List removed;
            private int removeIndex;
            private boolean cancel;

            UpdateSwingRequest(List add, int ai, List rem, int ri) {
                this.added = add;
                this.addIndex = ai;
                this.removed = rem;
                this.removeIndex = ri;
                this.cancel = false;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                if (!this.cancel) {
                    int numRemoved = this.removed == null ? 0 : this.removed.size();
                    int numAdded = this.added == null ? 0 : this.added.size();
                    Vector vector = BasicDirectoryModel.this.contents;
                    synchronized (vector) {
                        if (numRemoved > 0) {
                            BasicDirectoryModel.this.contents.removeAll(this.removed);
                        }
                        if (numAdded > 0) {
                            BasicDirectoryModel.this.contents.addAll(this.added);
                        }
                        BasicDirectoryModel.this.files = null;
                        BasicDirectoryModel.this.directories = null;
                    }
                    if (numRemoved > 0 && numAdded == 0) {
                        BasicDirectoryModel.this.fireIntervalRemoved(BasicDirectoryModel.this, this.removeIndex, this.removeIndex + numRemoved - 1);
                    } else if (numRemoved == 0 && numAdded > 0) {
                        BasicDirectoryModel.this.fireIntervalAdded(BasicDirectoryModel.this, this.addIndex, this.addIndex + numAdded - 1);
                    } else {
                        BasicDirectoryModel.this.fireContentsChanged();
                    }
                }
            }

            void cancel() {
                this.cancel = true;
            }
        }
    }
}

