/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.Serializable;
import javax.swing.JViewport;
import javax.swing.Scrollable;

public class ViewportLayout
implements LayoutManager,
Serializable {
    private static final long serialVersionUID = -788225906076097229L;

    public void addLayoutComponent(String name, Component c) {
    }

    public void removeLayoutComponent(Component c) {
    }

    public Dimension preferredLayoutSize(Container parent) {
        JViewport vp = (JViewport)parent;
        Component view = vp.getView();
        if (view != null) {
            if (view instanceof Scrollable) {
                return ((Scrollable)((Object)view)).getPreferredScrollableViewportSize();
            }
            return view.getPreferredSize();
        }
        return new Dimension();
    }

    public Dimension minimumLayoutSize(Container parent) {
        return new Dimension(4, 4);
    }

    public void layoutContainer(Container parent) {
        JViewport port = (JViewport)parent;
        Component view = port.getView();
        if (view == null) {
            return;
        }
        Rectangle portBounds = port.getViewRect();
        Dimension viewPref = new Dimension(view.getPreferredSize());
        Point portLowerRight = new Point(portBounds.x + portBounds.width, portBounds.y + portBounds.height);
        if (view instanceof Scrollable) {
            Scrollable sView = (Scrollable)((Object)view);
            if (sView.getScrollableTracksViewportWidth()) {
                viewPref.width = portBounds.width;
                portBounds.x = 0;
            }
            if (sView.getScrollableTracksViewportHeight()) {
                viewPref.height = portBounds.height;
                portBounds.y = 0;
            }
        }
        if (viewPref.width < portBounds.width) {
            viewPref.width = portBounds.width;
        }
        if (viewPref.height < portBounds.height) {
            viewPref.height = portBounds.height;
        }
        if (portLowerRight.x > viewPref.width) {
            portBounds.x = 0;
        }
        if (portLowerRight.y > viewPref.height) {
            portBounds.y = 0;
        }
        port.setViewSize(viewPref);
        port.setViewPosition(portBounds.getLocation());
    }
}

