/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.EventListener;
import java.util.TimerTask;
import javax.swing.SwingUtilities;
import javax.swing.event.EventListenerList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Timer
implements Serializable {
    private static final long serialVersionUID = -1116180831621385484L;
    private Runnable drainer = new Runnable(){

        public void run() {
            Timer.this.drainEvents();
        }
    };
    private static java.util.Timer timer = new java.util.Timer("swing.Timer", true);
    static boolean logTimers;
    protected EventListenerList listenerList = new EventListenerList();
    boolean coalesce = true;
    boolean repeats = true;
    int delay;
    int initialDelay;
    int ticks;
    Task task;
    private long queue;
    private Object queueLock = new Object();

    public Timer(int d, ActionListener listener) {
        this.delay = d;
        this.initialDelay = d;
        if (listener != null) {
            this.addActionListener(listener);
        }
    }

    public ActionListener[] getActionListeners() {
        return (ActionListener[])this.listenerList.getListeners(ActionListener.class);
    }

    public void setCoalesce(boolean c) {
        this.coalesce = c;
    }

    public boolean isCoalesce() {
        return this.coalesce;
    }

    public <T extends EventListener> T[] getListeners(Class<T> listenerType) {
        return this.listenerList.getListeners(listenerType);
    }

    public static void setLogTimers(boolean lt) {
        logTimers = lt;
    }

    public static boolean getLogTimers() {
        return logTimers;
    }

    public void setDelay(int d) {
        if (d < 0) {
            throw new IllegalArgumentException("Invalid delay: " + d);
        }
        this.delay = d;
    }

    public int getDelay() {
        return this.delay;
    }

    public void setInitialDelay(int i) {
        if (i < 0) {
            throw new IllegalArgumentException("Invalid initial delay: " + i);
        }
        this.initialDelay = i;
    }

    public int getInitialDelay() {
        return this.initialDelay;
    }

    public void setRepeats(boolean r) {
        this.repeats = r;
    }

    public boolean isRepeats() {
        return this.repeats;
    }

    public boolean isRunning() {
        return this.task != null;
    }

    public void addActionListener(ActionListener listener) {
        this.listenerList.add(ActionListener.class, listener);
    }

    public void removeActionListener(ActionListener listener) {
        this.listenerList.remove(ActionListener.class, listener);
    }

    public void restart() {
        this.stop();
        this.start();
    }

    public void start() {
        Task t = this.task;
        if (t == null) {
            t = new Task();
            if (this.isRepeats()) {
                timer.schedule((TimerTask)t, this.getInitialDelay(), (long)this.getDelay());
            } else {
                timer.schedule((TimerTask)t, this.getInitialDelay());
            }
            this.task = t;
        }
    }

    public void stop() {
        Task t = this.task;
        if (t != null) {
            t.cancel();
            this.task = null;
        }
    }

    protected void fireActionPerformed(ActionEvent event) {
        ActionListener[] listeners = this.getActionListeners();
        int i = 0;
        while (i < listeners.length) {
            listeners[i].actionPerformed(event);
            ++i;
        }
    }

    void fireActionPerformed() {
        this.fireActionPerformed(new ActionEvent(this, this.ticks++, "Timer"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void drainEvents() {
        Object object = this.queueLock;
        synchronized (object) {
            if (this.isCoalesce()) {
                if (this.queue > 0L) {
                    this.fireActionPerformed();
                }
            } else {
                while (this.queue > 0L) {
                    this.fireActionPerformed();
                    --this.queue;
                }
            }
            this.queue = 0L;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void queueEvent() {
        Object object = this.queueLock;
        synchronized (object) {
            ++this.queue;
            if (this.queue == 1L) {
                SwingUtilities.invokeLater(this.drainer);
            }
        }
    }

    private class Task
    extends TimerTask {
        private Task() {
        }

        public void run() {
            if (logTimers) {
                System.out.println("javax.swing.Timer -> queueEvent()");
            }
            Timer.this.queueEvent();
            if (!Timer.this.repeats) {
                Timer.this.task = null;
            }
        }
    }
}

