/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;

public class Popup {
    protected Popup(Component owner, Component contents, int x, int y) {
        if (contents == null) {
            throw new IllegalArgumentException();
        }
    }

    protected Popup() {
    }

    public void show() {
    }

    public void hide() {
    }

    static class JWindowPopup
    extends Popup {
        JWindow window;
        private Component contents;

        public JWindowPopup(Component owner, Component contents, int x, int y) {
            super(owner, contents, x, y);
            this.contents = contents;
            this.window = new JWindow(SwingUtilities.getWindowAncestor(owner));
            this.window.getContentPane().add(contents);
            this.window.setLocation(x, y);
            this.window.setFocusableWindowState(false);
        }

        public void show() {
            this.window.setSize(this.contents.getSize());
            this.window.show();
        }

        public void hide() {
            this.window.dispose();
        }
    }

    static class LightweightPopup
    extends Popup {
        Component owner;
        Component contents;
        int x;
        int y;
        private JPanel panel;
        private JLayeredPane layeredPane;

        public LightweightPopup(Component owner, Component contents, int x, int y) {
            super(owner, contents, x, y);
            JLayeredPane layeredPane;
            this.owner = owner;
            this.contents = contents;
            this.x = x;
            this.y = y;
            JRootPane rootPane = SwingUtilities.getRootPane(owner);
            this.layeredPane = layeredPane = rootPane.getLayeredPane();
        }

        public void show() {
            if (this.panel == null) {
                this.panel = new JPanel();
                this.panel.setLayout(new FlowLayout(0, 0, 0));
            }
            this.panel.add(this.contents);
            this.panel.setSize(this.contents.getSize());
            Point layeredPaneLoc = this.layeredPane.getLocationOnScreen();
            this.panel.setLocation(this.x - layeredPaneLoc.x, this.y - layeredPaneLoc.y);
            this.layeredPane.add(this.panel, JLayeredPane.POPUP_LAYER, 0);
            this.panel.repaint();
        }

        public void hide() {
            Rectangle bounds = this.panel.getBounds();
            this.layeredPane.remove(this.panel);
            this.layeredPane.repaint(bounds.x, bounds.y, bounds.width, bounds.height);
        }
    }
}

