/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.io.Serializable;
import java.util.BitSet;
import java.util.EventListener;
import javax.swing.ListSelectionModel;
import javax.swing.event.EventListenerList;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultListSelectionModel
implements Cloneable,
ListSelectionModel,
Serializable {
    private static final long serialVersionUID = -5718799865110415860L;
    protected EventListenerList listenerList = new EventListenerList();
    int selectionMode = 2;
    int leadSelectionIndex = -1;
    int anchorSelectionIndex = -1;
    protected boolean leadAnchorNotificationEnabled = true;
    boolean valueIsAdjusting = false;
    BitSet sel = new BitSet();
    Object oldSel;
    boolean setLeadCalledFromAdd = false;

    @Override
    public int getSelectionMode() {
        return this.selectionMode;
    }

    @Override
    public void setSelectionMode(int mode) {
        if (mode < 0 || mode > 2) {
            throw new IllegalArgumentException("Unrecognised mode: " + mode);
        }
        this.selectionMode = mode;
    }

    @Override
    public int getAnchorSelectionIndex() {
        return this.anchorSelectionIndex;
    }

    @Override
    public void setAnchorSelectionIndex(int index) {
        if (this.anchorSelectionIndex != index) {
            int old = this.anchorSelectionIndex;
            this.anchorSelectionIndex = index;
            if (this.leadAnchorNotificationEnabled) {
                this.fireValueChanged(index, old);
            }
        }
    }

    @Override
    public int getLeadSelectionIndex() {
        return this.leadSelectionIndex;
    }

    @Override
    public void setLeadSelectionIndex(int leadIndex) {
        int beg;
        int oldLeadIndex;
        if (leadIndex < 0) {
            if (this.anchorSelectionIndex < 0) {
                this.leadSelectionIndex = -1;
            } else {
                return;
            }
        }
        if (this.anchorSelectionIndex < 0) {
            return;
        }
        if (this.selectionMode == 0) {
            this.setSelectionInterval(leadIndex, leadIndex);
        }
        if ((oldLeadIndex = this.leadSelectionIndex) == -1) {
            oldLeadIndex = leadIndex;
        }
        if (!this.setLeadCalledFromAdd) {
            this.oldSel = this.sel.clone();
        }
        this.leadSelectionIndex = leadIndex;
        if (this.anchorSelectionIndex == -1) {
            return;
        }
        int R1 = Math.min(this.anchorSelectionIndex, oldLeadIndex);
        int R2 = Math.max(this.anchorSelectionIndex, oldLeadIndex);
        int S1 = Math.min(this.anchorSelectionIndex, leadIndex);
        int S2 = Math.max(this.anchorSelectionIndex, leadIndex);
        Math.min(R1, S1);
        Math.max(R2, S2);
        if (this.isSelectedIndex(this.anchorSelectionIndex)) {
            this.sel.clear(R1, R2 + 1);
            this.sel.set(S1, S2 + 1);
        } else {
            this.sel.set(R1, R2 + 1);
            this.sel.clear(S1, S2 + 1);
        }
        int i = beg = this.sel.nextSetBit(0);
        while (i >= 0) {
            i = this.sel.nextSetBit(i + 1);
        }
        BitSet old = (BitSet)this.oldSel;
        old.set(oldLeadIndex, !this.sel.get(oldLeadIndex));
        old.set(this.leadSelectionIndex, !this.sel.get(this.leadSelectionIndex));
        this.fireDifference(this.sel, old);
    }

    public void moveLeadSelectionIndex(int leadIndex) {
        if (this.leadSelectionIndex == leadIndex) {
            return;
        }
        this.leadSelectionIndex = leadIndex;
        if (this.isLeadAnchorNotificationEnabled()) {
            this.fireValueChanged(Math.min(this.leadSelectionIndex, leadIndex), Math.max(this.leadSelectionIndex, leadIndex));
        }
    }

    public boolean isLeadAnchorNotificationEnabled() {
        return this.leadAnchorNotificationEnabled;
    }

    public void setLeadAnchorNotificationEnabled(boolean l) {
        this.leadAnchorNotificationEnabled = l;
    }

    @Override
    public boolean getValueIsAdjusting() {
        return this.valueIsAdjusting;
    }

    @Override
    public void setValueIsAdjusting(boolean v) {
        this.valueIsAdjusting = v;
    }

    @Override
    public boolean isSelectionEmpty() {
        return this.sel.isEmpty();
    }

    @Override
    public int getMinSelectionIndex() {
        if (this.isSelectionEmpty()) {
            return -1;
        }
        return this.sel.nextSetBit(0);
    }

    @Override
    public int getMaxSelectionIndex() {
        if (this.isSelectionEmpty()) {
            return -1;
        }
        int mx = -1;
        int i = this.sel.nextSetBit(0);
        while (i >= 0) {
            mx = i;
            i = this.sel.nextSetBit(i + 1);
        }
        return mx;
    }

    @Override
    public boolean isSelectedIndex(int a) {
        if (a >= this.sel.length() || a < 0) {
            return false;
        }
        return this.sel.get(a);
    }

    @Override
    public void addSelectionInterval(int index0, int index1) {
        if (index0 == -1 || index1 == -1) {
            return;
        }
        if (this.selectionMode == 0) {
            this.setSelectionInterval(index0, index1);
        } else {
            int lo = Math.min(index0, index1);
            int hi = Math.max(index0, index1);
            this.oldSel = this.sel.clone();
            if (!(this.selectionMode != 1 || this.isSelectedIndex(index0) || this.isSelectedIndex(index1) || this.isSelectedIndex(Math.max(lo - 1, 0)) || this.isSelectedIndex(Math.min(hi + 1, this.sel.size())))) {
                this.sel.clear();
            }
            if (this.isSelectedIndex(this.leadSelectionIndex) && (index0 - 1 == this.leadSelectionIndex && index1 >= index0 && this.leadSelectionIndex >= this.anchorSelectionIndex || index0 + 1 == this.leadSelectionIndex && index1 <= index0 && this.leadSelectionIndex <= this.anchorSelectionIndex) && (this.anchorSelectionIndex != -1 || this.leadSelectionIndex != -1)) {
                this.setLeadCalledFromAdd = true;
                this.setLeadSelectionIndex(index1);
                this.setLeadCalledFromAdd = false;
            } else {
                this.leadSelectionIndex = index1;
                this.anchorSelectionIndex = index0;
                this.sel.set(lo, hi + 1);
                this.fireDifference(this.sel, (BitSet)this.oldSel);
            }
        }
    }

    @Override
    public void removeSelectionInterval(int index0, int index1) {
        if (index0 == -1 || index1 == -1) {
            return;
        }
        this.oldSel = this.sel.clone();
        int lo = Math.min(index0, index1);
        int hi = Math.max(index0, index1);
        if (this.getMinSelectionIndex() > 0 && this.getMinSelectionIndex() < lo && this.selectionMode == 1) {
            hi = this.sel.size() - 1;
        }
        this.sel.clear(lo, hi + 1);
        this.setAnchorSelectionIndex(index0);
        this.leadSelectionIndex = index1;
        this.fireDifference(this.sel, (BitSet)this.oldSel);
    }

    @Override
    public void clearSelection() {
        int from = this.sel.nextSetBit(0);
        if (from < 0) {
            return;
        }
        int to = from;
        int i = from;
        while (i >= 0) {
            to = i;
            i = this.sel.nextSetBit(i + 1);
        }
        this.sel.clear();
        this.fireValueChanged(from, to, this.valueIsAdjusting);
    }

    private void fireDifference(BitSet current, BitSet x) {
        x.xor(current);
        int from = x.nextSetBit(0);
        if (from < 0) {
            return;
        }
        int to = from;
        int i = from;
        while (i >= 0) {
            to = i;
            i = x.nextSetBit(i + 1);
        }
        this.fireValueChanged(from, to, this.valueIsAdjusting);
    }

    @Override
    public void setSelectionInterval(int anchor, int lead) {
        if (anchor == -1 || lead == -1) {
            return;
        }
        if (this.selectionMode == 0) {
            int lo = lead;
            int hi = lead;
            int selected = this.sel.nextSetBit(0);
            if (selected == lead) {
                return;
            }
            if (selected >= 0) {
                lo = Math.min(lo, selected);
                hi = Math.max(hi, selected);
            }
            if (this.anchorSelectionIndex >= 0) {
                lo = Math.min(lo, this.anchorSelectionIndex);
                hi = Math.max(hi, this.anchorSelectionIndex);
            }
            this.sel.clear();
            this.sel.set(lead);
            this.leadSelectionIndex = lead;
            this.anchorSelectionIndex = lead;
            this.fireValueChanged(lo, hi);
        } else if (this.selectionMode == 1) {
            int first;
            int last = first = this.sel.nextSetBit(0);
            if (first >= 0) {
                last += this.sel.cardinality() - 1;
            }
            int lo = Math.min(anchor, lead);
            int hi = Math.max(anchor, lead);
            if (lo == first && hi == last) {
                return;
            }
            this.sel.clear();
            this.sel.set(lo, hi + 1);
            if (first >= 0) {
                lo = Math.min(lo, first);
            }
            if (last >= 0) {
                hi = Math.max(hi, last);
            }
            if (this.anchorSelectionIndex >= 0) {
                lo = Math.min(lo, this.anchorSelectionIndex);
                hi = Math.max(hi, this.anchorSelectionIndex);
            }
            this.anchorSelectionIndex = anchor;
            this.leadSelectionIndex = lead;
            this.fireValueChanged(lo, hi);
        } else {
            BitSet oldSel = (BitSet)this.sel.clone();
            this.sel.clear();
            if (this.selectionMode == 0) {
                anchor = lead;
            }
            int lo = Math.min(anchor, lead);
            int hi = Math.max(anchor, lead);
            this.sel.set(lo, hi + 1);
            this.setAnchorSelectionIndex(anchor);
            this.leadSelectionIndex = lead;
            this.fireDifference(this.sel, oldSel);
        }
    }

    @Override
    public void insertIndexInterval(int index, int length, boolean before) {
        if (!before) {
            ++index;
            --length;
        }
        BitSet tmp = this.sel.get(index, this.sel.size());
        this.sel.clear(index, this.sel.size());
        int n = tmp.size();
        int i = 0;
        while (i < n) {
            this.sel.set(index + length + i, tmp.get(i));
            ++i;
        }
    }

    @Override
    public void removeIndexInterval(int index0, int index1) {
        int lo = Math.min(index0, index1);
        int hi = Math.max(index0, index1);
        BitSet tmp = this.sel.get(hi, this.sel.size());
        this.sel.clear(lo, this.sel.size());
        int n = tmp.size();
        int i = 0;
        while (i < n) {
            this.sel.set(lo + i, tmp.get(i));
            ++i;
        }
    }

    protected void fireValueChanged(boolean isAdjusting) {
        this.fireValueChanged(this.getMinSelectionIndex(), this.getMaxSelectionIndex(), isAdjusting);
    }

    protected void fireValueChanged(int firstIndex, int lastIndex) {
        this.fireValueChanged(firstIndex, lastIndex, this.getValueIsAdjusting());
    }

    protected void fireValueChanged(int firstIndex, int lastIndex, boolean isAdjusting) {
        ListSelectionEvent evt = new ListSelectionEvent(this, firstIndex, lastIndex, isAdjusting);
        ListSelectionListener[] listeners = this.getListSelectionListeners();
        int i = 0;
        while (i < listeners.length) {
            listeners[i].valueChanged(evt);
            ++i;
        }
    }

    @Override
    public void addListSelectionListener(ListSelectionListener listener) {
        this.listenerList.add(ListSelectionListener.class, listener);
    }

    @Override
    public void removeListSelectionListener(ListSelectionListener listener) {
        this.listenerList.remove(ListSelectionListener.class, listener);
    }

    public <T extends EventListener> T[] getListeners(Class<T> listenerType) {
        return this.listenerList.getListeners(listenerType);
    }

    public ListSelectionListener[] getListSelectionListeners() {
        return (ListSelectionListener[])this.getListeners(ListSelectionListener.class);
    }

    public Object clone() throws CloneNotSupportedException {
        DefaultListSelectionModel model = (DefaultListSelectionModel)super.clone();
        model.sel = (BitSet)this.sel.clone();
        model.listenerList = new EventListenerList();
        return model;
    }
}

