/*
 * Decompiled with CFR 0.152.
 */
package javax.sound.sampled;

import java.io.IOException;
import java.io.InputStream;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.TargetDataLine;

public class AudioInputStream
extends InputStream {
    protected AudioFormat format;
    protected long frameLength;
    protected long framePos;
    protected int frameSize;
    private InputStream input;
    private long markedFramePos;

    public AudioInputStream(InputStream is, AudioFormat fmt, long length) {
        this.format = fmt;
        this.frameLength = length;
        this.framePos = 0L;
        this.frameSize = fmt.getFrameSize();
        this.input = is;
    }

    public AudioInputStream(TargetDataLine line) {
        this(new TargetInputStream(line), line.getFormat(), -1L);
    }

    public int available() throws IOException {
        int result = this.input.available();
        if (this.frameSize != -1) {
            result -= result % this.frameSize;
        }
        return result;
    }

    public void close() throws IOException {
        this.input.close();
    }

    public AudioFormat getFormat() {
        return this.format;
    }

    public long getFrameLength() {
        return this.frameLength;
    }

    public void mark(int limit) {
        this.input.mark(limit);
        this.markedFramePos = this.framePos;
    }

    public boolean markSupported() {
        return this.input.markSupported();
    }

    public int read() throws IOException {
        if (this.frameSize != 1) {
            throw new IOException("frame size must be 1 for read()");
        }
        int result = this.framePos == this.frameLength ? -1 : this.input.read();
        if (result != -1) {
            ++this.framePos;
        }
        return result;
    }

    public int read(byte[] buf) throws IOException {
        return this.read(buf, 0, buf.length);
    }

    public int read(byte[] buf, int offset, int length) throws IOException {
        int result;
        if (this.framePos == this.frameLength) {
            result = -1;
        } else {
            int myFrameSize = this.frameSize == -1 ? 1 : this.frameSize;
            length -= length % myFrameSize;
            result = 0;
            while (result == 0 || result % myFrameSize != 0) {
                int val = this.input.read(buf, offset, length);
                if (val < 0) {
                    if (result == 0) {
                        return -1;
                    }
                    result -= result % myFrameSize;
                    break;
                }
                result += val;
            }
            this.framePos += (long)(result / myFrameSize);
        }
        return result;
    }

    public void reset() throws IOException {
        this.input.reset();
        this.framePos = this.markedFramePos;
    }

    public long skip(long n) throws IOException {
        if (this.frameSize != -1) {
            n -= n % (long)this.frameSize;
        }
        long actual = this.input.skip(n);
        if (this.frameSize != -1) {
            this.framePos += actual / (long)this.frameSize;
        }
        return actual;
    }

    private static class TargetInputStream
    extends InputStream {
        private TargetDataLine line;
        private byte[] buf;

        public TargetInputStream(TargetDataLine line) {
            this.line = line;
        }

        public synchronized int read() throws IOException {
            int count;
            if (this.buf == null) {
                this.buf = new byte[1];
            }
            if ((count = this.read(this.buf, 0, 1)) < 0) {
                return -1;
            }
            return this.buf[0];
        }

        public int read(byte[] buf, int offset, int length) throws IOException {
            return this.line.read(buf, offset, length);
        }
    }
}

