/*
 * Decompiled with CFR 0.152.
 */
package javax.security.auth.kerberos;

import java.security.BasicPermission;
import java.security.Permission;
import java.security.PermissionCollection;
import java.util.Enumeration;
import java.util.Vector;

public final class DelegationPermission
extends BasicPermission {
    public DelegationPermission(String name) {
        super(name);
        DelegationPermission.checkSyntax(name);
    }

    public DelegationPermission(String name, String actions) {
        super(name, actions);
        DelegationPermission.checkSyntax(name);
    }

    private static void checkSyntax(String name) {
        int index = name.indexOf(34, 1);
        int len = name.length();
        if (name.charAt(0) != '\"' || name.charAt(len - 1) != '\"' || index == -1 || index + 3 >= len || name.charAt(index + 1) != ' ' || name.charAt(index + 2) != '\"') {
            throw new IllegalArgumentException("invalid syntax for principals");
        }
    }

    public boolean implies(Permission perm) {
        return this.equals(perm);
    }

    public PermissionCollection newPermissionCollection() {
        return new PermissionCollection(){
            private Vector permissions = new Vector();

            public void add(Permission perm) {
                if (this.isReadOnly()) {
                    throw new SecurityException("readonly");
                }
                if (!(perm instanceof DelegationPermission)) {
                    throw new IllegalArgumentException("can only add DelegationPermissions");
                }
                this.permissions.add(perm);
            }

            public boolean implies(Permission perm) {
                if (!(perm instanceof DelegationPermission)) {
                    return false;
                }
                Enumeration e = this.elements();
                while (e.hasMoreElements()) {
                    DelegationPermission dp = (DelegationPermission)e.nextElement();
                    if (!dp.implies(perm)) continue;
                    return true;
                }
                return false;
            }

            public Enumeration elements() {
                return this.permissions.elements();
            }
        };
    }
}

